### Name: optint
### Title: Optimum interpolation
### Aliases: optimum interpolation optint
### Keywords: manip

### ** Examples

# This example takes a little while to run..
## Not run: 
##D lon <- c(12.02, 10.47,  9.28, 10.78, 10.71,  9.12,  8.20,  9.52,  8.18,  8.52,
##D           8.07,  6.15,  5.63,  6.37,  5.92,  5.33,  6.50,  7.42,  6.17, 10.00,
##D          10.02, 11.12, 10.93, 14.02, 13.98, 14.43, 15.42, 17.80, 18.53, 18.93,
##D          21.02, 21.88, 23.35, 23.52, 31.08, 15.47, 11.93)
##D lat <- c(60.61, 61.10, 62.12, 59.38, 59.95, 60.58, 60.52, 59.90, 59.83, 59.03,
##D          58.20, 58.88, 58.88, 59.65, 60.40, 60.38, 60.65, 62.23, 62.57,
##D          63.20, 62.82, 63.20, 63.47, 65.52, 66.82, 67.27, 68.70, 68.73,
##D          69.06, 69.65, 69.73, 69.83, 69.98, 69.33, 70.37, 78.25, 78.92)
##D val <- c(1.74, 1.43, 0.98, 1.31, 1.10, 1.39, 1.07, 1.33,-0.04, 1.07,
##D          1.07, 0.22, 0.89, 0.98, 0.77, 0.81, 1.43, 0.30, 0.69,-0.17,
##D          1.17, 0.32, 1.55, 1.65, 0.75, 0.78, 0.56, 0.04, 0.57, 0.52,
##D          0.51, 0.51, 0.96, 0.32, 0.35,-0.36, 0.00) 
##D library(akima)
##D lon.grd <- seq(min(lon),max(lon),length=20)
##D lat.grd <- seq(min(lat),max(lat),length=20)
##D fguess <- interp(lon,lat,val,lon.grd,lat.grd)$z
##D fguess[is.na(fguess)]<-mean(fguess,na.rm=TRUE)
##D eps <- abs(fguess)*0 + 0.1
##D opt.int <- optint(lon,lat,val,lon.grd,lat.grd,fguess,eps)
##D image(opt.int$lon,opt.int$lat,opt.int$map)
##D contour(opt.int$lon,opt.int$lat,opt.int$map,lwd=1,add=TRUE)
##D contour(lon.grd,lat.grd,fguess,lty=2,lwd=2,col="darkblue",add=TRUE)
##D addland()
## End(Not run)



