### Name: r2cdf
### Title: Save as netCDF file.
### Aliases: r2cdf
### Keywords: file

### ** Examples

## Not run: 
##D # Save EOFs as netCDF (use ncview or Ferret to view)
##D data(eof.slp)
##D r2cdf("test.nc",eof.slp)
##D #
##D #
##D slp <- retrieve.nc("data/DNMI_slp.nc")
##D mslp <- meanField(slp)
##D r2cdf("test.nc",mslp)
##D r2cdf("test.nc",slp)
##D #
##D slp <- cdfextract("data/nmc_slp.nc","slp",x.rng=c(-80,40),y.rng=c(20,75),
##D                   t.rng=c(times[is],times[is]+499),plot=FALSE)
##D r2cdf("test.nc",slp)
##D #
##D data(oslo.t2m)
##D map <- composite.field(slp,oslo.t2m)
##D r2cdf("test.nc",map)
##D #
##D Xdum=list(dat=slp$dat[1:10,,],lon=slp$lon,lat=slp$lat,tim=slp$tim[1:10],
##D           lev=NULL,v.name=slp$v.name,attributes=slp$attributes)
##D class(Xdum)="field"
##D r2cdf("test.nc",Xdum)
##D #
##D # The definition of a 'field' object is:
##D ny<-length(slp$lat); nx<-length(slp$lon)
##D slp  <- list(dat=slp$dat,lon=slp$lon,lat=slp$lat,tim=slp$tim,lev=slp$lev,
##D              v.name=slp$v.nam,id.x=slp$id.x,id.t=slp$id.t,
##D              yy=slp$yy,mm=slp$mm,dd=slp$dd,n.fld=1,
##D              id.lon=rep(slp$v.name,nx),id.lat=rep(slp$v.name,ny),
##D              attributes=dat.att)
##D  class(slp) <- c("field")
##D 
## End(Not run)



