\name{BEZ}
\alias{BEZ}
\title{Z score approximation of contrast significance}
\description{
 calculates a Z score approximation of contrast significance
}
\usage{
 BEZ(rankarray,lambda)
}
\arguments{
  \item{rankarray}{matrix of ranks}
  \item{lambda}{contrast coefficient vector}
}
\details{
 \code{BEZ} calculates a Z score approximation of the probability that the
 deviation of the mean rank scores from the contrast coefficient vector would
 occur given randomly allocated ranks. It is only useful in conjuction with
 the /code{kendall.w} function.
}
\value{
  \item{Z}{Z score}
}
\author{Jim Lemon}
\seealso{\code{\link{kendall.w}}}
\keyword{misc}

\eof
\name{Wcrit05}
\docType{data}
\alias{Wcrit05}
\title{Critical values of Kendall's W}
\description{
 Critical values of Kendall's W (alpha=0.05)
}
\usage{data(Wcrit05)}
\format{
  A data frame with 72 observations on 2 variables.
  \tabular{rlll}{
    [,1]  \tab count  \tab numeric  \tab Insect count\cr
    [,2]  \tab spray  \tab factor   \tab The type of spray
  }
}
\source{
 Kendall, M.G. (1970) Rank correlation methods. London: Charles Griffin.
}
\references{
 Siegel, S. & Castellan, N.J.Jr. (1988) Nonparametric
 statistics for the behavioral sciences. Boston, MA: McGraw-Hill.
}
\keyword{datasets}

\eof
\name{cohen.kappa}
\alias{cohen.kappa}
\title{kappa reliability coefficient for nominal data}
\description{
 calculates the kappa coefficient of reliability for nominal data
}
\usage{
cohen.kappa(classif, type=c("count","score"))
}
\arguments{
  \item{classif}{matrix of classification counts or scores}
  \item{type}{whether classif is an object by category matrix of counts
   or an object by classifier matrix of scores}
}
\details{
 \code{cohen.kappa} will accept either an object by category matrix of counts
 in which the numbers represent how many classifiers have placed the object
 in each category, or an object by classifier matrix of categories in which
 the numbers represent each classifier's categorization of that object. The
 default is to assume counts and the operator \bold{must} specify if scores
 are used.
}
\value{
  \item{kappa}{value of kappa}
  \item{Z}{the Z-score approximation}
  \item{p}{the probability of Z}
}
\references{Siegel, S. & Castellan, N.J.Jr. (1988) Nonparametric
 statistics for the behavioral sciences. Boston, MA: McGraw-Hill.}
\author{Jim Lemon}
\note{This is sometimes called Cohen's kappa. The name also avoids confusion
 with the kappa estimate of the conditioning number of a matrix. For a 
 contingency table version of this statistic, see \code{classAgreement}
 in package e1071}
\seealso{\code{\link{scores.to.counts}},\code{\link{wtpc}}}
\examples{
 # the "C" data from Krippendorff
 nmm<-matrix(c(1,1,NA,1,2,2,3,2,3,3,3,3,3,3,3,3,2,2,2,2,1,2,3,4,4,4,4,4,
 1,1,2,1,2,2,2,2,NA,5,5,5,NA,NA,1,1,NA,NA,3,NA),nrow=4)
 # first show the score to count transformation, remembering that
 # Krippendorff's data is classifier by object and must be transposed
 scores.to.counts(t(nmm))
 # now calculate kappa
 cohen.kappa(t(nmm),"score")
}
\keyword{misc}

\eof
\name{coincidence.matrix}
\alias{coincidence.matrix}
\title{calculate the concordance/discordance matrix for
 Krippendorff's alpha}
\description{
 calculates the coincidence matrix for Krippendorff's alpha.
}
\usage{
coincidence.matrix(x)
}
\arguments{
  \item{x}{classifier by object matrix of classifications}
}
\details{
 probably of no use by itself.
}
\value{
  \item{statistic}{always NA - value is calculated by \code{kripp.alpha}}
  \item{coincidence.matrix}{the concordance/discordance matrix
   used in the calculation of alpha}
  \item{data.values}{a character vector of the original data values}
  \item{nmatchval}{the count of matches, used in calculation}
}
\references{Krippendorff, K. (1980) Content analysis: An introduction to
 its methodology. Beverly Hills, CA: Sage.}
\author{Jim Lemon}
\note{This is the initial step in calculating Krippendorff's alpha coefficient.}
\seealso{\code{\link{kripp.alpha}}}
\examples{
 # the "C" data from Krippendorff
 nmm<-matrix(c(1,1,NA,1,2,2,3,2,3,3,3,3,3,3,3,3,2,2,2,2,1,2,3,4,4,4,4,4,
 1,1,2,1,2,2,2,2,NA,5,5,5,NA,NA,1,1,NA,NA,3,NA),nrow=4)
 coincidence.matrix(nmm)
}
\keyword{misc}

\eof
\name{kendall.w}
\alias{kendall.w}
\title{Kendall's W coefficient of concordance}
\description{
 calculates Kendall's W coefficient of concordance
}
\usage{
kendall.w(x,lambda,descending=TRUE,ranks=FALSE)
}
\arguments{
  \item{x}{matrix of scores or ranks}
  \item{lambda}{optional contrast coefficient vector or matrix}
  \item{descending}{whether high (default) or low scores represent top ranks}
  \item{ranks}{whether the values in \code{x} are scores or ranks}
}
\details{
 \code{kendall.w} will accept either a matrix or data frame of scores or ranks
 where the rows represent methods (usually raters) and the columns represent
 data objects. It will handle ties, but not missing values. By default it 
 assumes that numerically higher scores represent numerically lower ranks. A
 vector or matrix of contrast coefficients (which each must sum to zero) may 
 be supplied. A z-score approximation of the significance of each contrast will
 be displayed if \code{lambda} is present. The \code{ranks} argument allows the
 user to pass ranks directly to the function. If ranks are passed without
 setting \code{ranks} to TRUE and with \code{descending} TRUE, the order of
 the ranks will be reversed. For small values of k (methods), \code{kendall.w} 
 will try to lookup the tabled values for significance. For \code{k} greater
 than 7, a chi-squared approximation is returned. Only one of these values will
 be returned.
}
\value{
  \item{W}{value of W}
  \item{p.table}{whether the obtained W exceeded the table value for small N}
  \item{p.chisq}{the probability of the obtained chi-squared value for larger N}
}
\references{Siegel, S. & Castellan, N.J.Jr. (1988) Nonparametric
 statistics for the behavioral sciences. Boston, MA: McGraw-Hill.}
\author{Jim Lemon}
\note{Kendall's W may not be appropriate for nominal class data.}
\seealso{\code{\link{kripp.alpha}},\code{\link{cohen.kappa}}}
\keyword{misc}

\eof
\name{kripp.alpha}
\alias{kripp.alpha}
\title{calculate Krippendorff's alpha reliability coefficient}
\description{
 calculates the alpha coefficient of reliability proposed by Krippendorff.
}
\usage{
kripp.alpha(x, method="nominal"))
}
\arguments{
  \item{x}{classifier by object matrix of classifications}
  \item{method}{data level of x}
}
\details{
}
\value{
  \item{statistic}{value of alpha}
  \item{coincidence.matrix}{the concordance/discordance matrix
   used in the calculation of alpha}
  \item{data.values}{a character vector of the unique data values}
  \item{nmatchval}{the count of matches, used in calculation}
}
\references{Krippendorff, K. (1980) Content analysis: An introduction to
 its methodology. Beverly Hills, CA: Sage.}
\author{Jim Lemon}
\note{Krippendorff's alpha coefficient is particularly useful where
 the level of measurement of classification data is higher than nominal
 or ordinal.}
\seealso{\code{\link{coincidence.matrix}}}
\examples{
 # the "C" data from Krippendorff
 nmm<-matrix(c(1,1,NA,1,2,2,3,2,3,3,3,3,3,3,3,3,2,2,2,2,1,2,3,4,4,4,4,4,
 1,1,2,1,2,2,2,2,NA,5,5,5,NA,NA,1,1,NA,NA,3,NA),nrow=4)
 # first assume the default nominal classification
 kripp.alpha(nmm)
 # now use the same data with the other three methods
 kripp.alpha(nmm,"ordinal")
 kripp.alpha(nmm,"interval")
 kripp.alpha(nmm,"ratio") 
}
\keyword{misc}

\eof
\name{mcnemar.mh}
\alias{mcnemar.mh}
\title{2 way reliability coefficient for nominal data}
\description{
 calculates a coefficient of reliability for nominal data
}
\usage{
mcnemar.mh(x)
}
\arguments{
  \item{x}{2x2 classification matrix or matrix of dichotomous
   classification scores.}
}
\details{
 \code{mcnemar.mh} calculates a reliability coefficient for two raters
  classifying n objects into two categories. It will accept either a 2x2
  classification matrix of counts of objects falling into two categories
  or a 2xn or nx2 matrix of classification scores.
}
\value{
  \item{kappa}{value of kappa}
  \item{Z}{the Z-score approximation}
  \item{p}{the probability of Z}
}
\references{Siegel, S. & Castellan, N.J.Jr. (1988) Nonparametric
 statistics for the behavioral sciences. Boston, MA: McGraw-Hill.}
\author{Jim Lemon}
\seealso{\code{\link{stuart.maxwell.mh}}}
\examples{
 xt<-table(sample(0:1,50,TRUE),sample(0:1,50,TRUE))
 mcnemar.mh(xt)
}
\keyword{misc}

\eof
\name{rater.bias}
\alias{rater.bias}
\title{coefficient of rater bias}
\description{
 calculates a coefficient of systematic bias between two raters
}
\usage{
rater.bias(x)
}
\arguments{
 \item{x}{CxC classification matrix or matrix of classification scores
  into C categories.}
}
\details{
 \code{rater.bias} calculates a reliability coefficient for two raters
  classifying n objects into any number of categories. It will accept either 
  a cxc classification matrix of counts of objects falling into c categories
  or a 2xn or nx2 matrix of classification scores.
}
\value{
  \item{statistic}{value of coefficient}
  \item{p}{the probability of the coefficient as a df 1 Chi-square variable}
}
\references{
 Bishop Y.M.M., Fienberg S.E. & Holland P.W. (1975) Discrete multivariate 
 analysis: theory and practice. Cambridge, Massachusetts: MIT Press.
}
\author{Jim Lemon}
\seealso{\code{\link{mcnemar.mh}}}
\examples{
 # fake a 2xn matrix of three way classification scores
 ratings<-matrix(sample(1:3,60,TRUE),nrow=2)
 rater.bias(ratings)
}
\keyword{misc}

\eof
\name{scores.to.counts}
\alias{scores.to.counts}
\title{transform a score matrix to a count matrix}
\description{
 transforms an object by classifier matrix of classification scores to
 an object by category matrix of classification counts as used by
 \code{cohen.kappa}.
}
\usage{
scores.to.counts(scores)
}
\arguments{
  \item{scores}{object by classifier matrix of classification scores}
}
\details{
 usually called by \code{cohen.kappa}
}
\value{
  \item{counts}{an object by category matrix of counts}
  \item{scores.to.counts}{the concordance/discordance matrix
   used in the calculation of alpha}
  \item{data.values}{a character vector of the original data values}
  \item{nmatchval}{the count of matches, used in calculation}
}
\author{Jim Lemon}
\note{There seems to be no established convention for whether objects(cases)
 should be rows (as they are here) or columns. Make sure to transpose as
 below if necessary.}
\seealso{\code{\link{cohen.kappa}}}
\examples{
 # the "C" data from Krippendorff
 nmm<-matrix(c(1,1,NA,1,2,2,3,2,3,3,3,3,3,3,3,3,2,2,2,2,1,2,3,4,4,4,4,4,
 1,1,2,1,2,2,2,2,NA,5,5,5,NA,NA,1,1,NA,NA,3,NA),nrow=4)
 # remember to transpose the data to the expected format
 scores.to.counts(t(nmm))
}
\keyword{misc}

\eof
\name{stuart.maxwell.mh}
\alias{stuart.maxwell.mh}
\title{between rater concordance coefficient for classification}
\description{
 calculates the coefficient of concordance for two raters
}
\usage{
stuart.maxwell.mh(x)
}
\arguments{
 \item{x}{cxc classification matrix or matrix of classification scores
  into c categories.}
}
\details{
 \code{stuart.maxwell.mh} calculates a reliability coefficient for two raters
  classifying n objects into any number of categories. It will accept either 
  a cxc classification matrix of counts of objects falling into c categories
  or a cxn or nxc matrix of classification scores.
}
\value{
  \item{statistic}{value of coefficient}
  \item{p}{the probability of the coefficient as a Chi-square variable}
}
\references{
 Stuart A.A. (1955) A test for homogeneity of the marginal 
 distributions in a two-way classification. Biometrika, 42, 412-416.
 
 Maxwell A.E. (1970) Comparing the classification of subjects by two 
 independent judges. British Journal of Psychiatry, 116, 651-655.
}
\author{Jim Lemon}
\seealso{\code{\link{rater.bias}}}
\examples{
 # fake a 2xn matrix of three way classification scores
 ratings<-matrix(sample(1:3,60,TRUE),nrow=2)
 stuart.maxwell.mh(ratings)
}
\keyword{misc}

\eof
\name{tiecorr}
\alias{tiecorr}
\title{correction for tied ranks}
\description{
 calculates a correction for tied ranks
}
\usage{
 tiecorr(rankarray)
}
\arguments{
  \item{rankarray}{matrix of ranks}
}
\details{
 \code{tiecorr} calculates a correction for tied ranks that is appropriate for
 Kendall's W and the Spearman rank-order correlation coefficient.
}
\value{
  \item{tie3margsum}{correction factor}
}
\references{Siegel, S. & Castellan, N.J.Jr. (1988) Nonparametric
 statistics for the behavioral sciences. Boston, MA: McGraw-Hill.}
\author{Jim Lemon}
\seealso{\code{\link{kendall.w}}}
\keyword{misc}

\eof
\name{wtpc}
\alias{wtpc}
\title{calculate weighted percentages for nominal classification data}
\description{
 calculates weighted percentages for nominal classification data
}
\usage{
wtpc(x, n.methods, n.objects, type=c("count","score"))
}
\arguments{
  \item{x}{vector, data frame or matrix of ratings}
  \item{n.methods}{the number of methods (e.g. raters) used}
  \item{n.objects}{the number of objects rated or classified}
  \item{type}{whether the data represent counts of objects in categories
  or scores for objects by methods}
}
\details{
 \code{wtpc} will accept a vector (if only one method is used) matrix or 
 data frame in which values represent counts of objects (rows) classified 
 as categories (columns), or the same objects in which values represent 
 categorizations of those objects. The default is to assume counts 
 and the operator \bold{must} specify if scores are used. The formula
 used is: \code{wtpc = 100/n.methods * sum(category counts)/n.objects}.
}
\value{
  \item{wtpc}{vector of weighted percentages of occurrence of categories}
}
\author{Jim Lemon}
\note{This is a convenience function for calculating the frequencies of
category occurrences in ratings where all methods may not recognize the
same objects as belonging to the available categories.}
\examples{
 # the "C" data from Krippendorff
 nmm<-matrix(c(1,1,NA,1,2,2,3,2,3,3,3,3,3,3,3,3,2,2,2,2,1,2,3,4,4,4,4,4,
 1,1,2,1,2,2,2,2,NA,5,5,5,NA,NA,1,1,NA,NA,3,NA),nrow=4)
 # Krippendorff's data is classifier by object and must be transposed
 wtpc(t(nmm),4,12,"score")
}
\keyword{misc}

\eof
