\name{MOLS}
\alias{MOLS}
\title{Construction of Complete Sets of Mutually Orthogonal Latin Squares}
\description{
  The function constructs sets of mutually othogonal latin squares (MOLS) using Galois fields.
  The construction works for prime powers only. 
}
\usage{
MOLS(p, n, primpol = GF(p, n)[[2]][1, ])
}
\arguments{
  \item{p}{ A prime number. }
  \item{n}{ A positive integer.}
  \item{primpol}{ A primitive polynomial of the Galois Field GF(\eqn{p^n}{p^n}).}
}
\details{
  If \eqn{trt = p^n}{trt = p^n} is a prime power, then \eqn{trt}{trt}-1 latin squares of order \eqn{trt}{trt} 
  are constructed.
  The elements of the squares are numbered 1,\ldots,\eqn{trt}{trt}. 
  These squares are mutually orthogonal, i.e. if any two of them are superimposed, the resulting
  array will contain each ordered pair \eqn{(i,j)}{(i,j)}, \eqn{i}{i},\eqn{j}{j} in \{1,\ldots,
  \eqn{trt}{trt}\} exactly once.
  The squares are in standard order, i.e. the first row is always equal to (1,\ldots,\eqn{trt}{trt}).
  A primitive polynomial may be constructed automatically using the internal function \code{GF}.
}
\value{
  For \eqn{trt = p^n}{trt = p^n}, an array that contains \eqn{trt}{trt}-1 latin squares is returned. 
}
\references{ 
  Cherowitzo, W.: http://www-math.cudenver.edu/~wcherowi/courses/finflds.html
  
  Street, A.P. and Street, D.J. (1987): Combinatorics of experimental design. Oxford University Press, Oxford.

}
\author{ Oliver Sailer \email{sailer@statistik.uni-dortmund.de}}


\seealso{  \code{\link{des.MOLS}} }
\examples{
MOLS(7,1) # 6 mutually orthogonal latin squares of order 7
MOLS(2,3) # 7 mutually orthogonal latin squares of order 8
}

\keyword{ design }% at least one, from doc/KEYWORDS

\eof
\name{all.combin}
\alias{all.combin}
\title{Balanced Row-Column Design with all Possible Treatment Orders.}
\description{
  The function constructs a row-column design with subjects as rows and periods as columns. Each subject
  gets each treatment at most once. All possible treatment orders are assigned to the subjects. }
\usage{
all.combin(trt, k)
}
\arguments{
  \item{trt}{ An integer > 1. Number of treatments (products) to be tested. }
  \item{k}{ An integer \eqn{\leq \, trt}{<= trt}. Number of periods for each subject. }
}
\details{
  The design is a carryover balanced generalized Youden design that is uniform on the columns.
  The treatments are numbered 1,\ldots,\eqn{trt}{trt}. The entry \eqn{(i,j)}{(i,j)} 
  of the design corresponds to the treatment the \eqn{i}{i}-th subject gets in the \eqn{j}{j}-th period.
}
\value{
  A matrix with \eqn{\frac{trt!}{(trt-k)!}}{trt!/(trt-k)!} rows and \eqn{k}{k} columns representing the experimental design.
}
\references{ 
Patterson, H.D. (1952): The construction of balanced designs for experiments involving sequences of
treatments. Biometrika 39, 32-48. 

Wakeling, I.N. and MacFie, H.J.H. (1995): Designing consumer trials balanced for first and higher orders of
carry-over effect when only a subset of k samples from t may be tested. Food Quality and Preference 6, 299-308. }
\author{ Oliver Sailer \email{sailer@statistik.uni-dortmund.de} }
\note{ Requires the package \code{gregmisc}. }


\seealso{ \code{\link{get.plan}} }
\examples{
# Design for 4 treatments assigned in 3 periods.
# All possible treatment orders occur.
all.combin(4,3) 
}

\keyword{ design }

\eof
\name{analyze.rand}
\alias{analyze.rand}
\title{Analysis of a Simulation Study to Asses the Validity of a Randomization Procedure}
\description{
  The function analyzes the results of simulation studies done by functions like \code{rand.design.azais} or
  \code{rand.design.RC}.
  A table of results and, optionally, graphs are given that help to assess whether a randomization procedure validates
  a certain model for a given design.
}
\usage{
analyze.rand(where, fig = FALSE, ref = FALSE, refval = numeric(6),
    reftext = "Reference Value", pch1 = 46, col1 = "red",
    col2 = "black", ...)
}
\arguments{
  \item{where}{ Path that gives the location of the simulation results }
  \item{fig}{ Logical flag. Set to TRUE if you want to display the results in graphs }
  \item{ref}{ Logical flag. TRUE if you want to use your own reference values for the estimated contrast
                 in the simulation study. Otherwise, the true values of the contrast are used.}
  \item{refval}{ A numerical vector of length 6. The values that the contrast estimates are compared to.
                 This is set automatically to the true values of the contrast if \code{ref} is FALSE. }
  \item{reftext}{ Character string that contains the legend text in a graph displaying the location of the estimated
                  contrast and the corresponding reference value. }
  \item{pch1}{ A scalar that corresponds to the plotting character in the Q-Q-Plot of the estimated contrast that is
               displayed if \code{fig} is TRUE. }
  \item{col1}{ The colour of the theoretical CDF in the CDF-Plots that are displayed if \code{fig} is TRUE
           Also the colour of the reference values described above. }
  \item{col2}{ The colour of the empirical CDF in the CDF-Plots that are displayed if \code{fig} is TRUE }
  \item{\dots}{ Additional parameters for the graphs. }
}
\details{
  The input to the function comes from a file that is generated by the functions \code{rand.design.azais} or
  \code{rand.design.RC}.
  This file contains simulated values for contrast estimates and corresponding variance estimates. It also
  contains information on the experimental design and the model used.

  The output contains two tables. The first one displays empirical quantiles of the randomization t-statistics for the
  contrast as well as estimates of the location of the contrasts. The second table contains estimates of the variance of
  the contrast. In theory, the randomization validates the model for the design used, if the contrast estimate is unbiased and
  the variance estimate of the contrast is unbiased, too.
  The simulation study suggests that this is achieved, if two conditions hold: First, the absolute value of the
  Z-statistic of table 1 is less than 1.96 (Gauss test on the randomization contrasts).
  Second, the confidence interval for the difference of the model variance estimate and the empirical
  variance of the randomization contrasts should include zero. The boundaries of the interval
  are given in columns 4 and 6 of table 2.
  An additional information on the validity is given by the randomization t-statistics. If the model is valid, for most
  real data they will be approximately t-distributed. This can be checked by comparing the empirical 5\% quantile
  to the 5\% quantile of the true t-distribution.
  The plots show histograms of the randomization contrast estimates and cumulative distribution functions for the
  permutation t-statistics. Also, normal Q-Q-Plots of the estimated contrast and the estimate of the difference
  between the true variance and the model variance of the contrast are given.


}
\value{
  \item{1}{A 6*5 matrix of results. The rows correspond to the cases considered in \code{\link{rand.design.azais}}.
                  The first column contains the number of randomization t-statistics smaller than the 5\% quantile of the
                  theoretical t-distribution. The second column has the fraction of t-statistics smaller than this
                  quantile. The third column contains the mean of the estimated contrast values.
                  The fourth has the reference value for this mean.
                  In the fifth column the test statistic for the Gauss test of the contrast being equal to the reference value
                  is displayed.}
  \item{2}{A 6*5 matrix of results. The rows correspond to the cases considered in \code{\link{rand.design.azais}}.
                  The first column contains the empirical variance of the contrast estimates, the second column
                  has the average value of the variance estimate for the contrast under the applied model.
                  The following columns contain the lower, center and upper value of the confidence intervals
                  for the difference of the true variance and the estimated variance of the estimated contrast.}
}

\references{ Bailey, R.A. and Rowley C.A. (1987): Valid randomization.
Proceedings of the Royal Society London A 410, 105-124.

Kunert, J. and Sailer, O. (2004): On nearly balanced designs for sensory trials. In preparation.}
\author{ Oliver Sailer \email{sailer@statistik.uni-dortmund.de}}
\note{ If \code{fig} is TRUE, 24 graphics windows are opened.}

\seealso{ \code{\link{rand.design.azais}}, \code{\link{rand.design.RC}} }
\examples{
\dontrun{
# First create a data set to analyze:
d <- matrix(c(1:4,2:4,1,4,1:3,3,4,1,2),ncol=4)
rand.design.RC( d, rnorm(16), 1000, "D:\\mytest.txt", -1, 1 )
# Now do the analysis:
analyze.rand( "D:\\mytest.txt" )
analyze.rand( "D:\\mytest.txt", fig=TRUE, ref=TRUE,
    refval=c(0, -1, 0, -1, -.25, -1.25) )
}
}


\keyword{ design }

\eof
\name{balminRMD}
\alias{balminRMD}
\title{Function to construct the balanced minimal 
       repeated measurements designs of Afsarinejad (1983)}
\description{
  The function constructs a row-column design with subjects as rows and periods as columns. The design is incomplete, i.e.
  no subject gets all the treatments. The design is balanced for carryover effects but will in general not be
  a balanced block design.}
\
\usage{
balminRMD(trt, n, p)
}
\arguments{
  \item{trt}{ An integer >1 giving the number of treatments (products) to be tested. }
  \item{n}{ An integer >1 giving the number of subjects (assessors) in the study. }
  \item{p}{ An integer >1 giving the number of periods for each subject. }
}
\details{
  A necessary and sufficient condition for the existence of such a design is 
  that \eqn{\frac{(trt-1)}{(p-1)}}{(trt-1)/(p-1)} be a positive integer.
  In this case \eqn{n = \frac{trt(trt-1)}{(p-1)}}{n = trt(trt-1)/(p-1)}.  
  In the resulting design the treatments are numbered 1,\ldots,\eqn{trt}{trt}. 
  The entry \eqn{(i,j)}{(i,j)} 
  of the design corresponds to the treatment the \eqn{i}{i}-th subject gets in the \eqn{j}{j}-th period.
}
\value{
  A matrix with \eqn{n}{n} rows and \eqn{p}{p} columns representing the experimental design.
}

\references{ 
 Afsarinejad, K. (1983): Balanced repeated measurements designs. Biometrika 70, 199-204.
             
 Wakeling, I.N. and MacFie, H.J.H. (1995): Designing consumer trials balanced for first and higher orders of
 carry-over effect when only a subset of k samples from t may be tested. Food Quality and Preference 6, 299-308. }
\author{ Oliver Sailer \email{sailer@statistik.uni-dortmund.de}}


\seealso{ \code{\link{get.plan}} }
\examples{
balminRMD(10,30,4) # a balanced minimal RMD
balminRMD(11,22,6) # another balanced minimal RMD
}
    


\keyword{ design }

\eof
\name{biertest.d4}
\alias{biertest.d4}
\docType{data}
\title{ Experimental Design for the Beer Testing Data in Kunert (1998)}
\description{
  The design is a balanced incomplete block design with rows 
  as blocks. If one assumes that there is a preperiod, i.e. that each assessor is given the treatment of the fifth period
  before the experiment starts, then the design is carryover balanced. 
}
\usage{data(biertest.d4)}
\format{
  A matrix with 12 rows corresponding to the assessors, 5 columns corresponding to 
  the five periods. 
}
\details{
The five treatments (products) to be tested are numbered 1,\ldots,5.
}

\source{
  Kunert, J. (1998): Sensory experiments as crossover studies. Food Quality and Preference 9, 243-253
  (design d4). 
}

\examples{
data(biertest.d4)
}
\keyword{datasets}

\eof
\name{biertest.dat}
\alias{biertest.dat}
\docType{data}
\title{ The Beer Testing Data in Kunert (1998)}
\description{
  The data comes from a beer testing experiment where assessors had to rate
  the bitterness of five beers.    
}
\usage{data(biertest.dat)}
\format{
A matrix with 12 rows corresponding to the assessors, 5 columns corresponding to 
  the five periods.
}
\details{
  The possible values for the ratings lie in the interval [0, 12].
  Note that the data were reordered after the experiment. }
\source{
  Kunert, J. (1998): Sensory experiments as crossover studies. Food Quality and Preference 9, 243-253
  (table 1). 
}

\examples{
data(biertest.dat)
}
\keyword{datasets}

\eof
\name{biertest.f2}
\alias{biertest.f2}
\docType{data}
\title{ Experimental Design for the Beer Testing Data in Kunert (1998)}
\description{
  The design is a row-column design. It is actually a generalized latin square design that is also carryover balanced. 
}
\usage{data(biertest.d4)}
\format{
A matrix with 10 rows corresponding to the first 10 assessors in a fictional uniformity trial, 
  5 columns corresponding to the five periods. 
}
\details{
  There are five products to be tested, numbered 1,\ldots,5.
}
\source{
  Kunert, J. (1998): Sensory experiments as crossover studies. Food Quality and Preference 9, 243-253
  (design f2). 
}

\examples{
data(biertest.f2)
}
\keyword{datasets} % at least one, from doc/KEYWORDS

\eof
\name{crossdes-internal}
\alias{choices}
\alias{design.row}
\alias{factor.comb}
\alias{GF}
\alias{mult}
\alias{Q.t}
\alias{random.AZ}
\alias{random.azais}
\alias{random.bailey}
\alias{random.RC}
\alias{redu}
\alias{redu.modp}
\alias{tcdf.plot}
\alias{Td}
\title{ Internal Functions in crossdes }
\description{
  For internal use only.}
\usage{
design.row(d)
}
\author{ Oliver Sailer \email{sailer@statistik.uni-dortmund.de}}

\note{ The function \code{design.row} requires the library \code{combinat}. The functions \code{GF}
 and \code{MOLS}
 use the library conf.design. }

\keyword{internal}

\eof
\name{des.MOLS}
\alias{des.MOLS}
\title{ Construction of Designs Based on Mutually Orthogonal Latin Squares}
\description{
  The function constructs row-column designs based on complete sets of mutually orthogonal latin squares.
  Each subject may get each tratment at most once. The design is a generalized Youden design that is also 
  balanced for carryover effects.
}
\usage{
des.MOLS(trt, k)
}
\arguments{
  \item{trt}{ A numerical vector of length two. The first element is a prime number,
              the second a positive integer such that \eqn{ {trt[1]}^{trt[2]} }{trt[1]^trt[2]} is the
              number of treatments (products) to be tested. }
  \item{k}{ An integer \eqn{\leq \, trt}{<= trt}. Number of periods for each subject. }
}
\details{
  A complete set of mutually orthogonal latin squares is constructed using Galois Fields. 
  The rows of the designs represent the treatment
  orders for the subjects. If an incomplete design with \eqn{k}{k} columns is needed, 
  only the first \eqn{k}{k} columns of the designs are 
  considered.   
  The treatments are numbered 1,\ldots,\eqn{trt}{trt}. The entry \eqn{(i,j)}{(i,j)} 
  of the design corresponds to the treatment the \eqn{i}{i}-th subject gets in the \eqn{j}{j}-th period.
} 

\value{
  A matrix with \eqn{trt(trt-1)}{trt(trt-1)} rows and \eqn{k}{k} columns representing the experimental design.
}
\references{ 
Wakeling, I.N. and MacFie, H.J.H. (1995): Designing consumer trials balanced for first and higher orders of
 carry-over effect when only a subset of k samples from t may be tested. Food Quality and Preference 6, 299-308. 
 
Williams, E. J. (1949): Experimental designs balanced for the estimation of residual effects
of treatments. Australian Journal of Scientific Research, Ser. A 2, 149-168. 
}
\author{ Oliver Sailer \email{sailer@statistik.uni-dortmund.de}}
\note{ Requires the package \code{conf.design} to check whether the number of treatments is a prime power. }


\seealso{ \code{\link{get.plan}}, \code{\link{MOLS}} }
\examples{
des.MOLS(c(7,1),7)
des.MOLS(c(2,3),5)
}

\keyword{ design }% at least one, from doc/KEYWORDS

\eof
\name{get.plan}
\alias{get.plan}
\title{ Menu-Driven Construction of Carryover Balanced Experimental Designs}
\description{
  This menu based function constructs and randomizes simple experimental designs for repeated measurements with one or two block 
variables. It is assumed that each subject is assigned to each treatment at most once. A maximum number of 
subjects in the study is also requested. There are up to five possible construction methods available.
These construction methods and the characteristics of the resulting designs are described in Wakeling and MacFie (1995). }
\usage{
get.plan(trt, k = trt, maxsub = 1000)
}
\arguments{
  \item{trt}{ An integer > 1, giving the number of treatments.}
  \item{k}{ An integer in \{2,\ldots,\eqn{trt}{trt}\} giving the number of periods.}
  \item{maxsub}{ The maximum number of subjects available. }
}
\details{
  The five types of designs are: designs based on all possible treatment orders ("All combinations"),
  Williams designs ("Williams"), designs based on 
  mutually orthogonal latin squares ("MOLS"), a combination of balanced incomplete block designs (BIBDs) and Williams designs 
  ("Patterson") and
  the balanced minimal designs of Afsarinejad ("no BBD needed"). 
  Some designs are only available for special combinations of treatment number and number of periods. Other designs
  may require too many subjects. Therefore, the possible choices available for the submittet values of \eqn{trt}{trt},
  \eqn{k}{k} and \eqn{maxsub}{maxsub} 
  are determined. 
  If there is no design available, the parameters may be changed interactively.
  If more than one design type is available the user has to choose one. The minimum number of subjects required 
  for the designs is given and may be a criterion for selecting a design. All types of designs are balanced for first-order carryover effects.
  All types except the balanced minimal RMDs ("no BBD needed") are also balanced block designs. 
  The user may want to construct a design for a multiple of the minimum number of subjects required to get closer
  to the preferred number of subjects. 
  Once the design is chosen, the labels for the treatments and subjects are randomized and the design is displayed.  
  The treatments are numbered 1,\ldots,\eqn{trt}{trt}. The entry \eqn{(i,j)}{(i,j)} 
  of the design corresponds to the treatment the \eqn{i}{i}-th subject gets in the \eqn{j}{j}-th period.
}
\value{
  A matrix representing the experimental design.
}


\references{ 
  Afsarinejad, K. (1983): Balanced repeated measurements designs. Biometrika 70, 199-204.  
  
  Patterson, H.D. (1951): Change-over trials. Journal of the Royal Statistical Society B 13, 256-271.
            
  Patterson, H.D. (1952): The construction of balanced designs for experiments involving sequences of treatments. 
  Biometrika 39, 32-48.
  
  Wakeling, I.N. and MacFie, H.J.H. (1995): Designing consumer trials balanced for first and higher orders of
  carry-over effect when only a subset of k samples from t may be tested. Food Quality and Preference 6, 299-308. 
  
  Williams, E. J. (1949): Experimental designs balanced for the estimation of residual effects
  of treatments. Australian Journal of Scientific Research, Ser. A 2, 149-168. 
}



\author{Oliver Sailer \email{sailer@statistik.uni-dortmund.de}}
\note{  The "All combinations" approach requires the package gregmisc. }

\section{Warning }{ 
 There are two possible problems with this implementation of the "Patterson" approach:
 
 For the construction of designs that combine BIBDs with Williams designs, the function \code{opttodes} is called. 
 \code{opttodes} requires the package \code{Dopt}. 
 As of May 13 2004, CRAN states that \code{Dopt} is a package in development and that such packages may be unstable.
 
 Also note that if the necessary conditions for the existence of a BIBD are fulfilled, the "Patterson" approach
 always returns a design. This design will however not always be a BIBD! 
 When using the patterson approach, please check the reulting design for balance using \code{isGYD} and 
 \code{isCbalanced}.
 
 If you want to avoid loading \code{Dopt} or avoid getting a possibly unbalanced design, don't choose the menu option
 "Patterson". It should be noted that this is a computational problem only, not a problem of the theoretical
 approach of Patterson (1951). 
 }

\seealso{ \code{\link{all.combin}}, \code{\link{balminRMD}}, \code{\link{des.MOLS}}, 
  \code{\link{williams}}, \code{\link{williams.BIB}} }
\examples{
\dontrun{
get.plan(10,4,60)  
  # "Patterson" or "no BBD needed"
get.plan(7,7,7000) 
  # "All combinations", "Williams" or "MOLS", "Williams" requires 
  # only 14 subjects, "All combinations" requires 5040.   
get.plan(5,5,5)    
  # Increase maxsub
}
}



\keyword{design }% at least one, from doc/KEYWORDS

\eof
\name{isCbalanced}
\alias{isCbalanced}
\title{ Checking Block Designs for Carryover Balance }
\description{
   The function checks whether a block design is balanced for first order carryover effects (residual effects).
   The user specifies whether there is a preperiod. The design is checked and the left neighbour incidence matrix is given.  
}
\usage{
isCbalanced(d, preperiod = FALSE)
}
\arguments{
  \item{d}{ A matrix with entries 1,\ldots,\eqn{trt}{trt} representing the experimental design with
  rows as blocks (subjects). 
  The columns represent periods.
}
  \item{preperiod}{ Logical flag. TRUE if there is a preperiod. In this case, each subject experiences in the first period 
   the residual effect of the treatment of the last period (i.e. the last period preceeds the first period, i.e. the 
   plots in the last period are left neighbours of the plots in the first period). 
   FALSE if there are no residual effects in the first period.}
}
\details{
  The design is said to be carryover balanced (balanced for first order carryover effects), if each treatment is preceeded by all other treatments equally often
  and if no treatment is preceeded by itself. 
  If the design is balanced, this is stated.
}
\value{
  \item{1 }{Logical flag. TRUE if the design is carryover balanced. This is not displayed on the screen.}
  \item{2 }{Left neighbour incidence matrix. The \eqn{(i,j)}{(i,j)}-th element is the number of times that 
  treatment \eqn{i}{i} preceeds treatment \eqn{j}{j}.}
}

\author{ Oliver Sailer \email{sailer@statistik.uni-dortmund.de} }

\seealso{ \code{\link{isGYD}} }
\examples{
d1 <- matrix( c(1,2,3,4,1,1,1,1), 4,2)
d2 <- matrix( c(1:4,2:4,1,4,1:3,3,4,1,2),ncol=4)
d3 <- matrix( rep(1:3,each=2), ncol=2)
isCbalanced(d1)
isCbalanced(d1,TRUE)  
isCbalanced(d2)
isCbalanced(d3,TRUE)
}


\keyword{ design }% at least one, from doc/KEYWORDS

\eof
\name{isGYD}
\alias{isGYD}
\title{ Checking Row-Column Designs for Balance}
\description{
 A function to check a row-column design for balance. The rows and columns of the design
 are blocking variables. It is checked, which type of balance the design fulfills. 
 Optionally, incidence matrices are given.  
}
\usage{
isGYD(d, invis = FALSE, tables = FALSE, coded = FALSE)
}
\arguments{
  \item{d}{ A matrix representing the experimental design. The treatments must be numbered 1,\ldots,\eqn{trt}{trt}. }
  \item{invis}{ Logical flag. If TRUE, the type of design is displayed. }
  \item{tables}{ Logical flag. If TRUE, incidence matrices are given. }
  \item{coded}{ Logical flag. If TRUE, a logical vector representing the type of design is displayed.}
}
\details{
  A design is said to be a balanced block design if the following three conditions hold:
  i)   Each treatment appears equally often in the design.
  ii)  The design is binary, i.e. each treatment appears in each block either \eqn{n}{n} or \eqn{n}{n}+1 times
       where \eqn{n}{n} is an integer. 
  iii) The number of blocks where treatments \eqn{i}{i} and \eqn{j}{j} each occur \eqn{n}{n}+1 times is the same for all
       pairs of distinct treatments \eqn{(i,j)}{(i,j)}.
  Here the blocks are either rows or columns.
  
  A design that has less columns (rows) than treatments is said to be incomplete with respect to 
  rows (columns). 
  A design that is balanced with respect to both rows and columns is called a generalized Youden design (GYD).
  A GYD for which each treatment occurs equally often in each row (column) is called uniform on the rows (columns).
  If both conditions hold, it is called a generalized latin square. 
  A design where each treatment occurs exactly once in each row and column is called a latin square. 
}
\value{
  If \code{coded} is TRUE, a logical vector of length 8 is retured. The type of design is coded by this vector.
  If \code{coded} is FALSE, no value is returned.
  If \code{invis} is FALSE, the type of design is displayed on the screen.
  If \code{tables} is TRUE, additional incidence tables (occurences of treatments and pairs of treatments) are displayed.
}

\author{Oliver Sailer \email{sailer@statistik.uni-dortmund.de}}

\seealso{ \code{\link{isCbalanced}} }
\examples{
d1 <- matrix( c(1,2,3,4,1,1,1,1), 4,2)          
# d1 is not balanced
d2 <- matrix( c(1:4,2:4,1,4,1:3,3,4,1,2),ncol=4)    
# d2 is a latin square
d3 <- matrix( rep(1:3,each=2), ncol=2)          
# d3 is a balanced incomplete block design.
d1
isGYD(d1,tables=TRUE)  
d2
isGYD(d2,tables=TRUE)
d3
isGYD(d3,tables=TRUE)    
}

\keyword{design }% at least one, from doc/KEYWORDS

\eof
\name{opttodes}
\alias{opttodes}
\title{ Generation of Balanced Incomplete Block Designs Using the Package Dopt }
\description{
  The function \code{Dopt} of the library \code{Dopt} is used to construct balanced incomplete block designs
  (BIBDs). The design is assigned to a matrix where rows represent blocks (subjects) and 
  columns represent periods.  
}
\usage{
opttodes(trt, b, k, iter = 50)
}
\arguments{
  \item{trt}{ An integer > 1 giving the number of treatments of the design. }
  \item{b}{ An integer > 1 giving the number of rows (subjects) of the design. }
  \item{k}{ An integer > 1 giving the number of columns (periods) of the design. }
  \item{iter}{ The number of iterations of the function \code{Dopt} }
}
\details{
  The function \code{Dopt} tries to find a D-optimal block design for the specified parameters.
  The resulting design need not be a BIBD. 
  The necessary conditions for the existence are that \eqn{\frac{bk}{trt}}{bk/trt} and 
   \eqn{\frac{bk(k-1)}{trt(trt-1)}}{bk(k-1)/(trt(trt-1))} positive intergers.
  They are NOT checked automatically.
  Even if they are fulfilled, there need not be a BIBD.  
  If no BIBD is found, the function is iterated.
  If no BIBD is found after \code{iter} iterations, the search is terminated.
  In any case, the resulting design is checked by the function \code{isGYD}, the result is
  displayed on the screen and the resulting design matrix is returned. 
}
\value{
  A matrix that represents the experimental design.
}

\author{Oliver Sailer \email{sailer@statistik.uni-dortmund.de}}
\note{ As indicated above, the returned design is not necessarily a BIBD design.}

\section{Warning }{ This function requires the package \code{Dopt}. 
 As of May 13 2004, CRAN states that \code{Dopt} is a package in development and that such packages may be unstable.
}

\seealso{ \code{\link{get.plan}}, \code{\link[Dopt]{Dopt}}}
\examples{
opttodes(10,30,4)       # BIBD
opttodes(3,3,2)         # BIBD, even GYD
opttodes(5,5,3, 100)    # There is no BIBD for these parameters   
}

\keyword{ design }% at least one, from doc/KEYWORDS

\eof
\name{rand.design.RC}
\alias{rand.design.RC}
\title{Simulation Study to Asses the Validity of a Randomization Procedure}
\description{
  The function performs a simulation study to assess whether randomization of treatment labels and rows (subjects) 
  validates the row-column model
  for a given design. The results are stored to a file. 
}
\usage{
rand.design.RC(design, dat, n, where, tau1, rho)
}
\arguments{
  \item{design}{ A matrix with \eqn{b}{b} rows and \eqn{k}{k} columns representing the experimental design. 
  Treatments are numbered 1,\ldots,\eqn{trt}{trt}. }
  \item{dat}{ A numerical vector with \eqn{bk}{bk} elements giving the data to be used for the simulation study.
              The first \eqn{k}{k} values of \code{dat} correspond to the first row of the design,
              the next \eqn{k}{k} values correspond to the second row etc. }
  \item{n}{ The number of permutations in the simulation study. }
  \item{where}{ Path that gives the location of the simulation results.}
  \item{tau1}{ The value of the main effect of treatment 1. }
  \item{rho}{ The value that is used for the carryover (residual) effects of treatments 1 and 2. }
}
\details{
  The simulation study proceeds as follows:
  For every iteration, treatment labels and rows of the design are randomized. Then the elementary contrast 
  \eqn{tau_1 - tau_{trt}}{tau_1 - tau_trt} is estimated and the estimate of the variance of this contrast is computed.
  These computations are done for each of six situations:
  1) There are no direct or residual effects of treatments.
  2) There is a direct effect of treatment 1.
  In 3) and 4), a residual effect of treatment 2 is added while 
  in 5) and 6), a residual effect of treatment 1 is added.   
  The estimates are then stored to \code{where}.
}
\value{
  There is no value returned. The results are stored in a file.
}
\references{ Bailey, R.A. and Rowley, C.A. (1985): Valid randomization. Proceedings of the Royal Society London A 410, 105-124. 

             Kunert, J. and Sailer, O. (2004): On nearly balanced designs for sensory trials. In preparation.
}
\author{Oliver Sailer \email{sailer@statistik.uni-dortmund.de} }
\note{ You need to call \code{analyze.rand} to display and interpret the results.
       \code{rand.design.RC} just performs the simulation study. }

\seealso{  \code{\link{analyze.rand}}, \code{\link{rand.design.azais}} }
\examples{
\dontrun{ 
# First create a data set to analyze:
d <- matrix(c(1:4,2:4,1,4,1:3,3,4,1,2),ncol=4)
rand.design.RC( d, rnorm(16), 1000, "D:\\mytest.txt", -1, 1 )
# Now do the analysis:
analyze.rand( "D:\\mytest.txt", fig=TRUE, ref=TRUE, 
 refval=c(0, -1, 0, -1, -.25, -1.25) ) 
}
}

\keyword{ design } % at least one, from doc/KEYWORDS

\eof
\name{rand.design.azais}
\alias{rand.design.azais}
\title{Simulation Study to Asses the Validity of a Randomization Procedure}
\description{
   The function performs a simulation study to assess whether a randomization procedure proposed by Azais (1987)
  validates the simple block model for a given design. The results are stored to a file. 
}
\usage{
rand.design.azais(design, dat, n, where, tau1, rho)
}

\arguments{
  \item{design}{ A matrix with \eqn{b}{b} rows and \eqn{k}{k} columns representing the experimental design. 
  Treatments are numbered 1,\ldots,\eqn{trt}{trt}. }
  \item{dat}{ A numerical vector with \eqn{bk}{bk} elements giving the data to be used for the simulation study.
              The first \eqn{k}{k} values of \code{dat} correspond to the first row of the design,
              the next \eqn{k}{k} values correspond to the second row etc. }
  \item{n}{ The number of permutations in the simulation study. }
  \item{where}{ Path that gives the location of the simulation results.}
  \item{tau1}{ The value of the main effect of treatment 1. }
  \item{rho}{ The value that is used for the carryover (residual) effects of treatments 1 and 2. }
}
\details{
  The simulation study proceeds as follows:
  For every iteration, treatment labels and rows of the design are randomized. Then the treatment order in each row
  is permuted cyclically. Then the elementary contrast 
  \eqn{tau_1 - tau_{trt}}{tau_1 - tau_trt} is estimated and the estimate of the variance of this contrast is computed.
  These computations are done for each of six situations:
  1) There are no direct or residual effects of treatments.
  2) There is a direct effect of treatment 1.
  In 3) and 4), a residual effect of treatment 2 is added while 
  in 5) and 6), a residual effect of treatment 1 is added.   
  The estimates are then stored to \code{where}.
}
\value{
  There is no value returned. The results are stored in a file.
}


\references{ 
 Azais, J.M. (1987): Design of experiments for studying intergenotypic competition. 
 Journal of the Royal Statistical Society B 49, 334-345.
 
 Bailey, R.A. and Rowley, C.A. (1987): Valid randomization. Proceedings of the Royal Society London A 410, 105-124. 
 
 Kunert, J. and Sailer, O. (2004): On nearly balanced designs for sensory trials. In preparation.
}

\author{Oliver Sailer \email{sailer@statistik.uni-dortmund.de}}
\note{ You need to call \code{analyze.rand} to display and interpret the results.
       \code{rand.design.azais} just performs the simulation study. }

\seealso{ \code{\link{analyze.rand}}, \code{\link{rand.design.RC}}}
\examples{
\dontrun{ 
# First create a data set to analyze:
d <- matrix(c(1,1,1,2,2,3,4,4,3,4,2,3),ncol=3)
rand.design.azais( d, rnorm(12), 1000, "D:\\mytest.txt", -1, 1 )
# Now do the analysis:
analyze.rand( "D:\\mytest.txt", fig=TRUE, ref=TRUE, 
 refval=c(0, -1, 0, -1, -.5, -1.5) ) 
}
}



\keyword{ design }% at least one, from doc/KEYWORDS

\eof
\name{williams.BIB}
\alias{williams.BIB}
\title{Construction of Carryover Balanced Designs Based on 
 Balanced Incomplete Block Designs}
\description{
  Patterson (1951) combined balanced incomplete block designs (BIBDs) with Williams designs to get 
  carryover balanced generalized Youden designs. 
}
\usage{
williams.BIB(d)
}
\arguments{
  \item{d}{A matrix representing a BIBD. Rows represent blocks (subjects).}
}
\details{
  For each row of the design, a Williams design is constructed using the treatments of that row.
  The rows of the resulting designs are then combined. 
  The treatments are numbered 1,\ldots,\eqn{trt}{trt}. The entry \eqn{(i,j)}{(i,j)} 
  of the design corresponds to the treatment the \eqn{i}{i}-th subject gets in the \eqn{j}{j}-th period.
}

\value{
   A matrix representing the experimental design.
}

\references{ 
Patterson, H.D. (1951): Change-over trials. Journal of the Royal Statistical 
Society B 13, 256-271. 

Wakeling, I.N. and MacFie, H.J.H. (1995): Designing consumer trials balanced for first and higher orders of
carry-over effect when only a subset of k samples from t may be tested. Food Quality and Preference 6, 299-308. 
}
\author{ Oliver Sailer \email{sailer@statistik.uni-dortmund.de}}
\note{  BIBDs may be generated using \code{opttodes}. }

\section{Warning }{ The resultig design is only balanced properly if the input design actually is a BIBD.
 This is NOT checked automatically. You have to do this by yourself, e.g. by applying \code{isGYD} to your design.
} 

\seealso{  \code{\link{get.plan}}, \code{\link{isGYD}}, \code{\link{opttodes}}, \code{\link{williams}} }
\examples{
d <- matrix( rep(1:3,each=2), ncol=2)
# # check for balance
# isGYD(d)
williams.BIB(d)
}

\keyword{ design }% at least one, from doc/KEYWORDS

\eof
\name{williams}
\alias{williams}
\title{Construction of Williams Designs }
\description{
  The function constructs williams designs. Williams designs are row-column designs. They are used if 
  each of the treatments in the study is given to each of the subjects. If the number of 
  treatments to be tested is even, the design is a latin square, otherwise it consists of two latin squares.
}
\usage{
williams(trt)
}
\arguments{
  \item{trt}{ An integer > 1, giving the number of treatments in the design. }
}
\details{
  The resulting design is a (generalized) latin square that is also balanced for first order carryover effects. 
  Carryover balance is achieved with very few subjects.
  In the experimental design the treatments are numbered 1,\ldots,\eqn{trt}{trt}. The entry 
  \eqn{(i,j)}{(i,j)} of the design corresponds 
  to the treatment the \eqn{i}{i}-th subject gets in the \eqn{j}{j}-th period.
}
\value{
  A matrix representing the experimental design.
}
\references{ 
Wakeling, I.N. and MacFie, H.J.H. (1995): Designing consumer trials balanced for first and higher orders of
carry-over effect when only a subset of k samples from t may be tested. Food Quality and Preference 6, 299-308. 

Williams, E. J. (1949): Experimental designs balanced for the estimation of residual effects
of treatments. Australian Journal of Scientific Research, Ser. A 2, 149-168. 
}

\author{ Oliver Sailer \email{sailer@statistik.uni-dortmund.de}}

\seealso{ \code{\link{get.plan}} }
\examples{
williams(3)
williams(10)
}

\keyword{ design }% at least one, from doc/KEYWORDS

\eof
