%                               -*- Mode: Rd -*- 
% autosearch.Rd --- 
% Author          : Claus Dethlefsen
% Created On      : Sat May 25 23:01:29 2002
% Last Modified By: Claus Dethlefsen
% Last Modified On: Fri Jan 09 10:41:43 2004
% Update Count    : 81
% Status          : Unknown, Use with caution!
% 

\name{autosearch}
\alias{autosearch}
\alias{heuristic}
\alias{gettable}

%- Also NEED an `\alias' for EACH other topic documented here.

\title{Greedy search}

\description{
  From initial network, does local perturbations to increase network score.
}

\usage{
autosearch(initnw,data,prior=jointprior(network(data)),maxiter=50,
           trylist= vector("list",size(initnw)),trace=TRUE,
           timetrace=TRUE,showban=FALSE,removecycles=FALSE) 

heuristic(initnw,data,prior=jointprior(network(data)),
          maxiter=100,restart=10,degree=size(initnw),
          trylist= vector("list",size(initnw)),trace=TRUE,
          timetrace=TRUE,removecycles=FALSE)
gettable(x)
}

%- maybe also `usage' for other objects documented here.
\arguments{
  \item{initnw}{an object of class \code{\link{network}}, from which the
    search is started. } 
  \item{data}{a data frame used for learning the network, see
    \code{\link{network}}.} 
  \item{prior}{a list containing parameter priors, generated by
    \code{\link{jointprior}}.} 
 \item{maxiter}{an integer, which gives the maximum number of steps in the
   search algorithm.} 
  \item{restart}{an integer, which gives the number of times to perturb
    \code{initnw} and rerun the 
    search.}
  \item{degree}{an integer, which gives the degree of perturbation, see
    \code{\link{perturb}}.} 
  \item{trylist}{a list used internally for reusing learning of nodes,
    see \code{\link{maketrylist}}.} 
  \item{trace}{a logical. If \code{TRUE}, plots the accepted networks
    during search.} 
  \item{timetrace}{a logical. If \code{TRUE}, prints some timing
    information on the screen.} 
  \item{showban}{a logical passed to  the plot method for network
    objects. If
    \code{FALSE}, the banned arrows are not shown in the plots (if
    \code{trace} is \code{TRUE}).}
  \item{removecycles}{a logical. If \code{TRUE}, all networks explored in the
    search is returned, except for networks containing a cycle. If \code{FALSE}, all networks are returned, including
    cyclic networks.}
  \item{x}{an output object from a search.}
}

\details{
  In \code{autosearch}, a list of networks is in each step
  created with either one
  arrow added, one arrow deleted or one arrow turned (if a cycle is not
  generated). The network scores of all the proposal networks are
  calculated and the network with the highest score is chosen for the
  next step in the search. If no proposed network has a higher network
  score than the previous network, the search is terminated. The
  network with the highest network score is returned, along with a list
  containing all tried networks (depending on the value of \code{removecycles}).

  \code{heuristic} restarts by perturbing \code{initnw}
  \code{degree} times and calling 
  \code{autosearch} again. The number
  of restarts is given by the option \code{restart}.
}

\value{\code{autosearch} and \code{heuristic} returns a list with three
  elements, that may be accessed using \code{\link{getnetwork}},
  \code{\link{gettable}} and \code{\link{gettrylist}}. The elements are
  \item{nw}{an object of class \code{\link{network}}, which gives the
  network with the highest score.}
  \item{table}{a table with all tried
    networks. If removecycles is \code{FALSE}, the networks may contain
    cycles. The table contains two columns: \code{model} with a 
    string representation of the model and \code{score} with the
    corresponding log network score. The table can be translated to a
    \code{\link{networkfamily}} using \code{\link{makenw}}.}  
  \item{trylist}{an updated list used internally for reusing learning
    of nodes, see \code{\link{maketrylist}}.}
}

\seealso{\code{\link{perturb}}
  }


\references{
  Further information about \bold{deal} can be found at:\cr
  \url{http://www.math.auc.dk/novo/deal}.
}

\author{
  Susanne Gammelgaard Bttcher \email{alma@math.auc.dk}, \cr
  Claus Dethlefsen \email{dethlef@math.auc.dk}.
}

%\note{ ~~further notes~~ }

% ~Make other sections like WARNING with \section{WARNING }{....} ~

\examples{
data(rats)
fit       <- network(rats)
fit.prior <- jointprior(fit,12)
fit       <- getnetwork(learn(fit,rats,fit.prior))
fit       <- getnetwork(insert(fit,2,1,rats,fit.prior))
fit       <- getnetwork(insert(fit,1,3,rats,fit.prior))
hisc      <- autosearch(fit,rats,fit.prior,trace=FALSE)
hisc      <- autosearch(fit,rats,fit.prior,trace=FALSE,removecycles=TRUE) # slower
plot(getnetwork(hisc))

hisc2     <- heuristic(fit,rats,fit.prior,restart=10,trace=FALSE)
plot(getnetwork(hisc2))
print(modelstring(getnetwork(hisc2)))
plot(makenw(gettable(hisc2),fit))
}

\keyword{models}

\eof
%                               -*- Mode: Rd -*- 
% deal-internal.Rd --- 
% Author          : Claus Dethlefsen
% Created On      : Wed Jan 07 10:32:46 2004
% Last Modified By: Claus Dethlefsen
% Last Modified On: Tue Apr 27 09:20:00 2004
% Update Count    : 26
% Status          : Unknown, Use with caution!
% 
\name{deal-internal}

\alias{printline}
\alias{post}
\alias{post0}
\alias{postc}
\alias{postc0c}
\alias{postcc}
\alias{postM}
\alias{learnnode}
\alias{udisclik}
\alias{addrandomarrow}
\alias{turnrandomarrow}
\alias{deleterandomarrow}
\alias{addarrows}
\alias{addarrow}
\alias{turnarrow}
\alias{removearrow}
\alias{cycletest}
\alias{findleaf}
\alias{conditional.cont}
\alias{conditional.disc}
\alias{conditional}
\alias{cond.node}
\alias{cond}
\alias{elementin}
\alias{findex}
\alias{jointdisc}
\alias{jointcont}
\alias{localmaster}
\alias{postdist}
\alias{postdist.node}
\alias{nwequal}
\alias{inspectprob}

\alias{Autosearch}
\alias{dealEdges}
\alias{DealLabelAllEdges}
\alias{dealVariableDescription}
\alias{Menus}
\alias{newDealTestObject}
\alias{newnetwork}
\alias{recovernetwork}
\alias{dynamic.Graph}
\alias{testEdge}
\alias{fun}
\alias{modifyModel}

\alias{DealTestClass-class}
\alias{networkclass-class}

\alias{label,DealTestClass-method}
\alias{width,DealTestClass-method}
\alias{dynamic.Graph-methods}
\alias{dynamic.Graph,networkclass-method}
\alias{testEdge-methods}
\alias{modifyModel-methods}
\alias{modifyModel,networkclass-method}
\alias{testEdge,networkclass-method}

\title{deal internal functions}

\description{
  These are functions internally called by other functions
  in the package \code{deal} and not meant to be called by the user.
}

\usage{
printline(s="-",n=60)

post   (mu,tau,rho,phi,y,z,timetrace=FALSE) 
postM  (mu,tau,rho,phi,y,z,timetrace=FALSE) 
postc  (mu,tau,rho,phi,y,z,timetrace=FALSE) 
postcc (mu,tau,rho,phi,y,z,timetrace=FALSE) 
post0  (mu,tau,rho,phi,y,timetrace=FALSE) 
postc0c(mu,tau,rho,phi,y,timetrace=FALSE) 

learnnode(node,nw,df,prior=jointprior(nw),timetrace=FALSE)
udisclik(node,nw,df)

addrandomarrow(nw,data,prior,trylist=vector("list",size(nw)),nocalc=FALSE,
               timetrace=FALSE)
turnrandomarrow(nw,data,prior,trylist=vector("list",size(nw)),nocalc=FALSE,
               timetrace=FALSE)
deleterandomarrow(nw,data,prior,trylist=vector("list",size(nw)),nocalc=FALSE,
               timetrace=timetrace)

addarrows(nw, node, data, prior,trylist=vector("list",size(nw)))

addarrow   (nw,df,prior,trylist=vector("list",size(nw))) 
turnarrow  (nw,df,prior,trylist=vector("list",size(nw))) 
removearrow(nw,df,prior,trylist=vector("list",size(nw))) 

cycletest(nw)
findleaf (nw) 

conditional.cont(A,mu,nu,rho,phi) 
conditional(A,master,nw) 
conditional.disc(A,master) 
cond.node(node,nw,nw.prior=jointprior(nw)) 

elementin(nw,nwl)

findex (i, dim, config=TRUE)

jointdisc(nw,timetrace=FALSE)
jointcont(nw,timetrace=FALSE)

localmaster(family,nw,prior=jointprior(nw))

postdist(nw) 
postdist.node(nd,nw,vtype = "mode")

nwequal(nw1,nw2)

inspectprob(nw,unitscale=20,cexscale=8,
            arrowlength=.25,xr=c(0,350),yr=xr,...) 

	     }

\author{
  Susanne Gammelgaard Bttcher \email{alma@math.auc.dk}, \cr
  Claus Dethlefsen \email{dethlef@math.auc.dk}.
}


\keyword{internal}

\eof
%                               -*- Mode: Rd -*- 
% drawnetwork.Rd --- 
% Author          : Claus Dethlefsen
% Created On      : Sat May 25 23:01:44 2002
% Last Modified By: Claus Dethlefsen
% Last Modified On: Fri Jan 09 10:48:16 2004
% Update Count    : 45
% Status          : Unknown, Use with caution!
% 

\name{drawnetwork}
\alias{drawnetwork}


%- Also NEED an `\alias' for EACH other topic documented here.

\title{Graphical interface for editing networks}

\description{\code{drawnetwork} allows the user to specify a Bayesian network through a point and click interface.
}

\usage{
drawnetwork(nw,df,prior,trylist=vector("list",size(nw)),
            unitscale=20,cexscale=8,
            arrowlength=.25,nocalc=FALSE,
            yr=c(0,350),xr=yr,...)


}

%- maybe also `usage' for other objects documented here.
\arguments{
  \item{nw}{an object of class \code{\link{network}} to be edited.}
  \item{df}{a data frame used for learning the network, see
    \code{\link{network}}.} 
  \item{prior}{a list containing parameter priors, generated by
    \code{\link{jointprior}}.} 
  \item{trylist}{a list used internally for reusing learning of nodes,
    see \code{\link{maketrylist}}.} 
  \item{cexscale}{a numeric passed to the plot method for network
    objects. Measures the scaled size of text and symbols.} 
  \item{arrowlength}{a numeric passed to
     the plot method for network
    objects. Measures the length of the edges of the arrowheads.}
  \item{nocalc}{a logical. If \code{TRUE}, no learning procedure is called, see eg. \code{\link{rnetwork}}.}
  \item{unitscale}{a numeric passed to
     the plot method for network
    objects. Scale parameter for chopping off arrow heads.}
  \item{xr}{a numeric vector with two components containing the range on x-axis.}
  \item{yr}{a numeric vector with two components containing the range on y-axis.}
  \item{...}{additional plot arguments, passed to  the plot method for network
    objects.}
}

\details{
To insert an arrow from node 'A' to node 'B', first click node 'A' and
then click node 'B'. When the graph is finished, click 'stop'.

To specify that an arrow must not be present, press 'ban' (a toggle)
and draw the arrow. This is shown as a red dashed arrow. It is possible
to ban both directions between nodes. The ban list is stored with the
network in the property \code{banlist}. It is a matrix with two
columns. Each row is the 'from' node index and the 'to' node index,
where the indices are the column number in the data frame.

Note that the network score changes as the network is re-learned
whenever a change is made (unless \code{nocalc} is \code{TRUE}).

}

\value{A list with two elements that may be accessed using
  \code{\link{getnetwork}} and \code{\link{gettrylist}}. The elements are
  \item{nw}{an object of class \code{\link{network}} with the final network.}
  \item{trylist}{an updated list used internally for reusing learning
    of nodes, see \code{\link{maketrylist}}.}
}

\seealso{\code{\link{network}}
  }

\references{
  Further information about \bold{deal} can be found at:\cr
  \url{http://www.math.auc.dk/novo/deal}.
}

\author{
  Susanne Gammelgaard Bttcher \email{alma@math.auc.dk}, \cr
  Claus Dethlefsen \email{dethlef@math.auc.dk}.
}


\examples{
data(rats)
rats.nw    <- network(rats)
rats.prior <- jointprior(rats.nw,12)
rats.nw    <- getnetwork(learn(rats.nw,rats,rats.prior))

\dontrun{newrat  <- getnetwork(drawnetwork(rats.nw,rats,rats.prior))}
}

\keyword{models}

\eof
%                               -*- Mode: Rd -*- 
% genlatex.Rd --- 
% Author          : Claus Dethlefsen
% Created On      : Sat May 25 23:02:07 2002
% Last Modified By: Claus Dethlefsen
% Last Modified On: Wed Jan 07 09:16:22 2004
% Update Count    : 12
% Status          : Unknown, Use with caution!
% 

\name{genlatex}
\alias{genlatex}
\alias{genpicfile}

%- Also NEED an `\alias' for EACH other topic documented here.

\title{From a network family, generate LaTeX output}

\description{The networks in a network family is arranged as
  pictex-graphs in a LaTeX-table. 
}

\usage{
genlatex(nwl,outdir="pic/",prefix="scoretable",picdir="",picpre="pic",
         ncol=5,nrow=7,width=12/ncol,vadjust=-1.8)
genpicfile (nwl,outdir="pic/",prefix="pic",w=1.6,h=1.6,bigscale=3) 
}

%- maybe also `usage' for other objects documented here.
\arguments{
  \item{nwl}{object of class \code{networkfamily} containing a list of
    objects of class \code{network}.}
  \item{outdir}{character string, the directory for storing output.}
  \item{prefix}{character string, the filename (without extension) of the LaTeX file. The
    filenames of the picfiles begin with the given prefix.} 
  \item{picdir}{character string, the directory where pic-files are stored.}
  \item{picpre}{character string, prefix for pic-files.}
  \item{ncol}{integer, the number of columns in LaTeX table.}
  \item{nrow}{integer, the number of rows in LaTeX table.}
  \item{width}{numeric, the width of each cell in the LaTeX table.}
  \item{vadjust}{numeric, the vertical adjustment in LaTeX table.}
  \item{w}{numeric, the width of pictex objects}
  \item{h}{numeric, the height of pictex objects}
  \item{bigscale}{numeric, the scaling of the best network, which is output in 'nice.tex'}
  
}

\value{Files:

  \item{\{outdir\}\{picpre\}xx.tex}{one pictex file for each network in the
  network family, indexed by xx.}

  \item{\{outdir\}\{prefix\}.tex}{LaTeX file with table including all pictex files.}

  \item{\{outdir\}\{picpre\}nice.tex}{pictex file with the best network.}
}

\seealso{\code{\link{networkfamily}}}

\author{
  Susanne Gammelgaard Bttcher \email{alma@math.auc.dk}, \cr
  Claus Dethlefsen \email{dethlef@math.auc.dk}.
}

%\note{ ~~further notes~~ }

% ~Make other sections like WARNING with \section{WARNING }{....} ~

\examples{
data(rats)
allrats <- getnetwork(networkfamily(rats,network(rats)))
allrats <- nwfsort(allrats)

\dontrun{dir.create("c:/temp")}
\dontrun{genpicfile(allrats,outdir="c:/temp/pic/")}
\dontrun{genlatex(allrats,outdir="c:/temp/pic/",picdir="c:/temp/pic/")}

## LATEX FILE:
#\documentclass{article}
#\usepackage{array,pictex}
#\begin{document}
#\input{scoretable}
#\input{picnice}
#\end{document}
}

\keyword{iplot}

\eof
%                               -*- Mode: Rd -*- 
% insert.Rd --- 
% Author          : Claus Dethlefsen
% Created On      : Sat May 25 23:02:17 2002
% Last Modified By: Claus Dethlefsen
% Last Modified On: Fri Jan 09 10:25:58 2004
% Update Count    : 22
% Status          : Unknown, Use with caution!
% 

\name{insert}
\alias{insert}
\alias{remover}

%- Also NEED an `\alias' for EACH other topic documented here.

\title{Insert/remove an arrow in network}

\description{Inserts/removes one arrow in a network (if legal)
}

\usage{
insert (nw,j,i,df,prior,nocalc=FALSE,trylist=vector("list",size(nw))) 
remover(nw,j,i,df,prior,nocalc=FALSE,trylist=vector("list",size(nw))) 
}

%- maybe also `usage' for other objects documented here.
\arguments{
  \item{nw}{an object of class \code{\link{network}}.}
  \item{j}{integer, giving the index of the 'from' node.}
  \item{i}{integer, giving the index of the 'to' node.}
  \item{df}{a data frame used for learning the network, see
    \code{\link{network}}.} 
  \item{prior}{a list describing parameter priors, generated by
    \code{\link{jointprior}}.} 
  \item{nocalc}{a logical. If \code{TRUE}, learning is not called.}
  \item{trylist}{a list, used internally for reusing learning of nodes,
    see \code{\link{maketrylist}}.} }

\details{
  Examines if the arrow from \code{j} to \code{i} is legal according to
  the following criteria
  \item{1.}{Arrows from/to the same node are not legal.}
  \item{2.}{Arrows from continous nodes to discrete nodes are not legal.}
  \item{3.}{Arrows banned in ban list are not legal, see \code{\link{drawnetwork}}.}
  \item{4.}{Arrows already existing in the network are not legal.}

  If the arrow is not legal, a \code{NULL} network is returned. Otherwise, the
  arrow is inserted/removed, the network is re-learned (if
  \code{nocalc} is \code{FALSE}). The trylist is updated.
}

\value{A list with two elements
  \item{nw}{an object of class \code{\link{network}} with the arrow
    added/removed if this is possible. If not, \code{NULL} is returned.}
  \item{trylist}{an updated list, used internally for reusing learning
    of nodes, see \code{\link{maketrylist}}.}
}

\references{
  Further information about \bold{deal} can be found at:\cr
  \url{http://www.math.auc.dk/novo/deal}.
}


\author{
  Susanne Gammelgaard Bttcher \email{alma@math.auc.dk}, \cr
  Claus Dethlefsen \email{dethlef@math.auc.dk}.
}

%\note{ ~~further notes~~ }

% ~Make other sections like WARNING with \section{WARNING }{....} ~

\examples{
data(rats)
rats.nw    <- network(rats)
rats.nw    <- getnetwork(insert(rats.nw,2,1,nocalc=TRUE))
rats.prior <- jointprior(rats.nw,12)

rats.nw2   <- network(rats)
rats.nw2   <- getnetwork(learn(rats.nw2,rats,rats.prior))
rats.nw2   <- getnetwork(insert(rats.nw2,1,2,rats,rats.prior))

rats.nw3   <- getnetwork(remover(rats.nw2,1,2,rats,rats.prior))
}

\keyword{iplot}

\eof
%                               -*- Mode: Rd -*- 
% jointprior.Rd --- 
% Author          : Claus Dethlefsen
% Created On      : Sat May 25 23:02:21 2002
% Last Modified By: Claus Dethlefsen
% Last Modified On: Thu Jan 08 15:36:27 2004
% Update Count    : 59
% Status          : Unknown, Use with caution!
% 

\name{jointprior}
\alias{jointprior}

%- Also NEED an `\alias' for EACH other topic documented here.

\title{Calculates the joint prior distribution}

\description{Given a network with a \code{prob} property for each node, derives the
  joint probability distribution. Then the quantities needed in
the local master procedure for finding the local parameter priors are
deduced.}

\usage{
jointprior(nw,N=NA,phiprior="bottcher",timetrace=FALSE) 
}

%- maybe also `usage' for other objects documented here.
\arguments{
  \item{nw}{an object of class \code{\link{network}}. Each node must
    have a \code{prob} property to describe the local probability
    distribution. The \code{prob} property
    is created using \code{\link{prob}} method for network objects, which is called by the
    \code{\link{network}} function.}
  \item{N}{an integer, which gives the size of the imaginary data base. If
    this is too small, 
    \code{NA}'s may be created in the output, resulting in errors in
    \code{\link{learn}}. If no \code{N} is given, the procedure tries to 
    set a value as low as possible.} 
  \item{phiprior}{a string, which specifies how the prior for phi is
    calculated. Either \code{phiprior="bottcher"} or
    \code{phiprior="heckerman"} can be used.} 
  \item{timetrace}{a logical. If \code{TRUE}, prints some timing
    information on the screen.} 
}

\details{For the discrete part of the network, the joint probability
  distribution is 
  calculated by multiplying together the local probability
  distributions. Then, \code{jointalpha} is determined by multiplying
  each entry in the joint probability distribution by the size of the
  imaginary data base \code{N}. 

  For the mixed part of the network, for each configuration of the discrete
  variables, the joint Gaussian distribution of the continuous
  variables is constructed and represented by \code{jointmu} (one
  row for each configuration of the discrete parents) and
  \code{jointsigma} (a list of matrices -- one for each configuration of
  the discrete parents). The configurations of the discrete parents are
  ordered according to \code{\link{findex}}. The algorithm for
  constructing the joint distribution of the continuous variables is
  described in Shachter and Kenley (1989). 

  Then, \code{jointalpha}, \code{jointnu}, \code{jointrho}, \code{mu} and
  \code{jointphi} are deduced. These quantities are later used for
deriving local parameter priors.

  For each configuration \code{i} of the discrete variables,
  \deqn{\nu_i=\rho_i=\alpha_i}{nu[i]=rho[i]=jointalpha[i]} and
  \deqn{\phi_i = (\nu_i -1)\Sigma_i}{phi[i] = (nu[i] -1)Sigma[i]}
  if \code{phiprior="bottcher"}, see Bttcher(2001) and
  \deqn{\phi_i = \nu_i(\rho_i -2)\Sigma_i/(\nu_i+1)}{phi[i] = nu[i](rho[i] -2)Sigma[i]/(nu[i]+1) }
  if \code{phiprior="heckerman"}, see Heckerman, Geiger and Chickering (1995).

}

\value{
  A list with the following elements,
  \item{jointalpha}{a table used in the local master procedure for discrete variables.}
  \item{jointnu}{a table used in the local master procedure for continuous variables.}
  \item{jointrho}{a table used in the local master procedure for continuous variables.}
  \item{jointmu}{a numeric matrix used in the local master procedure for continuous variables.}
  \item{jointsigma}{a list of numeric matrices (not used in further calculations).}
  \item{jointphi}{a list of numeric matrices used in the local master procedure for continuous variables.}
}

\seealso{\code{\link{network}}, \code{\link{prob}}
  }

  \references{
    Bttcher, S.G. (2001). Learning Bayesian Networks with Mixed Variables, {\em Artificial Intelligence and Statistics 2001}, Morgan Kaufmann, San Francisco, CA, USA, 149-156.

    Heckerman, D., Geiger, D. and Chickering, D. (1995). Learning Bayesian
    networks: The combination of knowledge and statistical data. Machine
    Learning {\bf 20}: 197-243.  

Shachter, R.D. and Kenley, C.R. (1989), Gaussian influence diagrams. Management
    Science {\bf 35}:527-550.
    
  Further information about \bold{deal} can be found at:\cr
  \url{http://www.math.auc.dk/novo/deal}.
}

\author{
  Susanne Gammelgaard Bttcher \email{alma@math.auc.dk}, \cr
  Claus Dethlefsen \email{dethlef@math.auc.dk}.
}

%\note{ ~~further notes~~ }

% ~Make other sections like WARNING with \section{WARNING }{....} ~

\examples{
data(rats)
rats.nw    <- network(rats)
rats.prior <- jointprior(rats.nw,12)

\dontrun{savenet(rats.nw,file("rats.net"))}
\dontrun{rats.nw <- readnet(file("rats.net"))}
\dontrun{rats.nw <- prob(rats.nw,rats)}
\dontrun{rats.prior <- jointprior(rats.nw,12)}

}

\keyword{models}

\eof


\name{ksl}
\alias{ksl}
\non_function{}
\title{Health and social characteristics}
\description{
 Data from a study measuring health and social characteristics of 
 representative samples of Danish 70 year olds, taken in 1967 and 1984.
}
\format{A data frame with variables of both discrete and continuous
  types.
  \describe{
    \item{FEV}{Forced ejection volume}
    \item{Kol}{Cholesterol}
    \item{Hyp}{Hypertension (no/yes)}
    \item{logBMI}{Logarithm of Body Mass Index}
    \item{Smok}{Smoking (no/yes)}
    \item{Alc}{Alcohol consumption (seldom/frequently)}
    \item{Work}{Working (yes/no)}
    \item{Sex}{male/female}
    \item{Year}{Survey year (1967/1984)}
    }
 }
\references{
%  Morrison, D.F. (1976). Multivariate Statistical Methods. McGraw-Hill, USA.

%  Edwards, D. (1995). Introduction to Graphical Modelling,
%  Springer-Verlag. New York.

  Further information about \bold{deal} can be found at:\cr
  \url{http://www.math.auc.dk/novo/deal}.

  
}
\keyword{datasets}


\eof
%                               -*- Mode: Rd -*- 
% learn.Rd --- 
% Author          : Claus Dethlefsen
% Created On      : Sat May 25 23:02:26 2002
% Last Modified By: Claus Dethlefsen
% Last Modified On: Fri Jan 09 10:50:49 2004
% Update Count    : 82
% Status          : Unknown, Use with caution!
% 

\name{learn}
\alias{learn}

%- Also NEED an `\alias' for EACH other topic documented here.

\title{Estimation of parameters in the local probability
distributions}

\description{Updates the distributions of the parameters in the network,
  based on a prior network and data. Also, the network score is calculated.
}

\usage{
learn (nw, df, prior=jointprior(nw),
               nodelist=1:size(nw),
               trylist=vector("list",size(nw)),
               timetrace=FALSE) 

}

%- maybe also `usage' for other objects documented here.
\arguments{
  \item{nw}{an object of class \code{\link{network}}.}
  \item{df}{a data frame used for learning the network, see
    \code{\link{network}}.} 
  \item{prior}{a list containing parameter priors, generated by
    \code{\link{jointprior}}.} 
  \item{nodelist}{a numeric vector of indices of nodes to be learned.}
  \item{trylist}{a list used internally for reusing learning of nodes,
    see \code{\link{maketrylist}}.} 
  \item{timetrace}{a logical. If \code{TRUE}, prints some timing
    information on the screen.} 
}

\details{
  The procedure \code{learn} determines the master prior, local parameter
  priors and local parameter posteriors, see Bttcher (2001). It may be called on all nodes
  (default) or just a single node. 
  
  From the joint prior distribution, the marginal distribution of
  all parameters in the family consisting of the node and its parents
  can be determined. This is the master prior, see
  \code{\link{localmaster}}.

  The local parameter priors are now determined by conditioning in
  the master prior distribution, see
  \code{\link{conditional}}. The hyperparameters associated with the
  local parameter prior distribution is attached to each node in the
  property \code{condprior}.

  Finally, the local parameter posterior distributions are calculated (see
  \code{\link{post}}) and attached to each node in the property
  \code{condposterior}. 
  
  A so-called trylist is maintained to speedup the learning process. The
  trylist consists of a list of
  matrices for each node. The matrix for a given node holds previously
  evaluated parent configurations and the corresponding log-likelihood
  contribution. If a node with a certain parent
  configuration needs to be learned, it is checked, whether the node has
  already been learned. The previously learned nodes are given as input
  in the trylist parameter and is updated in the learning procedure. 

  When one or more nodes in a network have been learned, the network
  score is updated and attached to the network in the property
  \code{score}.  

  The learning procedure is called from various functions using the
  principle, that networks should always be updated with their
  score. Thus, e.g.\ \code{\link{drawnetwork}} keeps the network updated
  when the graph is altered.

}

\seealso{\code{\link{networkfamily}},
\code{\link{jointprior}},
\code{\link{maketrylist}},
\code{\link{network}}
}

\value{A list with two elements that may be accessed using
  \code{\link{getnetwork}} and \code{\link{gettrylist}}. The elements are
  \item{nw}{an object of class \code{\link{network}}, with the
    \code{condposterior} properties updated for 
    the nodes. Also, the property \code{score} is updated and contains
    the network score. The contribution to the network score for each
    node is contained in the property \code{loglik} for each node.}
  \item{trylist}{an updated list used internally for reusing learning
    of nodes, see \code{\link{maketrylist}}.}
}

\references{
 Bttcher, S.G. (2001). Learning Bayesian Networks with Mixed Variables, {\em Artificial Intelligence and Statistics 2001}, Morgan Kaufmann, San Francisco, CA, USA, 149-156.

  Further information about \bold{deal} can be found at:\cr
  \url{http://www.math.auc.dk/novo/deal}.
}

\author{
  Susanne Gammelgaard Bttcher \email{alma@math.auc.dk}, \cr
  Claus Dethlefsen \email{dethlef@math.auc.dk}.
}


\examples{
data(rats)
fit       <- network(rats)
fit.prior <- jointprior(fit,12)
fit.learn <- learn(fit,rats,fit.prior,timetrace=TRUE)
fit.nw    <- getnetwork(fit.learn)
fit.learn2<- learn(fit,rats,fit.prior,trylist=gettrylist(fit.learn),timetrace=TRUE)
}

\keyword{iplot}

\eof
%                               -*- Mode: Rd -*- 
% makesimprob.Rd --- 
% Author          : Claus Dethlefsen
% Created On      : Sat May 25 23:02:48 2002
% Last Modified By: Claus Dethlefsen
% Last Modified On: Wed Jan 14 08:27:33 2004
% Update Count    : 20
% Status          : Unknown, Use with caution!
% 

\name{makesimprob}
\alias{makesimprob}

%- Also NEED an `\alias' for EACH other topic documented here.

\title{Make a suggestion for simulation probabilities}

\description{Creates local probability distributions reflecting the
  graph of the network. These are attached as a \code{simprob} property
  to each node in the network and can be edited and used for
  \code{\link{rnetwork}}. 
}

\usage{
makesimprob(nw,
                        s2=function(idx,cf) {
                          cf <- as.vector(cf)
                          xs <- (1:length(cf))
                          log(xs\%*\%cf+1)
                        },
                        m0=function(idx,cf) {
                          cf <- as.vector(cf)
                          xs <- (1:length(cf))^2
                          .69*(xs\%*\%cf)
                          },
                        m1=function(idx,cf) {
                          cf <- as.vector(cf)
                          xs <- (1:length(cf))*10
                          idx*(cf\%*\%xs)
                          })
}

%- maybe also `usage' for other objects documented here.
\arguments{
  \item{nw}{an object of class \code{\link{network}}.}
  \item{s2}{function that returns the variance as a function of the node
    index and the configuration of the discrete variables.}
  \item{m0}{function that returns the intercept  as a function of the node
    index and the configuration of the discrete variables.}
  \item{m1}{function that returns the regression coefficients as a
    function of the node 
    index and the configuration of the discrete variables.}
}

\details{
  For each node, the local \code{simprob} is determined. If the node is
  discrete, the probability distribution is uniform (and thus not
  reflecting the dependence in the graph, as it should). If the node is
  continuous, one mean and variance is attached per configuration of the
  discrete parents. The mean depends on the continuos parents and is the
  regression coefficients determined by the functions \code{m0}
  (intercept) and \code{m1} (regression coefficients). The variance is
  determined by the function \code{s2}.
}

\value{The network object \code{nw}, where each node has attached the
  property  \code{simprob}.}

\references{
  Further information about \bold{deal} can be found at:\cr
  \url{http://www.math.auc.dk/novo/deal}.
}

\seealso{\code{\link{rnetwork}}}

\author{
  Susanne Gammelgaard Bttcher \email{alma@math.auc.dk}, \cr
  Claus Dethlefsen \email{dethlef@math.auc.dk}.
}

%\note{ ~~further notes~~ }

% ~Make other sections like WARNING with \section{WARNING }{....} ~


\keyword{models}

\eof
%                               -*- Mode: Rd -*- 
% maketrylist.Rd --- 
% Author          : Claus Dethlefsen
% Created On      : Sat May 25 23:02:52 2002
% Last Modified By: Claus Dethlefsen
% Last Modified On: Wed Jan 07 08:58:09 2004
% Update Count    : 20
% Status          : Unknown, Use with caution!
% 

\name{maketrylist}
\alias{maketrylist}

%- Also NEED an `\alias' for EACH other topic documented here.

\title{Creates the full trylist}

\description{For faster learning, a trylist is maintained as a lookup
  table for a given parent configuration of a node.}

\usage{
maketrylist(initnw,data,prior=jointprior(network(data)),timetrace=FALSE) 
}

%- maybe also `usage' for other objects documented here.
\arguments{
 \item{initnw}{an object of class \code{\link{network}}, from which the
    search is started. } 
  \item{data}{a data frame used for learning the network, see
    \code{\link{network}}.} 
  \item{prior}{a list containing parameter priors, generated by
    \code{\link{jointprior}}.} 
\item{timetrace}{a logical. If \code{TRUE}, prints some timing
    information on the screen.} 
}

\details{This procedure is included for illustrative purposes. For each
  node in the 
  network, all possible parent 
  configurations are created and learned. The result is called a
  trylist. To create the full trylist is very time-consuming,
  and a better choice is to maintain a trylist while searching and
  indeed this is automatically done. The trylist is given as output to
  all functions that call the learning procedure and can be given as an
  argument. 
}

\value{A list with one element per node in the network. In the list,
  element \emph{i} is a matrix with two columns: a string with the
  indices of the parent nodes, separated by ":", and a numeric with the
  log-likelihood contribution of the node given the parent
  configuration. Whenever learning is performed of a node given a parent
  configuration, the trylist is consulted to yield faster learning,
  especially useful when using \code{\link{autosearch}} or
  \code{\link{heuristic}}.
} 


\references{
  Further information about \bold{Deal} can be found at:\cr
  \url{http://www.math.auc.dk/novo/deal}.
}


\author{
  Susanne Gammelgaard Bttcher \email{alma@math.auc.dk}, \cr
  Claus Dethlefsen \email{dethlef@math.auc.dk}.
}

\seealso{ 
  \code{\link{networkfamily}},
  \code{\link{autosearch}}
  \code{\link{heuristic}}
  }


  \examples{
data(rats)
rats.nw <- network(rats)
rats.pr <- jointprior(rats.nw,12)
rats.nw <- getnetwork(learn(rats.nw,rats,rats.pr))
rats.tr <- maketrylist(rats.nw,rats,rats.pr)

rats.hi <- getnetwork(heuristic(rats.nw,rats,rats.pr,trylist=rats.tr))
}

\keyword{models}

\eof
%                               -*- Mode: Rd -*- 
% network.Rd --- 
% Author          : Claus Dethlefsen
% Created On      : Sat May 25 23:03:21 2002
% Last Modified By: Claus Dethlefsen
% Last Modified On: Fri Jan 09 12:38:41 2004
% Update Count    : 84
% Status          : Unknown, Use with caution!
% 

\name{network}
\alias{network}
\alias{plot.network}
\alias{print.network}

%- Also NEED an `\alias' for EACH other topic documented here.

\title{Bayesian network data structure}

\description{
  A Bayesian network is represented as an object of class
  \code{network}. Methods for printing and plotting are defined. 
}

\usage{
network(df,specifygraph=FALSE,inspectprob=FALSE,
        doprob=TRUE,yr=c(0,350),xr=yr) 
\method{print}{network}(x,filename=NA,condposterior=FALSE,
                          condprior=FALSE,...) 
\method{plot}{network} (x,arrowlength=.25,
                        notext=FALSE,
                        sscale=7,showban=TRUE,yr=c(0,350),xr=yr,
                        unitscale=20,cexscale=8,...)


}

%- maybe also `usage' for other objects documented here.
\arguments{
  \item{df}{a data frame, where the columns define the variables. A
    continuous variable should have type \code{numeric} and discrete varibles
    should have type \code{\link[base]{factor}}.}
  \item{specifygraph}{a logical. If \code{TRUE}, provides a call to
    \code{\link{drawnetwork}} to interactively specify a directed
    acyclic graph and possibly a ban list (see below).}
  \item{inspectprob}{a logical. If \code{TRUE}, provides a plot of the
    graph and possibility to inspect the calculated probability
    distribution by clicking on the nodes.}
  \item{doprob}{a logical. If \code{TRUE}, do not calculate a
    probability distribution. Used 
    for example in \code{\link{rnetwork}}. }
  \item{x}{an object of class \code{\link{network}}.}
  \item{filename}{a string or \code{NA}. If not \code{NA}, output is
    printed to a file.} 
  \item{condprior}{a logical. If \code{TRUE}, the conditional prior is
    printed, see \code{\link{conditional}}.}
  \item{condposterior}{a logical. If \code{TRUE}, the conditional posterior is
    printed, see \code{\link{learn}}.}
  \item{sscale}{a numeric. The nodes are initially placed on a circle
    with radius \code{sscale}.} 
  \item{unitscale}{a numeric. Scale parameter for chopping off arrow heads.}
  \item{cexscale}{a numeric. Scale parameter to set the size of the nodes.}
  \item{arrowlength}{a numeric containing the length of the arrow heads.}
  \item{xr}{a numeric vector with two components containing the range on x-axis.}
  \item{yr}{a numeric vector with two components containing the range on y-axis.}
  \item{notext}{a logical. If \code{TRUE}, no text is displayed in the nodes on the plot.}
  \item{showban}{a logical. If \code{TRUE}, banned arrows are shown in red.}
  \item{\dots}{additional plot arguments, passed to \code{\link{plot.node}}.}
}


\value{
  The \code{netork} creator function returns an object of class
  \code{network}, which is a list with the following 
  elements (properties),
  \item{nodes}{a list of objects of class \code{node}. If
    \code{doprob} is \code{TRUE}, the nodes are given the 
    property \code{prob} which is the initial probability distribution used
    by \code{\link{jointprior}}.}
  \item{n}{an integer containing the number of nodes in the network.}
  \item{discrete}{a numeric vector of indices of discrete nodes.}
  \item{continuous}{a numeric vector of indices of continuous nodes.}
  \item{banlist}{a numeric matrix with two columns. Each row contains the
    indices \code{i -> j} of arrows that may not be allowed in the
    directed acyclic graph.}
  \item{score}{a numeric added by \code{\link{learn}} and is the log network
    score.}
  \item{relscore}{a numeric added by \code{\link{nwfsort}} and is the relative
     network score -- compared with the best network in a network family.}
}

\seealso{\code{\link{networkfamily}},
  \code{\link{node}},
  \code{\link{rnetwork}},
  \code{\link{learn}},
  \code{\link{drawnetwork}},
  \code{\link{jointprior}},
  \code{\link{heuristic}},
  \code{\link{nwequal}}
  }

\references{
  Further information about \bold{deal} can be found at:\cr
  \url{http://www.math.auc.dk/novo/deal}.
}

\author{
  Susanne Gammelgaard Bttcher \email{alma@math.auc.dk}, \cr
  Claus Dethlefsen \email{dethlef@math.auc.dk}.
}

%\note{ ~~further notes~~ }

% ~Make other sections like WARNING with \section{WARNING }{....} ~

\examples{
A <- factor(rep(c("A1","A2"),50))
B <- factor(rep(rep(c("B1","B2"),25),2))
thisnet <- network( data.frame(A,B) )

set.seed(109)
sex     <- gl(2,4,label=c("male","female"))
age     <- gl(2,2,8)
yield   <- rnorm(length(sex))
weight  <- rnorm(length(sex))
mydata  <- data.frame(sex,age,yield,weight)
mynw    <- network(mydata)

# adjust prior probability distribution
localprob(mynw,"sex")   <- c(0.4,0.6)
localprob(mynw,"age")   <- c(0.6,0.4)
localprob(mynw,"yield") <- c(2,0)
localprob(mynw,"weight")<- c(1,0)

print(mynw)
plot(mynw)

prior <- jointprior(mynw)
mynw  <- getnetwork(learn(mynw,mydata,prior))
thebest <- getnetwork(autosearch(mynw,mydata,prior))

print(mynw,condposterior=TRUE)

\dontrun{savenet(mynw,file("yield.net"))}
}

\keyword{models}

\eof
%                               -*- Mode: Rd -*- 
% networkfamily.Rd --- 
% Author          : Claus Dethlefsen
% Created On      : Sat May 25 23:03:26 2002
% Last Modified By: Claus Dethlefsen
% Last Modified On: Wed Jan 14 08:27:43 2004
% Update Count    : 42
% Status          : Unknown, Use with caution!
% 

\name{networkfamily}
\alias{networkfamily}
\alias{print.networkfamily}
\alias{plot.networkfamily}

%- Also NEED an `\alias' for EACH other topic documented here.

\title{Generates and learns all networks for a set of variables.}

\description{Method for generating and learning all networks that are
possible for a given set of variables. These may be
  plotted or printed. Also, functions for
sorting according to the network score (see \code{\link{nwfsort}}) and for 
making a network family unique (see the \code{unique} method for
\code{networkfamily} objects) are available.  }

\usage{
networkfamily(data,nw=network(data), prior=jointprior(nw),
              trylist=vector("list",size(nw)), timetrace=TRUE) 

\method{print}{networkfamily}(x,...)
\method{plot}{networkfamily}(x,layout=,
        cexscale=5,arrowlength=0.1,sscale=7,...) 
}

%- maybe also `usage' for other objects documented here.
\arguments{
  \item{nw}{an object of class \code{\link{network}}. This should be the
  empty network for the set of variables.}
  \item{data}{a data frame used for learning the network, see
    \code{\link{network}}.} 
  \item{prior}{a list containing parameter priors, generated by
    \code{\link{jointprior}}.} 
  \item{trylist}{a list used internally for reusing learning of nodes,
    see \code{\link{maketrylist}}.} 
  \item{timetrace}{a logical. If \code{TRUE}, prints some timing
    information on the screen.} 
  \item{x}{an object of class \code{networkfamily}.}
  \item{layout}{a numeric two dimensional vector with the number of plots in the rows
    and columns of each plotting page. Default set to \code{rep(min(1+floor(sqrt(length(x))),5),2)}.}
  \item{cexscale}{a numeric. A scaling parameter to set the size of the nodes.}
  \item{arrowlength}{a numeric, which gives the length of the arrow heads.}
  \item{sscale}{a numeric. The nodes are initially placed on a circle
    with radius \code{sscale}.} 
  \item{...}{additional plot arguments passed to the plot method for network
    objects.}
}

\details{
  \code{networkfamily} generates and learns all possible networks with
  the nodes given as in the initial network \code{nw}. This is done by
  successively trying to generate the networks with all possible arrows
  to/from each node (see \code{\link{addarrows}}). If there is a ban list
  present in \code{nw} (see \code{\link{network}}), then this is
  respected, as are the restrictions described in \code{\link{insert}}.

  After generation of all possible networks, a test for cycles (see
  \code{\link{cycletest}}) is performed and only networks with directed
  acyclic graphs are returned.

}

\value{The function \code{networkfamily} returns a list with two components,
  \item{nw}{an object of class \code{networkfamily}.}
  \item{trylist}{an updated list used internally for reusing learning
    of nodes, see \code{\link{maketrylist}}.}
}

\note{
  Generating all possible networks can be \emph{very} time consuming!
}

\author{
  Susanne Gammelgaard Bttcher \email{alma@math.auc.dk}, \cr
  Claus Dethlefsen \email{dethlef@math.auc.dk}.
}

\references{
  Further information about \bold{deal} can be found at:\cr
  \url{http://www.math.auc.dk/novo/deal}.
}


\seealso{\code{\link{network}},
  \code{\link{genlatex}},
  \code{\link{heuristic}},
  \code{\link{nwfsort}},
  \code{\link{unique.networkfamily}},
  \code{\link{elementin}},
  \code{\link{addarrows}},
  \code{\link{cycletest}}
}

\examples{
data(rats)
allrats <- getnetwork(networkfamily(rats))
plot(allrats)
print(allrats)
}

\keyword{iplot}

\eof
%                               -*- Mode: Rd -*- 
% networktools.Rd --- 
% Author          : Claus Dethlefsen
% Created On      : Wed Jan 07 12:35:45 2004
% Last Modified By: Claus Dethlefsen
% Last Modified On: Fri Jan 09 12:36:08 2004
% Update Count    : 13
% Status          : Unknown, Use with caution!
% 

\name{Network tools}
\alias{modelstring}
\alias{makenw}
\alias{size}
\alias{as.network}
\alias{banlist}
\alias{getnetwork}
\alias{gettrylist}
\alias{banlist<-}

\title{Tools for manipulating networks}

\description{Various extraction/replacement functions for networks}

\usage{
modelstring(x)
makenw(tb,template)
as.network(nwstring,template)
size(x)
banlist(x)
banlist(x) <- value
getnetwork(x)
gettrylist(x)
}

\arguments{
    \item{x}{an object of class \code{\link{network}}.} 
  \item{tb}{a table output from \code{\link{autosearch}} or
    \code{\link{heuristic}} in the list property \code{table}. Can be
    translated into a \code{\link{networkfamily}}.}
  \item{template}{an object of class \code{\link{network}} with the same
    nodes as the networks described in the table \code{tb}.}
  \item{nwstring}{a string representing the network.}
  \item{value}{a numeric matrix with two columns. Each row contains the
    indices \code{i -> j} of arrows that may not be allowed in the
    directed acyclic graph.}
}

\details{
    The string representation of a network is a minimal size
  representation to speed up calculations. The functions
  \code{modelstring}, \code{as.network} and \code{makenw} converts
  between the string represention and network objects.

  \code{size} extracts the number of nodes in a network object.

  \code{banlist} extracts the banlist from a network object.

  \code{getnetwork} and \code{gettrylist} are accessor function that
  extracts a network object or trylist from the result from
  \code{\link{autosearch}}, \code{\link{heuristic}},
  \code{\link{learn}}, \code{\link{perturb}}, 
  \code{\link{networkfamily}}, \code{\link{drawnetwork}}.
}

\keyword{models}

\eof
%                               -*- Mode: Rd -*- 
% node.Rd --- 
% Author          : Claus Dethlefsen
% Created On      : Sat May 25 23:03:31 2002
% Last Modified By: Claus Dethlefsen
% Last Modified On: Fri Jan 09 10:58:31 2004
% Update Count    : 79
% Status          : Unknown, Use with caution!
% 

\name{node}
\alias{node}
\alias{plot.node}
\alias{print.node}
\alias{nodes}
\alias{nodes<-}

%- Also NEED an `\alias' for EACH other topic documented here.

\title{Representation of nodes}

\description{An important part of a \code{\link{network}} is the list of
  nodes. The nodes summarize the local properties of a node, given the
  parents of the node.
}

\usage{
node (idx,parents,type="discrete",name=paste(idx),
                 levels=2,levelnames=paste(1:levels),position=c(0,0)) 
\method{print}{node} (x,filename=NA,condposterior=TRUE,condprior=TRUE,...) 
\method{plot}{node} (x,cexscale=10,notext=FALSE,...)
nodes(nw)
value <- nodes(nw)
}

%- maybe also `usage' for other objects documented here.
\arguments{
  \item{x}{an object of class \code{node}.}
  \item{parents}{a numeric vector with indices of the parents of the node.}
  \item{idx}{an integer, which gives the index of the node (the column number of the
    corresponding data frame).}
  \item{type}{a string, which gives the type of the node. Either
    \code{"discrete"} (for factors) or \code{"continuous"} (for numeric).}
  \item{name}{a string, which gives the name used when plotting and
    printing. Defaults to the column 
    name in the data frame.}
  \item{levels}{an integer. If \code{type} is \code{"discrete"}, this is
    the number of levels for the discrete variable.}
  \item{levelnames}{if \code{type} is \code{"discrete"}, this is a vector of
    strings (same length as \code{levels}) with the names of the
    levels. If \code{type} is \code{"continuous"}, the argument is ignored.}
  \item{position}{a numeric vector with coordinates where the node should
    appear in the 
    plot. Usually set by \code{\link{network}} and \code{\link{drawnetwork}}.}
  \item{nw}{an object of class \code{\link{network}}.}
  \item{value}{a list of elements of class \code{\link{node}}.}
  \item{filename}{a string or \code{NA}. If not \code{NA}, output is
    printed to a file.} 
  \item{condprior}{a logical. If \code{TRUE}, the conditional prior is
    printed, see \code{\link{conditional}}.}
  \item{condposterior}{a logical. If \code{TRUE}, the conditional posterior is
    printed, see \code{\link{learn}}.}
  \item{cexscale}{a numeric. Scale parameter to set the size of the nodes.}
  \item{notext}{a logical. If \code{TRUE}, no text is displayed in the nodes on the plot.}
  \item{\dots}{additional plot arguments.}
}

\details{
  The operations on a node are typically done when operating on a
  \code{\link{network}}, so these functions are not to be called
  directly. 

  When a network is created with \code{network}, the nodes in the
  nodelist are created using the \code{node} procedure.

  Local
  probability distributions are added as the property \code{prob} to
  each node using \code{prob.node}. If the node is continuous, this is a
  numeric vector with 
  the conditional variance and the conditional regression coefficients
  arising from a regression on the continuous parents, using data. If
  the node has discrete parents, \code{prob} is a matrix with a row
  for each configuration of the discrete parents. If the node is
  discrete, \code{prob} is a multiway array which gives the conditional
  probability distribution for each configuration of the discrete
  parents. The generated \code{prob} can be replaced to match the prior
  information available.

  \code{nodes} gives the list of nodes of a network. \code{localprob}
  gives the probability distribution for each node in the network.
  }

\value{
  The \code{node} creator function returns an object of class
  \code{node}, which is a list with the following 
  elements (properties),
  \item{idx}{an integer. A unique index for this node. It MUST
    correspond to the column index of the variable in the data frame.}
  \item{name}{a string. The printed name of the node.}
  \item{type}{a string. Either \code{"continuous"} or \code{"discrete"}.}
  \item{levels}{an integer. If the node is of type \code{"discrete"}, this
    integer is the 
    number of levels of the node.}
  \item{levelnames}{if \code{type} is \code{"discrete"}, this is a vector of
    strings (same length as \code{levels}) with the names of the
    levels. If \code{type} is \code{"continuous"}, the node does not have this property.}
  \item{parents}{a vector of indices of the parents to this node. It is
    best to manage this vector using the \code{\link{insert}} function.}
  \item{prob}{a numeric vector, matrix or multiway array, giving the
    initial probability distribution. If the node is discrete,
    \code{prob} is a multiway array. If the node is continuous,
    \code{prob} is a matrix with one row for each configuration of the
    discrete parents, reducing to a vector if the node has no discrete parents.}
  \item{condprior}{a list, generated by \code{\link{conditional}} giving
    the parameter priors deduced from
    \code{\link{jointprior}} using the master prior procedure (see
    \code{\link{localmaster}}). }
  \item{condposterior}{a list, which gives the parameter posteriors obtained from
    \code{\link{learnnode}}.}
  \item{loglik}{a numeric giving the log likelihood contribution for this node,
    calculated in \code{\link{learnnode}}.}
  \item{simprob}{a numeric vector, matrix or multiway array similar to \code{prob}, added by
    \code{\link{makesimprob}} and used by \code{\link{rnetwork}}.}
}

\references{
  Further information about \bold{deal} can be found at:\cr
  \url{http://www.math.auc.dk/novo/deal}.
}

\author{
  Susanne Gammelgaard Bttcher \email{alma@math.auc.dk}, \cr
  Claus Dethlefsen \email{dethlef@math.auc.dk}.
}

%\note{ ~~further notes~~ }

% ~Make other sections like WARNING with \section{WARNING }{....} ~

\keyword{models}

\eof
%                               -*- Mode: Rd -*- 
% numbermixed.Rd --- 
% Author          : Claus Dethlefsen
% Created On      : Sat May 25 23:03:38 2002
% Last Modified By: Claus Dethlefsen
% Last Modified On: Fri Jan 09 10:38:13 2004
% Update Count    : 8
% Status          : Unknown, Use with caution!
% 

\name{numbermixed}
\alias{numbermixed}

%- Also NEED an `\alias' for EACH other topic documented here.

\title{The number of possible networks}

\description{Calculates the number of different directed acyclic graphs
  for a set of discrete and continuous nodes. }

\usage{
numbermixed(nd,nc)
}

%- maybe also `usage' for other objects documented here.
\arguments{
  \item{nd}{an integer, which gives the number of discrete nodes.}
  \item{nc}{an integer, which gives the number of continuous nodes.}
}

\details{
  No arrows are allowed from continuous nodes to discrete nodes. Cycles
  are not allowed. The
  number of networks is given by Bttcher (2003), using the result in
  Robinson (1977).

  When nd+nc>15, the procedure is quite slow.
}

\value{
  A numeric containing the number of directed acyclic graphs with the given node
  configuration. 
}

\references{
  Bttcher, S.G. (2003). Learning Conditional Gaussian
  Networks. \url{http://www.math.auc.dk/~alma}. Aalborg University, 2003.

  Robinson, R.W. (1977). Counting unlabeled acyclic digraphs, {\em Lecture
  Notes in Mathematics}, 622: Combinatorial Mathematics.

  Further information about \bold{deal} can be found at:\cr
  \url{http://www.math.auc.dk/novo/deal}.

}

\author{
  Susanne Gammelgaard Bttcher \email{alma@math.auc.dk}, \cr
  Claus Dethlefsen \email{dethlef@math.auc.dk}.
}

%\note{ ~~further notes~~ }

% ~Make other sections like WARNING with \section{WARNING }{....} ~

\examples{
numbermixed(2,2)
\dontrun{numbermixed(5,10)}
}

\keyword{models}

\eof
%                               -*- Mode: Rd -*- 
% nwfsort.Rd --- 
% Author          : Claus Dethlefsen
% Created On      : Sat May 25 23:03:47 2002
% Last Modified By: Claus Dethlefsen
% Last Modified On: Fri Jul 25 14:35:47 2003
% Update Count    : 7
% Status          : Unknown, Use with caution!
% 

\name{nwfsort}
\alias{nwfsort}

%- Also NEED an `\alias' for EACH other topic documented here.

\title{Sorts a list of networks}

\description{According to the \code{score} property of the networks in
  a network family, the networks are sorted and the relative score,
i.e.\ the score of a network relative to the
  highest score, is attached to each network as the \code{relscore}
  property. 
}

\usage{
nwfsort(nwf)
}

%- maybe also `usage' for other objects documented here.
\arguments{
  \item{nwf}{an object of class \code{networkfamily}.}
}


\author{
  Susanne Gammelgaard Bttcher \email{alma@math.auc.dk}, \cr
  Claus Dethlefsen \email{dethlef@math.auc.dk}.
}

%\note{ ~~further notes~~ }

% ~Make other sections like WARNING with \section{WARNING }{....} ~
\references{
  Further information about \bold{deal} can be found at:\cr
  \url{http://www.math.auc.dk/novo/deal}.
}


\keyword{iplot}

\eof
%                               -*- Mode: Rd -*- 
% nwfunique.Rd --- 
% Author          : Claus Dethlefsen
% Created On      : Sat May 25 23:03:51 2002
% Last Modified By: Claus Dethlefsen
% Last Modified On: Wed Jan 07 09:18:38 2004
% Update Count    : 15
% Status          : Unknown, Use with caution!
% 

\name{unique.networkfamily}
\alias{unique.networkfamily}

%- Also NEED an `\alias' for EACH other topic documented here.

\title{Makes a network family unique.}

\description{Removes networks that are equal or equivalent to networks already in the network family.
}

\usage{
\method{unique}{networkfamily}(x,incomparables=FALSE,equi=FALSE,timetrace=FALSE,epsilon=1e-12,...)
}

%- maybe also `usage' for other objects documented here.
\arguments{
  \item{x}{an object of class \code{networkfamily}.}
  \item{incomparables}{a logical, but has no effect.}
   \item{equi}{a logical. If \code{TRUE}, also equivalent networks are
     thrown out 
(\emph{i.e.} if
     their score is within \code{epsilon} from another network).}
   \item{timetrace}{a logical. If \code{TRUE}, prints some timing
    information on the screen.} 
   \item{epsilon}{a numeric, which measures how close network scores are
     allowed to be from each other to be 'equivalent'.}
   \item{...}{further arguments (no effect)}
}



\author{
  Susanne Gammelgaard Bttcher \email{alma@math.auc.dk}, \cr
  Claus Dethlefsen \email{dethlef@math.auc.dk}.
}
\references{
  Further information about \bold{deal} can be found at:\cr
  \url{http://www.math.auc.dk/novo/deal}.
}

%\note{ ~~further notes~~ }

% ~Make other sections like WARNING with \section{WARNING }{....} ~

\examples{
data(rats)
rats.nwf <- networkfamily(rats)
rats.nwf2<- unique(getnetwork(rats.nwf),equi=TRUE)
}
\keyword{iplot}

\eof
%                               -*- Mode: Rd -*- 
% perturb.Rd --- 
% Author          : Claus Dethlefsen
% Created On      : Sat May 25 23:03:54 2002
% Last Modified By: Claus Dethlefsen
% Last Modified On: Fri Jan 09 10:59:49 2004
% Update Count    : 26
% Status          : Unknown, Use with caution!
% 

\name{perturb}
\alias{perturb}

%- Also NEED an `\alias' for EACH other topic documented here.

\title{Perturbs a network}

\description{Randomly insert/delete/turn arrows to obtain another network.
}

\usage{
perturb(nw,data,prior,degree=size(nw),trylist=vector("list",size(nw)),
        nocalc=FALSE,timetrace=TRUE) 
}

%- maybe also `usage' for other objects documented here.
\arguments{
  \item{nw}{an object of class \code{network}, from which arrows are added/removed/turned.}
  \item{data}{a data frame used for learning the network, see
    \code{\link{network}}.} 
  \item{prior}{a list containing parameter priors, generated by
    \code{\link{jointprior}}.} 
  \item{degree}{an integer, which gives the number of attempts to randomly
    insert/remove/turn an arrow.}
  \item{trylist}{a list used internally for reusing learning of nodes,
    see \code{\link{maketrylist}}.} 
  \item{nocalc}{a logical. If \code{TRUE} no learning procedure is called, see eg. \code{\link{rnetwork}}.}
  \item{timetrace}{a logical. If \code{TRUE}, prints some timing
    information on the screen.} 
}

\details{
  Given the initial network, a new network is constructed by randomly
  choosing an action: remove, turn, add. After the action is chosen, we
  choose randomly among all possibilities of that action. If there are
  no possibilites, the unchanged network is returned.}

\value{A list with two elements that may be accessed using
  \code{\link{getnetwork}} and \code{\link{gettrylist}}. The elements are
  \item{nw}{an object of class \code{\link{network}} with the generated network.}
  \item{trylist}{an updated list used internally for reusing learning
    of nodes, see \code{\link{maketrylist}}.}
}

\references{
  Further information about \bold{deal} can be found at:\cr
  \url{http://www.math.auc.dk/novo/deal}.
}


\author{
  Susanne Gammelgaard Bttcher \email{alma@math.auc.dk}, \cr
  Claus Dethlefsen \email{dethlef@math.auc.dk}.
}

%\note{ ~~further notes~~ }

% ~Make other sections like WARNING with \section{WARNING }{....} ~

\examples{
set.seed(200)
data(rats)
fit       <- network(rats)
fit.prior <- jointprior(fit)
fit       <- getnetwork(learn(fit,rats,fit.prior))
fit.new   <- getnetwork(perturb(fit,rats,fit.prior,degree=10))

data(ksl)
ksl.nw    <- network(ksl)
ksl.rand  <- getnetwork(perturb(ksl.nw,nocalc=TRUE,degree=10))
plot(ksl.rand)
}

\keyword{iplot}

\eof
%                               -*- Mode: Rd -*- 
% prob.Rd --- 
% Author          : Claus Dethlefsen
% Created On      : Sat May 25 23:03:31 2002
% Last Modified By: Claus Dethlefsen
% Last Modified On: Fri Jan 09 13:51:28 2004
% Update Count    : 13
% Status          : Unknown, Use with caution!
% 

\name{prob}
\alias{prob}
\alias{prob.network}
\alias{prob.node}
\alias{localprob}
\alias{localprob<-}
\alias{localprior}
\alias{localposterior}

%- Also NEED an `\alias' for EACH other topic documented here.

\title{Local probability distributions}

\description{Methods for accessing or changing the local probability
  distributions and for accessing the local prior and posterior distributions
}

\usage{
prob(x,df,...)

\method{prob}{node} (x,df,nw,...)
\method{prob}{network} (x,df,...)

localprob(nw)
value <- localprob(nw,name)

localprior(node)
localposterior(node)

}

%- maybe also `usage' for other objects documented here.
\arguments{
  \item{x}{an object of class \code{node} or \code{network}.}
  \item{df}{a data frame, where the columns define the variables. A
    continuous variable should have type \code{numeric} and discrete varibles
    should have type \code{\link[base]{factor}}.}
  \item{nw}{an object of class \code{\link{network}}.}
  \item{node}{an object of class \code{\link{node}}.}
  \item{name}{a string, which gives the node name.}
  \item{\dots}{additional arguments for specific methods.}
}

\details{
  The \code{prob} methods add local
  probability distributions to
  each node. If the node is continuous, this is a
  numeric vector with 
  the conditional variance and the conditional regression coefficients
  arising from a regression on the continuous parents, using data. If
  the node has discrete parents, \code{prob} is a matrix with a row
  for each configuration of the discrete parents. If the node is
  discrete, \code{prob} is a multiway array which gives the conditional
  probability distribution for each configuration of the discrete
  parents. The generated \code{prob} can be replaced to match the prior
  information available.

  \code{localprob} returns the probability distribution
  for each node in the network.

  In a learned network, the local prior and posterior can be accessed
  for each node using \code{localprior} and \code{localposterior}.
  
  }
\references{
  Further information about \bold{deal} can be found at:\cr
  \url{http://www.math.auc.dk/novo/deal}.
}

\author{
  Susanne Gammelgaard Bttcher \email{alma@math.auc.dk}, \cr
  Claus Dethlefsen \email{dethlef@math.auc.dk}.
}

%\note{ ~~further notes~~ }

% ~Make other sections like WARNING with \section{WARNING }{....} ~

\keyword{models}

\eof
%                               -*- Mode: Rd -*- 
% rats.Rd --- 
% Author          : Claus Dethlefsen
% Created On      : Sat May 25 23:04:20 2002
% Last Modified By: Claus Dethlefsen
% Last Modified On: Thu Jul 24 15:40:23 2003
% Update Count    : 10
% Status          : Unknown, Use with caution!
% 

\name{rats}
\alias{rats}
\non_function{}
\title{Weightloss of rats}
\description{
  An artificial data set. 24 rats (12 female, 12 male) have been
  randomized to use one of three drugs (products for loosing
  weight). The weightloss for each rat is noted after one and two
  weeks. 
}
\format{A data frame with 4 variables.
  \describe{
    \item{Sex}{a factor with two levels: "M" (male), "F" (female)}
    \item{Drug}{a factor with three levels: "D1", "D2", "D3" (three types)}
    \item{W1}{a numeric: weightloss, week one.}
    \item{W2}{a numeric: weightloss, week 2.}
  }
  }
\references{
  Morrison, D.F. (1976). Multivariate Statistical Methods. McGraw-Hill, USA.

  Edwards, D. (1995). Introduction to Graphical Modelling,
  Springer-Verlag. New York.

  Further information about \bold{deal} can be found at:\cr
  \url{http://www.math.auc.dk/novo/deal}.

  
}
\keyword{datasets}


\eof
\name{readnet}
\alias{readnet}
\alias{savenet}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Reads/saves .net file}
\description{
Reads/saves a Bayesian network specification in the \code{.net} language (see
\url{http://developer.hugin.com/documentation/net/}).
}
\usage{
readnet(con=file("default.net"))
savenet(nw, con=file("default.net"))
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{con}{a connection.}
  \item{nw}{an object of class \code{\link{network}}.}
}
\details{
  \code{readnet} reads only the structure of a network, i.e.\ the
  directed acyclic graph.

  \code{savenet} exports the \code{prob} property for each node in the
  network object along with the network structure defined by the parents
  of each node. 
} 
\value{
  \code{readnet} creates an object of class \code{\link{network}} with
  the nodes specified as 
  in the \code{.net} connection. The network 
  has not been learned and the nodes do not have \code{prob} properties
  (see \code{\link{prob.network}}).

  \code{savenet} writes the object to the connection.
}
\author{
  Susanne Gammelgaard Bttcher \email{alma@math.auc.dk}, \cr
  Claus Dethlefsen \email{dethlef@math.auc.dk}.
}
\references{
  Further information about \bold{deal} can be found at:\cr
  \url{http://www.math.auc.dk/novo/deal}.
}

\note{The call to \code{readnet(savenet(network))} is \emph{not} the identity
  function as information is thrown away in both \code{savenet} and
  \code{readnet}.} 

\seealso{\code{\link{network}}}

\examples{
data(rats)
nw <- network(rats)
\dontrun{savenet(nw,file("default.net"))}
\dontrun{nw2 <- readnet(file("default.net"))}
\dontrun{nw2 <- prob(nw2,rats)}

}
\keyword{ iplot }% at least one, from doc/KEYWORDS

\eof
%                               -*- Mode: Rd -*- 
% simulation.Rd --- 
% Author          : Claus Dethlefsen
% Created On      : Sat May 25 23:04:28 2002
% Last Modified By: Claus Dethlefsen
% Last Modified On: Tue Jan 06 14:03:28 2004
% Update Count    : 21
% Status          : Unknown, Use with caution!
% 

\name{rnetwork}
\alias{rnetwork}

%- Also NEED an `\alias' for EACH other topic documented here.

\title{Simulation of data sets with a given dependency structure}

\description{
  Given a network with nodes having the \code{simprob} property,
  \code{rnetwork} simulates
a data set.  }

\usage{
rnetwork(nw, n=24, file="") 
}

%- maybe also `usage' for other objects documented here.
\arguments{
  \item{nw}{an object of class \code{\link{network}}, where each node
    has the property \code{simprob} (see \code{\link{makesimprob}}).}
  \item{n}{an integer, which gives the number of cases to simulate.}
  \item{file}{a string. If non-empty, the data set is stored there.}
}

\details{
  The variables are simulated one at a time in an order that ensures
  that the parents of the node have already been simulated. For discrete
  variables a multinomial distribution is used and for continuous
  variables, a Gaussian distribution is used, according to the
  \code{simprob} property in each node.
}

\value{
  A data frame with one row per case. If a file name is given, a file is
  created with the data set.
}

\references{
  Further information about \bold{deal} can be found at:\cr
  \url{http://www.math.auc.dk/novo/deal}.
}


\author{
  Susanne Gammelgaard Bttcher \email{alma@math.auc.dk}, \cr
  Claus Dethlefsen \email{dethlef@math.auc.dk}.
}

%\note{ ~~further notes~~ }

% ~Make other sections like WARNING with \section{WARNING }{....} ~

\examples{
A  <- factor(NA,levels=paste("A",1:2,sep=""))
B  <- factor(NA,levels=paste("B",1:3,sep=""))
c1 <- NA
c2 <- NA
df <- data.frame(A,B,c1,c2)

nw <- network(df,doprob=FALSE) # doprob must be FALSE
nw <- makesimprob(nw)          # create simprob properties

set.seed(944) 
sim <- rnetwork(nw,n=100)    # create simulated data frame
}

\keyword{models}

\eof
%                               -*- Mode: Rd -*- 
% score.Rd --- 
% Author          : Claus Dethlefsen
% Created On      : Sat May 25 23:03:31 2002
% Last Modified By: Claus Dethlefsen
% Last Modified On: Wed Jan 07 14:41:43 2004
% Update Count    : 2
% Status          : Unknown, Use with caution!
% 

\name{score}
\alias{score}
\alias{score.network}
\alias{score.node}

%- Also NEED an `\alias' for EACH other topic documented here.

\title{Network score}

\description{
}

\usage{
score(x,...)

\method{score}{node}    (x,...)
\method{score}{network} (x,...)

}

%- maybe also `usage' for other objects documented here.
\arguments{
  \item{x}{an object of class \code{node} or \code{network}.}
  \item{\dots}{additional arguments for specific methods.}
}

\value{For networks, the log network score is returned. For nodes, the
  contribution to the log network score is returned.
}
\references{
  Further information about \bold{deal} can be found at:\cr
  \url{http://www.math.auc.dk/novo/deal}.
}

\author{
  Susanne Gammelgaard Bttcher \email{alma@math.auc.dk}, \cr
  Claus Dethlefsen \email{dethlef@math.auc.dk}.
}

%\note{ ~~further notes~~ }

% ~Make other sections like WARNING with \section{WARNING }{....} ~

\keyword{models}

\eof
