\name{dip}
\alias{dip}
\title{Compute Hartigan's Dip Test Statistic for Unimodality}
\description{
  Computes Hartigan's dip test statistic for testing unimodality,
  and additionally the modal interval.
}
\usage{
dip(x, full.result = FALSE, debug = FALSE)
}
\arguments{
  \item{x}{numeric; the data.}
  \item{full.result}{logical; if \code{TRUE} returns the full result
    list, see below.}
  \item{debug}{logical; if true, some tracing information is printed
    (from the C routine).}
}
\value{
  depending on \code{full.result} either a number, the dip statistic, or
  a list with components
  \item{x}{the sorted \code{\link{unname}()}d data.}
  \item{n}{\code{length(x)}.}
  \item{dip}{the dip statistic}
  \item{lo.hi}{indices into \code{x} for lower and higher end of modal interval}
  \item{xl, xu}{lower and upper end of modal interval}
  \item{gcm, lcm}{(last used) indices for \bold{g}reatest \bold{c}onvex
    \bold{m}inorant and the \bold{l}east \bold{c}oncave \bold{m}ajorant.}
  \item{mn, mj}{index vectors of length \code{n} for the GC minorant and
    the LC majorant respectively.}
}
\note{
  For \eqn{n \le 3}{n <= 3} where \code{n <- length(x)}, the dip
  statistic is always zero, i.e., there's no possible dip test.

  Yong Lu \email{lyongu+@cs.cmu.edu} found in Oct 2003 that the code
  wasn't giving symmetric results for mirrored data (and was giving
  results of almost 1, and then found the reason, a misplaced ")" in the
  original Fortran code.  This bug has been corrected for diptest
  version 0.25-0.
}
\references{
  P. M. Hartigan (1985)
  Computation of the Dip Statistic to Test for Unimodality;
  \emph{Applied Statistics (JRSS C)} \bold{34}, 320--325.

  J. A. Hartigan and P. M. Hartigan (1985)
  The Dip Test of Unimodality;
  \emph{Annals of Statistics} \bold{13}, 70--84.
}
\author{Martin Maechler \email{maechler@stat.math.ethz.ch}, based on
  earlier code from Dario Ringach \email{dario@wotan.cns.nyu.edu}
}
\seealso{\code{\link{isoreg}} for isotonic regression.}
\examples{
data(statfaculty)
plot(density(statfaculty))
dip(statfaculty)

str(dip(statfaculty, full = TRUE, debug = TRUE))

data(faithful)
fE <- faithful$eruptions
plot(density(fE))
str(dip(fE, full = TRUE, debug = TRUE))

data(precip)
plot(density(precip))
str(dip(precip, full = TRUE, debug = TRUE))
}
\keyword{htest}
\keyword{distribution}

\eof
\name{exHartigan}
\alias{exHartigan}
\title{Hartigan's Artificial n-modal Example Data Set}
\description{
 63 (integer) numbers; unimodal or bimodal, that's the question.
}
\examples{
data(exHartigan)
plot(dH <- density(exHartigan))
rug(exHartigan)# should jitter
}
\keyword{data}

\eof
\name{qDiptab}
\alias{qDiptab}
\title{Table of Quantiles from a Large Simulation for Hartigan's Dip Test}
\docType{data}
\description{
  Whereas Hartigan(1985) published a table of empirical percentage
  points of the dip statistic (see \code{\link{dip}}) based on N=9999
  samples of size \eqn{n} from \eqn{U[0,1]}, our table of empirical
  quantiles is currently based on N=1'000'001 samples for each \eqn{n}.
}
\note{
  Taking N=1'000'001 ensures that all the \code{\link{quantile}(X, p)}
  used here are exactly order statistics \code{sort(X)[k]}.
}
\format{
  A numeric matrix %may change: of dimension 17 * 26,
  where each row corresponds to sample size \eqn{n}, and each column to
  a probability (percentage) in \eqn{[0,1]}.  The dimnames are named
  \code{n} and \code{Pr} and coercable to these values, see the
  examples.  \code{attr(qDiptab, "N_1")} is \eqn{N - 1}, such that with
  \code{k <- as.numeric(dimnames(qDiptab)$Pr) * attr(qDiptab, "N_1")},
  e.g., \code{qDiptab[n == 15,]} contains exactly the order statistics
  \eqn{D_{[k]}} (from the \eqn{N+1} simulated values of
  \code{\link{dip}(U)}, where \code{U <- runif(15)}.
}
\seealso{\code{\link{dip}}, also for the references.}
\author{Martin Maechler \email{maechler@stat.math.ethz.ch}
}
\examples{
data(qDiptab)
str(qDiptab)
## the sample sizes `n' :
dnqd <- dimnames(qDiptab)
(nn <- as.integer(dnqd $n))
## the probabilities:
P.p <- as.numeric(print(dnqd $ Pr))

## This is as "Table 1" in Hartigan & Hartigan (1985) -- but more accurate
ps <- c(1,5,10,50,90,95,99, 99.5, 99.9)/100
tab1 <- qDiptab[nn <= 200,  as.character(ps)]
round(tab1, 4)
}
\keyword{datasets}

\eof
\name{statfaculty}
\alias{statfaculty}
\title{Faculty Quality in Statistics Departments}
\docType{data}
\usage{
data(statfaculty)
}
\description{
 Faculty quality in statistics departments was assessed as part of a
 larger study reported by Scully(1982).
}
\format{A numeric vector of 63 (integer) numbers, sorted increasingly,
  as reported by the reference.
}
\references{
  J. A. Hartigan and P. M. Hartigan (1985)
  The Dip Test of Unimodality;
  \emph{Annals of Statistics} \bold{13}, 70--84.
}
\source
  M. G. Scully (1982)
  Evaluation of 596 programs in mathematics and physical sciences;
  \emph{Chronicle Higher Educ.} \bold{25} 5, 8--10.
}
\examples{
data(statfaculty)
plot(dH <- density(statfaculty))
rug(jitter(statfaculty))
}
\keyword{datasets}

\eof
