### Name: lm.disp
### Title: Normal dispersion models.
### Aliases: lm.disp summary.dispmod
### Keywords: models regression

### ** Examples

data(minitab)
attach(minitab)

y <- V^(1/3)
summary(mod <- lm(y ~ H + D))

summary(mod.disp1 <- lm.disp(y ~ H + D))
summary(mod.disp2 <- lm.disp(y ~ H + D, ~ H))

# Likelihood ratio test
deviances <- c(mod.disp1$initial.deviance, mod.disp2$deviance, mod.disp1$deviance)
lrt <- c(NA, abs(diff(deviances)))
cbind(deviances, lrt, p.value=1-pchisq(lrt, 1))

# quadratic dispersion model on D (as discussed by Aitkin)
summary(mod.disp4 <- lm.disp(y ~ H + D, ~ D + I(D^2)))
r <- mod$residuals
plot(D, log(r^2))
phi.est <- mod.disp4$var$fitted.values
lines(D, log(phi.est))



