### Name: tfstart
### Title: Extract Time Frame Information
### Aliases: tfstart tfstart.default tfstart.tstframe start.tframed
###   start.tframe tfend tfend.default tfend.tstframe end.tframed
###   end.tframe tffrequency tffrequency.default frequency.tframed
###   frequency.tframe tfperiods tfperiods.default tfperiods.stamped
###   periods periods.default periods.tframed periods.tframe tftime
###   tftime.default time.tframed time.tframe
### Keywords: programming utilities ts chron

### ** Examples

    z <- ts(rnorm(100), start=c(1982,1), frequency=12)
    tfstart(z)
    z <- tframed(matrix(rnorm(200), 100,2), 
            tf=list(start=c(1982,1), frequency=12))
    tfend(z)
    periods(z)
    time(z)



