l.SS                  package:dse1                  R Documentation

_E_v_a_l_u_a_t_e _a _s_t_a_t_e _s_p_a_c_e _T_S_m_o_d_e_l

_D_e_s_c_r_i_p_t_i_o_n:

     Evaluate a state space TSmodel.

_U_s_a_g_e:

         ## S3 method for class 'SS':
         l(obj1, obj2, sampleT=NULL, predictT=NULL, error.weights=0,
              return.state=FALSE, return.track=FALSE, result=NULL, 
              compiled=.DSECOMPILED,
              warn=TRUE, return.debug.info=FALSE, ...)

_A_r_g_u_m_e_n_t_s:

    obj1: An 'SS' 'TSmodel' object.

    obj2: A TSdata object.

 sampleT: an integer indicating the last data point to use  for one
          step ahead filter estimation. If NULL all available data is
          used. 

predictT: an integer indicating how far past the end of the  sample
          predictions should be made. For models with an input,  input
          data must be provided up to predictT. Output data is 
          necessary only to sampleT. If NULL predictT is set to
          sampleT.

error.weights: a vector of weights to be applied to the  squared
          prediction errors.

return.state: if TRUE the element 'filter$state'  containing
          E[z(t)|y(t-1), u(t)] is returned as part of the  result. This
          can be a fairly large matrix.

return.track: if TRUE the element 'filter$track' containing the
          expectation of the tracking error given y(t-1) and u(t) is 
          returned as part of the result. This can be an very large
          array. 

  result: if result is not specified an object of class  TSestModel is
          returned. Otherwise, the specified element  of
          'TSestModel$estimates' is returned.

compiled: if TRUE the compiled version of the code is used.  Otherwise
          the S/R version is used.

    warn: if FALSE then certain warning messages are turned off.

return.debug.info: logical indicating if additional debugging
          information should be returned.

     ...: (further arguments, currently disregarded).

_D_e_t_a_i_l_s:

     This function is called by the function l() when the argument to l
     is a state space model. Using l() is usually preferable to calling
     l.SS directly. l.SS calls a compiled program unless
     compiled=FALSE. The compiled version is much faster than the S
     version.

     Output data must be at least as long as sampleT. If sampleT is not
     supplied it is taken to be periods(data).

     Input data must be at least as long as predictT. predictT must be
     at least as large as sampleT. If predictT is not supplied it is
     taken to be sampleT.

     If 'error.weights' is greater than zero then weighted prediction 
     errors are calculated up to the horizon indicated by the length of
     error.weights. The weights are applied to the squared error at
     each period ahead.

_V_a_l_u_e:

     Usually an object of class TSestModel (see TSestModel), but see
     result above.

_S_e_e _A_l_s_o:

     'SS' 'l' 'l.ARMA' 'TSmodel' 'TSestModel.object' 'smoother'

_E_x_a_m_p_l_e_s:

     if(is.R()) data("eg1.DSE.data.diff", package="dse1")
     model <- toSS(TSmodel(estVARXls(eg1.DSE.data.diff)))
     lmodel <- l.SS(model,eg1.DSE.data.diff)

