### Name: summary.effect
### Title: Summarizing, Printing, and Plotting Effects
### Aliases: print.effect print.effect.list print.summary.effect
###   summary.effect summary.effect.list plot.effect plot.effect.list
### Keywords: hplot models

### ** Examples

data(Cowles)
mod.cowles <- glm(volunteer ~ sex + neuroticism*extraversion, 
    data=Cowles, family=binomial)
eff.cowles <- all.effects(mod.cowles, xlevels=list(neuroticism=0:24, 
    extraversion=seq(0, 24, 6)))
eff.cowles
    ## Not run: 
##D     model: volunteer ~ sex + neuroticism * extraversion
##D     
##D     sex effect
##D     sex
##D     female      male 
##D     0.4409441 0.3811941 
##D     
##D     neuroticism*extraversion effect
##D             extraversion
##D     neuroticism          0         6        12        18        24
##D             0  0.07801066 0.1871263 0.3851143 0.6301824 0.8225756
##D             1  0.08636001 0.1963396 0.3870453 0.6200668 0.8083638
##D             2  0.09551039 0.2058918 0.3889798 0.6098458 0.7932997
##D             3  0.10551835 0.2157839 0.3909179 0.5995275 0.7773775
##D            . . .
##D             23 0.51953129 0.4747277 0.4303273 0.3870199 0.3454282
##D             24 0.54709527 0.4895731 0.4323256 0.3768303 0.3243880
##D     
## End(Not run)
plot(eff.cowles, 'sex', ylab="Prob(Volunteer)")
    ## Not run: 
##D     Loading required package: lattice 
##D     
## End(Not run)

plot(eff.cowles, 'neuroticism:extraversion', ylab="Prob(Volunteer)",
    ticks=list(at=c(.1,.25,.5,.75,.9)))

plot(eff.cowles, 'neuroticism:extraversion', multiline=TRUE, 
    ylab="Prob(Volunteer)")
    
plot(effect('sex:neuroticism:extraversion', mod.cowles,
    xlevels=list(neuroticism=0:24, extraversion=seq(0, 24, 6))), multiline=TRUE)
## Not run: 
##D     Warning message: 
##D     sex:neuroticism:extraversion does not appear in the model in: 
##D       effect("sex:neuroticism:extraversion", mod.cowles, 
##D       xlevels = list(neuroticism = 0:24,
## End(Not run)

data(Prestige)
mod.pres <- lm(prestige ~ log(income, 10) + poly(education, 3) + poly(women, 2), 
    data=Prestige)
eff.pres <- all.effects(mod.pres, default.levels=50)
plot(eff.pres, ask=FALSE)




