### Name: frail.fit
### Title: Fits a frailty proportional hazards model
### Aliases: frail.fit
### Keywords: survival regression

### ** Examples

fam.size <- rep(20, 5)
n <- sum(fam.size)
fam <- rep(1:length(fam.size), fam.size)
beta <- 1
sigma <- 1
frail <- rep(rnorm(length(fam.size), 0, sigma), fam.size)
x <- runif(n)
exit <- rexp(n, exp(x * beta + frail))
event <- rep(1, n)
enter <- numeric(n)
mlreg(Surv(enter, exit, event) ~ x, frailty = frail)



