\name{age.window}
\alias{age.window}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Age cut of survival data}
\description{For a given age interval, each spell is cut to fit into the
  given age interval.
}
\usage{
age.window(dat, window, surv=c("enter", "exit", "event"))
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{dat}{Input data frame. Must contain survival data.}
  \item{window}{Vector of length two; the age interval.}
  \item{surv}{Vector of length three giving the names of the central
    variables in 'dat'.}
}
\details{
The \code{window} must be in the order \code{(begin, end)}
}
\value{
  A data frame of the same form as the input data frame, but 'cut' as
  desired. Intervals exceeding \code{window[2]} will be given
  \code{event = 0}

}
%\references{ ~put references to the literature/web site here ~ }
\author{Gran Brostrm}
%\note{ ~~further notes~~ }

\seealso{\code{\link{cal.window}}, \code{\link{coxreg}}},
\code{\link{mlreg}}}

\examples{
dat <- data.frame(enter = 0, exit = 5.731, event = 1, x = 2)
window <- c(2, 5.3)
dat.trim <- age.window(dat, window)  
}
\keyword{survival}% at least one, from doc/KEYWORDS


\eof
\name{cal.window}
\alias{cal.window}

\title{Calendar time cut of survival data}
\description{For a given time interval, each spell is cut so that it
  fully lies in the given time interval
}
\usage{
cal.window(dat, window, surv=c("enter", "exit", "event", "birthdate"))
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{dat}{Input data frame. Must contain survival data and a birth date.}
  \item{window}{Vector of length two; the time interval}
  \item{surv}{Vector of length four giving the names of the central
    variables in 'dat'.}
}
\details{
The \code{window} must be in the order \code{(begin, end)}
}
\value{
  A data frame of the same form as the input data frame, but 'cut' as
  desired. Intervals exceeding \code{window[2]} will be given
  \code{event = 0}
  
}
%\references{ ~put references to the literature/web site here ~ }
\author{Gran Brostrm}
%\note{ ~~further notes~~ }

\seealso{\code{\link{age.window}}, \code{\link{coxreg}}, \code{\link{mlreg}}}

\examples{
dat <- data.frame(enter = 0, exit = 5.731, event = 1,
birthdate = 1962.505, x = 2)
window <- c(1963, 1965)
dat.trim <- cal.window(dat, window)  
}
\keyword{survival}% at least one, from doc/KEYWORDS


\eof
\name{check.surv}
\alias{check.surv}
\title{Check the integrity of survival data.}
\description{
Check that exit occurs after enter, that spells from an individual do
not overlap, and that each individual experiences at most one event.
}
\usage{
check.surv(enter, exit, event, id = NULL, eps = 1e-08)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{enter}{Left truncation time.}
  \item{exit}{Time of exit.}
  \item{event}{Indicator of event. Zero means 'no event'.}
  \item{id}{Identification of individuals.}
  \item{eps}{The smallest allowed spell length or overlap.}
}
\details{
Interval lengths must be strictly positive.
}
\value{
A vector of id's for the insane individuals. Of zero length if no errors.
}
\references{}
\author{Gran Brostrm}
\note{}

\seealso{\code{\link{join.spells}}, \code{\link{coxreg}}, \code{\link{mlreg}}}
\examples{
xx <- data.frame(enter = c(0, 1), exit = c(1.5, 3), event = c(0, 1), id =
c(1,1))
check.surv(xx$enter, xx$exit, xx$event, xx$id)
}
\keyword{manip}
\keyword{survival}

\eof
\name{coxreg}
\alias{coxreg}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Cox regression}
\description{
  Performs Cox regression with some special attractions, especially
  \emph{sampling of risksets} and \emph{the weird bootstrap}.
}
\usage{
coxreg(formula = formula(data), data = parent.frame(),
na.action = getOption("na.action"), init, method = c("efron", "breslow"),
control = list(eps = 1e-08, maxiter = 10, trace = FALSE),
singular.ok = TRUE, model = FALSE,
x = FALSE, y = TRUE, boot = FALSE, rs, max.survs)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{formula}{ a formula object, with the response on the left of
    a ~ operator, and the terms on the right. The response must be
    a survival object as returned by the Surv function.}
  \item{data}{a data.frame in which to interpret the variables named
    in the formula.}
  \item{na.action}{ a missing-data filter function, applied to the
    model.frame, after any subset argument has been used.
    Default is \code{options()$na.action}.}
  \item{init}{vector of initial values of the iteration.
    Default initial value is zero for all variables.}
  \item{method}{Method of treating ties, "efron" (default) or "breslow".}
  \item{control}{a list with components \code{eps} (convergence
    criterion), \code{maxiter} (maximum number of iterations), and
    \code{silent} (logical, controlling amount of output). You can
    change any component without mention the other(s).}
  \item{singular.ok}{Not used}
  \item{model}{Not used}
  \item{x}{Return the design matrix in the model object?}
  \item{y}{return the response in the model object?}
  \item{rs}{Risk set?}
  \item{boot}{Number of boot replicates. Defaults to FALSE, no boot samples.}
  \item{max.survs}{Sampling of risk sets? If given, it should (the upper
    limit on) the number of survivors in each risk set.}
}
\details{
The default method, \code{efron}, and the alternative, \code{breslow},
  are both the same as in \code{\link[survival]{coxph}} in package
  \code{survival}. 
}
\value{
A list of class \code{c("coxreg", "coxph")} with components
  \item{coefficients}{Fitted parameter estimates.}
  \item{var}{Covariance matrix of the estimates.}
  \item{loglik}{Vector of length two; first component is the value at
    the initial parameter values, the second componet is the maximized value.}
  \item{score}{The score test statistic (at the initial value).}
  \item{linear.predictors}{The estimated linear predictors.}
  \item{residuals}{The martingale residuals.}
  \item{hazard}{The estimated baseline hazard.}
  \item{means}{Means of the columns of the design matrix.}
  \item{w.means}{Weighted (against exposure time) means of covariates;
    weighted relative frequencies of levels of factors.}
  \item{n}{Number of spells in indata (possibly after removal of cases
    with NA's).}
  \item{events}{Number of events in data.}
  \item{terms}{Used by extractor functions.}
  \item{assign}{Used by extractor functions.}
  \item{wald.test}{The Walt test statistic (at the initial value).}
  \item{y}{The Surv vector.}
  \item{isF}{Logical vector indicating the covariates that are factors.}
  \item{covars}{The covariates.}
  \item{ttr}{Total Time at Risk.}
  \item{levels}{List of levels of factors.}
  \item{formula}{The calling formula.}
  \item{bootstrap}{The (matrix of) bootstrap replicates, if requested on
    input. It is up to the user to do whatever desirable with this sample.}
  \item{boot.sd}{The estimated standard errors of the bootstrap replicates.}
  \item{call}{The call.}
  \item{method}{The method.}
  \item{convergence}{Did the optimization converge?}
  \item{fail}{Did the optimization fail? (Is \code{NULL} if not).}
}
\references{}
\author{Gran Brostrm}
\note{This function starts by creating risksets, if no riskset is
  supplied via \code{rs}, with the aid of
  \code{\link{risksets}}. Supplying output from \code{risksets} via \code{rs}
  fails if there are any NA's in the data! Note also
  that it depends on stratification, so \code{rs} contains information
  about stratification. Giving another strata variable in the formula is
  an error. The same is ok, for instance to supply stratum
  interactions.}
\section{Warning}{The use of \code{rs} is dangerous, see note. It
  can however speed up computing time considerably for huge data sets.} 

\seealso{\code{\link{coxph}}, \code{\link{risksets}}}
\examples{

 dat <- data.frame(time=  c(4, 3,1,1,2,2,3),
                status=c(1,1,1,0,1,1,0),
                x=     c(0, 2,1,1,1,0,0),
                sex=   c(0, 0,0,0,1,1,1))
 coxreg( Surv(time, status) ~ x + strata(sex), data = dat) #stratified model
 # Same as:
 rs <- risksets(Surv(dat$time, dat$status), strata = dat$sex)
 coxreg( Surv(time, status) ~ x, data = dat, rs = rs) #stratified model
 }
\keyword{survival}% at least one, from doc/KEYWORDS
\keyword{regression}% __ONLY ONE__ keyword per line

\eof
\name{coxreg.fit}
\alias{coxreg.fit}

\title{Cox regression}
\description{
Called by \code{\link{coxreg}}, but a user can call it directly.
}
\usage{
coxreg.fit(X, Y, rs, strats, offset, init, max.survs,
method = "breslow", boot = FALSE, control)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{X}{The design matrix.}
  \item{Y}{The survival object.}
  \item{rs}{The risk set composition. If absent, calculated.}
  \item{strats}{The stratum variable. Can be absent.}
  \item{offset}{Offset. Can be absent.}
  \item{init}{Start values. If absent, equal to zero.}
  \item{max.survs}{Sampling of risk sets? If so, gives the maximum
    number of survivors in each risk set.}
  \item{method}{Either "efron" (default) or "breslow".}
  \item{boot}{Number of bootstrap replicates. Defaults to FALSE, no
    bootstrapping.} 
  \item{control}{See \code{\link{coxreg}}}
}
\details{
\code{rs} is dangerous to use when NA's are present. 
}
\value{
  A list with components
  \item{coefficients}{Estimated regression parameters.}
  \item{var}{Covariance matrix of estimated coefficients.}
  \item{loglik}{First component is value at \code{init}, second at maximum.}
  \item{score}{Score test statistic, at initial value.}
  \item{linear.predictors}{Linear predictors.}
  \item{residuals}{Martingale residuals.}
  \item{hazard}{Estimated baseline hazard. At value zero of
    'design' variables.}
  \item{means}{Means of the columns of the design matrix.}
  \item{bootstrap}{The bootstrap replicates, if requested on input.}
  \item{conver}{\code{TRUE} if convergence.}
  \item{fail}{\code{TRUE} if failure.}
  \item{iter}{Number of performed iterations.}
}
%\references{ ~put references to the literature/web site here ~ }
\author{Gran Brostrm}
\note{It is the user's responsibility to check that indata is sane.}

\seealso{\code{\link{coxreg}}, \code{\link{risksets}}}
\examples{
 X <- as.matrix(data.frame(
                x=     c(0, 2,1,4,1,0,3),
                sex=   c(1, 0,0,0,1,1,1)))
 time <- c(1,2,3,4,5,6,7)
 status <- c(1,1,1,0,1,1,0)
 stratum <- rep(1, length(time))

 coxreg.fit(X, Surv(time, status), strats = stratum, max.survs = 6,
     control = list(eps=1.e-4, maxiter = 10, trace = FALSE))
}

\keyword{survival}
\keyword{regression}

\eof
\name{cro}
\alias{cro}
\title{Creates a minimal representation of a data frame.}
\description{
Given a data frame with a defined response variable, this function
creates a unique representation of the covariates in the data frame,
vector (matrix) of responses, and a pointer vector, connecting the
responses with the corresponding covariates. 
}
\usage{
cro(dat, response=1)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{dat}{A data frame}
  \item{response}{The column(s) where the response resides.}
}
\details{
  The rows in the data frame are converted to text strings with
  \code{paste} and compared with \code{match}.
  
}
\value{
A list with components
  \item{y}{The response.}
  \item{covar}{A data frame with unique rows of covariates.}
  \item{keys}{Pointers from \code{y} to \code{covar}, connecting each
    response with its covariate vector.}
}
%\references{ ~put references to the literature/web site here ~ }
\author{Gran Brostrm}
\note{This function is based on suggestions by Anne York and Brian Ripley.}

\seealso{\code{\link{match}}, \code{\link{paste}}}

\examples{
dat <- data.frame(y = c(1.1, 2.3, 0.7), x1 = c(1, 0, 1), x2 = c(0, 1, 0))
cro(dat)
}
\keyword{manip}% at least one, from doc/KEYWORDS
%\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line

\eof
\name{frail.fit}
\alias{frail.fit}

\title{Fits a frailty proportional hazards model}
\description{
This function is called from \code{\link{mlreg}}. Can be called directly
by a user who knows what (s)he is doing! 
}
\usage{
frail.fit(X, Y, rs, strats, offset, init, max.survs, frailty, control)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{X}{Design matrix}
  \item{Y}{Survival object}
  \item{rs}{Risk set pointers}
  \item{strats}{Stratum variable}
  \item{offset}{Offset variable}
  \item{init}{Initial regression parameter values}
  \item{max.survs}{Sampling of risk sets?}
  \item{frailty}{The frailty grouping variable}
  \item{control}{Values for the optimization}
}
\details{
Frailty is analyzed in a marginal framework, with numerical
integration. This is very slow and somewhat unstable.
}
\value{
See the code!
}

\author{Gran Brostrm}

\section{Warning }{Not very much tested. Can fail, and is very slow.}
\seealso{\code{\link{mlreg}}}
\examples{
fam.size <- rep(20, 5)
n <- sum(fam.size)
fam <- rep(1:length(fam.size), fam.size)
beta <- 1
sigma <- 1
frail <- rep(rnorm(length(fam.size), 0, sigma), fam.size)
x <- runif(n)
exit <- rexp(n, exp(x * beta + frail))
event <- rep(1, n)
enter <- numeric(n)
mlreg(Surv(enter, exit, event) ~ x, frailty = frail)
}
\keyword{survival}
\keyword{regression}

\eof
\name{geome.fit}
\alias{geome.fit}

\title{Constant intensity discrete time proportional hazards}
\description{
This function is called from \code{mlreg}. A user may call it directly.
}
\usage{
geome.fit(X, Y, rs, strats, offset, init, max.survs, method = "ML",
boot = FALSE, control)
}

\arguments{
  \item{X}{The design matrix}
  \item{Y}{Survival object}
  \item{rs}{risk set produced by \code{risksets}}
  \item{strats}{Stratum indicator}
  \item{offset}{ Offset}
  \item{init}{Initial values}
  \item{max.survs}{Maximal survivors}
  \item{method}{"ML" or "MPPL"}
  \item{boot}{should we bootstrap?}
  \item{control}{See mlreg}
}

\value{
See the code.
}
\references{See mlreg}
\author{Gran Brostrm}
\note{Nothing special}

\seealso{\code{\link{mlreg}}}
\examples{

}
\keyword{survival}


\eof
\name{join.spells}
\alias{join.spells}

\title{Straighten up a survival data frame}
\description{
 Unnecessary cut spells are glued together, overlapping spells are
 "polished", etc. 
}
\usage{
join.spells(dat, eps = 1.e-8)
}

\arguments{
  \item{dat}{A data frame with names enter, exit, event, id.}
  \item{eps}{Tolerance for equality of two event times.}
}
\details{
 In case of overlapping intervals (i.e., a data error), the appropriate
 id's are returned.
}
\value{
  A data frame with the same variables as the input, but individual
  spells are joined, if possible (identical covariate values, and
  adjacent time intervals).
}
\references{Therneau, T.M. and Grambsch, P.M. (2000). \emph{Modeling
    Survival Data: Extending the Cox
  model.} Springer.}
\author{Gran Brostrm}
%\note{}


\seealso{\code{\link{coxreg}}, \code{\link{mlreg}}, \code{\link{check.surv}}}

%\examples{
%}
\keyword{manip}% at least one, from doc/KEYWORDS
\keyword{survival}

\eof
\name{make.communal}
\alias{make.communal}

\title{Put communals in "fixed" data frame}
\description{
  Given an ordinary data frame suitable for survival analysis, and a
  data frame with "communal" time series, this function includes the
  communal covariates as fixed, by the "cutting spells" method.
  
}
\usage{
make.communal(dat, com.dat, communal = TRUE, start, period = 1, lag = 0, 
surv=c("enter", "exit", "event", "birthdate"), tol=1e-04, fortran=TRUE)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{dat}{A data frame containing interval specified survival data
    and covariates, of which one must give a "birth date", the
    connection between duration and calendat time}
  \item{com.dat}{Data frame with communal covariates. They must have the
    same start year and periodicity, given by \code{com.ins}}
  \item{communal}{Boolean; if TRUE, then it is a true communal (default),
    otherwise a fixed. The first component is the first
    year (start date in decimal form), and the second component is the
    period length. The third is \code{lag} and the fourth is
    \code{scale}.}
  \item{start}{Start date in decimal form.}
  \item{period}{Period length. Defaults to one.}
  \item{lag}{The lag of the effect. Defaults to zero.}
  \item{surv}{Character vector of length 4 giving the names of interval
    start, interval end, event indicator, birth date, in that
    order. These names must correspond to names in \code{dat}}
  \item{tol}{Largest length of an interval considered to be of zero
    length. The cutting sometimes produces zero length intervals, which
    we want to discard.}
  \item{fortran}{If \code{TRUE}, then a Fortran implementation of the
    function is used. This is the default.}
}
\details{
The main purpose of this function is to prepare a data file for use with
\code{\link{coxreg}}, \code{\link{mlreg}}, \code{\link{weibreg}} and
\code{\link[survival]{coxph}}.
}
\value{
The return value is a data frame with the same variables as in the
combination of \code{dat} and \code{com.dat}. Therefore it is an error
to have common name(s) in the two data frames.
}
%\references{ ~put references to the literature/web site here ~ }
\author{Gran Brostrm}
\note{Not very vigorously tested.}


\seealso{\code{\link{coxreg}}, \code{\link{mlreg}},
  \code{\link[survival]{coxph}}, \code{\link{cal.window}}} 

\examples{
dat <- data.frame(enter = 0, exit = 5.731, event = 1,
birthdate = 1962.505, x = 2)
## Birth date: July 2, 1962 (approximately).
com.dat <- data.frame(price = c(12, 3, -5, 6, -8, -9, 1, 7))
dat.com <- make.communal(dat, com.dat, start = 1962.000) 
}
\keyword{survival}


\eof
\name{mlreg}
\alias{mlreg}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{ML proportional hazards regression}
\description{
  Maximum Likelihood estimation of proportional hazards models.
}
\usage{
mlreg(formula = formula(data), data = parent.frame(),
na.action = getOption("na.action"), init, method = c("ML", "MPPL"),
control = list(eps = 1e-08, maxiter = 10, n.points = 12, trace = FALSE),
singular.ok = TRUE, model = FALSE,
x = FALSE, y = TRUE, boot = FALSE, geometric = FALSE,
rs, frailty = NULL, max.survs)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{formula}{ a formula object, with the response on the left of
    a ~ operator, and the terms on the right. The response must be
    a survival object as returned by the Surv function.}
  \item{data}{a data.frame in which to interpret the variables named
    in the formula.}
  \item{na.action}{ a missing-data filter function, applied to the
    model.frame, after any subset argument has been used.
    Default is \code{options()$na.action}.}
  \item{init}{vector of initial values of the iteration.
    Default initial value is zero for all variables.}
  \item{method}{Method of treating ties, "ML", the default, means pure
    maximum likelihood, i.e, data are treated as discrete. The choice
    "MPPL" implies that risk sets with no tied events are treated as in
    ordinary Cox regression. This is a cameleont that adapts to data,
    part discrete and part continuous.}
  \item{control}{a list with components \code{eps} (convergence
    criterion), \code{maxiter} (maximum number of iterations), and
    \code{silent} (logical, controlling amount of output). You can
    change any component without mention the other(s).}
  \item{singular.ok}{Not used.}
  \item{model}{Not used.}
  \item{x}{Return the design matrix in the model object?}
  \item{y}{return the response in the model object?}
  \item{boot}{No. of bootstrap replicates. Defaults to FALSE, i.e., no
    bootstrapping.} 
  \item{geometric}{If \code{TRUE}, the intensity is assumed constant
  within strata.}
  \item{rs}{Risk set? If present, speeds up calculations considerably.}
  \item{frailty}{A grouping variable for frailty analysis. Full name is
    needed.} 
  \item{max.survs}{Sampling of risk sets?}
}
\details{
Method \code{ML} performs a true discrete analysis, i.e., one parameter
per observed event time. Method \code{MPPL} is a compromize between the
discrete and continuous time approaches; one parameter per observed
event time with multiple events. With no ties in data, an ordinary Cox
regression (as with \code{\link{coxreg}}) is performed. 
}
\value{
A list of class \code{c("mlreg", "coxreg", "coxph")} with components
  \item{coefficients}{Fitted parameter estimates.}
  \item{var}{Covariance matrix of the estimates.}
  \item{loglik}{Vector of length two; first component is the value at
    the initial parameter values, the second componet is the maximized value.}
  \item{score}{The score test statistic (at the initial value).}
  \item{linear.predictors}{The estimated linear predictors.}
  \item{residuals}{The martingale residuals.}
  \item{hazard}{The estimated baseline hazard.}
  \item{means}{Means of the columns of the design matrix.}
  \item{w.means}{Weighted (against exposure time) means of covariates;
    weighted relative frequencies of levels of factors.}
  \item{n}{Number of spells in indata (possibly after removal of cases
    with NA's).}
  \item{events}{Number of events in data.}
  \item{terms}{Used by extractor functions.}
  \item{assign}{Used by extractor functions.}
  \item{wald.test}{The Walt test statistic (at the initial value).}
  \item{y}{The Surv vector.}
  \item{isF}{Logical vector indicating the covariates that are factors.}
  \item{covars}{The covariates.}
  \item{ttr}{Total Time at Risk.}
  \item{levels}{List of levels of factors.}
  \item{formula}{The calling formula.}
  \item{call}{The call.}
  \item{bootstrap}{The bootstrap sample, if requested on input.}
  \item{sigma}{Present if a frailty model is fitted. Equals the
    estimated frailty standard deviation.}
  \item{sigma.sd}{The standard error of the estimated frailty standard
    deviation.} 
  \item{method}{The method.}
  \item{convergence}{Did the optimization converge?}
  \item{fail}{Did the optimization fail? (Is \code{NULL} if not).}
}
\references{Brostrm, G. (2002). Cox regression; Ties without
  tears. \emph{Communications in Statistics: Theory and Methods}
  \bold{31}, 285--297.}  
\author{Gran Brostrm}
\note{This function starts by creating risksets, if no riskset is
  supplied via \code{rs}, with the aid of \code{\link{risksets}}. This
  latter mechanism fails if there are any NA's in the data! Note also
  that it depends on stratification, so \code{rs} contains information
  about stratification. Giving another strata variable in the formula is
  an error. The same is ok, for instance to supply stratum
  interactions.}
\section{Warning}{The use of \code{rs} is dangerous, see note above. It
  can however speed up computing time.} 

\seealso{\code{\link{coxph}}, \code{\link{risksets}}}
\examples{

 dat <- data.frame(time=  c(4, 3,1,1,2,2,3),
                status=c(1,1,1,0,1,1,0),
                x=     c(0, 2,1,1,1,0,0),
                sex=   c(0, 0,0,0,1,1,1))
 mlreg( Surv(time, status) ~ x + strata(sex), data = dat) #stratified model
 # Same as:
 rs <- risksets(Surv(dat$time, dat$status), strata = dat$sex)
 mlreg( Surv(time, status) ~ x, data = dat, rs = rs) #stratified model
 }
\keyword{survival}% at least one, from doc/KEYWORDS
\keyword{regression}% __ONLY ONE__ keyword per line

\eof
\name{mlreg.fit}
\alias{mlreg.fit}

\title{ML proportional hazards regression}
\description{
Called by \code{\link{mlreg}}, but a user can call it directly.
}
\usage{
mlreg.fit(X, Y, rs, strats, offset, init, max.survs,
method = "ML", boot = FALSE, control)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{X}{The design matrix.}
  \item{Y}{The survival object.}
  \item{rs}{The risk set composition. If absent, calculated.}
  \item{strats}{The stratum variable. Can be absent.}
  \item{offset}{Offset. Can be absent.}
  \item{init}{Start values. If absent, equal to zero.}
  \item{max.survs}{Sampling of risk sets? If so, gives the maximum
    number of survivors in each risk set.}
  \item{method}{Either "ML" (default) or "MPPL".}
    \item{boot}{No. of bootstrap replicates. Defaults to FALSE, i.e., no
    bootstrapping.} 
  \item{control}{See \code{\link{coxreg}}}
}
\details{
  See \code{\link{mlreg}} for details.
}
\value{
  A list with components
  \item{coefficients}{Estimated regression parameters.}
  \item{var}{Covariance matrix of estimated coefficients.}
  \item{loglik}{First component is value at \code{init}, second at maximum.}
  \item{score}{Score test statistic, at initial value.}
  \item{linear.predictors}{Linear predictors.}
  \item{residuals}{Martingale residuals.}
  \item{hazard}{Estimated baseline hazard. At value zero of
    'design' variables.}
  \item{means}{Means of the columns of the design matrix.}
  \item{bootstrap}{The bootstrap sample, if requested on input.}
  \item{conver}{\code{TRUE} if convergence.}
  \item{fail}{\code{TRUE} if failure.}
  \item{iter}{Number of performed iterations.}
}
\references{ ~put references to the literature/web site here ~ }
\author{Gran Brostrm}
\note{\code{rs} is dangerous to use when NA's are present. 
It is the user's responsibility to ensure that indata is sane.}

\seealso{\code{\link{coxreg}}, \code{\link{risksets}}}
\examples{
 X <- as.matrix(data.frame(
                x=     c(0, 2,1,4,1,0,3),
                sex=   c(1, 0,0,0,1,1,1)))
 time <- c(1,2,3,4,5,6,7)
 status <- c(1,1,1,0,1,1,0)
 stratum <- rep(1, length(time))

 mlreg.fit(X, Surv(time, status), strats = stratum, max.survs = 6,
     control = list(eps=1.e-4, maxiter = 10, trace = TRUE))
}

\keyword{survival}
\keyword{regression}

\eof
\name{perstat}
\alias{perstat}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Period statistics}
\description{
  Calculates occurrence / exposure rates for time periods given by
  \code{period} and for ages given by \code{age}.
  
}
\usage{
perstat(surv, period, age = c(0, 200))
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{surv}{An (extended) \code{surv} object (4 columns with
    \code{enter}, \code{exit}, \code{event}, \code{birthdate}) }
  \item{period}{A vector of dates (in decimal form)}
  \item{age}{A vector of length 2; lowest and highest age}
}
\details{
 
}
\value{
A list with components
  \item{events}{No. of events in eavh time period.}
  \item{exposure}{Exposure times in each period.}
  \item{intensity}{\code{events / exposure}}
}
%\references{ ~put references to the literature/web site here ~ }
\author{Gran Brostrm}
%\note{ ~~further notes~~ }

\seealso{\code{\link{piecewise}}}

%\examples{
%}
\keyword{survival}% at least one, from doc/KEYWORDS
\keyword{nonparametric}% __ONLY ONE__ keyword per line

\eof
\name{piecewise}
\alias{piecewise}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Piecewise hazards}
\description{
Calculate piecewise hazards, no. of events, and exposure times in each
interval indicated by cutpoints.
}
\usage{
piecewise(enter, exit, event, cutpoints)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{enter}{Left interval endpoint}
  \item{exit}{Right interval endpoint}
  \item{event}{Indicator of event}
  \item{cutpoints}{Vector of cutpoints}
}
\details{
Exact calculation.
}
\value{
  A list with components

  \item{deaths}{Vector of number of deaths}
  \item{exposure}{Vector of total exposure time}
  \item{hazard}{Vector of hazards, \code{hazard} == \code{deaths} /
    \code{exposure}} 
}

\author{Gran Brostrm}

\seealso{\code{\link{perstat}}}

%\examples{
%}
\keyword{survival}
\keyword{nonparametric}


\eof
\name{plot.Surv}
\alias{plot.Surv}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Plots of survivor functions.}
\description{
  Kaplan-Meier estimates. If only one curve, confidence limits according
  to Greenwood's formula are drawn.
}
\usage{
plot.Surv(x, strata=rep(1, length(exit)), limits=FALSE, conf=0.95,
xlim = NULL, ylim = NULL, main="Survivor function(s)", 
xlab="Duration",
ylab="Remaining fraction", ...)
}
\arguments{
  \item{x}{A \code{Surv} object.}
  \item{strata}{Defines a partition of the data. One survivor function
    for each level of \code{strata} is drawn.}
  \item{limits}{If TRUE, and if the number of curves is one, confidence
    limits are drawn.}
  \item{conf}{The confidence level for the confidence limits.}
  \item{xlim}{Horizontal plot limits. If NULL, calculated by the function.}
  \item{ylim}{Vertical plot limits. If NULL, set to \code{c(0, 1)}}.
  \item{main}{A heading for the plot.}
  \item{xlab}{Label on the x axis.}
  \item{ylab}{Label on the y-axis.}
  \item{...}{Anything that \code{plot} likes...}
}
\details{
Left truncation is allowed. Note, though, that this fact may result in
strange estimated curves due to lack of data in certain (low) ages.
}
\value{
No value is returned.
}
%\references{}
\author{Gran Brostrm}
%\note{ ~~further notes~~ }

% ~Make other sections like WARNING with \section{WARNING }{....} ~

\seealso{\code{\link{plot.cum}}}

\examples{
time0 <- numeric(50)
group <- c(rep(0, 25), rep(1, 25))
time1 <- rexp( 50, exp(group) )
event <- rep(1, 50)
plot.Surv(Surv(time0, time1, event), strata = group)
}
\keyword{survival}

\eof
\name{plot.cum}
\alias{plot.cum}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Plots of Cumulative Hazards Functions.}
\description{
Nelson-Aalen plots.
}
\usage{
plot.cum(x, group=rep(1, length(exit)), 
main="Cumulative hazards function(s)", xlab="Duration", ylab="",
log.scale = FALSE, ...)
}
\arguments{
  \item{x}{A \code{Surv} object.}
  \item{group}{Defines a partition of the data. One survivor function
    for each level of \code{group} is drawn.}
  \item{main}{Header of the plot.}
  \item{xlab}{Label of the x axis.}
  \item{ylab}{Label of the y axis.}
  \item{log.scale}{If TRUE, plotting is done on a log-log scale. Default
    is FALSE}
  \item{...}{Anything that \code{plot} likes...}
}
\details{
Left truncation is allowed. Note, though, that this fact may result in
strange estimated curves due to lack of data in certain (low) ages.
}
\value{
No value is returned.
}
\references{}
\author{Gran Brostrm}
%\note{ ~~further notes~~ }

% ~Make other sections like WARNING with \section{WARNING }{....} ~

\seealso{\code{\link{plot.Surv}}}

\examples{
time0 <- numeric(50)
group <- c(rep(0, 25), rep(1, 25))
time1 <- rexp( 50, exp(group) )
event <- rep(1, 50)
plot.cum(Surv(time0, time1, event), group)
plot.cum(Surv(time0, time1, event), group, log.scale = TRUE)
}
\keyword{survival}



\eof
\name{plot.weibreg}
\alias{plot.weibreg}

\title{Plots output from a Weibull regression}
\description{
Just a simple plot of the hazard functions for each stratum.
}
\usage{
plot.weibreg(x, new.data = rep(0, length(x$means)), ...)
}

\arguments{
  \item{x}{A \code{weibreg} object}
  \item{new.data}{At which covariate values? This doesn't work for the moment.}
  \item{...}{Who knows?}
}
\warning{\code{new.data} does not work as intended.}
\details{
The plot is drawn at the mean values of the covariates.
}
\value{
No return
}

\author{Gran Brostrm}

\seealso{\code{\link{weibreg}}, ~~~ }
\examples{
## The function is currently defined as
function (x, new.data = rep(0, length(x$means))) 
{
    if (!inherits(x, "weibreg")) 
        stop("Works only with 'weibreg' objects.")
    ncov <- length(x$means)
    ns <- x$n.strata
    lambda <- exp(x$coefficients[ncov + (1:ns) * 2 - 1])
    p <- exp(x$coefficients[ncov + (1:ns) * 2])
    xlim <- c(min(x$y[, 1]), max(x$y[, 2]))
    npts <- 199
    xx <- seq(xlim[1], xlim[2], length = npts)
    if (xx[1] <= 0) 
        xx[1] <- 0.001
    haz <- matrix(ncol = npts, nrow = ns)
    for (i in 1:ns) {
        tl <- xx/lambda[i]
        haz[i, ] <- (p[i]/lambda[i]) * tl^(p[i] - 1)
    }
    ylim <- c(0, max(haz))
    cat("length(xx) = ", length(xx), "\n")
    cat("dim(haz) = ", dim(haz), "\n")
    plot(xx, haz[1, ], type = "l", xlim = xlim, ylim = ylim)
    if (ns > 1) {
        for (i in 2:ns) {
            lines(xx, haz[i, ], type = "l", lty = i)
        }
    }
  }
}
\keyword{dplot}% at least one, from doc/KEYWORDS
\keyword{survival}% __ONLY ONE__ keyword per line

\eof
\name{print.coxreg}
\alias{print.coxreg}

\title{Prints coxreg objects}
\description{
More "pretty-printing" than \code{print.coxph}, which is a fall-back for
'difficult' objects.
}
\usage{
print.coxreg(x, digits = max(options()$digits - 4, 3), ...)
}
\arguments{
  \item{x}{A \code{coxreg} object, typically the result of running
    \code{coxreg}} 
  \item{digits}{Output format.}
  \item{\dots}{Other arguments.}
}
\details{
Doesn't work with three-way and higher interactions, in which case
\code{print.coxph} is used. Prints also output from \code{\link{mlreg}}.
}
\value{
No value is returned.
 }
%\references{ ~put references to the literature/web site here ~ }
\author{Gran Brostrm}
%\note{}


\seealso{\code{\link{coxreg}}, \code{\link{print.coxph}}}
%\examples{

}
\keyword{survival}% at least one, from doc/KEYWORDS

\eof
\name{print.weibreg}
\alias{print.weibreg}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Prints weibreg objects}
\description{

}
\usage{
print.weibreg(x, digits = max(options()$digits - 4, 3), ...)
}

\arguments{
  \item{x}{A \code{weibreg} object}
  \item{digits}{Precision in printing}
  \item{\dots}{Not used.}
}

\value{
No value is returned.
}
%\references{ ~put references to the literature/web site here ~ }
\author{Gran Brostrm}
\note{Doesn't work for threeway or higher order interactions. Use
  \code{\link[survival]{print.coxph}} in that case.} 

% ~Make other sections like Warning with \section{Warning }{....} ~ 
 \seealso{\code{\link{weibreg}}}, \code{\link[survival]{print.coxph}}}
%\examples{

%}
\keyword{survival}% at least one, from doc/KEYWORDS
\keyword{regression}% __ONLY ONE__ keyword per line

\eof
\name{risksets}
\alias{risksets}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Finds the compositions and sizes of risk sets}
\description{
  Focus is on the risk set composition just prior to a failure.
}
\usage{
risksets(x, strata, max.survs)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{x}{A \code{Surv} object.}
  \item{strata}{Stratum indicator.}
  \item{max.survs}{Maximum number of survivors in each risk set. If
    smaller than the 'natural number', survivors are sampled from the
    present ones.}
}
\details{
  If the input argument max.survs is left alone, all survivors are
  accounted for in all risk sets.
}
\value{
  A list with components
  \item{antrs}{No. of risk sets in each stratum. The number of strata is
    given by \code{length(antrs)}.}
  \item{risktimes}{Ordered distinct failure time points.}
  \item{eventset}{vector of pointers to events in each risk set.} 
  \item{riskset}{vector of pointers to 
    the members of the risk sets, in order. The 'events' 
    first are the events.}
  \item{size}{The sizes of the risk sets.}
  \item{n.events}{The number of events in each risk set.}
}
%\references{Brostrm, G.}
\author{Gran Brostrm}
\note{can be used to "sample the risk sets".}

\seealso{\code{\link{table.events}}, \code{\link{coxreg}}, \code{\link{mlreg}}}

\examples{
 enter <- c(0, 1, 0, 0)
 exit <- c(1, 2, 3, 4)
 event <- c(1, 1, 1, 0)
 risksets(Surv(enter, exit, event))
}
\keyword{survival}

\eof
\name{summary.coxreg}
\alias{summary.coxreg}

\title{Prints coxreg objects}
\description{
This is the same as \code{\link{print.coxreg}}
}
\usage{
summary.coxreg(object, ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{object}{A \code{coxreg} object}
  \item{\dots}{Additional ...}
}

\author{Gran Brostrm}

\seealso{\code{\link{print.coxreg}}}
\examples{
## The function is currently defined as
function (object, ...) 
print(object)
}
\keyword{survival}
\keyword{print}

\eof
\name{summary.weibreg}
\alias{summary.weibreg}

\title{Prints a weibreg object}
\description{
This is the same as \code{\link{print.weibreg}}
}
\usage{
summary.weibreg(object, ...)
}

\arguments{
  \item{object}{A \code{weibreg} object}
  \item{\dots}{Additional ... }
}

\author{Gran Brostrm}

\seealso{\code{\link{print.weibreg}} }
\examples{
## The function is currently defined as
function (object, ...) 
print(object)
}
\keyword{survival}
\keyword{print}

\eof
\name{table.events}
\alias{table.events}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Calculating failure times, risk set sizes and No. of events in
  each risk set}
\description{
  From input data of the 'interval' type, with an event indicator,
  summary statistics for each risk set (at an event time point) are
  calculated. 
}
\usage{
table.events(enter=rep(0, length(exit)), exit, event)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{enter}{Left truncation time point.}
  \item{exit}{End time point, an event or a right censoring.}
  \item{event}{Event indicator.}
}
%\details{
  
%}
\value{
  A list with components
  \item{times}{Ordered distinct event time points.}
  \item{events}{Number of events at each event time point.}
  \item{riskset.sizes}{Number at risk at each event time point.}
}
%\references{}
\author{Gran Brostrm}
%\note{}

 
\seealso{\code{\link{risksets}}}

\examples{
exit = c(1,2,3,4,5)
event = c(1,1,0,1,1)
table.events(exit = exit, event = event)
}
\keyword{survival}%-- one or more ...

\eof
\name{weibreg}
\alias{weibreg}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Weibull regression}
\description{Proportional hazards model with baseline hazard(s) from the Weibull
  family of distributions. Allows for stratification with different
  scale and shape in each stratum, and left truncated and right censored data.
}
\usage{
weibreg(formula = formula(data), data = parent.frame(),
na.action = getOption("na.action"), init, shape = 0,
control = list(eps = 1e-04, maxiter = 10, trace = FALSE),
singular.ok = TRUE, model = FALSE, x = FALSE, y = TRUE)
}


\arguments{
  \item{formula}{a formula object, with the response on the left of
    a ~ operator, and the terms on the right. The response must be
    a survival object as returned by the Surv function.}
  \item{data}{a data.frame in which to interpret the variables named
    in the formula.}
  \item{na.action}{ a missing-data filter function, applied to the
    model.frame, after any subset argument has been used.
    Default is \code{options()$na.action}.}
  \item{init}{vector of initial values of the iteration.
    Default initial value is zero for all variables.}
  \item{shape}{If positive, the shape parameter is fixed at that value
    (in each stratum). If zero or negative, the shape parameter is
    estimated. If more than one stratum is present in data, each stratum
    gets its own estimate.}
    \item{control}{a list with components \code{eps} (convergence
    criterion), \code{maxiter} (maximum number of iterations), and
    \code{silent} (logical, controlling amount of output). You can
    change any component without mention the other(s).}
  \item{singular.ok}{Not used.}
  \item{model}{Not used.}
  \item{x}{Return the design matrix in the model object?}
  \item{y}{Return the response in the model object?}
}

\details{
The parameterization is the same as in \code{\link{coxreg}},
\code{\link{coxreg}}, and \code{\link[survival]{coxph}}, but different
from the one used by \code{\link[survival]{survreg}}. To compare
regression coefficients with the latter, multiply them by minus the
(estimated) shape parameter.

The model is
\deqn{h(t; p, \lambda, \beta, z) = \lambda (t / \lambda)^{p-1}\exp(-(
  t / \lambda )^p) \exp(z\beta)}
Note that this is in correspondence with \code{\link{dgamma}}, but not
with \code{\link[survival]{survreg}}! To compare regression coefficients
with those from \code{survreg} you need to divide by estimated shape
(\eqn{\hat{p}}) and change sign. The p-values and test statistics are
however the same, with one exception; the score test is done at
maximized scale and shape in \code{weibreg}. 
}

\value{
A list of class \code{c("weibreg", "coxreg", "coxph")} with components
  \item{coefficients}{Fitted parameter estimates.}
  \item{var}{Covariance matrix of the estimates.}
  \item{loglik}{Vector of length two; first component is the value at
    the initial parameter values, the second componet is the maximized value.}
  \item{score}{The score test statistic (at the initial value).}
  \item{linear.predictors}{The estimated linear predictors.}
  \item{means}{Means of the columns of the design matrix.}
  \item{w.means}{Weighted (against exposure time) means of covariates;
    weighted relative frequencies of levels of factors.}
  \item{n}{Number of spells in indata (possibly after removal of cases
    with NA's).}
  \item{events}{Number of events in data.}
  \item{terms}{Used by extractor functions.}
  \item{assign}{Used by extractor functions.}
%  \item{wald.test}{The Wald test statistic (at the initial value).}
  \item{y}{The Surv vector.}
  \item{isF}{Logical vector indicating the covariates that are factors.}
  \item{covars}{The covariates.}
  \item{ttr}{Total Time at Risk.}
  \item{levels}{List of levels of factors.}
  \item{formula}{The calling formula.}
  \item{call}{The call.}
  \item{method}{The method.}
  \item{convergence}{Did the optimization converge?}
  \item{fail}{Did the optimization fail? (Is \code{NULL} if not).}
  \item{pfixed}{TRUE if shape was fixed in the estimation.}
}

\author{Gran Brostrm}
%\note{}


\section{Warning}{The print method \code{\link{print.weibreg}} doesn't work if
threeway or higher order interactions are present. Use
\code{\link[survival]{print.coxph}} in that case.}

\seealso{\code{\link{coxreg}}, \code{\link{mlreg}}, \code{\link{print.weibreg}}}

\examples{
 dat <- data.frame(time=  c(4, 3,1,1,2,2,3),
                status=c(1,1,1,0,1,1,0),
                x=     c(0, 2,1,1,1,0,0),
                sex=   c(0, 0,0,0,1,1,1))
 weibreg( Surv(time, status) ~ x + strata(sex), data = dat) #stratified model
}
\keyword{survival}% at least one, from doc/KEYWORDS
\keyword{regression}% __ONLY ONE__ keyword per line

\eof
\name{weibreg.fit}
\alias{weibreg.fit}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Weibull regression}
\description{
This function is called by \code{\link{weibreg}}, but it can also be
directly called by a user.
}
\usage{
weibreg.fit(X, Y, strata, offset, init, shape, control)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{X}{The design (covariate) matrix.}
  \item{Y}{A survival object, the response.}
  \item{strata}{A stratum variable.}
  \item{offset}{Offset.}
  \item{init}{Initial regression parameter values.}
  \item{shape}{If positive, a fixed value of the shape parameter in the
    Weibull distribution. Otherwise, the shape is estimated.}
  \item{control}{Controls convergence and output.}
}
\details{
See \code{\link{weibreg}} for more detail.
}
\value{
  \item{coefficients}{Estimated regression coefficients plus estimated
    scale and shape coefficients, sorted by strata, if present.}
  \item{var}{}
  \item{loglik}{Vector of length 2. The first component is the maximized
  loglihood with only scale and shape in the model, the second the final
  maximum.}
  \item{score}{Score test statistic at initial values}
  \item{linear.predictors}{Linear predictors for each interval.}
  \item{means}{Means of the covariates}
  \item{conver}{TRUE if convergence}
  \item{fail}{TRUE if failure}
  \item{iter}{Number of Newton-Raphson iterates.}
  \item{n.strata}{The number of strata in the data.}

}
%\references{ ~put references to the literature/web site here ~ }
\author{Gran Brostrm}
%\note{}


\seealso{\code{\link{weibreg}}}
%\examples{

%}
\keyword{survival}
\keyword{regression}

\eof
\name{wfunk}
\alias{wfunk}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Loglihood function of a Weibull regression}
\description{
Calculates minus the log likelihood function and its first and second order
derivatives for data from a Weibull regression model. Is called by
\code{\link{weibreg}}. 
}
\usage{
wfunk(beta, lambda, p, X, Y, offset = rep(0, NROW(X)),
ord = 2, pfixed = FALSE, trace = TRUE)
}

\arguments{
  \item{beta}{Regression parameters}
  \item{lambda}{The scale paramater}
  \item{p}{The shape parameter}
  \item{X}{The design (covariate) matrix.}
  \item{Y}{The response, a survival object.}
  \item{offset}{Offset.}
  \item{ord}{ord = 0 means only loglihood, 1 means score vector as well,
  2 loglihood, score and hessian.}
  \item{pfixed}{Logical, if TRUE the shape parameter is regarded as a known
  constant in the calculations.}
  \item{trace}{If TRUE, more verbose output.}
}
\details{
Note that the function returns log likelihood, score vector
and minus hessian, i.e. the observed information.
The model is
\deqn{h(t; p, \lambda, \beta, z) = \lambda (t / \lambda)^{(p-1)}\exp{(-(
  t / \lambda)^p}) \exp(z\beta)}
This is in correspondence with \code{\link{dgamma}}.
}
\value{
A list with components
  \item{f}{The log likelihood. Present if \code{ord >= 0}}
  \item{fp}{The score vector. Present if \code{ord >= 1}}
  \item{fpp}{The negative of the hessian. Present if \code{ord >= 2}}
}
%\references{ }
\author{Gran Brostrm}
%\note{}

\seealso{\code{\link{weibreg}}}
%\examples{
%}
\keyword{survival}
\keyword{distribution}

\eof
