ellipse.profile           package:ellipse           R Documentation

_P_a_i_r_w_i_s_e _p_r_o_f_i_l_e _s_k_e_t_c_h

_D_e_s_c_r_i_p_t_i_o_n:

     This routine approximates a contour of a function based on the
     profile of that function.

_U_s_a_g_e:

     ## S3 method for class 'profile':
     ellipse(x, which = c(1, 2), level = 0.95, t = sqrt(qchisq(level, 2)), 
         npoints = 100, ...)

_A_r_g_u_m_e_n_t_s:

       x: An object of class 'profile', e.g. from  profile.glm in the
          MASS package. 

   which: Which pair of parameters to use. 

   level: The 'ellipse.profile' function defaults assume that the
          profiled function is -2 times the log likelihood of a regular
          model.  With this assumption the 'level' argument specifies
          the confidence level for an asymptotic confidence region. 

       t: The square root of the value to be contoured. 

 npoints: How many points to use in the ellipse. 

     ...: Extra arguments are not used. 

_D_e_t_a_i_l_s:

     This function uses the 4 point approximation to the contour as
     described in Appendix 6 of Bates and Watts (1988).  It produces
     the exact contour for quadratic surfaces, and good approximations
     for mild deviations from quadratic.  If the surface is multimodal,
     the algorithm is likely to produce nonsense.

_V_a_l_u_e:

     An 'npoints' x '2' matrix with columns having the chosen parameter
     names,  which approximates a contour of the function that was
     profiled.

_R_e_f_e_r_e_n_c_e_s:

     Bates and Watts (1988) Nonlinear Regression Analysis & its
     Applications

_S_e_e _A_l_s_o:

     'profile', 'ellipse.nls'

_E_x_a_m_p_l_e_s:

     # Plot an approximate 95% confidence region for the Puromycin
     # parameters Vm and K, and overlay the ellipsoidal region

     data(Puromycin)
     Purboth <- nls(formula = rate ~ ((Vm + delV * (state == "treated"))
       * conc)/(K + conc), data = Puromycin,
       start = list(Vm = 160, delV = 40, K = 0.05))
     Pur.prof <- profile(Purboth)
     plot(ellipse(Pur.prof, which = c('Vm', 'K')), type = 'l')
     lines(ellipse(Purboth, which = c('Vm', 'K')), lty = 2)
     params <- Purboth$m$getPars()
     points(params['Vm'],params['K'])

