pairs.profile            package:ellipse            R Documentation

_P_r_o_f_i_l_e _p_a_i_r_s

_D_e_s_c_r_i_p_t_i_o_n:

     This function produces pairwise plots of profile traces, profile
     sketches, and ellipse approximations to confidence intervals.

_U_s_a_g_e:

     ## S3 method for class 'profile':
     pairs(x, labels = c(names(x), "Profile tau"), panel = lines, invert = TRUE, 
         plot.tau = TRUE, plot.trace = TRUE, plot.sketch = TRUE, 
             plot.ellipse = FALSE, level = 0.95, ...)

_A_r_g_u_m_e_n_t_s:

       x: An object of class 'profile', generally the result of the
          'profile()' function. 

  labels: The labels to use for each variable.  These default to the
          variable names. 

   panel: The function to use to draw the sketch in each panel. 

  invert: Whether to swap the axes so things look better. 

plot.tau: Whether to do the profile tau (profile t) plots. 

plot.trace: Whether to do the profile trace plots. 

plot.sketch: Whether to do the profile sketch plots. 

plot.ellipse: Whether to do the ellipse approximations. 

   level: The nominal confidence level for the profile sketches and
          ellipses. 

     ...: Other plotting parameters. 

_D_e_t_a_i_l_s:

     This function implements the plots used in Bates and Watts (1988)
     for nonlinear regression diagnostics.

_S_i_d_e _E_f_f_e_c_t_s:

     Produces a plot on the current device for each pair of variables
     in the profile object.

_R_e_f_e_r_e_n_c_e_s:

     Bates and Watts (1988), Nonlinear Regression Analysis & its
     Applications.

_S_e_e _A_l_s_o:

     'profile', 'ellipse.profile', 'ellipse.nls'

_E_x_a_m_p_l_e_s:

      # Plot everything for the Puromycin data
      data(Puromycin)
      Purboth <- nls(formula = rate ~ ((Vm + delV * (state == "treated"))
        * conc)/(K + conc), data = Puromycin,
        start = list(Vm = 160, delV = 40, K = 0.05))
      Pur.prof <- profile(Purboth)
      pairs(Pur.prof, plot.ellipse = TRUE)

