### Name: atvnonpar
### Title: Non-parametric Estimates for Dependence Functions of the
###   Trivariate Extreme Value Distribution
### Aliases: atvnonpar
### Keywords: nonparametric

### ** Examples

s3pts <- matrix(rexp(30), nrow = 10, ncol = 3)
s3pts <- s3pts/rowSums(s3pts)
sdat <- rmvevd(100, dep = 0.6, model = "log", d = 3)
atvnonpar(s3pts, sdat)

## Not run: atvnonpar(data = sdat, plot = TRUE)
## Not run: atvnonpar(data = sdat, plot = TRUE, ord = c(2,3,1), lab = LETTERS[1:3])
## Not run: atvpar(dep = 0.6, model = "log", plot = TRUE)
## Not run: atvpar(dep = 0.6, model = "log", plot = TRUE, blty = 1)



