\name{bmw}
\alias{bmw}
\title{Daily Log Returns on BMW Share Price} 
\description{
  These data are the daily log returns on BMW share price 
  from Tuesday 2nd January 1973 until Tuesday 23rd July 1996.
  The data are contained in a numeric vector.
  The dates of each observation are contained in a \code{times}
  attribute, which is an object of class \code{"POSIXct"} (see
  \code{\link{DateTimeClasses}}).
  Note that these data form an irregular time series because
  no trading takes place at the weekend. 
}
\usage{data(bmw)}
\format{A numeric vector containing 6146 observations, with a
  \code{times} attribute which is a \code{POSIXct} object
  of the same length.}
\keyword{datasets}

\eof
\name{danish}
\alias{danish}
\title{Danish Fire Insurance Claims} 
\description{
  These data describe large fire insurance claims 
  in Denmark from Thursday 3rd January 1980 until
  Monday 31st December 1990.
  The data are contained in a numeric vector.
  The dates of each observation are contained in a \code{times}
  attribute, which is an object of class \code{"POSIXct"} (see
  \code{\link{DateTimeClasses}}).
  They were supplied by Mette Rytgaard of Copenhagen Re. 
  Note that these data form an irregular time series. 
}
\usage{data(danish)}
\format{A numeric vector containing 2167 observations, with a
  \code{times} attribute which is a \code{POSIXct} object
  of the same length.}
\keyword{datasets}

\eof
\name{decluster}
\alias{decluster}
\title{Decluster Point Process}
\description{
  Declusters clustered point process data so that Poisson
  assumption is more tenable over a high threshold.
}
\usage{
decluster(series, run = NA, picture = TRUE)
}
\arguments{
  \item{series}{a numeric vector of threshold exceedances
    with a \code{times} attribute which should be a numeric
    vector containing either the indices or the times/dates
    of each exceedance (if times/dates, the attribute should
    be an object of class \code{"POSIXct"} or an object that
    can be converted to that class; see
    \code{\link{as.POSIXct}})}
  \item{run}{parameter to be used in the runs method; any two
    consecutive threshold exceedances separated by more than this
    number of observations/days are considered to belong to
    different clusters}  
  \item{picture}{whether or not a picture of declustering should
    be drawn}
}
\value{
  The declustered object. 
}
\section{References}{
  Embrechts, P., Klueppelberg, C., Mikosch, T. (1997).
  \emph{Modelling Extremal Events}. Springer.
  Chapter 8, 413--429. 
}
\seealso{\code{\link{pot}}, \code{\link{exindex}},
  \code{\link{as.POSIXct}}}

\examples{
# decluster the 200 exceedances of a particular threshold in 
# the negative BMW data
data(bmw)
out <- pot(-bmw, ne = 200) 
decluster(out$data, 30) 
}
\keyword{manip}

\eof
\name{dgev}
\alias{dgev}
\alias{pgev}
\alias{qgev}
\alias{rgev}
\title{Generalized Extreme Value Distribution}
\description{
  Cumulative probability, quantiles, density and random generation
  from the generalized extreme value distribution. 
}
\usage{
pgev(q, xi = 1, mu = 0, sigma = 1) 
qgev(p, xi = 1, mu = 0, sigma = 1) 
dgev(x, xi = 1, mu = 0, sigma = 1) 
rgev(n, xi = 1, mu = 0, sigma = 1)
}
\arguments{
\item{q}{vector of quantiles}
\item{p}{vector of probabilities}
\item{x}{vector of values at which to evaluate density}
\item{n}{sample size}
\item{xi}{shape parameter}
\item{mu}{location parameter}
\item{sigma}{scale parameter}
}
\value{
  Probability (\code{pgev}), quantile (\code{qgev}), density
  (\code{dgev}) or random sample (\code{rgev}) for the GEV
  distribution with shape \code{xi}. 
}

\seealso{\code{\link{dgpd}}, \code{\link{gev}}}
\keyword{distribution}

\eof
\name{dgpd}
\alias{dgpd}
\alias{pgpd}
\alias{qgpd}
\alias{rgpd}
\title{Generalized Pareto Distribution }
\description{
  Cumulative probability, quantiles, density and random
  generation from the generalized Pareto distribution. 
}
\usage{
pgpd(q, xi, mu = 0, beta = 1) 
qgpd(p, xi, mu = 0, beta = 1) 
dgpd(x, xi, mu = 0, beta = 1) 
rgpd(n, xi, mu = 0, beta = 1)
}
\arguments{
\item{q}{vector of quantiles.}
\item{p}{vector of probabilities.}
\item{x}{vector of values at which to evaluate density}
\item{n}{sample size}
\item{xi}{shape parameter.}
\item{mu}{location parameter.}
\item{beta}{scale parameter}
}
\value{
  Probability (\code{pgpd}), quantile (\code{qgpd}), density
  (\code{dgpd}) or random sample (\code{rgpd}) for the GPD
  distribution with shape \code{xi}. 
}

\seealso{\code{\link{dgev}}, \code{\link{gpd}}}
\keyword{distribution}

\eof
\name{emplot}
\alias{emplot}
\title{Plot of Empirical Distribution Function}
\description{
  Plots empirical distribution function of a sample. 
}
\usage{
emplot(data, alog = "x", labels = TRUE, \dots)
}
\arguments{
  \item{data}{data vector}
  \item{alog}{whether axes are to be logged: \code{"x"} x-axis
    only; \code{"y"} y-axis only; \code{"xy"} both axes;
    \code{""} neither axis.}
  \item{labels}{whether or not axes should be labelled}
  \item{\dots}{other graphics parameters}
}
\details{
  This is a simple explanatory function. A straight line on the  
  double log scale indicates Pareto tail behaviour. 
}
\seealso{\code{\link{qplot}}, \code{\link{meplot}}}

\examples{
\dontrun{data(danish)}
\dontrun{emplot(danish)} 
# Danish fire insurance data show Pareto tail behaviour 
}
\keyword{hplot}

\eof
\name{exindex}
\alias{exindex}
\title{Estimate Extremal Index}
\description{
  Plot estimates of extremal index using the blocks method. 
}
\usage{
exindex(data, block, start = 5, end = NA, reverse = FALSE,
    auto.scale = TRUE, labels = TRUE, \dots)
}
\arguments{
  \item{data}{data vector (raw values not block maxima).}
  \item{block}{the block size. A numeric value is interpreted as
    the number of data values in each successive block.
    All the data is used, so the last block may not contain
    \code{block} observations.
    If the \code{data} has a \code{times} attribute containing (in
    an object of class \code{"POSIXct"}, or an object that can be
    converted to that class; see \code{\link{as.POSIXct}}) the
    times/dates of each observation, then \code{block} may instead
    take the character values \code{"month"}, \code{"quarter"},
    \code{"semester"} or \code{"year"}.}
  \item{start}{lowest value of K at which to plot a point; K is the
    number of blocks in which a specified threshold is exceeded}
  \item{end}{highest value of K at which to plot a point}
  \item{reverse}{whether plot is to be by increasing threshold
    (\code{TRUE}) or increasing K value (\code{FALSE})}
  \item{auto.scale}{whether or not plot should be automatically
    scaled; if not, \code{xlim} and \code{ylim} graphical parameters
    may be entered}
  \item{labels}{whether or not axes should be labelled}
  \item{\dots}{other graphics parameters}
}
\value{
  A table of results is returned invisibly.
}
\references{
  Embrechts, P., Klueppelberg, C., Mikosch, T. (1997).
  \emph{Modelling Extremal Events}. Springer. Chapter 8, 413-429.  
}
\seealso{\code{\link{gev}}, \code{\link{hill}},
  \code{\link{as.POSIXct}}}

\examples{
\dontrun{data(bmw)}
\dontrun{exindex(bmw, 100)} 
\dontrun{exindex(-bmw, 100)} 
# calculate extremal index for the right and left tails of the BMW 
# log returns 
}
\keyword{hplot}

\eof
\name{findthresh}
\alias{findthresh}
\title{Find Threshold}
\description{
  Finds a threshold so that a given number of
  extremes lie above.  
}
\usage{
findthresh(data, ne)
}
\arguments{
  \item{data}{data vector}
  \item{ne}{vector giving number of extremes above the threshold}
}
\details{
  When the data are tied a threshold is found so that at least 
  the specified number of extremes lie above.
}
\value{
  Vector of suitable thresholds. 
}
\seealso{\code{\link{hill}}, \code{\link{gpd}},
  \code{\link{pot}}}

\examples{
# Find threshold giving (at least) fifty exceedances for Danish data
data(danish)
findthresh(danish, 50) 
}
\keyword{manip}

\eof
\name{gev}
\alias{gev}
\title{Fit Generalized Extreme Value Distribution}
\description{
  Fits generalized extreme value distribution (GEV) to
  block maxima data. 
}
\usage{
gev(data, block = NA, \dots)
}
\arguments{
  \item{data}{data vector. Interpretation depends on value of
    block: if no block size is specified then data are
    interpreted as block maxima; if block size is set, then data
    are interpreted as raw data and block maxima are calculated.}
  \item{block}{the block size. A numeric value is interpreted as the
    number of data values in each successive block. All the data is
    used, so the last block may not contain \code{block} observations.
    If the \code{data} has a \code{times} attribute containing (in
    an object of class \code{"POSIXct"}, or an object that can be
    converted to that class; see \code{\link{as.POSIXct}}) the
    times/dates of each observation, then \code{block} may instead
    take the character values \code{"month"}, \code{"quarter"},
    \code{"semester"} or \code{"year"}.}
  \item{\dots}{arguments passed to \code{optim}}
}
\value{
  An object of class \code{gev} describing the fit and including
  parameter estimates and standard errors.
  Fitting is carried out using maximum likelihood.
}
\seealso{\code{\link{plot.gev}}, \code{\link{gumbel}},
  \code{\link{optim}}, \code{\link{as.POSIXct}}}

\examples{
# Fit GEV to monthly maxima
data(bmw)
out <- gev(bmw, "month") 
# Fit GEV to maxima of blocks of 100 observations
out <- gev(bmw, 100) 
# Fit GEV to the data in nidd.annual, the annual maximum water 
# levels of the River Nidd, using the "BFGS" optimization method
data(nidd.annual) 
out <- gev(nidd.annual, method = "BFGS", control = list(maxit = 500))   
}
\keyword{models}

\eof
\name{gpd}
\alias{gpd}
\title{Fit Generalized Pareto Model}
\description{
  Returns an object of class \code{"gpd"} representing the fit of
  a generalized Pareto model to excesses over a high threshold. 
}
\usage{
gpd(data, threshold = NA, nextremes = NA, method = c("ml", "pwm"),
    information = c("observed", "expected"), \dots)
}
\arguments{
  \item{data}{data vector}
  \item{threshold}{a threshold value (either this or
    \code{nextremes} must be given but not both)}
  \item{nextremes}{the number of upper extremes to be used (either
    this or \code{threshold} must be given but not both)}
  \item{method}{whether parameters should be estimated by the maximum
    likelihood method \code{"ml"} or the probability-weighted moments
    method \code{"pwm"}}
  \item{information}{whether standard errors should be calculated with
    \code{"observed"} or \code{"expected"} information. This only applies
    to the maximum likelihood method; for the probability-weighted moments
    method \code{"expected"} information is used if possible}
  \item{\dots}{arguments passed to \code{optim}}
}
\value{
  An object of class \code{"gpd"} describing the fit and including
  parameter estimates and standard errors. 
}
\details{
  The function uses the general purpose optimization function
  \code{optim} when \code{method = "ml"} is chosen.
}
\references{
  Parameter and  quantile  estimation  for  the  generalized
  Pareto   distribution,   JRM   Hosking   and   JR  Wallis,
  \emph{Technometrics} \bold{29}(3), pages 339-349, 1987.
}
\seealso{\code{\link{plot.gpd}}, \code{\link{shape}}, 
  \code{\link{quant}}, \code{\link{optim}}}     

\examples{
data(danish)
out <- gpd(danish, 10) 
# Fits GPD to excess losses over 10 for the Danish
# fire insurance data 
}
\keyword{models}

\eof
\name{gpd.q}
\alias{gpd.q}
\title{Add Quantile Estimates to plot.gpd}
\description{
  Calculates quantile estimates and confidence intervals for
  high quantiles above the threshold in a GPD analysis, and
  adds a graphical representation to an existing plot.
}
\usage{
gpd.q(x, pp, ci.type = c("likelihood", "wald"), ci.p = 0.95,
    like.num = 50)
}
\arguments{
  \item{x}{a list object returned by \code{plot.gpd} or
    \code{tailplot}}
  \item{pp}{the desired probability for quantile estimate (e.g. 0.99
    for the 99th percentile)}
  \item{ci.type}{method for calculating a confidence interval:
    \code{"likelihood"} or \code{"wald"}}
  \item{ci.p}{probability for confidence interval (must be less
    than 0.999)}
  \item{like.num}{number of times to evaluate profile likelihood}
}
\details{
  The GPD approximation in the tail is used to estimate quantile. 
  The \code{"wald"} method uses the observed Fisher information
  matrix to calculate confidence interval. The \code{"likelihood"}
  method reparametrizes the likelihood in terms of the unknown
  quantile and uses profile likelihood arguments to construct a
  confidence interval. 
}
\seealso{\code{\link{gpd}}, \code{\link{plot.gpd}},
  \code{\link{gpd.sfall}}, \code{\link{tailplot}}}
\examples{
\dontrun{data(danish)}
\dontrun{out <- gpd(danish, 10)} 
\dontrun{tp <- tailplot(out)} 
\dontrun{gpd.q(tp, 0.999)} 
# Estimates 99.9th percentile of Danish fire losses 
}
\keyword{iplot}

\eof
\name{gpd.sfall}
\alias{gpd.sfall}
\title{Add Expected Shortfall Estimates to a GPD Plot}
\description{
  Calculates expected shortfall (tail conditional expectation) 
  estimates and confidence intervals for high quantiles above the
  threshold in a GPD analysis, and adds a graphical representation
  to an existing plot.  
}
\usage{
gpd.sfall(x, pp, ci.p = 0.95, like.num = 50)
}
\arguments{
  \item{x}{a list object returned by \code{plot.gpd} or
    \code{tailplot}}
  \item{pp}{the desired probability for expected shortfall estimate
    (e.g. 0.99 for the 99th percentile)}
  \item{ci.p}{probability for confidence interval (must be less
    than 0.999)}
  \item{like.num}{number of times to evaluate profile likelihood}
}
\details{
  Expected shortfall is the expected size of the loss, given that a
  particular quantile of the loss distribution is exceeded. 
  The GPD approximation in the tail is used to estimate expected
  shortfall. The likelihood is reparametrised  in terms of the unknown
  expected shortfall and profile likelihood arguments are used to
  construct a confidence interval. 
}
\seealso{\code{\link{gpd}}, \code{\link{plot.gpd}},
  \code{\link{tailplot}}, \code{\link{gpd.q}}}

\examples{
\dontrun{data(danish)}
\dontrun{out <- gpd(danish, 10)}
\dontrun{tp <- tailplot(out)}
\dontrun{gpd.q(tp, 0.999)} 
# Estimates 99.9th percentile of Danish fire losses 
\dontrun{gpd.sfall(tp, 0.999)} 
# Estimates associated expected shortfall for Danish fire losses 
}
\keyword{iplot}

\eof
\name{gpdbiv}
\alias{gpdbiv}
\title{Implements Bivariate POT Method}
\description{
  Returns an object of class \code{"gpdbiv"} representing the fit
  of a bivariate POT (peaks over thresholds) model for joint
  excesses over thresholds. 
}
\usage{
gpdbiv(data1 = NA, data2 = NA, u1 = NA, u2 = NA, ne1 = NA, ne2 = NA,
    global = FALSE, method = "BFGS", \dots)
}
\arguments{
  \item{data1}{first data vector}
  \item{data2}{second data vector}
  \item{u1}{threshold for \code{data1} (either this or \code{ne1}
    must be given but not both)}
  \item{u2}{threshold for \code{data2} (either this or \code{ne2}
    must be given but not both)}
  \item{ne1}{number of upper extremes to be used for \code{data1}
    (either this or \code{u1} must be given but not both)}
  \item{ne2}{number of upper extremes to be used for \code{data2}
    (either this or \code{u2} must be given but not both)}
  \item{global}{should a global maximisation of the likelihood with
    respect to marginal and dependence parameters be undertaken. The
    default alternative is a two-stage local fit where first the
    marginal parameters are estimated and then the dependence
    parameter. This is much faster than a global fit.}
  \item{method}{the optimization method (see \code{optim}).
    The argument has been created (as distinct from \dots) in order
    to make the \code{"BFGS"} method the default, as the default
    used by \code{optim} is not recommended for the one-dimensional
    optimizations that occur when \code{global = FALSE}.}
  \item{\dots}{other arguments passed to \code{optim}}
}
\value{
  An object of class \code{"gpdbiv"} representing the fit and including
  parameter estimates and standard errors. 
}
\details{
  This function implements a model suggested by Richard Smith (see
  references below). The marginal excess distributions are GPD
  distributions, as suggested by univariate EVT and implemented in gpd.  
  The dependence specification is known as the logistic or Gumbel
  dependence structure, but it would be easy to program alternatives. 
}
\references{
  Multivariate Threshold Methods, Richard L. Smith,
  in \emph{Extreme Value Theory and Applications}, ed. J. Galambos,
  published by Kluwer, pages 225-248, 1994.
  
  Markov Chain Models for Threshold Exceedances,
  R.L. Smith, J.A. Tawn, S.G. Coles,
  \emph{Biometrika} \bold{84}, 249-268, 1997. 
}
\seealso{\code{\link{gpd}}, \code{\link{plot.gpdbiv}}, 
  \code{\link{interpret.gpdbiv}}}

\examples{
data(bmw) ; data(siemens)
out <- gpdbiv(-bmw, -siemens, ne1 = 100, ne2 = 100)
interpret.gpdbiv(out, 0.05, 0.05)
\dontrun{plot(out)} 
}
\keyword{models}

\eof
\name{gumbel}
\alias{gumbel}
\title{Fit Gumbel Distribution}
\description{
  Fits gumbel distribution (GEV with \code{xi = 0}) to
  block maxima data. 
}
\usage{
gumbel(data, block = NA, \dots)
}
\arguments{
  \item{data}{data vector. Interpretation depends on value of
    block: if no block size is specified then data are
    interpreted as block maxima; if block size is set, then data
    are interpreted as raw data and block maxima are calculated.}
  \item{block}{the block size. A numeric value is interpreted as the
    number of data values in each successive block. All the data is
    used, so the last block may not contain \code{block} observations.
    If the \code{data} has a \code{times} attribute containing (in
    an object of class \code{"POSIXct"}, or an object that can be
    converted to that class; see \code{\link{as.POSIXct}}) the
    times/dates of each observation, then \code{block} may instead
    take the character values \code{"month"}, \code{"quarter"},
    \code{"semester"} or \code{"year"}.}
  \item{\dots}{arguments passed to \code{optim}}
}
\value{
  An object of class \code{"gev"} describing the fit and including
  parameter estimates and standard errors.
  Fitting is carried out using maximum likelihood.
}
\details{ 
  This function is primarily intended for comparison with GEV for 
  assessing the need for a heavy-tailed Frechet (or short-tailed 
  Weibull) to model block maxima. 
}
\seealso{\code{\link{plot.gev}}, \code{\link{gev}},
  \code{\link{optim}}, \code{\link{as.POSIXct}}}

\examples{
# Fit Gumbel to maxima of blocks of 100 observations
data(bmw)
out <- gumbel(bmw, 100) 
# Fit Gumbel to the data in nidd.annual, the annual maximum water 
# levels of the River Nidd, using the "BFGS" optimization method
data(nidd.annual)
out <- gumbel(nidd.annual, method = "BFGS", control = list(maxit = 500))
}
\keyword{models}

\eof
\name{hill}
\alias{hill}
\title{Create Hill Plot}
\description{
  Plot the Hill estimate of the tail index of heavy-tailed
  data, or of an associated quantile estimate.
}
\usage{
hill(data, option = c("alpha","xi","quantile"), start = 15,
    end = NA, reverse = FALSE, p = NA, ci = 0.95,
    auto.scale = TRUE, labels = TRUE, \dots)
}
\arguments{
  \item{data}{data vector}
  \item{option}{whether \code{"alpha"}, \code{"xi"} (1/alpha) or
    \code{"quantile"} (a quantile estimate) should be plotted}
  \item{start}{lowest number of order statistics at which to plot
    a point}
  \item{end}{highest number of order statistics at which to plot
    a point}
  \item{reverse}{whether plot is to be by increasing threshold
    (\code{TRUE}) or increasing number of order statistics
    (\code{FALSE})}
  \item{p}{probability required when option \code{"quantile"} is
    chosen}
  \item{ci}{probability for asymptotic confidence band; for no
    confidence band set \code{ci} to zero}
  \item{auto.scale}{whether or not plot should be automatically
    scaled; if not, \code{xlim} and \code{ylim} graphical
    parameters may be entered}
  \item{labels}{whether or not axes should be labelled}
  \item{\dots}{other graphics parameters}
}
\details{
  This plot is usually calculated from the alpha perspective.
  For a generalized Pareto analysis of heavy-tailed data using
  the \code{gpd} function, it helps to plot the Hill estimates
  for xi. 
}
\seealso{\code{\link{shape}}, \code{\link{quant}}}

\examples{
\dontrun{data(danish)}
\dontrun{hill(danish)} 
# Hill plot of heavy-tailed Danish fire insurance data 
\dontrun{hill(danish, option = "quantile", end = 500, p = 0.999)} 
# Hill plot of estimated 0.999 quantile of Danish fire insurance data 
}
\keyword{hplot}

\eof
\name{interpret.gpdbiv}
\alias{interpret.gpdbiv}
\title{Interpret Results of Bivariate GPD Fit}
\description{
  Interprets the results of a bivariate GPD model fitted
  using the bivariate POT method. 
}
\usage{
interpret.gpdbiv(out, x, y)
}
\arguments{
\item{out}{a \code{gpdbiv} object}
\item{x}{a scalar value greater than first threshold}
\item{y}{a scalar value greater than second threshold}
}
\value{
 A vector of probabilities is invisibly returned, in printed order. 
}
\section{Side Effects}{
  A simple interpretation of the fit in terms of exceedance 
  probabilities for the point (x,y) is printed. 
}
\details{
  First marginal probabilities of exceeding the points x and y
  are calculated, and then joint and conditional probabilities. 
}
\seealso{\code{\link{gpdbiv}}, \code{\link{plot.gpdbiv}}}

\examples{
data(bmw) ; data(siemens)
out <- gpdbiv(-bmw, -siemens, ne1 = 100, ne2 = 100) 
interpret.gpdbiv(out, 0.05, 0.05) 
# probabilities of 5\% falls in BMW and Siemens stock prices 
}
\keyword{htest}

\eof
\name{meplot}
\alias{meplot}
\title{Sample Mean Excess Plot}
\description{
  Plots sample mean excesses over increasing thresholds.  
}
\usage{
meplot(data, omit = 3, labels = TRUE, \dots)
}
\arguments{
  \item{data}{data vector}
  \item{omit}{number of upper plotting points to be omitted}
  \item{labels}{whether or not axes are to be labelled}
  \item{\dots}{other graphics parameters}
}
\details{
  An upward trend in plot shows heavy-tailed behaviour. In particular,
  a straight line with positive gradient above some threshold is a sign 
  of Pareto behaviour in tail. A downward trend shows thin-tailed 
  behaviour whereas a line with zero gradient shows an exponential 
  tail. Because upper plotting points are the average of a handful of
  extreme excesses, these may be omitted for a prettier plot. 
}
\seealso{\code{\link{gpd}}, \code{\link{qplot}}}

\examples{
\dontrun{data(danish)}
\dontrun{meplot(danish)} 
# Sample mean excess plot of heavy-tailed Danish fire insurance data 
}
\keyword{hplot}

\eof
\name{nidd.annual}
\alias{nidd.annual}
\title{The River Nidd Data} 
\description{
  These data represent annual maximal levels of the 
  River Nidd in Yorkshire. 
  These data are suitable for analysis with \code{gev}. 
}
\format{A numeric vector containing 35 observations.}
\usage{data(nidd.annual)}
\keyword{datasets}

\eof
\name{nidd.thresh}
\alias{nidd.thresh}
\title{The River Nidd Data} 
\description{
  These data represent high river levels of the 
  River Nidd in Yorkshire above a threshold value 
  of 65. These data are suitable for analysis with 
  \code{gpd}.  
}
\format{A numeric vector containing 154 observations.}
\usage{data(nidd.thresh)}
\keyword{datasets}

\eof
\name{plot.gev}
\alias{plot.gev}
\title{Plot Fitted GEV Model}
\description{
  The plot method plot.gev provides two different residual plots 
  for assessing fitted GEV model. The user selects the plot type 
  from a menu. See the examples below. 
}
\usage{
\method{plot}{gev}(x, \dots)
}
\arguments{
  \item{x}{a \code{gev} object}
  \item{\dots}{other graphics parameters}
}
\details{
  Data are converted to unit exponentially distributed residuals
  under null hypothesis that GEV fits. Two diagnostics for iid
  exponential data are offered. 
}
\seealso{\code{\link{gev}}, \code{\link{qplot}}}

\examples{
data(bmw)
out <- gev(bmw, 100) 
\dontrun{plot(out)}
 
\dontrun{Make a plot selection (or 0 to exit):}
\dontrun{1: plot: Scatterplot of Residuals}
\dontrun{2: plot: QQplot of Residuals}
}
\keyword{hplot}

\eof
\name{plot.gpd}
\alias{plot.gpd}
\title{Plot Fitted GPD Model}
\description{
  The plot method plot.gpd provides four different plots 
  for assessing fitted GPD model. The user selects the plot
  type from a menu. See the examples below. 
}
\usage{
\method{plot}{gpd}(x, optlog = NA, extend = 1.5, labels = TRUE, \dots)
}
\arguments{
  \item{x}{a \code{gpd} object}
  \item{optlog}{optional argument for plots 1 and 2 giving a
    particular choice of logarithmic axes: \code{"x"} x-axis
    only; \code{"y"} y-axis only; \code{"xy"} both axes;
    \code{""} neither axis.}
  \item{extend}{optional argument for plots 1 and 2 expressing how
    far x-axis should extend as a multiple of the largest data value.
    This argument must take values greater than 1 and is useful for
    showing estimated quantiles beyond data.}
  \item{labels}{optional argument for plots 1 and 2  specifying whether
    or not axes should be labelled}
  \item{\dots}{other graphics parameters}
}
\value{
  If plot 1 or 2 is selected as the final plot, a list object containing
  details of the plot is returned invisibly.
  This object should be used as the first argument of \code{gpd.q}
  or \code{gpd.sfall} to add quantile estimates or expected shortfall
  estimates to the plot.
}
\seealso{\code{\link{gpd}}, \code{\link{quant}}, \code{\link{shape}}}

\examples{
data(danish)
out <- gpd(danish, 10) 
\dontrun{plot(out)} 

\dontrun{Make a plot selection (or 0 to exit):}
\dontrun{1: plot: Excess Distribution} 
\dontrun{2: plot: Tail of Underlying Distribution} 
\dontrun{3: plot: Scatterplot of Residuals} 
\dontrun{4: plot: QQplot of Residuals} 
}
\keyword{hplot}

\eof
\name{plot.gpdbiv}
\alias{plot.gpdbiv}
\title{Plot Fitted Bivariate GPD Model}
\description{
  Provides a number of plots summarising a bivariate GPD model
  fitted using the bivariate POT method. See the examples below. 
}
\usage{
\method{plot}{gpdbiv}(x, extend = 1.1, n.contours = 15, \dots)
}
\arguments{
  \item{x}{a \code{gpdbiv} object}
  \item{extend}{optional argument expressing how far x-axis should
    extend as a multiple of the largest data value.}
  \item{n.contours}{number of contours in bivariate contour plots}
  \item{\dots}{other graphics parameters}
}
\details{
  Option 1 plots the threshold exceedance data; option 2 plots contours
  of the fitted bivariate distribution function in the joint upper tail
  (above both thresholds); option 3 plots corresponding contours of the
  fitted joint survival function; plots 4 and 5 show the fitted tails
  of the marginal distributions. 
}
\seealso{\code{\link{gpd}}, \code{\link{gpdbiv}},
  \code{\link{tailplot}}, \code{\link{interpret.gpdbiv}},
  \code{\link{plot.gpd}}}

\examples{
data(bmw) ; data(siemens)
out <- gpdbiv(-bmw, -siemens, ne1 = 100, ne2 = 100) 
\dontrun{plot(out)}
 
\dontrun{Make a plot selection (or 0 to exit): }
\dontrun{1: plot: Exceedance data}
\dontrun{2: plot: Contours of Bivariate Distribution Function}
\dontrun{3: plot: Contours of Bivariate Survival Function} 
\dontrun{4: plot: Tail of Marginal 1} 
\dontrun{5: plot: Tail of Marginal 2} 
}
\keyword{hplot}

\eof
\name{plot.pot}
\alias{plot.pot}
\title{Plot Fitted POT Model}
\description{
  The plot method plot.pot provides seven different plots 
  for assessing fitted POT model. The user selects the plot
  type from a menu. See the examples below. 
}
\usage{
\method{plot}{pot}(x, \dots)
}
\arguments{
  \item{x}{a \code{pot} object}
  \item{\dots}{other graphics parameters}
}
\details{
  Plot 1 displays the exceedance process of the chosen threshold. 
  Plots 2-4  assess the Poisson nature of the exceedance process 
  by looking at the scaled gaps between exceedances, which should
  be iid unit exponentially distributed. Plots 5-6 assess the GPD
  nature of the excesses by looking at suitably defined residuals,
  which should again be iid unit exponentially distributed. Option
  8 allows the user to call GPD plotting functions. 
}
\value{
  If plot 1 or 2 from the GPD plots is selected as the final plot
  (i.e. option 8 is selected, followed by option 1 or 2), a list
  object containing details of the plot is returned invisibly.
  This object should be used as the first argument of \code{gpd.q}
  or \code{gpd.sfall} to add quantile estimates or expected shortfall
  estimates to the plot.
}
\seealso{\code{\link{gpd}}, \code{\link{pot}},
  \code{\link{plot.gpd}}}

\examples{
data(danish)
out <- pot(danish,10) 
\dontrun{plot(out)} 
  
\dontrun{Make a plot selection (or 0 to exit):} 
\dontrun{1: plot: Point Process of Exceedances} 
\dontrun{2: plot: Scatterplot of Gaps} 
\dontrun{3: plot: Qplot of Gaps} 
\dontrun{4: plot: ACF of Gaps} 
\dontrun{5: plot: Scatterplot of Residuals} 
\dontrun{6: plot: Qplot of Residuals} 
\dontrun{7: plot: ACF of Residuals} 
\dontrun{8: plot: Go to GPD Plots}   
}
\keyword{hplot}

\eof
\name{pot}
\alias{pot}
\title{Peaks Over Thresholds Model}
\description{
  Fits a Poisson point process to the data, an approach 
  sometimes known as peaks over thresholds (POT), and
  returns an object of class \code{"pot"}. 
}
\usage{
pot(data, threshold = NA, nextremes = NA, run = NA, picture = TRUE,
    \dots)
}
\arguments{
  \item{data}{numeric vector of data, which may have a \code{times}
    attribute containing (in an object of class \code{"POSIXct"}, or
    an object that can be converted to that class; see
    \code{\link{as.POSIXct}}) the times/dates of each observation.
    If no \code{times} attribute exists, the data are assumed to
    be equally spaced.}
  \item{threshold}{a threshold value (either this or \code{nextremes}
    must be given but not both)}
  \item{nextremes}{the number of upper extremes to be used (either
    this or \code{threshold} must be given but not both)}
  \item{run}{if the data are to be declustered the run length
    parameter for the runs method (see \code{\link{decluster}})
    should be entered here}
  \item{picture}{whether or not a picture should be drawn if
    declustering is performed}
  \item{\dots}{arguments passed to \code{optim}}
}
\value{
  An object of class \code{"pot"} describing the fit and including
  parameter estimates and standard errors. 
}
\details{
  Uses \code{optim} for point process likelihood maximization. 
}
\seealso{\code{\link{gpd}}, \code{\link{plot.pot}}, 
  \code{\link{plot.gpd}}, \code{\link{decluster}},
  \code{\link{optim}}, \code{\link{as.POSIXct}}}

\examples{
data(danish)
out <- pot(danish, 10)  
# Fits POT model to Danish fire insurance losses 
}
\keyword{models}

\eof
\name{qplot}
\alias{qplot}
\title{Exploratory QQplot for Extreme Value Analysis}
\description{
  Creates a QQplot for threshold data against the exponential 
  distribution or the generalized Pareto distribution. 
}
\usage{
qplot(data, xi = 0, trim = NA, threshold = NA, line = TRUE,
    labels = TRUE, \dots)
}
\arguments{
  \item{data}{data vector}
  \item{xi}{the xi value of a generalized Pareto distribution}
  \item{trim}{value at which data are to be right-truncated}
  \item{threshold}{value at which data are to be left-truncated}
  \item{line}{whether or not a straight line is to be added}
  \item{labels}{whether or not the axes are to be labelled}
  \item{\dots}{other graphics parameters}
}
\details{
  If xi is zero the reference distribution is the exponential; if 
  xi is non-zero the reference distribution is the generalized 
  Pareto with that value of xi. 
  In the case of the exponential, the plot is interpreted as follows. 
  Concave departures from a straight line are a sign of heavy-tailed  
  behaviour. Convex departures show thin-tailed behaviour. 
}
\seealso{\code{\link{gpd}}, \code{\link{meplot}}}

\examples{
\dontrun{data(danish)}
\dontrun{qplot(danish)} 
# QQplot of heavy-tailed Danish fire insurance data 
}
\keyword{hplot}

\eof
\name{quant}
\alias{quant}
\title{Plot of GPD Tail Estimate of a High Quantile}
\description{
  Creates a plot showing how the estimate of a high quantile in
  the tail of a dataset based on the GPD approximation varies with
  threshold or number of extremes. 
}
\usage{
quant(data, p = 0.99, models = 30, start = 15, end = 500, reverse =
    TRUE, ci = 0.95, auto.scale = TRUE, labels = TRUE, \dots)
}
\arguments{
  \item{data}{numeric vector of data}
  \item{p}{desired probability for quantile estimate (e.g. 0.99
    gives 99th percentile)}
  \item{models}{number of consecutive gpd models to be fitted}
  \item{start}{lowest number of exceedances to be considered}
  \item{end}{maximum number of exceedances to be considered}
  \item{reverse}{should plot be by increasing threshold
    (\code{TRUE}) or number of extremes (\code{FALSE})}
  \item{ci}{probability for asymptotic confidence band; for no
    confidence band set to zero}
  \item{auto.scale}{whether or not plot should be automatically scaled;
    if not, xlim and ylim graphical parameters may be entered}
  \item{labels}{whether or not axes should be labelled}
  \item{\dots}{other graphics parameters}
}
\value{
  A table of results is returned invisibly.
}
\details{
  For every model \code{gpd} is called. Evaluation may be slow. 
  Confidence intervals by the Wald method (which is fastest). 
}
\seealso{\code{\link{gpd}}, \code{\link{plot.gpd}},
  \code{\link{gpd.q}}, \code{\link{shape}}}

\examples{
\dontrun{data(danish)}
\dontrun{quant(danish, 0.999)} 
# Estimates of the 99.9th percentile of the Danish losses using 
# the GPD model with various thresholds 
}
\keyword{hplot}

\eof
\name{records}
\alias{records}
\title{Calculate Record Development}
\description{
  Creates a data frame showing the development of records in 
  a dataset and calculating the expected behaviour for iid data.
}
\usage{
records(data, do.plot = TRUE, conf.level = 0.95, \dots)
}
\arguments{
  \item{data}{data vector}
  \item{do.plot}{whether a plot of record development should be
    created}
  \item{conf.level}{confidence level for record development plot}
  \item{\dots}{graphics parameters}
}
\value{
 A data frame. 
}
\details{
  Records are counted and the observations at which they occur 
  recorded. This is compared with the expected behaviour for iid 
  data. 
}

\examples{
\dontrun{data(danish)}
\dontrun{records(danish)} 
# Record fire insurance losses in Denmark 
}
\keyword{hplot}

\eof
\name{riskmeasures}
\alias{riskmeasures}
\title{Calculates Quantiles and Expected Shortfalls}
\description{
  Makes a rapid calculation of point estimates of prescribed
  quantiles and expected shortfalls using the output of the
  function \code{gpd}. 
}
\usage{
riskmeasures(x, p)
}
\arguments{
\item{x}{results of a \code{gpd} fit}
\item{p}{a vector of probability levels}
}
\value{
  A matrix with three columns: probability level, quantile
  estimate, shortfall estimate. 
}
\details{
  This function simply calculates point estimates and (at present)
  makes no attempt to calculate confidence intervals for the risk
  measures. If confidence levels are required use \code{gpd.q} and
  \code{gpd.sfall} which interact with graphs of the tail of a loss
  distribution and are much slower. 
}
\seealso{\code{\link{gpd}}, \code{\link{tailplot}},
  \code{\link{gpd.q}}, \code{\link{gpd.sfall}}}

\examples{
data(danish)
out <- gpd(danish, 10) 
riskmeasures(out, c(0.999, 0.9999)) 
# gives estimates of 0.999 and 0.9999 quantiles of Danish loss
# distribution as well as the associated expected shortfall estimates 
}
\keyword{htest}

\eof
\name{rlevel.gev}
\alias{rlevel.gev}
\title{Calculate Return Levels Based on GEV Fit}
\description{
  Calculates the k-block return level and 95\% confidence interval
  based on a GEV model for block maxima, where k is specified by
  the user. The k-block return level is that level exceeded once
  every k blocks, on average. 
}
\usage{
rlevel.gev(out, k.blocks = 20, add = FALSE, \dots)
}
\arguments{
  \item{out}{an object returned by the function \code{gev}}
  \item{k.blocks}{specifies the particular return level to be
    estimated; default set arbitrarily to 20}
  \item{add}{whether the return level should be added graphically
    to a time series plot; if \code{FALSE} a graph of the profile
    likelihood curve showing the return level and its confidence
    interval is produced}
  \item{\dots}{other graphics parameters}
}
\value{
  Vector containing lower 95\% bound of confidence interval,
  estimated return level and upper 95\% bound. 
}
\details{
  The GEV likelihood is reparameterized in terms of the unknown
  return level and profile likelihood arguments are used to
  construct a confidence interval. 
}
\seealso{\code{\link{gev}}, \code{\link{plot.gev}}}

\examples{
data(bmw)
out <- gev(bmw, "month")
# Fit GEV to monthly maxima of daily returns on BMW share price
\dontrun{rlevel.gev(out, 40)}
# Calculate the 40 month return level
}
\keyword{htest}

\eof
\name{shape}
\alias{shape}
\title{Plot for GPD Shape Parameter}
\description{
  Creates a plot showing how the estimate of shape varies
  with threshold or number of extremes. 
}
\usage{
shape(data, models = 30, start = 15, end = 500, reverse = TRUE,
    ci = 0.95, auto.scale = TRUE, labels = TRUE, \dots)
}
\arguments{
  \item{data}{numeric vector of data}
  \item{models}{number of consecutive gpd models to be fitted}
  \item{start}{lowest number of exceedances to be considered}
  \item{end}{maximum number of exceedances to be considered}
  \item{reverse}{should plot be by increasing threshold
    (\code{TRUE}) or number of extremes (\code{FALSE})}
  \item{ci}{probability for asymptotic confidence band; for no
    confidence band set to zero}
  \item{auto.scale}{whether or not plot should be automatically
    scaled; if not, \code{xlim} and \code{ylim} graphical
    parameters may be entered}
  \item{labels}{whether or not axes should be labelled}
  \item{\dots}{other graphics parameters}
}
\value{
  A table of results is returned invisibly.
}
\details{
  For every model \code{gpd} is called. Evaluation may be slow. 
}
\seealso{\code{\link{gpd}}, \code{\link{plot.gpd}},
  \code{\link{hill}}}

\examples{
\dontrun{data(danish)}
\dontrun{shape(danish)}
# Shape plot of heavy-tailed Danish fire insurance data 
}
\keyword{hplot}

\eof
\name{siemens}
\alias{siemens}
\title{Daily Log Returns on Siemens Share Price} 
\description{
  These data are the daily log returns on Siemens share price 
  from Tuesday 2nd January 1973 until Tuesday 23rd July 1996.
  The data are contained in a numeric vector.
  The dates of each observation are contained in a \code{times}
  attribute, which is an object of class \code{"POSIXct"} (see
  \code{\link{DateTimeClasses}}).
  Note that these data form an irregular time series because 
  no trading takes place at the weekend. 
}
\usage{data(siemens)}
\format{A numeric vector containing 6146 observations, with a
  \code{times} attribute which is a \code{POSIXct} object
  of the same length.}
\keyword{datasets}

\eof
\name{sp.raw}
\alias{sp.raw}
\title{SP Data to June 1993} 
\description{
  The daily closing values of the S&P index from
  Monday 4th January 1960 until Friday 11th June 1993.
  The data are contained in a numeric vector.
  The dates of each observation are contained in a \code{times}
  attribute, which is an object of class \code{"POSIXct"} (see
  \code{\link{DateTimeClasses}}).
}
\format{A numeric vector containing 8415 observations, with a
  \code{times} attribute which is a \code{POSIXct} object
  of the same length.}
\usage{data(sp.raw)}
\keyword{datasets}

\eof
\name{spto87}
\alias{spto87}
\title{SP Return Data to October 1987} 
\description{
  The daily log returns on the S&P index value from
  Tuesday 5th January 1960 until Friday 16 October 1987.
  The data are contained in a numeric vector.
  The dates of each observation are contained in a \code{times}
  attribute, which is an object of class \code{"POSIXct"} (see
  \code{\link{DateTimeClasses}}).
}
\format{A numeric vector containing 6985 observations, with a
  \code{times} attribute which is a \code{POSIXct} object
  of the same length.}
\usage{data(spto87)}
\keyword{datasets}

\eof
\name{tailplot}
\alias{tailplot}
\title{Plot Tail Estimate From GPD Model}
\description{
  Interacts with the output of gpd to produce a plot of the tail
  of the underlying distribution of the data.
  This is one of the options of \code{plot.gpd}, but tailplot enables
  the user to bypass the menu of the former. 
}
\usage{
tailplot(x, optlog = NA, extend = 1.5, labels = TRUE, \dots)
}
\arguments{
  \item{x}{a \code{gpd} object}
  \item{optlog}{optional argument giving a particular choice
    of logarithmic axes: \code{"x"} x-axis only; \code{"y"}
    y-axis only; \code{"xy"} both axes; \code{""} neither axis.}
  \item{extend}{optional argument expressing how far x-axis should
    extend as a multiple of the largest data value. This argument
    must take values greater than 1 and is useful for showing
    estimated quantiles beyond data.}
  \item{labels}{optional argument specifying whether or not axes
    should be labelled}
  \item{\dots}{other graphics parameters}
}
\value{
  A list object containing details of the plot is returned invisibly.
  This object should be used as the first argument of \code{gpd.q}
  or \code{gpd.sfall} to add quantile estimates or expected shortfall
  estimates to the plot.
}

\seealso{\code{\link{gpd}}, \code{\link{plot.gpd}},
  \code{\link{shape}}, \code{\link{quant}}}

\examples{
data(danish)
out <- gpd(danish, 10) 
\dontrun{tailplot(out)} 
}
\keyword{hplot}

\eof
