gpd.q                  package:evir                  R Documentation

_A_d_d _Q_u_a_n_t_i_l_e _E_s_t_i_m_a_t_e_s _t_o _p_l_o_t._g_p_d

_D_e_s_c_r_i_p_t_i_o_n:

     Calculates quantile estimates and confidence intervals for high
     quantiles above the threshold in a GPD analysis, and adds a
     graphical representation to an existing plot.

_U_s_a_g_e:

     gpd.q(x, pp, ci.type = c("likelihood", "wald"), ci.p = 0.95,
         like.num = 50)

_A_r_g_u_m_e_n_t_s:

       x: a list object returned by 'plot.gpd' or 'tailplot'

      pp: the desired probability for quantile estimate (e.g. 0.99 for
          the 99th percentile)

 ci.type: method for calculating a confidence interval: '"likelihood"'
          or '"wald"'

    ci.p: probability for confidence interval (must be less than 0.999)

like.num: number of times to evaluate profile likelihood

_D_e_t_a_i_l_s:

     The GPD approximation in the tail is used to estimate quantile. 
     The '"wald"' method uses the observed Fisher information matrix to
     calculate confidence interval. The '"likelihood"' method
     reparametrizes the likelihood in terms of the unknown quantile and
     uses profile likelihood arguments to construct a confidence
     interval.

_S_e_e _A_l_s_o:

     'gpd', 'plot.gpd', 'gpd.sfall', 'tailplot'

_E_x_a_m_p_l_e_s:

     ## Not run: data(danish)
     ## Not run: out <- gpd(danish, 10) 
     ## Not run: tp <- tailplot(out) 
     ## Not run: gpd.q(tp, 0.999) 
     # Estimates 99.9th percentile of Danish fire losses 

