\name{bsplineS}
\alias{bsplineS}
\title{B-spline Basis Function Values}
\description{
Evaluates a set of B-spline basis functions, or a derivative of these functions, at a set of arguments. 
}
\usage{
bsplineS(x, breaks, norder=4, nderiv=0)
}
\arguments{
  \item{x}{A vector of argument values at which the B-spline basis functions are to evaluated.}
  \item{breaks}{A strictly increasing set of break values defining the B-spline basis. The argument values x should be within the interval spanned by the break values.}
  \item{norder}{The order of the B-spline basis functions. The order less one is the degree of the piece-wise polynomials that make up any B-spline function. The default is order 4, meaning piece-wise cubic. }
  \item{nderiv}{The derivative to be evaluated. The derivative must not exceed the order. The default derivative is 0, meaning that the basis functions themselves are evaluated.}
}
\details{
}
\value{
A matrix of function values. The number of rows equals the number of arguments, and the number of columns equals the number of basis functions. 
}
\references{}
\note{}
\author{}
\seealso{}
\examples{}
\keyword{}

\eof
\name{bsplinepen}
\alias{bsplinepen}
\title{B-Spline Penalty Matrix}
\description{
Computes the matrix defining the roughness penalty for functions expressed in terms of a B-spline basis.
}
\usage{
bsplinepen(basisfd, Lfd=2)
}
\arguments{
  \item{basisfd}{A B-spline basis object.}
  \item{Lfd}{Either a nonnegative integer or a linear differential operator object.}
}
\details{
A roughness penalty for a function x(t) is defined by integrating the square of either the derivative of x(t) or, more generally, the result of applying a linear differential operator L to it. The most common roughness penalty is the integral of the square of the second derivative D2x(t), and this is the default. To apply this roughness penalty, the matrix of inner products of the basis functions (possibly after applying the linear differential operator to them) defining this function is necessary. This function just calls the roughness penalty evaluation function specific to the basis involved. 
}
\value{A symmetric matrix of order equal to the number of basis functions defined by the B-spline basis object. Each element is the inner product of two B-spline basis functions after applying the derivative or linear differential operator defined by Lfdobj. 
}
\references{}
\note{}
\author{}
\seealso{}
\examples{}
\keyword{}

\eof
\name{cca.2fun.fd}
\alias{cca.2fun.fd}
\title{Canonical Correlation for Two Functional Data Objects}
\description{
This is an extension of function cca.fd that computes a functional canonical correlation with regularization using two different functional data samples. These may have different bases, and different penalty functionals. It is assumed that both are univariate. Two differential operators are also possible. 
}
\usage{
cca.2fun.fd(fd1, fd2=fd1, ncan=2, lambda1=0.00025, Lfd1=2, lambda2=lambda1, Lfd2=Lfd1)
}
\arguments{
  \item{fd1}{The first functional data object.}
  \item{fd2}{The second functional data object.}
  \item{ncan}{The number of canonical variables to be estimated.}
  \item{lambda1}{The smoothing parameter for the first set of canonical variables.}
  \item{Lfd1}{The order of derivative to be penalized if it is a scalar, or the linear differential operator whose value is to be penalized if it is a functional data object. This applies to the first functional data object fd1. }
  \item{lambda2}{The smoothing parameter for the second set of canonical variables.}
  \item{Lfd2}{The order of derivative to be penalized if it is a scalar, or the linear differential operator whose value is to be penalized if it is a functional data object. This applies to the second functional data object fd2. }
}
\details{
Function cca.fd is mainly intended for situations where the two functions are reflecting the same variable, such as angle in the gait data. However, one also can want to correlate two variables of an entirely different character, such as temperature and precipitation in the weather data. In this case the two functional data objects will be univariate, but otherwise should be defined separately, and possibly with rather different bases. 
}
\value{
A list with these entries is returned. 
"weight function 1 " A functional data object for the first canonical variable in the "ncan" pairs of canonical variate weight functions. Each replicate corresponds to a pair of weight functions. 
"weight function 2 " A functional data object for the first canonical variable in the "ncan" pairs of canonical variate weight functions. Each replicate corresponds to a pair of weight functions. 
"correlations" The complete set of canonical correlations. The number is equal to the number of basis functions. 
"variates" An array of the values taken by the canonical variates, that is, the scores on the variates. This is a 3-way array with first dimension corresponding to replicates, second to the different variates (dimension NCAN) and third (dimension 2) to the "x" and "y" scores. 
}
\references{Ramsay, J. O. and Silverman, B. W. (1997) Functional Data Analysis. New York: Springer. Canonical correlation analysis is described in Chapter 12. 
}
\note{}
\author{}
\seealso{cca.fd}
\examples{}
\keyword{}

\eof
\name{cca.fd}
\alias{cca.fd}
\title{Canonical correlation analysis }
\description{
Carry out a functional canonical correlation analysis with regularization or roughness penalties on the estimated canonical variables. 
}
\usage{
cca.fd(fd, ncan=2, lambda=0.00025, Lfd=2)
}
\arguments{
  \item{fd}{A bivariate functional data object. That is, it is assumed that there are two functions for each replication. The coefficient matrix for this object will be three-dimensional, with the final dimension being of length 2. }
  \item{ncan}{Number of pairs of canonical variates to be found.}
  \item{lambda}{Smoothing or regularization parameter. If lambda is a 2-vector then the first component will be applied to the "x" and the second to the "y" functions. }
  \item{Lfd}{The order of derivative to be penalized if it is a scalar, or the linear differential operator whose value is to be penalized if it is a functional data object. }
}
\details{
}
\value{
An object of class cca.fd with these entries is returned. 
"weight functions" A functional data object for the "ncan" pairs of canonical variate weight functions. Each replicate corresponds to a pair of weight functions. 
"correlations" The complete set of canonical correlations. The number is equal to the number of basis functions. 
"variates" An array of the values taken by the canonical variates, that is, the scores on the variates. This is a 3-way array with first dimension corresponding to replicates, second to the different variates (dimension NCAN) and third (dimension 2) to the "x" and "y" scores. 
}
\references{
Ramsay, J. O. and Silverman, B. W. (1997) Functional Data Analysis. New York: Springer. Canonical correlation analysis is described in Chapter 12. 
}
\note{}
\author{}
\seealso{plot.cca.fd, cca.2fun.fd}
\examples{}
\keyword{}

\eof
\name{center.fd}
\alias{center.fd}
\title{Center Functional Data}
\description{
Subtract the pointwise mean from each of the functions in a functional data object; that is, to center them on the mean function. 
}
\usage{
center.fd(fd)
}
\arguments{
  \item{fd}{A functional data object. }
}
\details{
}
\value{
Returns a functional data object with same dimensions as fd that contains the centered versions of the functions in the object fd. 
}
\references{}
\note{}
\author{}
\seealso{
sumFd, meanFd, std.fd 
}
\examples{}
\keyword{}

\eof
\name{create.basis}
\alias{create.basis}
\title{Create a Basis Object }
\description{
Create a basis object, used to define a basis for converting discrete data to a functional data object defined by an expansion in terms of the basis functions that this function defines. This is a general purpose function, and special versions of this function are available for each type of basis that is allowed. Normally one would use one of these instead of this function. 
}
\usage{
create.basis(type, rangeval, nbasis, params=paramvec)
}
\arguments{
  \item{type}{One of the following strings: "bspline", "fourier", "expon", "const", "polyg" and "power".}
  \item{rangeval}{A vector of length 2 containing the initial and final values of the interval over which the functional data object can be evaluated. }
  \item{nbasis}{The number of basis functions. }
  \item{params}{A vector of parameters defining the basis. What these mean varies from basis to basis, and the create functions specific to each basis should be consulted. }
}
\details{
See specific versions of this function. 
}
\value{
A basis object. 
}
\references{}
\note{}
\author{}
\seealso{
create.bspline.basis, create.constant.basis, create.exponential.basis, create.fourier.basis, create.polygonal.basis, create.power.basis. 
}
\examples{}
\keyword{}

\eof
\name{create.bifd}
\alias{create.bifd}
\title{Create a Two-Argument Functional Data Object}
\description{
Create a bifd object containing functional observations defined over two arguments. This function is not normally needed; it is called within other functions to create two-argument functions such as covariance functions and bivariate regression functions. 
}
\usage{
create.bifd(coef, sbasisfd, tbasisfd, bifdnames=list(NULL, repnames, NULL))
}
\arguments{
  \item{coef}{A 2-, 3-, or 4-dimensional array, the first two dimensions corresponding to basis functions, the third to replications, and the fourth, if present, to functions. }
  \item{sbasisfd}{An object of the basis.fd class for the first argument. }
  \item{tbasisfd}{An object of the basis.fd class for the second argument. }
  \item{bifdnames}{A list of length 3, each element being a string vector containing labels for the levels of the corresponding dimension of the discrete data. The first dimension is for argument values, and is given the default name time, the second is for replications, and is given the default name reps, and the third is for functions, and is given the default name values. These default names are assigned in function data2fd, which also assigns default string vectors by using the dimnames attribute of the discrete data array. }
}
\details{
}
\value{
Returns a list with the bifd class attribute containing the coefficient array with the name coefs, a basis.fd object with the name sbasis, and a basis.fd object with the name tbasis. 
}
\references{}
\note{}
\author{}
\seealso{}
\examples{}
\keyword{}

\eof
\name{create.bspline.basis}
\alias{create.bspline.basis}
\title{Create a set of B-spline basis functions for constructing a functional data object. }
\description{
Functional data objects are constructed by specifying a set of basis functions and a set of coefficients defining a linear combination of these basis functions. The B-spline basis is a system that is usually used for non-periodic functions. It has the advantages of very fast computation and great flexibility. On the other hand, if the data are considered to be periodic, then the Fourier basis is usually preferred. 
}
\usage{
create.bspline.basis(rangeval=c(0, 1), nbasis=NULL, norder=4, breaks=NULL)
}
\arguments{
  \item{rangeval}{A vector of length 2 containing the initial and final values of the interval over which the functional data object can be evaluated. Default value c(0,1) }
  \item{nbasis}{An integer variable specifying the number of basis functions. Default value NULL.}
  \item{norder}{An integer specifying the order of b-splines, which is one higher than their degree. The default of 4 gives cubic splines. }
  \item{breaks}{A vector specifying the break points defining the b-spline. Also called knots, these are a strictly increasing sequence of junction points between piecewise polynomial segments. They must satisfy breaks[1] = rangeval[1] and breaks[nbreaks] = rangeval[2], where nbreaks is the length of breaks. There must be at least 3 values in breaks. There is a potential for inconsistency among arguments nbasis, norder, and breaks. It is resolved as follows: If breaks is supplied, nbreaks = length(breaks), and nbasis = nbreaks + norder - 2, no matter what value for nbasis is supplied. If breaks is not supplied, but nbasis is, nbreaks = nbasis - norder + 2, and if this turns out to be less than 3, an error message results. If neither breaks nor nbasis is supplied, nbreaks is set to 21. }
}
\details{
Spline functions are constructed by joining polynomials end-to-end at argument values called break points or knots . First, the interval is subdivided into a set of adjoining intervals separated the knots. Then a polynomial of order m and degree m-1 is defined for each interval. In order to make the resulting piece-wise polynomial smooth, two adjoining polynomials are constrained to have their values and all their derivatives up to order m-2 match at the point where they join. 

Consider as an illustration the very common case where the order is 4 for all polynomials, so that degree of each polynomials is 3. That is, the polynomials are cubic . Then at each break point or knot, the values of adjacent polynomials must match, and so also for their first and second derivatives. Only their third derivatives will differ at the point of junction. 

The number of degrees of freedom of a cubic spline function of this nature is calculated as follows. First, for the first interval, there are four degrees of freedom. Then, for each additional interval, the polynomial over that interval now has only one degree of freedom because of the requirement for matching values and derivatives. This works out to the following equation: The number of degrees of freedom is equal to the number of interior knots (that is, not counting the lower and upper limits) plus the order of the polynomials. 

B-splines are a set of special spline functions that can be used to construct any such piece-wise polynomial by computing the appropriate linear combination. They derive their computational convience from the fact that any B-spline basis function is nonzero over at most m adjacent intervals. The number of basis functions is given by the rule above for the number of degrees of freedom. 

The number of intervals controls the flexibility of the spline; the more knots, the more flexible the resulting spline will be. But the position of the knots also plays a role. Where do we position the knots? There is room for judgment here, but two considerations must be kept in mind: (1) you usually want at least one argument value between two adjacent knots, and (2) there should be more knots where the curve needs to have sharp curvatures such as a sharp peak or valley or an abrupt change of level, but only a few knots are required where the curve is changing very slowly. 

}
\value{
Returns a list with the basis.fd, class attribute with entries as above having names type, rangeval, nbasis, and params, respectively. The type member is bspline. 
}
\references{}
\note{}
\author{}
\seealso{
basis.fd. create.basis, create.fourier.basis 
}
\examples{}
\keyword{}

\eof
\name{create.constant.basis}
\alias{create.constant.basis}
\title{Create a Constant Basis}
\description{
Create a constant basis object, defining a single basis function whose value is everywhere 1.0. 
}
\usage{
create.constant.basis(rangeval=c(0, 1))
}
\arguments{
  \item{rangeval}{A vector of length 2 containing the initial and final values of argument t defining the interval over which the functional data object can be evaluated. However, this is seldom used since the value of the basis function does not depend on the range or any argument values. }
  \item{}{}
  \item{}{}
}
\details{
}
\value{
A basis object of the type "const". 
}
\references{}
\note{}
\author{}
\seealso{}
\examples{}
\keyword{}

\eof
\name{create.exponential.basis}
\alias{create.exponential.basis}
\title{Create an Exponential Basis}
\description{
Create an exponential basis object defining a set of exponential functions with rate constants in argument ratevec. 
}
\usage{
create.exponential.basis(rangeval=c(0, 1), ratevec=1)
}
\arguments{
  \item{rangeval}{A vector of length 2 containing the initial and final values of the interval over which the functional data object can be evaluated. }
  \item{ratevec }{A vector of length nbasis of rate constants defining basis functions of the form exp(rate*x). }
}
\details{
Exponential functions are of the type ebx where b is the rate constant. If b = 0, the constant function is defined. 
}
\value{
A basis object with the type "expon". 
}
\references{}
\note{}
\author{}
\seealso{}
\examples{}
\keyword{}

\eof
\name{create.fd}
\alias{create.fd}
\title{Create a Functional Data Object }
\description{
Create a functional data object containing functional observations. Note that one would normally do this by a call to the data2fd or smooth.basis functions, so that this function usually not needed, except by when writing new functions for functional data objects. 
}
\usage{
create.fd(coef, basisfd, fdnames=defaultnames)
}
\arguments{
  \item{coef}{A 2- or 3-dimensional array, the first dimension corresponding to basis functions, the second to replications, and the third, if present, to functions.}
  \item{basisfd }{An object of the basis.fd class defining the basis to be used. }
  \item{fdnames}{A list of length 3, each element being a string vector containing labels for the levels of the corresponding dimension of the discrete data. The first dimension is for argument values, and is given the default name time, the second is for replications, and is given the default name reps, and the third is for functions, and is given the default name values. These default names are assigned in function data2fd, which also assigns default string vectors by using the dimnames attribute of the discrete data array. }
}
\details{
}
\value{
Returns a list with the fd class attribute containing the coefficient array with the name coefs, the basis.fd object with the name basis, and the dimension names list with the name fdnames. 
}
\references{}
\note{}
\author{}
\seealso{
basisfdobj, fdobj, create.basis.fd, data2fd 
}
\examples{}
\keyword{}

\eof
\name{create.fourier.basis}
\alias{create.fourier.basis}
\title{Create a set of Fourier basis functions for constructing a functional data object. }
\description{
Functional data objects are constructed by specifying a set of basis functions and a set of coefficients defining a linear combination of these basis functions. The Fourier basis is a system that is usually used for periodic functions. It has the advantages of very fast computation and great flexibility. If the data are considered to be nonperiod, the Fourier basis is usually preferred. 
}
\usage{
create.fourier.basis(rangeval=c(0, 1), nbasis=3, period=width)
}
\arguments{
  \item{rangeval}{A vector of length 2 containing the initial and final values of the interval over which the functional data object can be evaluated. Default value c(0,1) }
  \item{nbasis }{An integer variable specifying the number of basis functions. Default value 3. }
  \item{period }{The width of any interval over which the Fourier functions repeat themselves, or are periodic. The default is the width of the interval defined in rangeval. }
}
\details{
The first basis function is the unit function with the value one everywhere. The next two are the sine/cosine pair with period defined in the argument period. The fourth and fifth are the sin/cosine series with period one half of period. And so forth. The number of basis functions is usually odd. 
}
\value{
Returns a list with the basis.fd, class attribute with entries as above having names type, rangeval, nbasis, and params, respectively. The type member is fourier. 
}
\references{}
\note{}
\author{}
\seealso{
basis.fd. create.basis, create.bspline.basis 
}
\examples{}
\keyword{}

\eof
\name{create.polygonal.basis}
\alias{create.polygonal.basis}
\title{Create a Polygonal Basis }
\description{
A basis is set up for constructing polygonal lines, consisting of straight line segments that join together. 
}
\usage{
create.polygonal.basis(argvals=NULL)
}
\arguments{
  \item{argvals }{A strictly increasing vector of argument values at which line segments join to form a polygonal line. }
}
\details{
The actual basis functions consist of triangles, each with its apex over an argument value. Note that in effect the polygonal basis is identical to a B-spline basis of order 2 and a knot or break value at each argument value. The range of the polygonal basis is set to the interval defined by the smallest and largest argument values. 
}
\value{
A basis object with the type "polyg". 
}
\references{}
\note{}
\author{}
\seealso{
basis.fd. create.basis, create.bspline.basis 
}
\examples{}
\keyword{}

\eof
\name{create.power.basis}
\alias{create.power.basis}
\title{Create a Power Basis Object }
\description{
The basis system is a set of powers of argument x. That is, a basis function would be x**exponent, where exponent is the value of one of the exponents. The power basis would normally only be used for positive values of x. 
}
\usage{
create.power.basis(rangeval=c(0, 1), exponent=1)
}
\arguments{
  \item{rangeval }{A vector of length 2 with the first element being the lower limit of the range of argument values, and the second the upper limit. Of course the lower limit must be less than the upper limit. }
  \item{exponent }{A vector of length nbasis containing the powers. }
}
\details{
}
\value{
A basis object used to define power function bases. 
}
\references{}
\note{}
\author{}
\seealso{}
\examples{}
\keyword{}

\eof
\name{data2fd}
\alias{data2fd}
\title{Convert Discrete Data to Functional Data }
\description{
This function converts an array y of function values plus an array argvals of argument values into a functional data object. This a function that tries to do as much for the user as possible. 
}
\usage{
data2fd(y, argvals=seq(0, 1, len = n), basisfd,
        fdnames=defaultnames,
        argnames=c("time", "reps", "values"))
}
\arguments{
  \item{y}{An array containing sampled values of curves. If y is a vector, only one replicate and variable are assumed. If y is a matrix, rows must correspond to argument values and columns to replications or cases, and it will be assumed that there is only one variable per observation. If y is a three-dimensional array, the first dimension (rows) corresponds to argument values, the second (columns) to replications, and the third (layers) to variables within replications. Missing values are permitted, and the number of values may vary from one replication to another. If this is the case, the number of rows must equal the maximum number of argument values, and columns of y having fewer values must be padded out with NA's. }
  \item{argvals }{A set of argument values. If this is a vector, the same set of argument values is used for all columns of y. If argvals is a matrix, the columns correspond to the columns of y, and contain the argument values for that replicate or case. }
  \item{basisfd }{Either: A basisfd object created by function create.basis.fd(), or the value NULL, in which case a basisfd object is set up by the function, using the values of the next three arguments. }
  \item{fdnames }{A list of length 3, each member being a string vector containing labels for the levels of the corresponding dimension of the discrete data. The first dimension is for argument values, and is given the default name "time", the second is for replications, and is given the default name "reps", and the third is for functions, and is given the default name "values". These default names are assigned in function {tt data2fd}, which also assigns default string vectors by using the dimnames attribute of the discrete data array. }
  \item{argnames }{A character vector of length 3 containing: (1) the name of the argument, e.g. "time" or "age" (2) a description of the cases, e.g. "weather stations" (3) the name of the observed function value, e.g. "temperature" These strings are used as names for the members of list fdnames. }
}
\details{
}
\value{
An objecgt of the fd class containing the coefficient array with the name coefs, a basis.fd object with the name basis, and a list with the name fdnames. 
}
\references{
Ramsay, J. O. and Silverman, B. W. 1997. Functional data analysis. Springer-Verlag, New York. 310 pp. 
}
\note{}
\author{}
\seealso{
project.basis, smooth.basis, create.fd 
}
\examples{}
\keyword{}

\eof
\name{densityfd}
\alias{densityfd}
\title{Compute a Probability Density Function }
\description{
Like the regular S-PLUS function density, this function computes a probability density function for a sample of values of a random variable. However, in this case the density function is defined by a functional data object Wfdobj along with a normalizing constant C. The density function p(x) has the form 
p(x) = C exp[W(x)] where function W(x) is defined by the functional data object Wfdobj. 
}
\usage{
densityfd(x, Wfdobj, Lfdobj=3, lambda=0, conv=0.0001, iterlim=20,
          active=2:nbasis, dbglev=1)
}
\arguments{
  \item{x}{A vector of variable values for which the density is required. }
  \item{Wfdobj }{A functional data object defining a single univariate function. }
  \item{Lfdobj }{Either a nonnegative integer or a linear differential operator object. If present, the derivative or the value of applying the operator is evaluated rather than the functions themselves. }
  \item{lambda }{A nonnegative value controlling the amount of roughness in the data. }
  \item{conv }{A criterion for convergence of the iterations. }
  \item{iterlim }{A limit on the number of iterations. }
  \item{active }{A logical vector of length equal to the number of coefficients defining Wfdobj. If an entry is T, the corresponding coefficient is estimated, and if F, it is held at the value defining the argument Wfdobj. Normally the first coefficient is set to 0 and not estimated, since it is assumed that W(0) = 0. }
  \item{dbglev}{Either 0, 1, or 2. This controls the amount information printed out on each iteration, with 0 implying no output, 1 intermediate output level, and 2 full output. }
}
\details{
The goal of the function is provide a smooth density function estimate that approaches some target density by an amount that is controlled by the linear differential operator Lfdobj and the penalty parameter. For example, if the second derivative of W(t) is penalized heavily, this will force the function to approach a straight line, which in turn will force the density function itself to be nearly normal or Gaussian. Similarly, to each textbook density function there corresponds a W(t), and to each of these in turn their corresponds a linear differential operator that will, when apply to W(t), produce zero as a result. 

To plot the density function or to evaluate it, evaluate Wfdobj, exponentiate the resulting vector, and then divide by the normalizing constant C. 
}
\value{
A list containing: 
Wfdobj 
A functional data object defining function W(x) that that optimizes the fit to the data of the monotone function that it defines. 
C 
The normalizing constant. 
Flist 
A list containing results for the final converged solution: 
f 
The optimal function value being minimized. 
grad 
The gradient vector at the optimal solution. 
norm 
The norm of the gradient vector at the optimal solution. 
iternum 
The number of iterations. 
iterhist 
A iternum+1 by 5 matrix containing the iteration history. 
}
\references{
See Chapter 5 in J. O. Ramsay and B. W. Silverman (2002) Applied Functional Data Analysis for an example of density estimation and further references. 
}
\note{}
\author{}
\seealso{
posfd, smooth.monotone, eval.monfd 
}
\examples{}
\keyword{}

\eof
\name{derivFd}
\alias{derivFd}
\title{Compute a Derivative Functional Data Object }
\description{
A derivative of a functional data object, or the result of applying a linear differential operator to a functional data object, is then converted to a functional data object. This is intended for situations where a derivative is to be manipulated as a functional data object rather than simply evaluated. 
}
\usage{
derivFd(fd, Lfd=1)
}
\arguments{
  \item{fd }{A functional data object. }
  \item{Lfd }{Either a nonnegative integer or a linear differential operator object. If present, the derivative or the value of applying the operator is evaluated rather than the functions themselves. }
}
\details{
The derivative of fd is first evaluated using function eval.fd, and then these values are converted to a functional data object using the data2fd function and the basis used to represent the original function. This assumes that the derivative does not vary any more complexly than the original function, which sometimes is doubtful. If the derivative is expected to be highly variable, it might be better to do this manually using a richer basis for the derivative rather than this function. 
}
\value{
A functional data object that represents the derivative of the argument fd. 
}
\references{}
\note{}
\author{}
\seealso{
eval.fd 
}
\examples{}
\keyword{}

\eof
\name{df2lambda}
\alias{df2lambda}
\title{Convert Degrees of Freedom to Smoothing Parameter }
\description{
The degree of roughness of an estimated function is controlled by a smoothing parameter lambda that directly multiplies the penalty. However, it can be difficult to interpret or choose this value, and it is often easier to determine the roughness by choosing a value that is equivalent of the degrees of freedom used by the smoothing procedure. This function converts a degrees of freedom value into a multipler lambda. 
}
\usage{
df2lambda(argvals, basisobj, wtvec=rep(1, n), Lfd=0, df=nbasis)
}
\arguments{
  \item{argvals }{Argument values associated with the values to be smoothed. }
  \item{basisobj}{A basis object.}
  \item{wtvec}{A vector of weights for the data to be smoothed. }
  \item{Lfd}{Either a nonnegative integer or a linear differential operator object. }
  \item{df}{The degrees of freedom to be converted. }
}
\details{
The conversion requires a one-dimensional optimization and may be therefore computationally intensive. 
}
\value{
The equivalent smoothing parameter value. 
}
\references{}
\note{}
\author{}
\seealso{}
\examples{}
\keyword{}

\eof
\name{eval.bifd}
\alias{eval.bifd}
\title{Evaluate a Two-argument Functional Data Object }
\description{
Evaluate a two-argument functional data object at specified argument values s and t. 
}
\usage{
eval.bifd(sevalarg, tevalarg, bifd, sLfd=0, tLfd=0)
}
\arguments{
  \item{sevalarg }{A vector of argument values for the first argument s of the functional data object to be evaluated. }
  \item{tevalarg }{A vector of argument values for the second argument t of the functional data object to be evaluated. }
  \item{bifd }{A two-argument functional data object. }
  \item{sLfd}{Either a nonnegative integer or a linear differential operator object. If present, the derivative or the value of applying the operator to the object as a function of the first argument s is evaluated rather than the functions themselves.}
  \item{tLfd }{Either a nonnegative integer or a linear differential operator object. If present, the derivative or the value of applying the operator to the object as a function of the second argument t is evaluated rather than the functions themselves. }
}
\details{
}
\value{
An array of 2, 3, or 4 dimensions containing the function values. The first dimension corresponds to the argument values in sevalarg, the second to argument values in tevalarg, the third if present to replications, and the fourth if present to functions. 
}
\references{}
\note{}
\author{}
\seealso{
eval.fd 
}
\examples{}
\keyword{}

\eof
\name{eval.fd}
\alias{eval.fd}
\title{Evaluate a Functional Data Object}
\description{
Evaluate a functional data object at specified argument values, or evaluate a derivative or the result of applying a linear differential operator to the functional object. 
}
\usage{
eval.fd(evalarg, fd, Lfd=0)
}
\arguments{
  \item{evalarg }{A vector of argument values at which the functional data object is to be evaluated. }
  \item{fd}{A functional data object to be evaluated. }
  \item{Lfd }{Either a nonnegative integer or a linear differential operator object. If present, the derivative or the value of applying the operator is evaluated rather than the functions themselves. }
}
\details{
}
\value{
Returns an array of 2 or 3 dimensions containing the function values. The first dimension corresponds to the argument values in evalarg, the second to replications, and the third if present to functions. 
}
\references{}
\note{}
\author{}
\seealso{
plotFd, plotfit.fd, fd2data, eval.bifd 
}
\examples{}
\keyword{}

\eof
\name{eval.monfd}
\alias{eval.monfd}
\title{Evaluate a Monotone Functional Data Object }
\description{
Evaluate a monotone functional data object at specified argument values, or evaluate a derivative of the functional object. 
}
\usage{
eval.monfd(evalarg, Wfd, Lfd=0)
}
\arguments{
  \item{evalarg }{A vector of argument values at which the functional data object is to be evaluated. }
  \item{Wfd}{A functional data object that defines the monotone function to be evaluated. Only univariate functions are permitted. }
  \item{Lfd }{A nonnegative integer specifying a derivative to be evaluated. AT this time of writing, permissible derivative values are 0, 1, 2, or 3. A linear differential operator is not allowed. }
}
\details{
A monotone function data object h(t) is defined by h(t) = [D**{-1} exp Wfd](t). In this equation, the operator D**{-1} means taking the indefinite integral of the function to which it applies. Note that this equation implies that the monotone function has a value of zero at the lower limit of the arguments. To actually fit monotone data, it will usually be necessary to estimate an intercept and a regression coefficient to be applied to h(t), usually with the least squares regression function lsfit. 

The function Wfd that defines the monotone function is usually estimated by monotone smoothing function smooth.monotone. 
}
\value{
Returns an matrix containing the monotone function values. The first dimension corresponds to the argument values in evalarg and the second to replications. 
}
\references{}
\note{}
\author{}
\seealso{}
\examples{}
\keyword{}

\eof
\name{expon}
\alias{expon}
\title{Exponential Basis Function Values }
\description{
Evaluates a set of exponential basis functions, or a derivative of these functions, at a set of arguments. 
}
\usage{
expon(x, ratevec=1, nderiv=0)
}
\arguments{
  \item{x }{A vector of argument values at which the exponential basis functions are to evaluated. }
  \item{ratevec }{A vector of rate values defining the exponential basis functions. If b is such a rate value, the corresponding basis function is ebx. The number of basis functions is equal to the number of rate constants. The default is the single constant one. }
  \item{nderiv }{The derivative to be evaluated. The derivative must not exceed the order. The default derivative is 0, meaning that the basis functions themselves are evaluated. }
}
\details{
}
\value{
A matrix of function values. The number of rows equals the number of arguments, and the number of columns equals the number of basis 
}
\references{}
\note{}
\author{}
\seealso{}
\examples{}
\keyword{}

\eof
\name{exponpen}
\alias{exponpen}
\title{Exponential Penalty Matrix }
\description{
Computes the matrix defining the roughness penalty for functions expressed in terms of a exponential basis. 
}
\usage{
exponpen(basisfd, Lfd=2)
}
\arguments{
  \item{basisfd}{An exponential basis object. }
  \item{Lfd}{Either a nonnegative integer or a linear differential operator object. }
}
\details{
A roughness penalty for a function x(t) is defined by integrating the square of either the derivative of x(t) or, more generally, the result of applying a linear differential operator L to it. The most common roughness penalty is the integral of the square of the second derivative D2x(t), and this is the default. To apply this roughness penalty, the matrix of inner products produced by this function is necessary. 
}
\value{
A symmetric matrix of order equal to the number of basis functions defined by the exponential basis object. Each element is the inner product of two exponential basis functions after applying the derivative or linear differential operator defined by Lfdobj. 
}
\references{}
\note{}
\author{}
\seealso{}
\examples{}
\keyword{}

\eof
\name{fda.internal}
\alias{c.fd}
\alias{create.basis.fd}
\alias{create.default.basis} 
\alias{create.polynomial.basis}   
\alias{cycleplot.fd}  
\alias{derivchk}                  
\alias{derivs} 
\alias{expect.phi}                
\alias{expect.phiphit}  
\alias{^.fd}    
\alias{-.fd}     
\alias{/.fd}  
\alias{[.fd}
\alias{*.fd} 
\alias{+.fd}
\alias{fd2data}                   
\alias{fngrad.smooth.monotone}     
\alias{geigen}                    
\alias{getnames} 
\alias{hesscal.smooth.monotone}   
\alias{inprod.n}   
\alias{interpreg}                 
\alias{is.diag}     
\alias{is.fd}                     
\alias{is.Lfd} 
\alias{isotone}                   
\alias{linesearch}                 
\alias{linesearch.smooth.monotone}
\alias{linesSmoothPspline}       
\alias{loglfnden}                 
\alias{loglfnpos}                  
\alias{m2ij}                      
\alias{make.basis}                 
\alias{monfn}                     
\alias{monfneval}            
\alias{mongrad}                   
\alias{mongrad1}      
\alias{monhess}                   
\alias{normalize.phi}          
\alias{odesolv}                   
\alias{pda.fd}    
\alias{pdalist}                   
\alias{pendiagfn}    
\alias{plotscores}                
\alias{plotSmoothPspline}   
\alias{polintarray}               
\alias{polintmat}    
\alias{polynom}  
\alias{polynompen}             
\alias{predictSmoothPspline}    
\alias{print.smooth.Pspline}    
\alias{ptwiseLM}                  
\alias{putcoef}    
\alias{rangechk}    
\alias{regfngrad}                  
\alias{reghess}                   
\alias{register}                   
\alias{regyfn}                    
\alias{rkck}                       
\alias{rkqs}                      
\alias{shifty}                     
\alias{smooth.basis.n}            
\alias{smooth.pos}                
\alias{sqrt.fd}                   
\alias{SRsetup}                    
\alias{SRsetup1}                  
\alias{stepchk}                    
\alias{stepit}                    
\alias{symsolve}                   
\alias{trapzmat}                  
\alias{trapz.n}                    
\alias{use.proper.basis}          
\alias{Varfnden}                
\alias{Varfnpos}                  
\alias{varmx}                      
\alias{warpfngrad}                
\alias{warphesscal}               
\alias{zerofind}                  
\title{Internal Functions and Objects}
\description{
These are internal functions and objects of the FDA package and should never be used by users in any circumstance. 
}
\usage{
fda.internal
}
\arguments{}
\details{}
\value{}
\references{}
\note{}
\author{}
\seealso{}
\examples{}
\keyword{internal}

\eof
\name{fourier}
\alias{fourier}
\title{Fourier Basis Function Values }
\description{
Evaluates a set of Fourier basis functions, or a derivative of these functions, at a set of arguments. 
}
\usage{
fourier(x, nbasis=n, period=span, nderiv=0)
}
\arguments{
  \item{x }{A vector of argument values at which the Fourier basis functions are to evaluated. }
  \item{nbasis }{The number of basis functions in the Fourier basis. The first basis function is the constant function, followed by sets of sine/cosine pairs. Normally the number of basis functions will be an odd. The default number is the number of argument values. }
  \item{period }{The width of an interval over which all sine/cosine basis functions repeat themselves. The default is the difference between the largest and smallest argument values. }
  \item{nderiv }{The derivative to be evaluated. The derivative must not exceed the order. The default derivative is 0, meaning that the basis functions themselves are evaluated. }
}
\details{
}
\value{
A matrix of function values. The number of rows equals the number of arguments, and the number of columns equals the number of basis 
}
\references{}
\note{}
\author{}
\seealso{}
\examples{
}
\keyword{}

\eof
\name{fourierpen}
\alias{fourierpen}
\title{Fourier Penalty Matrix }
\description{
Computes the matrix defining the roughness penalty for functions expressed in terms of a Fourier basis. 
}
\usage{
fourierpen(basisobj, Lfdobj=2)
}
\arguments{
  \item{basisobj }{A Fourier basis object. }
  \item{Lfdobj }{Either a nonnegative integer or a linear differential operator object. }
}
\details{
A roughness penalty for a function x(t) is defined by integrating the square of either the derivative of x(t) or, more generally, the result of applying a linear differential operator L to it. The most common roughness penalty is the integral of the square of the second derivative D2x(t), and this is the default. To apply this roughness penalty, the matrix of inner products of the basis functions (possibly after applying the linear differential operator to them) defining this function is necessary. This function just calls the roughness penalty evaluation function specific to the basis involved. 
}
\value{
A symmetric matrix of order equal to the number of basis functions defined by the Fourier basis object. Each element is the inner product of two Fourier basis functions after applying the derivative or linear differential operator defined by Lfdobj. 
}
\references{}
\note{}
\author{}
\seealso{}
\examples{}
\keyword{}

\eof
\name{getbasis}
\alias{getbasis}
\title{Get the Basis Object from a Functional Data Object }
\description{
Retrieves the basis defining a functional data object. 
}
\usage{
getbasis(fd)
}
\arguments{
  \item{fd }{A functional data object. }
}
\details{
}
\value{
The basis object defining fd. 
}
\references{}
\note{}
\author{}
\seealso{}
\examples{
}
\keyword{}

\eof
\name{getbasismatrix}
\alias{getbasismatrix}
\title{Get Values of Basis Functions }
\description{
Evaluates a set of basis functions for a vector of argument values. 
}
\usage{
getbasismatrix(evalarg, basisfd, Lfd=0)
}
\arguments{
  \item{evalarg }{A vector of argument values at which the basis object is to be evaluated. }
  \item{basisfd }{A basis object. }
  \item{Lfd }{Either a nonnegative integer or a linear differential operator object. If present, the derivative or the value of applying the operator is evaluated rather than the basis functions themselves. }
}
\details{
}
\value{
A matrix with number of rows equal to the length of evalarg and number of columns equal to the number of basis functions. The matrix contains values of each basis function at each argument value. 
}
\references{}
\note{}
\author{}
\seealso{}
\examples{
}
\keyword{}

\eof
\name{getbasispenalty}
\alias{getbasispenalty}
\title{Evaluate a Roughness Penalty Matrix }
\description{
Computes the matrix defining the roughness penalty for functions expressed in terms of a basis. 
}
\usage{
getbasispenalty(basisfd, Lfd=NULL)
}
\arguments{
  \item{basisfd }{A basis object. }
  \item{Lfd }{Either a nonnegative integer or a linear differential operator object. }
}
\details{
A roughness penalty for a function x(t) is defined by integrating the square of either the derivative of x(t) or, more generally, the result of applying a linear differential operator L to it. The most common roughness penalty is the integral of the square of the second derivative D2x(t), and this is the default. To apply this roughness penalty, the matrix of inner products of the basis functions defining this function is necessary. This function just calls the roughness penalty evaluation function specific to the basis involved. 
}
\value{
A symmetric matrix of order equal to the number of basis functions defined by the B-spline basis object. Each element is the inner product of two B-spline basis functions after applying the derivative or linear differential operator defined by Lfd. 
}
\references{}
\note{}
\author{}
\seealso{
bsplinepen, exponpen, fourierpen, polygpen, powerpen 
}
\examples{}
\keyword{}

\eof
\name{getbasistype}
\alias{getbasistype}
\title{Get the Basis Type from a Basis Object }
\description{
Retrieves the basis type from a basis object. 
}
\usage{
getbasistype(basisfd)
}
\arguments{
  \item{basisfd}{A basis object.}
}
\details{
}
\value{
A string such as "bspline" or "fourier" specifying the basis type. 
}
\references{}
\note{}
\author{}
\seealso{}
\examples{
}
\keyword{}

\eof
\name{getcoef}
\alias{getcoef}
\title{Get the Coefficient Array from a Functional Data Object }
\description{
Retrieves the coefficient array defining a functional data object. 
}
\usage{
getcoef(fd)
}
\arguments{
  \item{fd }{A functional data object. }
}
\details{
}
\value{
A 1-, 2-, or 3-dimensional array of coefficients defining a functional data object. 
}
\references{}
\note{}
\author{}
\seealso{}
\examples{
}
\keyword{}

\eof
\name{inprod}
\alias{inprod}
\title{Inner product of two functional data objects or two basis objects}
\description{
This is perhaps the most important function in the functional data library. Hardly any analysis fails to use inner products in some way, and many employ multiple inner products. While in certain cases these may be computed exactly, this is a more general function that approximates the inner product. The inner product is defined by two derivatives or linear differential operators that are applied to the first two arguments. 
}
\usage{
inprod(fd1, fd2, Lfd1=0, Lfd2=0, JMAX=15, EPS=0.0001)
}
\arguments{
  \item{fd1 }{Either a univariate functional data object or a basis object. }
  \item{fd2}{Either a univariate functional data object or a basis object. }
  \item{Lfd1}{Either a nonnegative integer or a linear differential operator object. If present, the derivative or the value of applying the operator is used rather than the functions themselves. This operator is applied to the first argument fd1. }
  \item{Lfd2}{Either a nonnegative integer or a linear differential operator object. If present, the derivative or the value of applying the operator is used rather than the functions themselves. This operator is applied to the second argument fd2. }
  \item{JMAX}{This controls the maximum number of function evaluations that will be used in the numerical approximation method (see below for details). The maximum number is 2**(JMAX-1)+1. The default of 15 seems more than adequate for most purposes. }
  \item{EPS}{This controls when convergence is declared for the approximation method. }
}
\details{
The approximation method is Romberg extrapolation using numerical integration by the trapezoidal rule. At each iteration, the number of values at which the functions are evaluated is doubled, and a polynomial extrapolation method is used to estimate the converged integral values as well as an error tolerance. Convergence is declared when the relative error falls below EPS for all products. The Romberg extrapolation method generally saves at least one and often two iterations relative to un-extrapolated trapezoidal integration. 

Functional data analyses will seldom need to use inprod directly, but code developers should be aware of its pivotal role. Future work may require more sophisticated and specialized numerical integration methods. 

inprod computes the definite integral, but some functions such as smooth.monotone and register.fd also need to compute indefinite integrals. These use the same approximation scheme, but usually require more accuracy, and hence more iterations. 

When one or both arguments are basis objects, they are converted to functional data objects using identity matrices as the coefficient matrices. 

inprod is only called when there is no faster or exact method available. In cases where there is, it has been found that the approximation is good to about four to five significant digits, which is sufficient for most applications. Perhaps surprisingly, in the case of B-splines, the exact method is not appreciably faster, but of course is more accurate. 

inprod calls function eval.fd perhaps thousands of times, so high efficiency for this function and the functions that it calls is important. 

}
\value{
A matrix of inner products. The number of rows is the number of functions or basis functions in argument fd1, and the number of columns is the same thing for argument fd2. 
}
\references{
Press, et, al, Numerical Recipes. 
}
\note{}
\author{}
\seealso{
monfn, mongrad, bsplinepen, fourierpen 
}
\examples{
}
\keyword{}

\eof
\name{lambda2df}
\alias{lambda2df}
\title{Convert Smoothing Parameter to Degrees of Freedom }
\description{
The degree of roughness of an estimated function is controlled by a smoothing parameter lambda that directly multiplies the penalty. However, it can be difficult to interpret or choose this value, and it is often easier to determine the roughness by choosing a value that is equivalent of the degrees of freedom used by the smoothing procedure. This function converts a multipler lambda into a degrees of freedom value. 
}
\usage{
lambda2df(argvals, basisfd, wtvec=rep(1, n), Lfd=NULL, lambda=0)
}
\arguments{
  \item{argvals }{Argument values associated with the values to be smoothed. }
  \item{basisfd }{A basis object. }
  \item{wtvec }{A vector of weights for the data to be smoothed. }
  \item{Lfd }{Either a nonnegative integer or a linear differential operator object. }
  \item{lambda }{The smoothing parameter to be converted. }
}
\details{
The conversion requires a one-dimensional optimization and may be therefore computationally intensive. 
}
\value{
The equivalent degrees of freedom value. 
}
\references{}
\note{}
\author{}
\seealso{}
\examples{
}
\keyword{}

\eof
\name{landmarkreg}
\alias{landmarkreg}
\title{Registration of Functional Observations Using Landmarks }
\description{
It is common to see that among a set of functions certain prominent features such peaks and valleys, called landmarks, do not occur at the same times, or other argument values. This is called phase variation, and it can be essential to align these features before proceeding with further functional data analyses. This function uses the timings of these features to align or register the curves. The registration involves estimating a nonlinear transformation of the argument continuum for each functional observation. This transformation is called a warping function. It must be strictly increasing and smooth. 
}
\usage{
landmarkreg(fd, fd0, ximarks, x0marks=xmeanmarks, wbasis=basis, Lfd=0, sparval=1e-010, monwrd=FALSE)
}
\arguments{
  \item{fd }{A functional data object containing the curves to be registered. }
  \item{fd0 }{A functional data object with a single observation defining a template or gold standard function to which the other functions are registered. }
  \item{ximarks }{A matrix containing the timings or argument values associated with the landmarks for the observations in fd to be registered. The number of rows equals the number of observations, and the number of columns equals the number of landmarks. }
  \item{x0marks }{A vector containing the timings or argument values associated with the landmarks for the template or gold standard function in fd0. }
  \item{wbasis }{A basis object used to define the warping functions. }
  \item{Lfd }{Either a nonnegative integer of a linear differential operator to be applied to the functions before registering them. }
  \item{sparval }{A smoothing parameter controlling the smoothness of the estimated warping functions. }
  \item{monwrd }{If TRUE, the warping function is estimated using a monotone smoothing methhod; otherwise, a regular smoothing method is used, which is not guaranteed to give strictly monotonic warping functions. }
}
\details{
It is essential that the location of every landmark be clearly defined in each of the curves as well as the template function. If this is not the case, consider using the continuous registration function register.fd. 

Although requiring that a monotone smoother be used to estimate the warping functions is safer, it adds considerably to the computatation time since monotone smoothing is itself an iterative process. It is usually better to try an initial registration with this feature to see if there are any failures of monotonicity. Moreover, monotonicity failures can usually be cured by increasing the smoothing parameter sparval. 

Not much curvature is usually required in the warping functions, so a rather low power basis, usually B-splines, is suitable for argument wbasis. 

A registration with a few prominent landmarks is often a good preliminary to using the more sophisticated but more lengthy process in register.fd. 

}
\value{
A list with these entries is returned. 
"fdreg" a functional data object for the registered curves 
"warpfd" A functional data object for the warping functions 
}
\references{
Ramsay, J. O. and Silverman, B. W. (1997) Functional Data Analysis. New York: Springer. Registration is described in Chapter 5. 
}
\note{}
\author{}
\seealso{
register.fd 
}
\examples{
}
\keyword{}

\eof
\name{linesFd}
\alias{linesFd}
\title{Add Lines from Functional Data to a Plot }
\description{
Lines defined by functional observations are added to an existing plot. 
}
\usage{
linesFd(fd, Lfd=0, ...)
}
\arguments{
  \item{fd }{A univariate functional data object. }
  \item{Lfd }{Either a nonnegative integer or a linear differential operator object. If present, the derivative or the value of applying the operator is evaluated rather than the functions themselves. }
  \item{... }{Additional arguments such as axis titles and so forth that can be used in all plotting programs. }
}
\details{
}
\value{
Lines added to an existing plot. 
}
\references{}
\note{}
\author{}
\seealso{
plotFd, plotfit.fd 
}
\examples{
}
\keyword{}

\eof
\name{linmod.fd}
\alias{linmod.fd}
\title{Fit One of Three Types of Functional Linear Model. }
\description{
The linear model function described below fits the three types of linear models described in Chapters 9, 10, and 11. At this point the function can only handle a single functional independent variable. The regularization features described in Chapters 10 and 11 are incorporated. 
To fit a linear model. Three cases are considered: 

functional dependent variable and multivariate independent variable, and the functional dependent variable can be multivariate or vector-valued. 
multivariate dependent variable and functional independent variable, 
functional dependent variable and a single functional independent variable. 
}
\usage{
linmod.fd(xfd, yfd, wtvec=rep(1, nrep), xLfd=2, yLfd=2, xlambda=0, ylambda=0, zmatrnk=p)
}
\arguments{
  \item{xfd }{If the independent variable is multivariate, a design matrix. If the independent variable is functional, a fd object. }
  \item{yfd }{If the dependent variable is multivariate, a design matrix. If the dependent variable is functional, a fd object. }
  \item{wtvec }{A vector of weights for the replications. By default these are 1's. }
  \item{xLfd }{For the independent variable, the order derivative to be penalized if an integer, or a linear differential operator if a functional data object. }
  \item{yLfd }{For the dependent variable, the order derivative to be penalized if an integer, or a linear differential operator if a functional data object. }
  \item{xlambda }{A smoothing parameter for the independent variable. This is zero by default. }
  \item{ylambda }{A smoothing parameter for the dependent variable. This is zero by default. }
  \item{zmatrnk }{The actual rank of independent variable matrix for the function DV/multivariate IV case. This is permitted to be less than the number of columns of this matrix. }
}
\details{
}
\value{
Returns a list with the following entries: 
"alpha" The intercept, either a scalar or a functional data object as the model requires. If the dependent variable is multivariate, there is one for each column of the matrix input as argument yfd. Otherwise this is a single constant. 
"regfd" A functional data object for the regression function. The structure of this object depends on the three cases: 
functional DV/multivariate IV: a univariate functional data object with a replication corresponding to each column dimension in the matrix input for argument xfd, and a function (3rd dimension in the coefficient matrix) for each function in the DV, 
multivariate DV/functional IV: a univariate functional data object having a replication correponding to each column of the matrix input as argument yfd. 
functional DV/functional IV: a bivariate functional object of the bifd class. 
"hatfd" A functional data object for the approximation to the dependent variable defined by the linear model, if the dependent variable is functional. Otherwise the matrix of approximate values. 
}
\references{}
\note{}
\author{}
\seealso{}
\examples{}
\keyword{}

\eof
\name{meanFd}
\alias{meanFd}
\title{Mean of Functional Data }
\description{
Evaluate the mean of a set of functions in a functional data object. 
}
\usage{
meanFd(fd)
}
\arguments{
  \item{fd }{A functional data object. }
}
\details{
}
\value{
Returns a functional data object with a single replication that contains the mean of the functions in the object fd. 
}
\references{}
\note{}
\author{}
\seealso{
std.fd, sumFd, center.fd }
\examples{}
\keyword{}

\eof
\name{pca.fd}
\alias{pca.fd}
\title{Functional Principal Components Analysis }
\description{
Functional Principal components analysis aims to display types of variation across a sample of functions. Principal components analysis is an exploratory data analysis that tends to be an early part of many projects. These modes of variation are called principal components or harmonics. This function computes these harmonics, the eigenvalues that indicate how important each mode of variation, and harmonic scores for individual functions. If the functions are multivariate, these harmonics are combined into a composite function that summarizes joint variation among the several functions that make up a multivariate functional observation. 
}
\usage{
pca.fd(fd, nharm=2, lambda=0, Lfd=2, centerfns=TRUE)
}
\arguments{
  \item{fd }{A functional data object defining a sample of curves. }
  \item{nharm }{The number of principal components or harmonics that are to be estimated for these functional data. }
  \item{lambda }{A smoothing parameter used to control the smoothness of the estimated harmonics. }
  \item{Lfd }{A linear differential operator object that defines the nature of the smoothness that is required of the harmonics. }
  \item{centerfns }{A logical variable which, if true, causes the mean function to be subtracted from each function prior to computing harmonics. That is, if true, the modes of variation are about the mean. If false, the modes of variation are about zero. }
}
\details{
}
\value{
Returns a list with the following entries: 
"harmonics" A functional data object containing the nharm harmonic, principal component, or eigenfunctions. If there is more than one variable in the fd argument, there is a harmonic corresponding to each function, and in this case the coefficient matrix has three dimensions. 
"values" The complete set of eigenvalues. The number of these is normally equal to the minimum of (1) number of basis functions defining the functional observations, or (2) the sample size. 
"scores" The principal component scores for each replication and harmonic. 
"varprop" The proportion of variance accounted for by each harmonic. 
"meanfd" meanfd The mean functional data object. 
}
\references{
Ramsay, J. O. and Silverman, B. W. (1997) Functional Data Analysis. New York: Springer. Compution of the principal component functions, eigenvalues, and principal component scores described in Chapter 6, and also incorporates the regularization concept described in Chapter 7. In Chapter 8 contains extensions to permit the analysis of joint variation in multivariate and functional data. 
}
\note{}
\author{}
\seealso{
plotPcaFd, cca.fd 
}
\examples{}
\keyword{}

\eof
\name{plotCcaFd}
\alias{plotCcaFd}
\title{Plot Output from Canonical Correlation Function CCA.FD }
\description{
Function cca.fd produces an object of class ccafd. This function plots the information in this object. 
}
\usage{
plotCcaFd(ccafd, overplt=FALSE, jcan=0, flip=FALSE, ...)
}
\arguments{
  \item{ccafd }{An object of class cca.fd that is produced by function cca.fd. }
  \item{overplt }{A logical variable. If overplt is TRUE, then each pair of weight functions is plotted in a single plot. The line types and colours of the "x" and "y" curves respectively are specified as in function plotFd. }
  \item{jcan }{If jcan=0, then all the pairs of variates are plotted. Otherwise only the variates in vector jcan are plotted (eg if jcan=1, only the leading variate is plotted, if jcan=c(1,3) only the first and third.) }
  \item{flip }{A logical vector of length ncan. If flip[j] is TRUE then the jth pair of weight functions are multiplied by -1. If flip is a scalar it is replicated to the necessary length. }
  \item{... }{Additional arguments that can be used in all plotting programs. }
}
\details{
}
\value{
}
\references{}
\note{}
\author{}
\seealso{}
\examples{
}
\keyword{}

\eof
\name{plotFd}
\alias{plotFd}
\title{Plot a Functional Data Object }
\description{
Functional data observations, or a derivative of them, are plotted. These may be either plotted simultaneously, as matplot does for multivariate data, or one by one with a mouse click to move from one plot to another. The function also accepts the other plot specification arguments that the regular plot does. 
}
\usage{
plotFd(fd, Lfd=0, matplt=TRUE, href=TRUE, nx=101, xlab=xlabel, ylab=ylabel, xlim=rangex, ylim=rangey, ...)
}
\arguments{
  \item{fd}{A functional data object. }
  \item{Lfd }{Either a nonnegative integer or a linear differential operator object. If present, the derivative or the value of applying the operator is plotted rather than the functions themselves. }
  \item{matplt }{A logical variable. If TRUE, the observations are all plotted simultaneously. If not, they are plotted one by one, with a mouse click to move to the next plot. }
  \item{href }{A logical variable. If TRUE, a horizontal dotted line is plotted at zero. }
  \item{nx }{The number of points to use to define the plot. The default is usually enough, but for a highly variable function more may be required. }
  \item{xlab }{A label for the abscissa. }
  \item{ylab }{A label for the ordinate. }
  \item{xlim }{Axis limits for the abscissa. }
  \item{ylim }{Axis limits for the ordinate. }
  \item{... }{Additional arguments that can be used in all plotting programs. }
}
\details{
}
\value{
A plot of the functional data. Note that for multivariate data, a suitable array must first be defined using the par function. 
}
\references{}
\note{}
\author{}
\seealso{
linesFd, plotfit.fd 
}
\examples{}
\keyword{}

\eof
\name{plotPcaFd}
\alias{plotPcaFd}
\title{Plot Output from Principal Components Analysis Function PCA.FD }
\description{
Function pca.fd produces an object of class pcafd. This function plots the information in this object. 
}
\usage{
plotPcaFd(pcafd, nx=128, pointplot=TRUE, harm=0, expand=0, cycle=FALSE, ...)
}
\arguments{
  \item{pcafd }{An object of class pcafd. }
  \item{nx }{The number of argument values used to plot the harmonics. }
  \item{pointplot }{A logical variable. If pointplot is TRUE, then the harmonics are plotted as + and -, otherwise lines are used. }
  \item{harm }{The number of harmonics to plot }
  \item{expand }{If expand = 0 then the effect of adding +/- 2 standard deviations of each principal component are given. Otherwise the factor expand is used. }
  \item{cycle }{A logical variable. If cycle is TRUE and there are two variables, then a cycle plot will be drawn. If the number of variables is anything else, cycle will be ignored. }
  \item{... }{Additional arguments that can be used in all plotting programs. }
}
\details{
}
\value{
A plot of the results of a principal components analysis. 
}
\references{}
\note{}
\author{}
\seealso{
pca.fd 
}
\examples{
}
\keyword{}

\eof
\name{plotfit.fd}
\alias{plotfit.fd}
\title{Plot a Functional Data Object Along with Data }
\description{
Functional observations are plotted one by one along with the data used to estimate them. 
}
\usage{
plotfit.fd(y, argvals, fd, rng=rangeval, index=1:nrep,
           nfine=101, residual=FALSE, sortwrd=FALSE)
}
\arguments{
  \item{y }{The discrete observations used to estimate the functional data object. }
  \item{argvals }{The argument values corresponding to y. }
  \item{fd }{The functional data object to be plotted. }
  \item{rng}{A vector of two strictly increasing values specifying a range over which the plots are to be shown. This range must be contained within the range used to define the functional data object. }
  \item{index }{A set of indices of functions if only a subset of the observations are to be plotted. }
  \item{nfine }{The number of argument values used to define the plot of the functional data object. }
  \item{residual }{A logical variable. If TRUE, the residuals are plotted rather than the data and functional data object. }
  \item{sortwrd }{A logical variable. If TRUE, the observations are sorted for plotting by the size of the sum of squared residuals. }
}
\details{
}
\value{
A set of plots, where a mouse click advances from one plot to the next. 
}
\references{}
\note{}
\author{}
\seealso{
plotFd, linesFd 
}
\examples{
}
\keyword{}

\eof
\name{polyg}
\alias{polyg}
\title{Polygonal Basis Function Values }
\description{
Evaluates a set of polygonal basis functions, or a derivative of these functions, at a set of arguments. 
}
\usage{
polyg(x, argvals, nderiv=0)
}
\arguments{
  \item{x }{A vector of argument values at which the polygonal basis functions are to evaluated. }
  \item{argvals }{A strictly increasing set of argument values containing the range of x within it that defines the polygonal basis. The default is x itself. }
  \item{nderiv }{The derivative to be evaluated. The derivative must not exceed one. The default derivative is 0, meaning that the basis functions themselves are evaluated. }
}
\details{
}
\value{
A matrix of function values. The number of rows equals the number of arguments, and the number of columns equals the number of basis 
}
\references{}
\note{}
\author{}
\seealso{}
\examples{}
\keyword{}

\eof
\name{polygpen}
\alias{polygpen}
\title{Polygonal Penalty Matrix }
\description{
Computes the matrix defining the roughness penalty for functions expressed in terms of a polygonal basis. 
}
\usage{
polygpen(basisfd, Lfd=1)
}
\arguments{
  \item{basisfd }{A polygonal basis object. }
  \item{Lfd }{Either a nonnegative integer or a linear differential operator object. }
}
\details{
A roughness penalty for a function x(t) is defined by integrating the square of either the derivative of x(t) or, more generally, the result of applying a linear differential operator L to it. The only roughness penalty possible aside from penalizing the size of the function itself is the integral of the square of the first derivative D1x(t), and this is the default. To apply this roughness penalty, the matrix of inner products produced by this function is necessary. 
}
\value{
A symmetric matrix of order equal to the number of basis functions defined by the polygonal basis object. Each element is the inner product of two polygonal basis functions after applying the derivative or linear differential operator defined by Lfdobj. 
}
\references{}
\note{}
\author{}
\seealso{}
\examples{}
\keyword{}

\eof
\name{posfd}
\alias{posfd}
\title{Smooth Data with a Positive Function using a Roughness Penalty }
\description{
This function smooths data from a single curve or function using a roughness penalty. Unlike function smooth. basis, however, the function is constrained to be positive. The function is defined by a functional data object Wfdobj, which defines the logarithm of the positive function. The roughness of Wfdobj, and hence of the positive smoothing function, is definable in a wide variety of ways using either derivatives or a linear differential operator. 
}
\usage{
posfd(y, argvals, Wfdobj, Lfd=3, lambda=0, conv=0.0001, iterlim=20,
      dbglev=1)
}
\arguments{
  \item{y }{A vector of observations on a single curve. }
  \item{argvals }{A vector of argument values corresponding to y. }
  \item{Wfdobj }{A functional data object defining a single univariate function. }
  \item{Lfd }{Either a nonnegative integer or a linear differential operator object. If present, the derivative or the value of applying the operator is evaluated rather than the functions themselves. }
  \item{lambda }{A nonnegative value controlling the amount of roughness in the data. }
  \item{conv }{A criterion for convergence of the iterations. }
  \item{iterlim }{A limit on the number of iterations. }
  \item{dbglev }{Either 0, 1, or 2. This controls the amount information printed out on each iteration, with 0 implying no output, 1 intermediate output level, and 2 full output. }
}
\details{
The computation of the positive function requires iterative optimization of the fitting criterion, and is therefore more computationally intensive than unconstrained smoothing. For this reason, only one curve at a time is allowed to be smoothed. 

The computational problem of estimating a positive function is very similar to that for estimating a density function, except that there is no normalizing constraint. For this reason, this function has much in common with function densityfd. 

To plot the positive function or to evaluate it, evaluate Wfdobj, and then exponentiate the resulting vector. 
}
\value{
A list containing: 
Wfdobj 
A functional data object defining function W(x) that that optimizes the fit to the data of the monotone function that it defines. 
Flist 
A list containing results for the final converged solution: 
f 
The optimal function value being minimized. 
grad 
The gradient vector at the optimal solution. 
norm 
The norm of the gradient vector at the optimal solution. 
iternum 
The number of iterations. 
iterhist 
A iternum+1 by 5 matrix containing the iteration history. 
}
\references{}
\note{}
\author{}
\seealso{}
\examples{
}
\keyword{}

\eof
\name{powerbasis}
\alias{powerbasis}
\title{Power Basis Function Values }
\description{
Evaluates a set of power basis functions, or a derivative of these functions, at a set of arguments. 
}
\usage{
powerbasis(x, exponents, nderiv=0)
}
\arguments{
  \item{x }{A vector of argument values at which the power basis functions are to evaluated. Since exponents may be negative, for example after differentiation, it is required that all argument values be positive. }
  \item{exponents }{A vector of exponents defining the power basis functions. If y is such a rate value, the corresponding basis function is xy. The number of basis functions is equal to the number of exponents. }
  \item{nderiv }{The derivative to be evaluated. The derivative must not exceed the order. The default derivative is 0, meaning that the basis functions themselves are evaluated. }
}
\details{
}
\value{
A matrix of function values. The number of rows equals the number of arguments, and the number of columns equals the number of basis 
}
\references{}
\note{}
\author{}
\seealso{}
\examples{}
\keyword{}

\eof
\name{powerpen}
\alias{powerpen}
\title{Power Penalty Matrix }
\description{
Computes the matrix defining the roughness penalty for functions expressed in terms of a power basis. 
}
\usage{
powerpen(basisobj, Lfd=2)
}
\arguments{
  \item{basisobj}{A power basis object. }
  \item{Lfd}{Either a nonnegative integer or a linear differential operator object. }
}
\details{
A roughness penalty for a function x(t) is defined by integrating the square of either the derivative of x(t) or, more generally, the result of applying a linear differential operator L to it. The most common roughness penalty is the integral of the square of the second derivative D2x(t), and this is the default. To apply this roughness penalty, the matrix of inner products produced by this function is necessary. 
}
\value{
A symmetric matrix of order equal to the number of basis functions defined by the power basis object. Each element is the inner product of two power basis functions after applying the derivative or linear differential operator defined by Lfdobj. 
}
\references{}
\note{}
\author{}
\seealso{}
\examples{}
\keyword{}

\eof
\name{printFd}
\alias{printFd}
\title{Print a Functional Data Object }
\description{
Prints a functional data object. 
}
\usage{
printFd(fd, ...)
}
\arguments{
  \item{fd }{A functional data object. }
  \item{... }{The additional optional arguments that are permitted for all print functions. }
}
\details{
}
\value{
The dimensions of the coefficient array are displayed, as well as the coefficient array itself. Then the characteristics of the basis are printed. 
}
\references{}
\note{}
\author{}
\seealso{}
\examples{
}
\keyword{}

\eof
\name{project.basis}
\alias{project.basis}
\title{Approximate Functional Data Using a Basis }
\description{
A vector or matrix of discrete data is projected into the space spanned by the values of a set of basis functions. This amounts to a least squares regression of the data on to the values of the basis functions. A small penalty can be applied to deal with stiautions in which the number of basis functions exceeds the number of basis points. This function is used with function data2fd, and is not normally used directly in a functional data analysis. 
}
\usage{
project.basis(y, argvals, basisfd, penalize=FALSE)
}
\arguments{
  \item{y }{A vector or matrix of discrete data. }
  \item{argvals }{The argument values correspond to the values in y. }
  \item{basisfd }{A basis object. }
  \item{penalize }{A logical variable. If TRUE, a small roughness penalty is applied to ensure that the linear equations defining the least squares solution are linearly independent or nonsingular. }
}
\details{
}
\value{
The matrix of coefficients defining the least squares approximation. This matrix has as many rows are there are basis functions, as many columns as there are curves, and if the data are multivariate, as many layers as there are functions. 
}
\references{}
\note{}
\author{}
\seealso{
data2fd 
}
\examples{
}
\keyword{}

\eof
\name{registerfd}
\alias{registerfd}
\title{Register Functional Data Objects }
\description{
Curves are aligned with a target or template curve using a continuous criterion. By aligned is meant that the shape of each curve is matched as closely as possible to that of the target by means of a smooth increasing transformation of the argument, or a warping function. 
}
\usage{
registerfd(y0fd, yfd, Wfd0, Lfdobj=2, lambda=1, conv=0.01, iterlim=10,
dbglev=1, periodic=FALSE, crit=2)
}
\arguments{
  \item{y0fd }{A functional data object defining the target. It must be univariate and it must define a single functional observation. }
  \item{yfd }{A functional data object defining the functions to be registered to yfd0. }
  \item{Wfd0 }{A functional data object defining the initial value of a function W(t) that determines the warping function. }
  \item{Lfdobj }{Either a nonnegative integer or a linear differential operator object that defines a rougness penalty to be applied to functional data object Wfd0. If present, the derivative or the value of applying the operator is evaluated rather than the functions themselves. }
  \item{lambda }{A nonnegative smoothing parameter that controls the degree of roughness in Wfdobj, and consequently in the monotone smoothing function. }
  \item{conv }{A criterion for convergence of the iterations. }
  \item{iterlim }{A limit on the number of iterations. }
  \item{dbglev }{Either 0, 1, or 2. This controls the amount information printed out on each iteration, with 0 implying no output, 1 intermediate output level, and 2 full output. }
  \item{periodic }{A logical variable. If T, the functions are considered to be periodic, in which case a constant can be added to all argument values after they are warped. }
  \item{crit }{An integer that is either 1 or 2 that indicates the nature of the continuous registration criterion that is used. If 1, the criterion is least squares, and if 2, the criterion is the minimum eigenvalue of a cross-product matrix. In general, criterion 2 is to be preferred. }
}
\details{
The warping function that smoothly and monotonely transforms the argument is defined by Wfd0 in the same that the monotone smoothing function is for function smooth.monotone. See the help file for that function for further details. 
}
\value{
A list containing: regstr <- list("regfd"=regfd, "Wfd"=Wfd, "shift"=shift) 
regfd 
The registered versions of the original function defined in yfd. 
Wfd 
The functional data object determining the warping functions. 
shift 
A constant that is added to the warped arguments if the data are considered periodic. Otherwise, zero. 
}
\references{}
\note{}
\author{}
\seealso{}
\examples{
}
\keyword{}

\eof
\name{smooth.Pspline}
\alias{smooth.Pspline}
\title{Smooth Data with Using mth Derivative Penalty }
\description{
This a generalized version of one of the regular S-PLUS functions, smooth.spline, that permits a penalty on the size of the derivative of any order m rather than just m = 2. It uses functions coded in C or Fortran that economize on storage and are much faster than the native S-PLUS code that is used in function smooth.basis. Consequently, it is more suitable for problems involving the need for very large number of basis functions, meaning in practice more than about 100. 
}
\usage{
smooth.Pspline(x, y, w, norder=2, df=norder+2, spar, method=3)
}
\arguments{
  \item{x }{Either a vector or matrix containing the data values to be smoothed. If a matrix, the columns correspond to replications of curves or functions. }
  \item{y }{Either a vector or matrix containing the data values to be smoothed. If a matrix, the columns correspond to replications of curves or functions. }
  \item{w }{Either a vector or matrix containing the data values to be smoothed. If a matrix, the columns correspond to replications of curves or functions. }
  \item{norder }{The order of the derivative whose size is to be penalized. See below for advice on what it should be. }
  \item{df }{The degree of freedom. }
  \item{spar }{A penalty parameter controlling the amount of smoothness or the size of the penalty if method = 3 or 4. }
  \item{method }{An integer with a value from 1 to 4 specifying the way in which the amount of smoothing is determined: 
    the amount of smoothing is controlled by the smoothing parameter lambda. 
    the amount of smoothing is controlled by the degrees of freedom value df. 
    the amount of smoothing optimizes the GCV or generalized cross-validation criterion. 
    the amount of smoothing optimizes the CV or ordinary cross-validation criterion. 
}
}
\details{
The need to choose the order m of the derivative arises if one needs smooth estimates of one or more derivatives. Generally, the advice is to choose m to be 2 larger than the highest order of derivative required. This in effect penalizes the curvature of that derive. So if the second derivative or acceleration is required, then use m = 4. 

Like S-PLUS function smooth.spline, this function also comes with additional functions: 

predictSmoothPspline
calculates values of a derivative of the smoothing function at argument values argvals. The call is 
predictSmoothPspline(splobj, argvals, nderiv = 0)

where splobj is the object of class "smooth.Pspline" returned by smooth.Pspline. 
plotSmoothPspline
plots an object of class "smooth.Pspline". The call is 
plotSmoothPspline(splobj, ...)

where splobj is the object of class "smooth.Pspline" returned by smooth.Pspline. Additional arguments for controlling the plot may also supplied, as in the regular plot function. 
linesSmoothPspline
adds lines to an existing plot showing an object of class "smooth.Pspline". The call is 
linesSmoothPspline(splobj, ...)

where splobj is the object of class "smooth.Pspline" returned by smooth.Pspline. Additional arguments for controlling the plot may also supplied, as in the regular lines function. 
print.smooth.Pspline
prints an object of class "smooth.Pspline". The call is 
print.smooth.Pspline(splobj, ...)

where splobj is the object of class "smooth.Pspline" returned by smooth.Pspline. Additional arguments for controlling the plot may also supplied, as in the regular print function. 
One should not put complete faith in any automatic method for selecting lambda, including the GCV method. There are many reasons for this. For example, if derivatives are required, then the smoothing level that is automatically selected may give unacceptably rough derivatives. These methods are also highly sensitive to the assumption of independent errors, which is usually dubious with functional data. The best advice is to start with the value minimizing the gcv measure, and then explore lambda values a few log units up and down from this value to see what the smoothing function and its derivatives look like. 
}
\value{
An object of class "smooth.Pspline" containing: 
norder
The order of the smoothing spline, that is, the derivative whose size is penalized. 
argvals
The argument value vector. 
ysmth
The values of the smooth function(s) corresponding to the values in y. 
lev
An vector of leverage values. 
gcv
The generalized cross-validation coefficient. 
cv
The ordinary cross-validation coefficient. 
lambda
The final value of the penalty parameter. 
my.call
The calling statement. 
}
\references{}
\note{}
\author{}
\seealso{
smooth.basis, smooth.spline, smooth.fd 
}
\examples{}
\keyword{}

\eof
\name{smooth.basis}
\alias{smooth.basis}
\title{Smooth Data using a Roughness Penalty }
\description{
This is the main function for smoothing data using a roughness penalty. Unlike function data2fd, which does not employ a rougness penalty, this function controls the nature and degree of smoothing by penalyzing a measure of rougness. Roughness is definable in a wide variety of ways using either derivatives or a linear differential operator. 
}
\usage{
smooth.basis(y, argvals, basisfd, wtvec=rep(1, n), Lfd=NULL, lambda=0,
             fdnames=list(NULL, dimnames(y)[2], NULL))
}
\arguments{
  \item{y }{An array containing values of curves at discrete sampling points or argument values. If the array is a matrix, the rows must correspond to argumentvalues and columns to replications, and it will be assumed that there is only one variable per observation. If Y is a three-dimensional array, the first dimension corresponds to argument values, the second to replications, and the third to variables within replications. If Y is a vector, only one replicate and variable are assumed. }
  \item{argvals }{A vector of argument values correspond to the observations in array y. }
  \item{basisfd }{A basis object. Each curve is represented by a linear combination of the basis functions defined in this object. }
  \item{wtvec }{A vector the same length as argvals containing nonnegative weight to be applied to the observations. By default these are one's. }
  \item{Lfd }{Either a nonnegative integer or a linear differential operator object. If present, the derivative or the value of applying the operator is evaluated rather than the functions themselves. }
  \item{lambda }{A nonnegative value controlling the amount of roughness in the data. }
  \item{fdnames}{ A list of length 3 with members containing 
    a single name for the argument domain, such as 'Time' 
    a vector of names for the replications or cases 
    a name for the function, or a vector of names if there are multiple functions. 
   }
}
\details{
If lambda is zero, there is no penalty on roughness. As lambda increases, usually in logarithmic terms, the penalty on roughness increases and the fitted curves become more and more smooth. Ultimately, the curves are forced to have zero roughness in the sense of being in the null space of the differential operator Lfd. For example, a common choice of roughness penalty is the integrated square of the second derivative. This penalizes curvature. Since the second derivative of a straight line is zero, very large values of lambda will force the fit to become linear. 

It is also possible to control the amount of roughness by using a degrees of freedom measure. The value equivalent to lambda is found in the list returned by the function. On the other hand, it is possible to specify a degrees of freedom value, and then use function df2lambda to determine the equivalent value of lambda. 

One should not put complete faith in any automatic method for selecting lambda, including the GCV method. There are many reasons for this. For example, if derivatives are required, then the smoothing level that is automatically selected may give unacceptably rough derivatives. These methods are also highly sensitive to the assumption of independent errors, which is usually dubious with functional data. The best advice is to start with the value minimizing the gcv measure, and then explore lambda values a few log units up and down from this value to see what the smoothing function and its derivatives look like. The function plotfit.fd was designed for this purpose. 

An alternative to using smooth.basis is to first represent the data in a basis system with reasonably high resolution using data2fd, and then smooth the resulting functional data object using function smooth.fd. 
}
\value{
A list containing: 
fd
An object of class fd containing coefficients 
df
A degrees of freedom measure 
gcv
A measure of lack of fit discounted for df. One method for choosing the smoothing parameter lambda, called the GCV method, is to find the value which minimizes this measure. 
}
\references{
A discussion of roughness penalties can be found in Chapter 4 of Ramsay, J. O. and Silverman, B.W. (1997) Functional Data Analysis. More information can be found in recent texts on nonparametric regression. A good discussion of degrees of freedom measure can be found in Hastie, T. and Tibshirani, R. (1990) Generalized Additive Models. 
}
\note{}
\author{}
\seealso{
data2fd, plotfit.fd, smooth.fd, project.basis 
}
\examples{}
\keyword{}

\eof
\name{smooth.fd}
\alias{smooth.fd}
\title{Smooth a Functional Data Object Using a Roughness Penalty }
\description{
This function is intended to apply a roughness penalized smooth to data already set up as a functional data object. For example, data may have been converted to a functional data object using function data2fd using a fairly large set of basis functions, and subsequently it was desired to smooth the functional data object that resulted. 
}
\usage{
smooth.fd(fd, lambda=0, Lfd=NULL, rebase=TRUE)
}
\arguments{
  \item{fd }{The functional data object to be smoothed. }
  \item{lambda }{A nonnegative value controlling the amount of roughness in the data. }
  \item{Lfd }{Either a nonnegative integer or a linear differential operator object. If present, the derivative or the value of applying the operator is evaluated rather than the functions themselves. }
  \item{rebase }{A logical variable that is only relevant if the basis is a polygonal basis of type "polyg". If this case, if rebase is TRUE , then the basis is changed to a cubic bspline basis before smoothing. }
}
\details{
See function smooth.basis for details. 
}
\value{
A functional data object. 
}
\references{
A discussion of roughness penalties can be found in Chapter 4 of Ramsay, J. O. and Silverman, B.W. (1997) Functional Data Analysis. More information can be found in recent texts on nonparametric regression. 
}
\note{}
\author{}
\seealso{
data2fd, plotfit.fd, smooth.basis, project.basis 
}
\examples{}
\keyword{}

\eof
\name{smooth.monotone}
\alias{smooth.monotone}
\title{Monotone Smoothing of Data }
\description{
When the discrete data that are observed reflect a smooth strictly increasing or strictly decreasing function, it is often desirable to smooth the data with a strictly monotone function, even though the data themselves may not be monotone due to observational error. An example is when data are collected on the size of a growing organism over time. This function computes such a smoothing function, but, unlike other smoothing functions, for only for one curve at a time. 

The smoothing function minimizes a weighted error sum of squares criterion. This minimization requires iteration, and therefore is more computationally intensive than normal smoothing. 
}
\usage{
smooth.monotone(x, y, wt=rep(1, nobs), Wfdobj, zmat=matrix(1, nobs, 1),
Lfdobj=1, lambda=0, conv=0.0001, iterlim=20, active=c(FALSE, rep(TRUE, ncvec -1)), dbglev=1)
}
\arguments{
  \item{x }{A vector of argument values associated with the data. }
  \item{y }{A vector of observations to be smoothed. }
  \item{Wfdobj }{A functional data object that determines the final monotone smooth. It must be univariate and define a single functional observation. }
  \item{wt }{A vector of positive weights for the observations. The default is all weights one. }
  \item{zmat }{A design matrix that permits an additive constant to possibly depend on covariate variables. The default is a column of one's. }
  \item{Lfdobj }{Either a nonnegative integer or a linear differential operator object that defines a rougness penalty to be applied to functional data object Wfdobj. If present, the derivative or the value of applying the operator is evaluated rather than the functions themselves. }
  \item{lambda }{A nonnegative smoothing parameter that controls the degree of roughness in Wfdobj, and consequently in the monotone smoothing function. }
  \item{conv }{A criterion for convergence of the iterations. }
  \item{iterlim }{A limit on the number of iterations. }
  \item{active }{A logical vector of length equal to the number of coefficients defining Wfdobj. If an entry is T, the corresponding coefficient is estimated, and if F, it is held at the value defining the argument Wfdobj. Normally the first coefficient is set to 0 and not estimated, since it is assumed that W(0) = 0. }
  \item{dbglev }{Either 0, 1, or 2. This controls the amount information printed out on each iteration, with 0 implying no output, 1 intermediate output level, and 2 full output. }
}
\details{
The monotone smoothing function has the following structure: 

f(x) = b0 + b1 D-1 [exp W(x)] 
Here the operator D-1 means taking the indefinite integral of the function that follows, namely exp W(x). The smoothing function f(x) is, by this structure, determined by three objects that need to be estimated from the data: 

W(x)
A functional data object that is first exponentiated and then the result integrated. This is the heart of the monotone smooth. The closer W(x) is to zero, the closer the monotone smooth becomes a straight line. The closer W(x) becomes a constant, the more the monotone smoother becomes an exponential function. It is assumed that W(0) = 0. 
b0
An intercept term that determines the value of the smoothing function at x = 0. 
b1
A regression coefficient that determines the slope of the smoothing function at x = 0. 
In addition, it is possible to have the intercept b0 depend in turn on the values of one or more covariates through the design matrix Zmatas follows: 

b0 = Zc 
In this case, the single intercept coefficient is replaced by the regression coefficients in vector c multipying the design matrix. 

}
\value{
A list containing: 
Wfdobj 
A functional data object defining function W(x) that that optimizes the fit to the data of the monotone function that it defines. 
beta 
The optimal regression coefficient values. 
Flist 
A list containing results for the final converged solution: 
f 
The optimal function value being minimized. 
grad 
The gradient vector at the optimal solution. 
norm 
The norm of the gradient vector at the optimal solution. 
iternum 
The number of iterations. 
iterhist 
A iternum+1 by 5 matrix containing the iteration history. 
}
\references{}
\note{}
\author{}
\seealso{}
\examples{
}
\keyword{}

\eof
\name{std.fd}
\alias{std.fd}
\title{Standard Deviation of Functional Data }
\description{
Evaluate the standard deviation of a set of functions in a functional data object. 
}
\usage{
std.fd(fd)
}
\arguments{
  \item{fd }{A functional data object. }
}
\details{
}
\value{
Returns a functional data object with a single replication that contains the standard deviation of the one or several functions in the object fd. 

}
\references{}
\note{}
\author{}
\seealso{
meanFd, sumFd, center.fd 
}
\examples{}
\keyword{}

\eof
\name{sumFd}
\alias{sumFd}
\title{Sum of Functional Data }
\description{
Evaluate the sum of a set of functions in a functional data object. 
}
\usage{
sumFd(fd)
}
\arguments{
  \item{fd }{A functional data object. }
}
\details{
}
\value{
Returns a functional data object with a single replication that contains the sum of the functions in the object fd. 
}
\references{}
\note{}
\author{}
\seealso{
std.fd, meanFd, center.fd 
}
\examples{}
\keyword{}

\eof
\name{summaryFd}
\alias{summaryFd}
\title{Summarize a Functional Data Object }
\description{
Provided a compact summary of the characteristics of a funtional data object. 
}
\usage{
summaryFd(fd, ...)
}
\arguments{
  \item{fd }{A functional data object. }
  \item{... }{The additional arguments that may be supplied to the usual summary function. }
}
\details{
}
\value{
A displayed summary of the functional data object. 
}
\references{}
\note{}
\author{}
\seealso{}
\examples{
}
\keyword{}

\eof
\name{var.fd}
\alias{var.fd}
\title{Variance and Covariance Surfaces for a Functional Data Object }
\description{
Compute the variance and covariance functions for functional data. These are two-argument functions, and therefore define a surface. If there is one functional data object supplied, its variance is computed. If there are two, the covariance between the two is computed. Both functional data objects must be univariate. 
}
\usage{
var.fd(fdx, fdy=fdx)
}
\arguments{
  \item{fdx }{A univariate functional data object. }
  \item{fdy }{A univariate functional data object. }
}
\details{
}
\value{
A two-argument functional data object representing the variance surface for a single functional data object or the covariance between two functional data objects. 
}
\references{}
\note{}
\author{}
\seealso{
meanFd, std.fd 
}
\examples{
}
\keyword{}

\eof
\name{varmx.pca.fd}
\alias{varmx.pca.fd}
\title{Rotation of Functional Principal Components with VARIMAX Criterion }
\description{
Principal components are often easier to interpret if they are rotated. Among the many possible ways in which this rotation can be defined, the VARIMAX criterion seems to give satisfactory results most of the time. 
}
\usage{
varmx.pca.fd(pcafd, nharm=scoresd[2], nx=101)
}
\arguments{
  \item{pcafd }{A principal components analysis object of class pca.fd. }
  \item{nharm }{The number of principal components or harmonics to be rotated. }
  \item{nx }{The number of argument values used to define the harmonics to be rotated. }
}
\details{
}
\value{
A princpal components analysis object of class pca.fd. 
}
\references{}
\note{}
\author{}
\seealso{}
\examples{
}
\keyword{}

\eof
\name{warpsmth}
\alias{warpsmth}
\title{A Smooth Monotone Warping Function }
\description{
This function does nearly the same thing that function smooth.monotone does, but in this case the constants b0 and b1 are determined so that the initial value of the warping function is the same as the initial argument value, and the final warping function value is the same as the final argument values. This function is mainly used in function landmarkreg to ensure that the warping function is monotone. 
}
\usage{
warpsmth(x, y, wt=rep(1, nobs), Wfd, Lfd=1, lambda=0, conv=0.0001, iterlim=20, active=rep(TRUE, nbasis), dbglev=0)
}
\arguments{
  \item{x }{A vector of argument values associated with the data. }
  \item{y }{A vector of observations to be smoothed. }
  \item{wt }{A vector of positive weights for the observations. The default is all weights one. }
  \item{Wfd }{A functional data object that determines the final monotone smooth. It must be univariate and define a single functional observation. }
  \item{Lfd }{Either a nonnegative integer or a linear differential operator object that defines a rougness penalty to be applied to functional data object Wfdobj. If present, the derivative or the value of applying the operator is evaluated rather than the functions themselves. }
  \item{lambda }{A nonnegative smoothing parameter that controls the degree of roughness in Wfdobj, and consequently in the monotone smoothing function. }
  \item{conv }{A criterion for convergence of the iterations. }
  \item{iterlim }{A limit on the number of iterations. }
  \item{active }{A logical vector of length equal to the number of coefficients defining Wfdobj. If an entry is T, the corresponding coefficient is estimated, and if F, it is held at the value defining the argument Wfdobj. Normally the first coefficient is set to 0 and not estimated, since it is assumed that W(0) = 0. }
  \item{dbglev }{Either 0, 1, or 2. This controls the amount information printed out on each iteration, with 0 implying no output, 1 intermediate output level, and 2 full output. }
}
\details{
See the help file for smooth.monotone. 
}
\value{
See the help file for smooth.monotone.
}
\references{}
\note{}
\author{}
\seealso{}
\examples{
}
\keyword{}

\eof
