### Name: image.plot
### Title: Draws image plot with a legend strip for the color scale.
### Aliases: image.plot
### Keywords: hplot

### ** Examples

 x<- 1:10 
 y<- 1:15 
z<- outer( x,y,"+") 
image.plot(x,y,z) 
# or obj<- list( x=x,y=y,z=z); image.plot(obj)
# now add some points on diagonal with some clipping anticipated 
points( 5:12, 5:12, pch="X", cex=3)
#
#fat (5% of figure) and short (50% of figure)  legend strip on the bottom 
image.plot( x,y,z,legend.width=.05, legend.shrink=.5, horizontal=TRUE) 

# you can always add a legend arbitrarily to any plot;
# note that here the plot is too big for the vertical strip but the
# horizontal fits nicely.
plot( 1:10, 1:10)
image.plot( zlim=c(0,25), legend.only=TRUE)
image.plot( zlim=c(0,25), legend.only=TRUE, horizontal =TRUE)

# combining the  usual image function and adding a legend
# first change margin for some more room
## Not run: 
##D par( mar=c(10,5,5,5))
##D image( x,y,z, col=topo.colors(64))
##D image.plot( zlim=c(0,25), nlevel=64,legend.only=TRUE, horizontal=TRUE)
## End(Not run)
#
# 
 



