### Name: make.Amatrix.Krig
### Title: Computes the prediction matrix for a Krig fit.
### Aliases: make.Amatrix.Krig
### Keywords: spatial

### ** Examples

# Compute the A matrix or "hat" matrix for a spatial process estimate
# with an exponential covariance, range= 100.
# check that this gives the same predicted values 
krig.out<- Krig( ozone$x, ozone$y, exp.cov, theta=100)
A<- make.Amatrix( krig.out, ozone$x)
test.fitted.values<- A%*%ozone$y  

# now compare this to predict( krig.out) or krig.out$fitted.values 
#                    they are all  the same! 



