### Name: predict.se.Krig
### Title: Standard errors of predictions for Krig spatial process estimate
### Aliases: predict.se.Krig
### Keywords: spatial

### ** Examples

# 
# Note: in these examples predict.se will default to predict.se.Krig using 
# a Krig object  

fit<- Krig(ozone$x,ozone$y,exp.cov, theta=10)    # krig fit 
predict.se.Krig(fit)                        # std errors of predictions 

# make a  grid of X's  
xg<-make.surface.grid( list(seq(-27,34,,40),seq(-20,35,,40)))     
out<- predict.se.Krig(fit,xg)     # std errors of predictions 

#at the grid points out is a vector of length 1600 
# reshape the grid points into a 40X40 matrix etc.  
out.p<-as.surface( xg, out) 
image.plot( out.p) 

# this is equivalent to  the single step function  
# (but default is not to extrapolation beyond data
out<- predict.surface.se( fit) 
image.plot( out) 

# Investigate misspecification 
# 
# first call Krig to create the Krig object.  
# 
Krig( ozone$x, ozone$y, cov.function=exp.cov, theta=100)-> fit 

# note how the new cov. parameters are specified just like in Krig  
predict.se(fit,xg)-> look 
predict.se( fit, xg, cov.function=exp.cov, theta=2.0, sigma2=1)-> look2 

set.panel( 2,1)
image.plot( as.surface( xg, look))
points( fit$x)
image.plot( as.surface( xg, look2))
set.panel( 1,1)



