\name{BD}
\alias{BD}
\title{
  Data frame of the effect of buffer compositions on DNA strand displacement 
amplification. A 4-d regression data set with 
with replication. This is a useful test data set for exercising function
fitting methods. 
}
\description{
The \code{BD} data frame has 89 rows and 5 columns. There are 89 runs with  
four buffer components (KCL, MgCl2, KP04, dnTP) systematically varied in 
a space-filliing design. The response is the DNA amplification rate.  
}
\usage{
data(BD)
}
\format{
This data frame contains the following columns: 

\describe{
\item{KCl}{
Buffer component. 
}
\item{MgCl2}{
Buffer component. 
}
\item{KPO4}{
Buffer component. 
}
\item{dNTP}{
Buffer component, deoxyribonucleotides. 
}
\item{lnya}{
Exponential amplification rate on a log scale, i.e. the actual amplification 
rate. 
}
}
}

\source{
Thanks to Perry Haaland and Michael OConnell.

Becton Dickinson Research Center 
Research Triangle Park, NC 
}
\seealso{
Tps  
}
\examples{
# fitting a DNA strand 
# displacement amplification  surface to various buffer compositions 
fit<- Tps(BD[,1:4],BD$lnya,scale.type="range") 
surface(fit)  # plots fitted surface and contours 
}
\keyword{datasets}
% docclass is function
% Converted by Sd2Rd version 1.21.

\eof
\name{Krig}
\alias{Krig}
\title{
  Kriging surface estimate  
}
\description{
Fits a surface to irregularly spaced data. The Kriging model assumes  
that the unknown  function is a realization  of a Gaussian 
random spatial processes. The assumed model is additive 
Y = P(x) +  Z(X) + e, where P is a low order polynomial and Z is a 
mean zero, 
Gaussian stochastic process with a  
covariance that is unknown up to a scale constant. The main advantages of
this function are the flexibility in specifying the covariance as an
R language function and also the supporting functions plot, predict,
predict.se, surface for
subsequent analysis. Krig also supports a correlation model where the mean
and marginal variances are supplied. 
}
\usage{
Krig(x, Y, cov.function=exp.cov, lambda=NA, df = NA,
cost=1, knots, weights=rep(1,length(Y)), 
m=2, return.matrices=TRUE, nstep.cv=80, scale.type="user", 
x.center=rep(0, ncol(x)), x.scale=rep(1, ncol(x)), rho=NA, sigma2=NA, 
method="GCV", decomp="DR", verbose=FALSE, cond.number=10^8, mean.obj=NULL, 
sd.obj=NULL, yname=NULL, return.X=TRUE, null.function=make.tmatrix, offset=0, 
 outputcall = NULL, cov.args=NULL,...)
}
\arguments{
\item{x}{
Matrix of independent variables. 
}
\item{Y}{
Vector of dependent variables. 
}
\item{cov.function}{
Covariance function for data in the form of an R function (see 
exp.cov).  
Default assumes that correlation is an exponential function of distance.
}
\item{df}{
The effective number of parameters for the fitted surface. Conversely, 
N- df, where N is the total number of observations is the degrees of
freedom associated with the residuals. 
This is an
alternative to specifying lambda and much more interpretable. 
}
\item{lambda}{
Smoothing parameter that is the ratio of the error variance (sigma**2) 
to the scale parameter of the  
covariance function (rho). If omitted this is estimated by GCV ( see
method below). 
}
\item{cost}{
Cost value used in GCV criterion. Corresponds to a penalty for  
increased number of parameters. 
}
\item{knots}{
A matrix of locations similar to x. These can define an alternative set of
basis functions for representing the estimate. One choice may be a
space-filling subset of the original x locations. (See details.)
}
\item{weights}{
Weights are proportional to the reciprocal variance of the measurement  
error. The default is no weighting i.e. vector of unit weights. 
}
\item{m}{
A polynomial function of degree (m-1) will be  
included in the model as the drift (or spatial trend) component. 
}
\item{return.matrices}{
Matrices from the decompositions are returned. The default is T.  
}
\item{nstep.cv}{
Number of grid points for minimum GCV search. 
}
\item{scale.type}{
This is a character string among: "range", "unit.sd", "user", "unscaled".
The independent variables and knots are scaled to the specified scale.type. 
By default no scaling is done. Scale type of
"range" scales the data to the interval (0,1) by forming 
(x-min(x))/range(x) for each x. Scale type of "unit.sd" 
Scale type of "user" allows specification of an x.center and x.scale by the 
user. The default for "user" is mean 0 and standard deviation 1. Scale 
type of "unscaled" does not scale the data. 
}
\item{x.center}{
Centering values to be subtracted from each column of the x matrix. 
}
\item{x.scale}{
Scale values that are divided into each column after centering. 
}
\item{rho}{
Scale factor for covariance. 
}
\item{sigma2}{
Variance of the errors, often called the nugget variance. If weights are
specified then the error variance is sigma2 divided by weights. 
}
\item{method}{
 
How should the "smoothing" parameter be estimated? The default is by
standard GCV 
Other choices are: GCV.model, GCV.one, RMSE, pure error. The differences 
are explained below.  
}
\item{decomp}{
Type of matrix decompositions used to compute the solution. Default is  
"DR" Demmler-Reinsch an alternative that more numerically stable is  
"WBW" Wendelberger-Bates-Wahba. This is the strategy used in GCV pack.   
"WBW" can not be used if knots are specified.
}
\item{verbose}{
If true will print out all kinds of intermediate stuff. Default is false,
of course.   
}
\item{cond.number}{
Maximum size of condition number to allow when using DR decomposition. 
}
\item{mean.obj}{
Object to predict the mean of the spatial process. This used in when
fitting a correlation model with varying spatial means and varying
marginal variances. (See details.)
}
\item{sd.obj}{
Object to predict the marginal standard deviation of the spatial process. 
}
\item{yname}{
Name of y variable 
}
\item{return.X}{
If true returns the big X matrix used for the estimate.  
}
\item{null.function}{
An S function that creates the matrices for the null space model.  
The default is make.tmatrix, an S function that creates polynomial 
null spaces of degree up to m-1. (See details)  
}
\item{offset}{
The offset to be used in the GCV criterion. Default is 0. This would be 
used when Krig is part of a backfitting algorithm and the offset has to be 
adjusted to reflect other model degrees of freedom. 
}
\item{cov.args}{
A list with the arguments to call the covariance function. (in addition to the locations)
}

\item{outputcall}{
If NULL the output object will have a \$call argument based on this call. 
If no NULL the output call will have whatever is passed. This is kludge
for the Tps function so that it return a Krig object but have the right
call argument.
}
\item{\dots}{
Optional arguments that appear are assume to be additional arguments
to the covariance function. 
}
}
\value{
A object of class Krig. This includes the predicted values in  
fitted.values and the residuals in residuals. The results of the grid 
search to minimize the generalized cross validation function are 
returned in gcv.grid. 

\item{call}{
Call to the function 
}
\item{y}{
Vector of dependent variables. 
}
\item{x}{
Matrix of independent variables. 
}
\item{weights}{
Vector of weights. 
}
\item{knots}{
Locations used to define the basis functions.  
}
\item{transform}{
List of components used in centering and scaling data. 
}
\item{np}{
Total number of parameters in the model. 
}
\item{nt}{
Number of parameters in the null space. 
}
\item{matrices}{
List of matrices from the decompositions (D, G, u, X, qr.T). 
}
\item{gcv.grid}{
Matrix of values from the GCV grid search. The first column 
is the grid of lambda values used in the search, the second column  
is the trace of the A matrix, the third column is the GCV values and 
the fourth column is the estimated value of sigma conditional on the vlaue
of lambda.  
}
\item{lambda.est}{
A table of estimated smoothing parameters with corresponding degrees 
of freedom and estimates of sigma found by different methods.  
}
\item{cost}{
Cost value used in GCV criterion. 
}
\item{m}{
Order of the polynomial space: highest degree polynomial is (m-1). 
This is a fixed part of the surface often referred to as the drift 
or spatial trend.  
}
\item{eff.df}{
Effective degrees of freedom of the model. 
}
\item{fitted.values}{
Predicted values from the fit. 
}
\item{residuals}{
Residuals from the fit. 
}
\item{lambda}{
Value of the smoothing parameter used in the fit. 
}
\item{yname}{
Name of the response. 
}
\item{cov.function}{
Covariance function of the model. 
}
\item{beta}{
Estimated coefficients in the ridge regression format 
}
\item{d}{
Estimated coefficients for the polynomial basis functions that span the 
null space 
}
\item{fitted.values.null}{
Fitted values for just the polynomial part of the estimate 
}
\item{trace}{
Effective number of parameters in model. 
}
\item{c}{
Estimated coefficients for the basis functions derived from the 
covariance. 
}
\item{coefficients}{
Same as the beta vector. 
}
\item{just.solve}{
Logical describing if the data has been interpolated using the basis  
functions.  
}
\item{shat}{
Estimated standard deviation of the measurement error (nugget effect). 
}
\item{sigma2}{
Estimated variance of the measurement error (shat**2). 
}
\item{rho}{
Scale factor for covariance.  COV(h(x),h(x\code{)) = rho*cov.function(x,x}) 
If the covariance is actually a 
correlation function then rho is also the "sill". 
}
\item{mean.var}{
Normalization of the covariance function used to find rho. 
}
\item{best.model}{
Vector containing the value of lambda, the estimated variance of the  
measurement error and the scale factor for covariance used in the fit. 
}
}
\details{
This function produces a object of class Krig. With this object it is easy to subsequently 
predict with this fitted surface, find standard errors, alter the y data ( but not x),  etc. 

The Kriging model is:  Y(x)= P(x) + Z(x) + e 

where Y is the dependent variable observed at location x, P is a low order
polynomial, Z is a mean zero, Gaussian field with covariance function K
and e is assumed to be independent normal errors. The estimated surface is
the best linear unbiased estimate (BLUE)  of P(x) + Z(x) given the
observed data. For this estimate K, is taken to be rho*cov.function and
the errors have variance sigma**2. In more conventional geostatistical terms
rho is the "sill" if the covariance function is actually a correlation function  and 
sigma**2 is the nugget variance or measure error variance (the two are confounded in this 
model.)  

If these parameters rho and sigma2 are omitted in the call, then they are
estimated in the following way. If lambda is given, then sigma2 is
estimated from the residual sum of squares divided by the degrees of
freedom associated with the residuals.  Rho is found as the difference
between the sums of squares of the predicted values having subtracted off
the polynomial part and sigma2.  

A useful extension of a stationary correlation to a nonstationary
covariance is what we term a correlation model. 
If mean and marginal standard deviation objects are included in the call.  
Then the observed data is standardized based on these functions.  The
spatial process is then estimated with respect to the standardized scale.
However for predictions and standard errors the mean and standard
deviation surfaces are used to produce results in the original scale of
the observations.

The GCV function has several alternative definitions when replicate
observations are present or if one uses a reduced set knots.  Here are the
choices based on the method argument:  

GCV: leave-one-out GCV. But if
there are replicates it is leave one group out. (Wendy and Doug prefer
this one.)  

GCV.one: Really leave-one-out GCV even if there are replicate
points.  This what the old tps function used in FUNFITS.
 
rmse: Match the estimate of sigma**2 to a external value ( called rmse)  

pure error: Match the estimate of sigma**2 to the estimate based on
replicated data (pure error estimate in ANOVA language).  

GCV.model:
Only considers the residual sums of squares explained by the basis
functions.  

WARNING: The covariance functions often have a nonlinear parameter that
control the strength of the correlations as a function of separation,
usually referred to as the range parameter. This parameter must be
specified in the call to Krig and will not be estimated.
}
\section{References}{
See "Additive Models" by Hastie and Tibshirani, "Spatial Statistics" by    
Cressie and the FIELDS manual. 
}
\seealso{
summary.Krig, predict.Krig, predict.se.Krig, predict.surface.se,
predict.surface, plot.Krig,
surface.Krig 
}
\examples{
#2-d example 
# fitting a surface to ozone  
# measurements. Range parameter is 10 (in miles) 

fit <- Krig(ozone$x, ozone$y, exp.cov, theta=10)  
 
summary( fit) # summary of fit 
plot(fit) # diagnostic plots of fit  
surface( fit, type="C") # look at the surface 
out.p<- predict.surface.se( fit) 
image(out.p)

# predict at data

predict( fit)

# predict on a grid ( grid chosen here by defaults)
out<- predict.surface( fit)
persp( out)

# predict at arbitrary points (10,-10) and (20, 15)
xnew<- rbind( c( 10, -10), c( 20, 15))
predict( fit, xnew)

# standard errors of prediction based on covariance model.  
predict.se( fit, xnew)

#
# Roll your own: using a user defined Gaussian covariance 
#
test.cov <- function(x1,x2,theta){exp(-(rdist(x1,x2)/theta)**2)} 
# use this and put in quadratic polynomial fixed function 
fit.flame<- Krig(flame$x, flame$y, test.cov, m=3, theta=.5)
#
# note how range parameter is passed to Krig.   
# BTW:  GCV indicates an interpolating model (nugget variance is zero) 
#
# take a look ...
surface(fit.flame, type="I") 

# 
# Thin plate spline fit to ozone data using the radial 
# basis function as a generalized covariance function 
#
# p=2 is the power in the radial basis function (with a log term added for 
# even dimensions)
# If m is the degree of derivative in penalty then p=2m-d 
# where d is the dimension of x. p must be greater than 0. 
#  In the example below p = 2*2 - 2 = 2  
#
# See also the Fields function Tps

out<- Krig( ozone$x, ozone$y, rad.cov, m=2,  p=2, 
scale.type="range",decomp="WBW") # these last two options make sure the
                                 # the results with Tps are identical
# A Knot example

data(ozone2)
y16<- ozone2$y[16,] # there are some missing values! 
good<- !is.na( y16)
y<- y16[good] # Krig does not remove missing values. 
x<- ozone2$lon.lat[ good,]

#
# the knots can be arbitrary but just for fun find them with a space 
# filling design. Here we select  50 from the full set of 147 points
#
xknots<- cover.design( x, 50)$design # select 50 knot points

out<- Krig( x, y, knots=xknots,  rad.cov, m=2,  p=2,scale.type="range")

# Zee plot 
surface( out, type="C")
US( add=TRUE)
points( x, col=2)
points( xknots, cex=2, pch="O")

summary( out)
#
# note that that trA found by GCV is around 15 so 50>15  knots may be a 
# reasonable approximation to the full estimator. 
#
surface( out, type='C')
# obs and knots
points( x)
points( xknots, col=2)


# Correlation model example

# fit krig surface using a mean and sd function to standardize 
# first get stats from 1987 summer Midwest O3 data set 
# Compare the function Tps to the call to Krig given above 
# fit tps surfaces to the mean and sd  points.  
# (a shortcut is being taken here just using the lon/lat coordinates) 
data(ozone2)
stats.o3<- stats( ozone2$y)
mean.o3<- Tps( ozone2$lon.lat, c( stats.o3[2,]))
sd.o3<- Tps(  ozone2$lon.lat, c( stats.o3[3,]))

# Now use these to fit particular day ( day 16) 

y16<- ozone2$y[16,] # there are some missing values! 
good<- !is.na( y16) 
 
fit<- Krig( ozone2$lon.lat[good,], y16[good],exp.earth.cov, theta=353, 
mean.obj=mean.o3, sd.obj=sd.o3)
#
# the finale
surface( fit, type="I")
US( add=TRUE)
title("Estimated ozone surface")

  
}
\keyword{spatial}
% docclass is function
% Converted by Sd2Rd version 1.21.

\eof
\name{Tps}
\alias{Tps}
\title{
  Thin plate spline regression 
}
\description{
Fits a thin plate spline surface to irregularly spaced data. The 
smoothing parameter is chosen by generalized cross-validation. The assumed 
model is additive  Y = f(X) +e  where f(X) is a d dimensional surface. 
This is a special case of the spatial process estimate.   
}
\usage{
Tps
(x, Y, m = NULL, p = NULL, decomp = "WBW", scale.type = "range", ...)
}
\arguments{
To be helpful, a more complete list of arguments are described that are the 
same as those for the Krig function.  

\item{x}{
Matrix of independent variables. Each row is a location. 
}
\item{Y}{
Vector of dependent variables. 
}
\item{m}{
A polynomial function of degree (m-1) will be  
included in the model as the drift (or spatial trend) component. 
Default is the value such that 2m-d is greater than zero where d is the 
dimension of x. 
}
\item{p}{
Exponent for radial basis functions. Default is 2m-d. 
}
\item{decomp}{
Type of matrix decompositions used to compute the solution. Default is  
the more numerically stable   
"WBW" Wendelberger-Bates-Wahba. This is the strategy used in GCV pack.   
An alternative is "DR" Demmler-Reinsch. This must be used if one 
wants a reduced set of basis functions (specifying knots). 
}
\item{scale.type}{
The independent variables and knots are scaled to the specified 
scale.type. 
By default the scale type is "range", whereby 
the locations are transformed  
 to the interval (0,1) by forming (x-min(x))/range(x) for each x. 
Scale type of "user" allows specification of an x.center and x.scale by 
the 
user. The default for "user" is mean 0 and standard deviation 1. Scale 
type of "unscaled" does not scale the data.  
}
\item{\dots}{
Any argument that is valid for the Krig function. Some of the main ones
are listed below. 
\describe{
\item{lambda}{
Smoothing parameter that is the ratio of the error variance (sigma**2) 
to the scale parameter of the  
covariance function. If omitted this is estimated by GCV. 
}
\item{cost}{
Cost value used in GCV criterion. Corresponds to a penalty for  
increased number of parameters. 
}
\item{knots}{
Subset of data used in the fit. 
}
\item{weights}{
Weights are proportional to the reciprocal variance of the measurement  
error. The default is no weighting i.e. vector of unit weights. 
}
\item{return.matrices}{
Matrices from the decompositions are returned. The default is T.  
}
\item{nstep.cv}{
Number of grid points for minimum GCV search. 
}
\item{x.center}{
Centering values are subtracted from each column of the x matrix. 
Must 
have scale.type="user".
}
\item{x.scale}{
Scale values that divided into each column after centering. 
Must 
have scale.type="user".
}
\item{rho}{
Scale factor for covariance. 
}
\item{sigma2}{
Variance of errors or if weights are not equal to 1 the variance is
sigma**2/weight. 
}
\item{method}{
Character string specifiying the method for estimating the "smoothing"
parameter. The default is 'GCV' -- generalized corss-validation. 
}
\item{verbose}{
If true will print out all kinds of intermediate stuff.  
}
\item{cond.number}{
maximum size of condition number to allow when using DR decomposition. 
}
\item{mean.obj}{
Object to predict the mean of the spatial process. 
}
\item{sd.obj}{
Object to predict the marginal standard deviation of the spatial process. 
}
\item{yname}{
Name of y variable 
}
\item{return.X}{
If true returns the big X matrix used for the estimate.  
}
\item{null.function}{
An S function that creates the matrices for the null space model.  
The default is make.tmatrix, an S function that creates polynomial 
null spaces.  
}
\item{offset}{
The offset to be used in the GCV criterion. Default is 0. This would be 
used when Krig/Tps is part of a backfitting algorithm and the offset has
to be included  to reflect other model degrees of freedom. 
}
}
}
}
\value{
A list of class Krig. This includes the predicted surface of 
fitted.values and the residuals. The results of the grid 
search minimizing the generalized cross validation function is 
returned in gcv.grid. 
Please see the documentation on Krig for details of the returned 
arguments.  
}
\details{
A thin plate spline is result of minimizing the residual sum of 
squares subject to a constraint that the function have a certain 
level of smoothness (or roughness penalty). Roughness is 
quantified by the integral of squared m-th order derivatives. For one 
dimension and m=2 the roughness penalty is the integrated square of 
the second derivative of the function. For two dimensions the 
roughness penalty is the integral of  

        (Dxx(f))**22 + 2(Dxy(f))**2 + (Dyy(f))**22 

(where Duv denotes the second partial derivative with respect to u 
and v.) Besides controlling the order of the derivatives, the value of 
m also determines the base polynomial that is fit to the data. 
The degree of this polynomial is (m-1). 

The smoothing parameter controls the amount that the data is 
smoothed. In the usual form this is denoted by lambda, the Lagrange 
multiplier of the minimization problem. Although this is an awkward 
scale, lambda =0 corresponds to no smoothness constraints and the data 
is interpolated.  lambda=infinity corresponds to just fitting the 
polynomial base model by ordinary least squares.  

This estimator is implemented simply by feeding the right generalized 
covariance function based on radial basis functions to the more general 
function Krig. This is a different approach than the older version in 
FUNFITS (tps) and provides simpler coding. One advantage of this   
implementation is that once a Tps/Krig object is 
created the estimator can be found rapidly for other data and smoothing 
parameters  provided the locations remain unchanged. This makes simulation 
within R efficient (see example below).  
}
\section{References}{
See "Nonparametric Regression and Generalized Linear Models"  
by Green and Silverman. 
See "Additive Models" by Hastie and Tibshirani. 
}
\seealso{
Krig, summary.Krig, predict.Krig, predict.se.Krig, plot.Krig,  
\code{\link{surface.Krig}}, 
\code{\link{sreg}} 
}
\examples{
#2-d example 

fit<- Tps(ozone$x, ozone$y)  # fits a surface to ozone measurements. 
plot(fit) # diagnostic plots of  fit and residuals. 
summary(fit)

# predict onto a grid that matches the ranges of the data.  

out.p<-predict.surface( fit)
image( out.p) 
surface(out.p) # perspective and contour plots of GCV spline fit 
# predict at different effective 
# number of parameters 
out.p<-predict.surface( fit,df=10)

#1-d example 
out<-Tps( rat.diet$t, rat.diet$trt) # lambda found by GCV 
plot( out$x, out$y)
lines( out$x, out$fitted.values)

# 
# compare to the ( much faster) one spline algorithm 
#  sreg(rat.diet$t, rat.diet$trt) 
# 
#
# simulation reusing
fit<- Tps( rat.diet$t, rat.diet$trt)
true<- fit$fitted.values
N<-  length( fit$y)
temp<- matrix(  NA, ncol=50, nrow=N)
sigma<- fit$shat.GCV
for (  k in 1:50){
ysim<- true + sigma* rnorm(N) 
temp[,k]<- predict(fit, y= ysim)
}
matplot( fit$x, temp, type="l")


# 
#4-d example 
fit<- Tps(BD[,1:4],BD$lnya,scale.type="range") 
surface(fit)   
# plots fitted surface and contours 
#2-d example using a reduced set of basis functions 
r1 <- range(flame$x[,1]) 
r2 <-range( flame$x[,2]) 
g.list <- list(seq(r1[1], r1[2],6), seq(r2[1], r2[2], 6)) 
knots<- make.surface.grid(g.list) 
# these knots are a 6X6 grid over 
# the ranges of the two flame variables 
out<-Tps(flame$x, flame$y, knots=knots, m=3)   
surface( out, type="I")
points( knots)
}
\keyword{smooth}
% docclass is function
% Converted by Sd2Rd version 1.21.

\eof
\name{US}
\alias{US}
\title{
  Plot of the US with state boundaries 
}
\description{
Plots quickly, medium resolution outlines of the US with the states and 
bodies of water.  
}
\usage{
US( xlim=c(-124.7, -67.1), ylim = c(25.2, 49.4), add=FALSE,shift=FALSE, ...)
}
\arguments{

\item{ylim}{
range of latitudes 
}
\item{xlim}{
range of longitudes 
}
\item{add}{
If true will add the world map to current plot 
}
\item{shift}{ If TRUE shifts to be centered on the Dateline and longitude
runs from 0 to 360. If FALSE centers on Prime Meridian and longitude runs
from -180 to 180.}

\item{\dots}{
These are graphical arguments that are passed to the lines function that 
draws outline.  
}
}
\details{
This function uses the FIELDS dataset US.dat for the coordinates.   
}
\seealso{
world
}
\examples{
# Draw map in device color # 3 
US( col=3) 
}
\keyword{hplot}
% docclass is function
% Converted by Sd2Rd version 1.21.

\eof
\name{US.dat}
\alias{US.dat}
\title{
Outline of coterminous US and states.
}
\description{
This data set is used by the fields function US to draw a map. It is the
medium resolution outline that is produced by drawing the US from the maps
package.
}
\keyword{datasets}
% docclass is data
% Converted by Sd2Rd version 1.21.

\eof
\name{Wtransform}
\alias{Wtransform.image}
\alias{Wtransform}
\alias{Wtransform.cylinder.image}
\title{
  Quadratic W wavelet transform for 1-d vectors or  rectangular or 
cylindrical images 
}
\description{
Finds the forward or inverse discrete wavelet transform using the
quadratic W basis. 
}
\usage{
Wtransform(x, inv = FALSE, transpose = FALSE, cut.min = 8)

Wtransform.image(x, inv=FALSE, transpose=FALSE, cut.min=8)

Wtransform.cylinder.image(x, inv=FALSE, transpose=FALSE, 
byX=TRUE,cut.min=8)

}
\arguments{
\item{x}{
Matrix to be transformed. For Wtransform the number of rows must be 
dyadic or m=p*2\^L where p is lees than or equal to cut.min. A 1-d 
transformation is effected on each column of x. 
For 
the 2-d transforms both the row and the column dimensions must 
satisfy this condition. A 2-d transformation is applied to the image.  

}
\item{inv}{
If true will compute the inverse transform default is false  
}
\item{transpose}{
If true will compute the transpose of transform default is false 
}
\item{cut.min}{
Minimum level of transformation.  cut.min=8 means that the coarsest level
will consist of 8 scale functions for the 1-d case and 64=8X8 scale 
functions centered on an 8X8 grid for the 2-d case.  
}
\item{byX}{
If TRUE enforces periodic boundary conditions on horizontal coordinate 
of the image and if FALSE
applies condition to vertical coordinate. (See details.)
}
}
\value{
A matrix the same size as x.   
}
\details{
The wavelet transform can be thought as matrix multiplication 
W \%*\% vec(x)  where vec(x) is the matrix x  stacked by columns.  
The inverse transform is  inv(W) \%*\% vec(x) and transpose is  
 t(W) \%*\% vec( x). One can interpret the columns of inv(W) as basis 
functions 
and they follow the usual pattern of translations and dilations of mother 
and father wavelets. (See example below.)


Another way of thinking of the transformation is by recursion:  apply a
smoother and a "rougher" to a vector and taking every other value. Now
apply the same operation to the smooth results, now half the length of the
previous vector. At each step one reduced the vector by a half and cut.min
specifies the size when to stop. The function \code{WQS} performs one step
of the recursion with smoother weights (-1, 3, 3, -1) and roughening
weights (-1, 3, -3, 1) away from the edges. \code{WQS} actually works for
a matrix where each column is transformed in this manner. Boundary
adjustments are made to preserve the shape of the basis functions. (See
example below.) By convention the returned matrix has the smoothed results
in the first half of the columns and the rough results in the second half.
The discrete wavelet transform performs this operation recursively on the
smoothed results until the smoothed vector is less than a set size.
Because each step reduces the size of the vector by 2 it only makes sense 
to
apply this algorithm to vectors whose length is dyadic or the product 
of a
small integer and a dyadic (e.g. 96=3*32). The precise tests are done by 
\code{dyadic.check} and \code{dyadic.2check} and if n is the dimension the 
constraint it that n=p*2\^L where L is less or equal to than cut.min. 
The 
transform will result in p scale (father) basis functions if cut.min is 
equal to p. 


At the end of the day this
recursive algorithm defines a linear transformation of the original image
to something that we call the wavelet decomposition. This is the full
matrix W mentioned above. It is also possible to express multiplication of
inv(W) and transposes by a similar recursive scheme and related sets of
filter weights. (Try \code{ WQSi( WQS(x))} as a test.) The reader is
referred to \code{WQSi} \code{WQS.T} and \code{WQSi.T} for the filtering
primitives. Finally it should be noted that the particular wavelets chosen
here are not orthogonal by have nice smooth properties and the father
wavelet resembles a Gaussian density while the mother looks like its
derivative.  (See example below for some plots of the implied basis
functions.)
Note that \code{Wtransform} is "vectorized" so that with little extra 
overhead one 
can do transforms for many separate 1-d series with one call. 
In particular, \code{Wtransform(diag(1,128),inv=TRUE)} will neatly 
generate the W matrix given above. 

For two dimensions for the basic step one applies WQS to
the columns of the matrix and then to the rows.  e.g.  
\code{t(WQS(t(WQS(x)))}. This primitive step is implemented in WQS2d. The
final algorithm calls WQS2d or its variants repeatedly on a matrix that
decreases by a factor of two in size along each dimension at each 
iteration.  


If the cylinder variant is specified the transform uses periodic
boundaries on one of the coordinates. This is useful for data on zonal
section of a sphere where a constant line of latitude should be periodic.  
For byX=T the wavelet basis functions wrap on the x-axis when an image
plot is made. (See example below.) This convention may cause some
confusion because R experts will know that the image plot rotates the the
matrix so that the (1,1) element is at the lower left corner. Thus
enforcing periodicity along the X-coordinate of the image pertains to the
columns of the matrix used to represent the image in R. (Compare
\code{matrix( 1:10,2,5)} to \code{image( matrix( 1:10,2,5))}.

}
\section{References}{
Nychka,D. , C. Wikle and J.A. Royle, (2002)  Multi-resolution models for
nonstationary spatial covariance functions Statistical Modelling 2
315-332.
}
\seealso{
plot.coef, WQS, WQSi, Wtransform.D  
}
\examples{
# W transform of a simple function
x<- seq( 0,1,256)
y<- x*(1-x)**3 + ifelse( x>.3, x,0)

Wtransform( y)-> out

# plot the implied wavelet basis functions
ID<- diag( 1, 256)
WQS.basis( 256)-> Wbasis
set.panel(2,2)
matplot( 1:256, Wbasis[,1:8], type="l", lty=c(1,2), col=2)
title("Father")
matplot( 1:256, Wbasis[,9:16], type="l", lty=c(1,2), col=2)
title("Mother")
matplot( 1:256, Wbasis[,17:32], type="l", lty=c(1,2), col=2)
title("Mother scaled by 2")
matplot( 1:256, Wbasis[,33:64], type="l", lty=c(1,2), col=2)
title("Mother scaled by 4")

# test that the transform works


# Precise definition of what the transform is doing in terms of 
# explicit matrix multiplication  all of 
# these should be machine zero
# Note that the direct matrix multiplications will be substantially slower
# for large vectors.
# y<- rnorm( 256)
# y<- y /sqrt(mean( y**2))


#sqrt(mean( c( Wtransform(y, inv=TRUE) - Wbasis%*%y)**2))
#sqrt(mean( c(Wtransform(y, inv=TRUE, transpose=TRUE) - t(Wbasis)%*%y)**2))
#sqrt(mean( c(Wtransform(y) - solve(Wbasis)%*%y)**2))
#sqrt(mean( c(Wtransform(y, transpose=TRUE) - t(solve(Wbasis))%*%y)**2))

#
## 2-d examples
#


# Wtransform of John Lennon image
data(lennon)
look<- Wtransform.image( lennon)
# 
### take a look: 
# image.plot( look)
#threshhold 
thr<-  quantile( abs( look), .95)
temp<- look
temp[abs(look)< thr] <- 0
look2<- Wtransform.image( temp, inv=TRUE)
# 
### take a look: 
# image( look2) # 95 \% compressed image

 
# a diagonal detail basis function 
# we find this by just multipling W by a unit vector!

temp<- matrix(0, nrow=32, ncol=32) 
temp[8,5]<- 1 
look<- Wtransform.image( temp , inv=TRUE, cut.min=4)
image( look)
title("diagonal detail W-wavelet")

#just for fun: redo this example for all indices up to 8!
#
#set.panel( 8,8)
#par( mar=c(0,0,0,0))
#for (  k in (1:8)){
#for ( j in (1:8)){
#temp<- matrix( 0 , nx,ny)
#temp[k,j] <- 1
#Wtransform.image( temp, inv=T, cut.min=cut.min)-> look
#image( look, axes=FALSE, xlab="", ylab="")
#box()
#}
#}


# examine a basis function to see periodic condition enforces along 
# X axis of image. 
temp<- matrix(0, nrow=32, ncol=32)
temp[8,5]<- 1
image( Wtransform.cylinder.image( temp , inv=TRUE, cut.min=4))
# now along Y-axis
image( Wtransform.cylinder.image( temp , inv=TRUE, cut.min=4, byX=FALSE))


}
\keyword{spatial}
% docclass is function
% Converted by Sd2Rd version 1.21.

\eof
\name{Wtransform.sim}
\alias{Wtransform.sim}
\title{
  Simulates a 2-d random wavelet field  
}
\description{
Generates a Gaussian field using quadratic W transform basis functions.   
}
\usage{
Wtransform.sim(D, cut.min=16)
}
\arguments{
\item{D}{
A matrix the same size as the image with the variances of the  
wavelet coefficients.   
}
\item{cut.min}{
Coarsest level of resolution in wavelet expansion this set the number of 
smooth basis functions.  
}
}
\value{
A  matrix image of the random field 
}
\section{Side Effects}{

}
\details{
The simulation is easy just an inverse transform applied to weighted 
independent normals. 
The tricky part is getting all the values of D in the right places.  
See plot.coef to plot out the elements of D to check them and also  
Wtransform.D to fill D from variances that are fixed at each level of 
resolution.  
}
\seealso{
Wtransfrom.image, W.image.cov  
}
\examples{
# 
#Fill to look like Gaussian. 
# 
 wght <- c(1., 0.05, 1e-07, 1e-09, 1e-11, 1e-14) 
D<- Wtransform.D(32,32, wght, cut.min=4)$D 
set.panel( 2,2)
for ( k in 1:4){
look<- Wtransform.sim( D, cut.min=4) 
image( look)
}
set.panel( 1,1)

}
\keyword{spatial}
% docclass is function
% Converted by Sd2Rd version 1.21.

\eof
\name{arrow.plot}
\alias{arrow.plot}
\title{
  Adds arrows to a plot
}
\description{
Adds arrows at specified points where the arrow lengths are scaled to
fit on 
the plot in a reasonable manner. A classic use of this function is to
depict a vector field. At each point (x,y) we have a vector with
components (u,v).  Like the arrows function this adds arrows to an 
existing plot.  
}
\usage{
arrow.plot(a1, a2, u = NA, v = NA, arrow.ex = 0.05,  
     xpd = TRUE, true.angle = FALSE, ...)
}
\arguments{
\item{a1}{
The x locations of the tails of the arrows or a  2 column matrix giving 
the x and y coordinates of the arrow tails. 
}
\item{a2}{
The y locations of the tails of the arrows or a 2 column matrix giving  
the u and v coordinates of the arrows. 
}
\item{u}{
The u components of the direction vectors if they are not specified in 
the a2 argument 
}
\item{v}{
The v  components of the direction vectors if they are not specified in     
the a2 argument 
}
\item{arrow.ex}{
Controls the length of the arrows. The length is in terms of the fraction 
of the shorter axis in the plot. So with a default of .05 20 arrows  
of maximum length can line up end to end along the shorter axis. 
}
\item{xpd}{
If true does not clip arrows to fit inside the plot region, default is 
not to clip. 
}
\item{true.angle}{
If true preserves the true angle of the (u,v) pair on the plot. E.g. if  
(u,v)=(1,1) then the arrow will be drawn at 45 degrees.  
}
\item{\dots}{
Graphics arguments passed to the arrows function that can can change the 
color or arrow sizes. See help on this for 
details. 
}
}
\details{
This function is useful because (u,v) may be in very different scales
from the locations (x,y). So some careful scaling is needed to plot the
arrows. 
The only tricky thing about this function is whether you want the true 
angles on the plot. For overlaying a  vector field on top of contours 
that are the streamlines  true.angle should be false. In this case you 
want u and v to be scaled in the same way as the x and y variables.  
If the scaling is not the same then the arrows will not look like tangent 
vectors to the streamlines.  
An application where the absolute angles are meaningful might be the hands of a 
clock showing different times zones on a world map. Here true.angle=T is
appropriate, the clock hands should preserve the right angles. 
}
\seealso{
\code{\link{arrows}} 
}
\examples{
#
# 20 random directions

x<- runif( 20)
y<- runif( 20)
u<- rnorm( 20)
v<- rnorm( 20)
plot( x,y)
arrow.plot( x,y,u,v, length=.05, col=3)
}
\keyword{aplot}
% docclass is function
% Converted by Sd2Rd version 1.21.

\eof
\name{as.image}
\alias{as.image}
\title{
  Creates image from irregular x,y,z  
}
\description{
Discretizes a set of  2-d locations to a grid and produces a image object  
with the z values in the right cells. For cells with more than one Z
value the average is used.   
}
\usage{
as.image(Z, ind, grid=NULL, x=NULL, nrow=64, ncol=64,weights=rep( 1,
length(Z)), na.rm=TRUE)
}
\arguments{
\item{Z}{
Values of image 
}
\item{ind}{
A matrix giving the row and column subscripts for each image 
value in Z. (Not needed if x is specified.) 
}
\item{grid}{
A list with components x and y of equally spaced values describing the 
centers of the grid points. The default is to use nrow and ncol and the 
ranges of the data locations (x)  to construct a grid.  
}
\item{x}{
Locations of image values. Not needed if  ind  is specified.  
}
\item{nrow}{
Number of rows in image matrix ( x-axis direction) 
}
\item{ncol}{
Number of columns in image matrix ( y-axis direction) 
}
\item{weights}{
If two or more values fall into the same  
pixel a weighted average is used to represent the pixel value. Default is 
equal weights. 
}
\item{na.rm}{ 
If true NA's are removed from the Z vector.}
}
\value{
An list in image format with a few more components. Components x and y are 
the grid values , z is a 
nrow X ncol matrix 
with the Z values. NA's are placed at cell locations where Z data has 
not been supplied.  
Component ind is a 2 column matrix with subscripts for the locations of 
the values in the image matrix.  
Component N is an image matrix with the number of original values that 
fall within each grid box. 
Component weights is an image matrix with the  sum of the
individual weights for each cell.  
}
\details{
The discretization is straightforward once the grid is determined.  
If two or more Z values have locations in the same cell the average value 
is 
taken as the value.  See the source code to modify this to get more 
information about coincident locations. (See the call to fast.1way) 
}
\seealso{
image.smooth, image.plot, Krig.discretize, Krig.replicates, image.count  
}
\examples{
# convert precip data to 50X50 image  
look<- as.image( precip$y, x= precip$x, nrow=50, ncol=50)
image.plot( look) 

# number of obs in each cell.
image.plot( look$x ,look$y, look$N, col=terrain.colors(50)) 
# hot spot is around Denver
}
\keyword{manip}
% docclass is function
% Converted by Sd2Rd version 1.21.

\eof
\name{as.surface}
\alias{as.surface}
\title{
  Creates an "surface" object from grid values. 
}
\description{
Reformats the vector from evaluating  a function on a grid of points into 
a list for use with surface plotting function. The list has the
usual components x,y and z and is suitable for use with persp, contour,
image and image.plot.
 
}
\usage{
as.surface(grid.list, z, order.variables="xy")
}
\arguments{
\item{grid.list}{
A description of the grid used to evaluate the function. This can 
either be in the form of a grid.list 
( see help file for grid.list) or the matrix of grid of points produced 
by make.surface.grid 
}
\item{z}{
The value of the function evaluated at the gridded points. 
}
\item{order.variables}{
Either "xy" or "yx" specifies how the x and y variables used to 
evaluate the function are matched with the x and y grids in the surface 
object. 
}
}
\value{
A list of class surface. This object is a modest generalization of the 
list input format (x,y,z,) for the S functions contour, image or persp.  

\item{x}{
The grid values in the  X-axis
}
\item{y}{
The grid values in the  Y-axis
}
\item{z}{
A matrix of dimensions nrow= length of x and ncol= length of y with
entries being the  grid point value reformatted from z. 
}
}
\details{
This function was written to simply to go back and forth between a
matrix of gridded values and the stacked vector obtained by stacking
columns. The main application is evaluating a function at each grid point
and then reforming the results for plotting. (See example below.)

If zimage is matrix of values then the input vector is c( zimage).
To go from the stacked vector to the matrix one needs the the nrow ncol
and explains why grid information must also be specified.
 
Note that the z input argument must be in the order 
values in order of stacking columns of the image. This is also the
order of the grid points generated by make.surface.grid.

To convert irregular 2-d data to a surface object where there are missing
cells see the function as.image. 
}
\seealso{
 grid.list, make.surface.grid, surface, contour,
image.plot, as.image 
}
\examples{
 

# Make a perspective of the surface Z= X**2 -Y**2 
# Do this by evaluating quadratic function on a 25 X 25 grid
  
grid.l<-list( X= seq( -2,2,,25), Y= seq( -2,2,,25)) 
xg<-make.surface.grid( grid.l)
# xg is a 625X2 matrix that has all pairs of X and Y grid values 
z<- xg[,1]**2 - xg[,2]**2  
# now fold z in the matrix format needed for persp 
out.p<-as.surface( xg, z) 
persp( out.p) 
# also try  plot( out.p) to see the default plot for a surface object 
}
\keyword{manip}
% docclass is function
% Converted by Sd2Rd version 1.21.

\eof
\name{bplot}
\alias{bplot}
\title{
  boxplot  
}
\description{
Plots boxplots of several groups of data
and allows for placement at different horizontal or vertical positions. It
is also flexible in the input object accepting either a list or matrix.
}
\usage{
bplot(x, by,style = "tukey", outlier = TRUE, plot = TRUE, ...)
}
\arguments{
\item{x}{
Vector, matrix,  list or data frame. A vector may be divided according
to the by argument. Matrices and data frames are separated by columns and
lists by components.   
}
\item{by}{
If x is a vector, an optional vector (either character or numerical)
specifying the categories to divide x into separate data sets.
}
\item{style}{
Type of boxplot default is "tukey". The other choice is "quantile" where
the whiskers are drawn to the 5 and 95 percentiles instead being based on
the inner fences. 
 
}
\item{outlier}{
If true outliers (points beyond outer fences) will be added to the plots. 
}
\item{plot}{
If false just returns a list with the statistics used for plotting the
box plots. 
}
\item{\dots}{
Other arguments controlling the boxplots ( passed to
bplot.obj) these are
listed below. Other graphical plotting arguments not matched (e.g. yaxt)
are used in the call to plot to set up the initial plot if add=T. 
 \describe{
\item{pos}{
The boxplots will be plotted vertically and pos gives the x or y locations
for their centers. If omitted the boxes are equally spaced at integer  
values.  
}
\item{width}{
Width of boxplots (in user coordinates) if omitted then the width is a
reasonable fraction of the  
distance between boxes and is set by the space argument. 
}
\item{labels}{
Labels under each boxplot. If missing the columns names or components of  
x are used.  
}
\item{srt}{
Rotate the labels (srt=90 makes them vertical). Default is to put them
horizontal. Sometimes long
labels run into each if they are horizontal.   
}
\item{add}{
If true, do not create a new plots just add the boxplots to a current
plot. Note  
that the pos argument may be useful in this case and should be in the
user coordinates of the parent plot.  
}
\item{space}{
Space between boxplots.  
}
\item{sort.names}{
If true plot the boxplot data set names are sorted in alphabetic order by
their labels.  
}
\item{xlab}{
Label for the x-axis 
}
\item{ylab}{
Label for the y-axis 
}
\item{label.cex}{
Boxplot label  size where 1.0 is  normal size characters.
If zero labels will not be added.  
}
\item{xaxt}{
Plotting parameter for x-axis generation. Default is not to produce
an x-axis. 
}
\item{horizontal}{
If true draw boxplots horizontally the default is false, produce
vertical box plots. 
}
}
}
}
\details{
This function was created as a complement to the usual S function for  
boxplots. The current function makes it possible to put the boxplots at  
unequal x or y positions. This is useful for visually grouping a large
set of  
boxplots into several groups. Also placement of the boxplots with  
respect to the axis can add information to the plot.  Another aspect  
is the emphasis on data structures for groups of data. One useful  
feature is the by option to break up the x vector into distinct  groups.   
If 5 or less observations are in a group the points themselves are  
plotted instead of a box.   

The function is broken into two steps: a call to stats.bplot to find the
statistics and a call to bplot.obj to plot the resulting object. 
The user is referred to describe.bplot to modify the statistics used and 
to draw.bplot.obj to modify how the bplot is drawn.

Finally to bin data into groups based on a continuous variable and to make
bplots of each group see bplot.xy. 
}
\seealso{
describe.bplot, draw.bplot.obj, stats.bplot, bplot.xy, bplot.obj
}
\examples{
#
set.seed(123)
temp<- matrix( rnorm(12*8), ncol=12)
pos<- c(1:6,9:14)
bplot(temp)
#
bplot( temp, pos=pos, labels=paste( "D",1:12), horizontal=TRUE)
#
bplot( temp, pos=pos, label.cex=0, horizontal=TRUE)
# add an axis
axis( 2)
}
\keyword{hplot}
% docclass is function
% Converted by Sd2Rd version 1.21.

\eof
\name{bplot.xy}
\alias{bplot.xy}
\title{
  Boxplots for conditional distribution 
}
\description{
Draws boxplots for y by binning on x. This gives a coarse, but quick,  
representation
of the conditional distrubtion of [Y|X] in terms of boxplots.  
}
\usage{
bplot.xy(x, y, N = 10, breaks = pretty(x, N), style = "tukey", 
    outlier = TRUE, plot = TRUE, xaxt = "s", ...)
}
\arguments{
\item{x}{
Vector to use for bin membership
}
\item{y}{
Vector to use for constructing boxplot statistics. 
}
\item{N}{
Number of bins on x. Default is 10.
}
\item{breaks}{
Break points defining bin boundaries. These can be unequally spaced. 
}
\item{style}{
Type of boxplot default is "tukey". The other choice is "quantile" where
the whiskers are drawn to the 5 and 95 percentiles instead being based on
the inner fences.
}
\item{xaxt}{
 
Plotting parameter for x-axis generation. Default is to produce
an x-axis.
}
\item{outlier}{
If true outliers (points beyond outer fences) will be added to the plots.
}
\item{plot}{
If false just returns a list with the statistics used for plotting the
box plots.
}
\item{\dots }{
Any other optional arguments passed to the bplot.obj function see the
help file for bplot for details. 
}
}
\seealso{
bplot, draw.bplot
}
\examples{
# condition on swim times to see how run times vary
bplot.xy( minitri$swim, minitri$run, N=5)

# bivariate normal corr= .6
set.seed( 123)
x<-rnorm( 1000)
y<- .6*x +  sqrt( 1- .6**2)*rnorm( 1000)
#
#
bplot.xy( x,y, breaks=seq( -3, 3,,15) ,xlim =c(-4,4), ylim =c(-4,4))
points( x,y, pch=".", col=3)
}
\keyword{hplot}
% docclass is function
% Converted by Sd2Rd version 1.21.

\eof
\name{cover.design}
\alias{cover.design}
\title{
  Computes Space-Filling "Coverage" designs using Swapping Algorithm 
}
\description{
Finds the set of points on a discrete grid (Candidate Set) which
minimize a geometric space-filling criterion. The strength of this method
is that the candidate set can satisfy whatever constraints are important
for the problem. 
}
\usage{
cover.design(R, nd, nruns = 1, nn = TRUE, num.nn = 100, fixed = NULL, 
    scale.type = "unscaled", R.center, R.scale, P = -20, Q = 20,
    start = NULL, DIST = NULL, return.grid = TRUE, return.transform = 
TRUE, max.loop=20, verbose=FALSE)
}
\arguments{
\item{R}{
A matrix of candidate points to be considered in the design.
Each row is a separate point.
}
\item{nd}{
Number of points to add to the design. If points exist and are to 
remain in the design (see "fixed" option), nd is the number of points 
to add. If no points are fixed, nd is the design size. 
}
\item{nruns}{
The number of random starts to be optimized. Uses random starts unless 
"start" is specified. If nruns is great than 1, the final results are  
the minimum.
}
\item{nn}{
Logical value specifying whether or not to consider only nearest 
neighbors in the swapping algorithm. When nn=FALSE, then the swapping 
algorithm will consider all points in the candidate space. When nn=TRUE, 
then the swapping algorithm will consider only the num.nn closest 
points for possible swapping. The default is to use nearest neighbors 
only (nn=TRUE). 
}
\item{num.nn}{
Number of nearest-neighbors to search over. The default number is 100. 
If nn=F then this argument will be ignore. 
}
\item{fixed}{
A matrix or vector specifying points to be forced into the 
experimental design. If fixed is a matrix, it gives coordinates of the 
fixed points in the design. In this case fixed must be a subset of 
R. If fixed is a vector, then fixed gives the row numbers from the 
candidate matrix R that identify the fixed points. The number of 
points to be generated, nd, is in addition to the number of points
specified by fixed. 
}
\item{scale.type}{
A character string that tells how to scale the candidate matrix, R, 
before calculating distances. The default is "unscaled", no
transformation is done.
Another option is "range" in which case
variables are scaled to a [0,1] range before applying any distance
functions. Use "unscaled"  when all of the columns of R 
are commensurate; for example, when R gives x and y in spatial 
coordinates. When the columns of R are not in the same units, then it is
generally thought that an appropriate choice of scaling will provide a 
better design. This would be the case, for example, for a typical 
process optimization. Other choices for scale.type are 
"unit.sd", which scales 
all columns of R to have 0 mean and unit standard deviation, and 
"user", which allows a user specified scaling (see R.center and R.scale
arguments). 
}
\item{R.center}{
A vector giving the centering values if
scale.type=\code{user}.
}
\item{R.scale}{
A vector giving the scale values if scale.type=\code{user}. 
}
\item{P}{
The "p" exponent of the coverage criterion (see below). It
affects how the distance from a point x to a set of design points D is 
calculated.  P=1 gives average distance. P=-1 gives harmonic mean distance. 
P=-Inf would give minimum distance (not available as a value). As P gets 
large and negative, points will tend to be more spread out. 
}
\item{Q}{
The "q" exponent of the coverage criterion (see below).It
affects how distances from all points not in the design to points in the 
design are averaged. When Q=1, simple averaging of the distances is employed. 
Q=Inf (not available as a value) in combination with P=-Inf would give a 
classical minimax design. 
}
\item{start}{
A matrix or vector giving the initial design from which to start 
optimization. If start is a matrix, it gives the coordinates of the 
design points. In this case start must be a subset of the candidate set , R matrix.
If start is a
vector, then start gives the row numbers of the initial design based on the rows of the
candidate matrix rows. The
default is to use a random starting design. 
}
\item{DIST}{
This argument is only for cover.design.S. 
A distance metric in the form of an S function. Default is Euclidean
distance (FIELDS rdist function)
See details
and example below for the correct form.
}
\item{return.grid}{
Logical value that tells whether or not to return the candidate matrix 
as an attribute of the computed design. The default is return.grid=T. 
If false this just reduces the returned object size. 
The candidate matrix is used by plot.spatial.design if it is available. 
}
\item{return.transform}{
Logical value that tells whether or not to return the transformation  
attributes 
of candidate set. The default is return.transform=T. 
}
\item{max.loop}{
Maximum number of outer loops in algorithm. This is the maximum number of 
passes through the design testing for swaps. 
}
\item{verbose}{
If TRUE prints out debugging information.
}

}
\value{
Returns a design object of class "spatial.design".
Subscripting this object has the same effect as subscripting the first
component (the design).  The returned list has the following
components:

\item{design}{
The best design in the form of a matrix.
}
\item{best.id}{
Row numbers of the final design from the original candidate matrix, R. 
}
\item{fixed}{
Row numbers of the fixed points from the original candidate matrix, R. 
}
\item{opt.crit}{
Value of the optimality criterion for the final design. 
}
\item{start.design}{
Row numbers of the starting design from the original candidate matrix, R. 
}
\item{start.crit}{
Value of the optimality criterion for the starting design. 
}
\item{history}{
The swapping history and corresponding values of the optimality 
criterion for the best design. 
}
\item{other.designs}{
The designs other than the best design generated when nruns is
greater than 1. 
}
\item{other.crit}{
The optimality criteria for the other designs when nrun is greate
than 1. 
}
\item{DIST}{
The distance function used in calculating the design criterion. 
}
\item{nn}{
Logical value for nearest-neighbor search or not. 
}
\item{num.nn}{
The number of nearest neighbor set. 
}
\item{grid}{
The matrix R is returned if the argument return.grid=T. 
}
\item{transform}{
The type of transformation used in scaling the data and the values 
of the centering and scaling constants if the argument return.transform=T. 
}
\item{call}{
The calling sequence. 
}
\item{P}{
The parameter value for calculating criterion. 
}
\item{Q}{
The parameter value for calculating criterion. 
}
\item{nhist}{
The number of swaps performed. 
}
\item{nloop}{
The number of outer loops required to reach convergence if nloop is less 
the max.loop. 
}
\item{minimax.crit}{
The minimax design criterion using DIST. 
}
\item{max.loop}{
The maximum number of outer loops. 
}
}
\details{

OTHER DISTANCE FUNCTIONS:
You can supply an R/S-function to be used as the
distance metric. The expected calling sequence for this distance function
is
function( X1,X2)\{....\} where X1 and X2 are matrices with coordinates as
the rows. The returned value of this function should be the pairwise
distance  matrix. If nrow( X1)=m and nrow( X2)=n then the function should
return an m by n matrix of all distances between these two sets of points.
See the example for Manhattan distance below. 

The candidate set and DIST function can be flexible and the last
example
below using sample correlation matrices is an example. 

COVERAGE CRITERION:
For nd design points  in the set D and nc candidate points ci in the
set C, 
the coverage criteria is defined as:

M(D,C) =  [sum(ci in C) [sum(di in D) (dist(di,ci)**P]**(Q/P)]**(1/Q)

        
Where P, less than  0, and Q, greater than 0, are parameters.
The algorithm used in
"cover.design" to find the set of nd points in C that minimize this 
criterion is an iterative swapping algorithm which will be described 
briefly. The resulting design is referred to as a "coverage design" 
from among the class of space-filling designs. If fixed points are
specified they are simply fixed in the design set and are not allowed to be
swapped out.

ALGORITHM:
 An initial set of nd points is chosen randomly  
if no starting 
configuration is provided. The nc x nd distance matrix between the 
points in C and the points in D is computed, and raised to the power P. 
The "row sums" of this matrix are computed.  Denote these as rs.i and 
the vector of row sums as rs.  Using rs, M(D,C) is computed as:

  [sum i (rs.i)**(Q/P)]**(1/Q)

Note that if point d.i is "swapped" for point c.j, one must 
only recompute 1 column of the original distance matrix, and 1 row. 
The row elements not in the ith column will be the same for all j and 
so only need computing when the first swapping occurs for each d.i . 
Denote the sum of these off-i elements as "newrow(i)".  The index is 
i here since this is the same for all rows (j=1,...nc). 
Thus, for each swap, the row sums vector is updated as 

  rs(new) = rs(old) - column(i,old) + column(i,new) 

And the jth element of rs(new) is replaced by: 

  rs(new)[j] = column(i,new)[k] + newrow(i) 

Finally, M(D,C) is computed for this swap of the ith design point 
for the jth candidate point using [2].  The point in C that when 
swapped produces the minimum value of M(D,C) replaces d.i. 
This is done for all nd points in the design, and is iterated until 
M(D,C) does not change. 
When the nearest neighbor option is selected, then the points 
considered for swapping are limited to the num.nn nearest neighbors 
of the current design point. 

STABILITY

The algorithm described above is guaranteed to converge.  However, upon
convergence, the solution is sensitive to the initial configuration of
points.  Thus, it is recommended that multiple optimizations be done (i.e.
set nruns greater than 1 ).  Also, the quality of the solution depends on
the density of the points on the region.  At the same time, for large
regions , optimization can be computationally prohibitive unless the
nearest neighbor option is employed. 

}
\section{References}{
Johnson, M.E., Moore, L.M., and Ylvisaker, D. (1990).  Minimax and 
maximin distance designs. Journal of Statistical Planning and 
Inference 26, 131-148. 
SAS/QC Software. Volume 2: Usage and Reference. Version 6. First 
Edition (1995). "Proc Optex". SAS Institute Inc. SAS Campus Drive, 
}
\seealso{
rdist, rdist.earth
}
\examples{
##
## 
# first generate candidate set
set.seed(123) # setting seed so that you get the same thing I do!
test.df <- matrix( runif( 600), ncol=3)

test1.des<-cover.design(R=test.df,nd=10)

summary( test1.des)
plot( test1.des)

#
candidates<- make.surface.grid( list( seq( 0,5,,20), seq(0,5,,20)))
out<- cover.design( candidates, 15)

# find 10 more points keeping this original design fixed

out3<-cover.design( candidates, 10,fixed=out$best.id)
# see what happened

plot( candidates[,1:2], pch=".")
points( out$design, pch="x")
points( out3$design, pch="o")    

# here is a strange graph illustrating the swapping history for the
# the first design. Arrows show the swapping 
#at each pass through the design.

h<- out$history
cd<- candidates
plot( cd[,1:2], pch=".")
points( out$design, pch="O", col=2)
points( out$start.design, pch="x", col=5)  

arrows(
cd[h[,2],1],
cd[h[,2],2],
cd[h[,3],1],
cd[h[,3],2],length=.1)
text( cd[h[,2],1],
cd[h[,2],2], h[,1], cex=1.0 )
                               

#
# try this out using "Manhattan distance"
#  ( distance following a grid of city streets)

dist.man<- function(x1,x2) {
            d<- ncol( x1)
            temp<- abs(outer( x1[,1], x2[,1],'-'))
            for ( k in 2:d){
               temp<- temp+abs(outer( x1[,k], x2[,k],'-'))
            }
            temp }

# use the design from the Euclidean distance as the starting
#configuration.

cover.design( candidates, 15, DIST=dist.man, start= out3$best.id)-> out2
# this takes a while ...
plot( out2$design)
points( out3$design, col=2)

# find a design on the sphere
#

candidates<- make.surface.grid( list( x=seq( -180,180,,20), y= seq( -85,
85,,20)))

out4<-cover.design( candidates, 15, DIST=rdist.earth)
# this takes a while 

plot( candidates, pch=".")
points(out4$design, pch="o", col=3)

# covering based on correlation for 153 ozone stations
#
data( ozone2)

cor.mat<-cor( ozone2$y, use="pairwise")

cor.dist<- function( x1,x2)
{matrix( 1-cor.mat[ x1,x2], ncol=length(x2))}

#
# find 25 points out of the 153
# here the "locations" are just the index but the distance is 
# determined by the correlation function. 
#
out5<-cover.design(cbind(1:153),25, DIST= cor.dist, scale.type="unscaled") 

plot( ozone2$lon.lat, pch=".")
points(  ozone2$lon.lat[out5$best.id,],pch="O", col=4)
#
# this seems a bit strange probably due some funny correlation values
#
 
}
\keyword{spatial}
% docclass is function
% Converted by Sd2Rd version 1.21.

\eof
\name{exp.cov}
\alias{exp.cov}
\title{
  Exponential, Gaussian and "power" covariance family 
}
\description{
Given two sets of locations computes the cross covariance matrix for
covariances among all pairings. 
}
\usage{
exp.cov(x1, x2, theta = rep(1, ncol(x1)), p = 1, C = NA)
}
\arguments{
\item{x1}{
Matrix of first set of locations where each row gives the coordinates of a
particular
point.
}
\item{x2}{
Matrix of second set of locations where each row gives the coordinates of
a particular point. If this is missing x1 is used. 
}
\item{theta}{
Range (or scale) parameter. This can be a scalar or a vector that is the
same length as the dimension of the locations. Default is theta=1.
}
\item{p}{
Exponent in the exponential form. p=1 gives an exponential and p=2 gives a
Gaussian. Default is the exponential form.
}
\item{C}{
A vector with the same length as the number of rows of x2. 
If specified the covariance matrix will be multiplied by this vector.
}
}
\value{
If the argument C is NULL the cross covariance matrix. Moreover if x1 is
equal to x2 then this is the covariance matrix for this set of locations. 
In general if nrow(x1)=m and nrow(
x2)=n then the returned matrix, Sigma will be mXn. 

If C is a vector of length n,  
then returned value is the multiplication of the cross covariance matrix
with this vector:  Sigma\%*\%C 
}
\details{
Functional Form: If x1 and x2 are matrices where nrow(x1)=m and nrow(
x2)=n then this
function should return a mXn matrix where the (i,j) element is the
covariance between the locations x1[i,] and x2[j,]. The
covariance is found as  exp( -(D.ij **p)) where  D.ij is the Euclidean
distance between  x1[i,] and x2[j,] but having first been scaled by theta.
Specifically 

D.ij = sqrt(  sum.k (( x1[i,k] - x2[j,k]) /theta[k])**2 ).

Note that if theta is a scalar then this defines an isotropic covariance
function. 

Implementation: The function r.dist is a useful FIELDS function that finds
the cross
distance matrix ( D defined above) for two sets of locations. Thus in
compact S code we have  

u <- t(t(x1)/theta)

v <- t(t(x2)/theta)

exp(-rdist(u, v)**p)

FORTRAN: The actual function calls FORTRAN to make the evaluation more
efficient this is especially important when the C argument is supplied.  
So unfortunately the actual code is not as crisp as the few lines given
above. For purposes of illustration, the function exp.cov.S is provided as
a simple example. (exp.cov.F does the heavy lifting and exp.cov is the
same as exp.cov.F)
}
\seealso{
 Krig, matern.cov, rdist, rdist.earth, gauss.cov, exp.image.cov 
}
\examples{
# exponential covariance matrix ( marginal variance =1) for the ozone
#locations 
out<- exp.cov( ozone$x, theta=100)

# out is a 20X20 matrix
out2<- exp.cov( ozone$x[6:20,],ozone$x[1:2,], theta=100)
# out2 is 15X2 matrix 
# Kriging fit where the nugget variance is found by GCV 
fit<- Krig( ozone$x, ozone$y, exp.cov, theta=100)
}
\keyword{spatial}
% docclass is function
% Converted by Sd2Rd version 1.21.

\eof
\name{fields internal }
\alias{[.spatial.design}
\alias{COR}
\alias{D4transform.image}
\alias{FIELDS.version}
\alias{Krig.coef}
\alias{Krig.df.to.lambda}
\alias{Krig.discretize}
\alias{Krig.fdf}
\alias{Krig.fgcv}
\alias{Krig.fgcv.model}
\alias{Krig.fgcv.one}
\alias{Krig.find.gcvmin}
\alias{Krig.fs2hat}
\alias{Krig.ftrace}
\alias{Krig.replicates}
\alias{Krig.updateY}
\alias{Krig.ynew}
\alias{W.image.cov}
\alias{WD4}
\alias{WD42d}
\alias{WD42di}
\alias{WD4i}
\alias{WQS}
\alias{WQS.T}
\alias{WQS.basis}
\alias{WQS2d}
\alias{WQS2di}
\alias{WQSdi}
\alias{WQSi}
\alias{WQSi.T}
\alias{WQS2d.cylinder}
\alias{WQS2di.cylinder}
\alias{WQSi.periodic} 
\alias{WQSi.periodic.T} 
\alias{WQS.periodic} 
\alias{WQS.periodic.basis}
\alias{WQS.periodic.T} 
\alias{Wtransform.D}
\alias{bisection.search}
\alias{bplot.obj}
\alias{cat.matrix}
\alias{cat.to.list}
\alias{ceiling2}
\alias{conjugate.gradient}
\alias{describe}
\alias{dyadic.2check}
\alias{dyadic.check}
\alias{describe.bplot}
\alias{double.exp}
\alias{draw.bplot}
\alias{draw.bplot.obj}
\alias{exp.cov.F}
\alias{exp.cov.S}
\alias{exp.earth.cov}
\alias{fast.1way}
\alias{find.upcross}
\alias{gauss.cov}
\alias{gcv.Krig}
\alias{gcv.sreg}
\alias{golden.section.search}
\alias{grey.level}
\alias{image.plot.info}
\alias{image.plot.plt}
\alias{image.smooth.setup}
\alias{in.poly}
\alias{krig.image.parameters}
\alias{lonlat2xy}
\alias{make.surface.grid}
\alias{make.tmatrix}
\alias{make.tmatrix.F}
\alias{make.tmatrix.S}
\alias{matern}
\alias{minimax.crit}
\alias{nkden}
\alias{periodic.cov.1d}
\alias{periodic.cov.cyl}
\alias{periodic.plane.3d}
\alias{plot.coef}
\alias{plot.krig.image}
\alias{plot.qsreg}
\alias{plot.sim.krig.image}
\alias{plot.spatial.design}
\alias{plot.vgram.matrix}
\alias{predict.interp.surface}
\alias{predict.krig.image}
\alias{predict.qsreg}
\alias{predict.sreg}
\alias{predict.Tps}
\alias{print.krig.image}
\alias{print.qsreg}
\alias{print.spatial.design}
\alias{print.sreg}
\alias{print.summary.Krig}
\alias{print.summary.krig.image}
\alias{print.summary.spatial.design}
\alias{print.summary.sreg}
\alias{qr.q2ty}
\alias{qr.yq2}
\alias{qsreg.fit}
\alias{qsreg.psi}
\alias{qsreg.rho}
\alias{qsreg.trace}
\alias{rad.cov}
\alias{rad.cov.F}
\alias{rad.cov.S}
\alias{rad.covC}
\alias{rad.image.cov}
\alias{radbas.constant}
\alias{rdist.F}
\alias{rdist.S}
\alias{replace.args.function}
\alias{setup.W.image.cov}
\alias{setup.Wtransform.cov}
\alias{sim.krig.image}
\alias{sim.rf.W}
\alias{sim.rf.default}
\alias{sreg.df.to.lambda}
\alias{sreg.fdf}
\alias{sreg.fgcv}
\alias{sreg.fgcv.model}
\alias{sreg.fgcv.one}
\alias{sreg.fit}
\alias{sreg.fs2hat}
\alias{sreg.trace}
\alias{stats.bplot}
\alias{stats.sim.krig.image}
\alias{summary.gcv.Krig}
\alias{summary.gcv.sreg}
\alias{summary.krig.image}
\alias{summary.qsreg}
\alias{summary.spatial.design}
\alias{summary.sreg}
\alias{surface}
\alias{surface.default}
\alias{surface.krig.image}
\alias{surface.surface}
\alias{test.data}
\alias{test.data2}
\alias{unscale}
\alias{variogram.matrix}
\alias{world.dat}
\title{
  Fields internal and secondary functions 
}
\description{
Listed below are supporting fucntions for the major methods in fields. 
}
\usage{

COR (dat) 
 
D4transform.image (x, inv = FALSE, transpose = FALSE, cut.min = 8) 
 
FIELDS.version  

Krig.coef (out, u = NULL, lambda = NULL, yM = NULL) 
Krig.df.to.lambda (df, D, guess = 1, tol = 1e-05) 
Krig.discretize (x, m = 64, n = 64, xg = NULL, yg = NULL, grid 
    = NULL,  expand = c(1, 1)) 
Krig.fdf (llam, info) 
Krig.fgcv (lam, obj) 
Krig.fgcv.model (lam, obj) 
Krig.fgcv.one (lam, obj) 
Krig.find.gcvmin (info, lambda.grid, gcv, gcv.fun, tol, verbose = FALSE) 
Krig.fs2hat (lam, obj) 
Krig.ftrace (lam, D) 
Krig.replicates (out, verbose = FALSE) 
Krig.updateY (out, Y, verbose = FALSE) 
Krig.ynew (out, ynew, verbose = FALSE) 
 

W.image.cov (ind1, ind2, Y, cov.obj = NULL, setup = FALSE, m = 64, 
         n = 64, ...) 
 
WD4 (x) 
WD42d (x) 
WD42di (x) 
WD4i (x) 
 
WQS (x) 
WQS.T (x) 
WQS.basis (N, cut.n = 8) 
WQS2d (x, transpose = FALSE) 
WQS2di (x, transpose = FALSE) 
WQSdi (x, transpose = FALSE) 
WQSi (x) 
WQSi.T (x) 
WQS.periodic(x)
WQS.periodic.T(x)
WQS.periodic.basis(N, cut.n = 8)
WQS.periodic.T(x)
WQS2d.cylinder(x, transpose = FALSE, byX=T)
WQS2di.cylinder(x, transpose = FALSE, byX=T)
WQSi.periodic(x)
WQSi.periodic.T(x)


Wtransform.D (nx, ny, weights = c(1), cut.min = 8, details = FALSE) 

bisection.search (x1, x2, f, tol = 1e-07, niter = 25, f.extra = 
        NA, upcross.level = 0) 
 
bplot.obj (data, pos = NA, width = NULL, labels = NULL, srt = 
            ,add = FALSE, space = 0.25, sort.names = FALSE, xlab = "", ylab = "", 
              label.cex = 1, xaxt = "n", outlier = TRUE, horizontal = FALSE, ...) 
 
cat.matrix (mat, digits = 8) 
 
cat.to.list (x, a) 
 
ceiling2 (m) 
 
conjugate.gradient (b, multAx, start = NULL, tol = 1e-05, kmax = 
             25, verbose = TRUE,    ...) 
 
describe (x) 
describe.bplot (temp, style = "tukey", outlier = TRUE) 

double.exp(x)

dyadic.2check( m,n,cut.p=2)
dyadic.check( n,cut.p=2) 

draw.bplot (temp, width, xpos, outlier = TRUE, style = "tukey") 
draw.bplot.obj (obj, width, xpos, outlier = TRUE, horizontal = FALSE) 
 
exp.cov.F (x1, x2, theta = rep(1, ncol(x1)), p = 1, C = NA) 
exp.cov.S (x1, x2, theta = 1) 
exp.earth.cov (x1, x2, theta = 1) 
 
fast.1way (lev, y, w = rep(1, length(y))) 
 
find.upcross (fun, fun.info, upcross.level = 0, guess = 1, tol = 
1e-05) 
 
gauss.cov (...) 
 
gcv.Krig (out, lambda.grid = NA, cost = 1, nstep.cv = 80, rmse = 
     NA,verbose = FALSE, tol = 1e-05, offset = 0, y = NULL, lambda = NA) 
 
gcv.sreg (out, lambda.grid = NA, cost = 1, nstep.cv = 20, rmse = 
     NA, offset = 0, trmin = NA, trmax = NA, verbose = TRUE, tol = 1e-05, 
     find.min = TRUE, method = "GCV") 
 
golden.section.search (ax, bx, cx, f, niter = 25, f.extra = NA, 
     tol = 1e-05) 
 
grey.level (n) 
 
image.plot.info (...) 
image.plot.plt ( add=FALSE,  legend.shrink = 0.9, legend.width = 0.04, 
horizontal = FALSE, offset = 2 * legend.width, bigplot = NULL, smallplot = NULL)

image.smooth.setup (nrow = 64, ncol = 64, dx = 1, dy = 1, 
     kernel.function = function(x) {    exp(-abs(x))}, 
     theta = 1, Mwidth = nrow, Nwidth = ncol, ...) 
 
in.poly (xd, xp, convex.hull = FALSE, inflation=1e-7) 
 
krig.image.parameters (out) 
 
lonlat2xy (lnlt, miles = FALSE) 
 
make.surface.grid (grid.list, X, nx = 30, ny = 30, 
      info.list = FALSE, FUN = median) 
make.tmatrix (x, m = 2) 
make.tmatrix.F (x, m = 2) 
make.tmatrix.S (x, m = 2) 
 
matern (t , scale = 1, range = 1,alpha=1/range,
                smoothness = 0.5, nu= smoothness, phi=scale)  

minimax.crit (obj, des = TRUE, R) 
 
nkden (data, bandwidth, n.points, grid) 
 
periodic.cov.1d (x1, x2, a, b) 
periodic.cov.cyl (x1, x2, a = 0, b = 365, theta = 1) 
periodic.plane.3d (x1, x2, a = 0, b = 365, theta = 1) 
 
plot.coef (x, cut.min = 8, graphics.reset = TRUE, common.range = FALSE) 
plot.krig.image (out, main = NA, digits = 4, which = rep(TRUE, 4), 
      graphics.reset = TRUE, ...) 
plot.qsreg (out, pch = "*", main = NA) 
plot.sim.krig.image (obj) 
plot.spatial.design (out) 
plot.vgram.matrix (obj, ...)
 
predict.interp.surface (obj, loc) 
predict.krig.image (obj, x, ...) 
predict.qsreg (out, x, derivative = 0, model = 1) 
predict.sreg (out, x, derivative = 0, model = 1) 
 
print.krig.image (obj) 
print.qsreg (x, ...) 
print.spatial.design (x) 
print.sreg (x, ...) 
print.summary.Krig (x, ...) 
print.summary.krig.image (x, ...) 
print.summary.spatial.design (x, digits = 4) 
print.summary.sreg (x, ...) 
 
qr.q2ty (qr, y) 
 
qr.yq2 (qr, y) 
 
qsreg.fit (x, y, lam, maxit = 50, maxit.cv = 10, tol = 1e-04, 
    offset = 0, sc = sqrt(var(y)) * 1e-07, alpha = 0.5, wt = rep(1, 
    length(x)), cost = 1)
qsreg.psi ( r,alpha=.5,C=1) 
qsreg.rho ( r,alpha=.5,C=1)
qsreg.trace (x, y, lam, maxit = 50, maxit.cv = 10, tol = 1e-04, 
    offset = 0, sc = sqrt(var(y)) * 1e-07, alpha = 0.5, 
    wt = rep(1, length(x)), cost = 1) 

rad.cov (x1, x2, p = 1, with.log = TRUE, with.constant = TRUE, C =NULL) 
rad.cov.F (x1, x2, p = 1, with.log = TRUE, with.constant = TRUE, C = NULL) 
rad.cov.S (x1, x2, p = 1, with.log = TRUE, with.constant = TRUE) 
rad.covC (x1, x2, C, p = 1, with.log = TRUE, with.constant = TRUE) 
rad.image.cov (ind1, ind2, Y, cov.obj = NULL, setup = FALSE, grid,...) 
radbas.constant (m, d) 
 
rdist.F (x1, x2) 
rdist.S (x1, x2, lon.lat = FALSE) 
 
replace.args.function (fun, ...) 
 
setup.W.image.cov (m, n, weights = 1, D = NULL, cut.min = 8, 
     max.m = m,max.n = n, x = NULL, grid = NULL, normalize = TRUE, ...) 
 
setup.Wtransform.cov (m, n, weights = 1, cut.min = 8, max.m = m, 
     max.n = n,x = NULL, grid = NULL, normalize = TRUE, ...) 
 
sim.krig.image (out, nreps = 10) 
sim.rf.W (cov.obj) 
sim.rf.default (obj) 
 
sreg.df.to.lambda (df, x, wt, guess = 1, tol = 1e-05) 
sreg.fdf (h, info) 
sreg.fgcv (lam, obj) 
sreg.fgcv.model (lam, obj) 
sreg.fgcv.one (lam, obj) 
sreg.fit (lam, info) 
sreg.fs2hat (lam, obj) 
sreg.trace (h, info) 

stats.bplot (x, by, style = "tukey", outlier = TRUE) 
stats.sim.krig.image (obj) 
 
summary.gcv.Krig (out, lambda, cost = 1, verbose = FALSE, offset = 
    0, y = NULL) 
summary.gcv.sreg (out, lambda, cost = 1, nstep.cv = 20, offset = 
    0, verbose = TRUE) 
summary.krig.image (x, digits = 4, ...) 
summary.qsreg (x, ...) 
summary.spatial.design (x, digits = 4, ...) 
summary.sreg (x, digits = 4, ...) 

surface (x, grid.list = NA, extrap = FALSE, xlab = NULL, ylab = 
    ,zlab = NULL, main = NULL, levels = NULL, zlim = NULL, ...) 
surface.default (...) 
surface.krig.image (obj, grid.list = NA, extrap = TRUE, 
      graphics.reset = FALSE, xlab = NULL, ylab = NULL, main = NULL,
      zlab = NULL,zlim = NULL,levels = NULL, ptype = "I", ...) 
 
surface.surface (...)
 
test.data  

test.data2

unscale (x, x.center, x.scale) 
 
variogram.matrix (dat, R = 5, dx) 
 
world.dat 
}
\keyword{internal}
% docclass is function
% Converted by Sd2Rd version 1.21.

\eof
\name{fields}
\alias{fields}
\title{
fields - tools for spatial data 
}
\description{
Fields is a collection of programs for curve and function
 fitting with an emphasis on spatial data and spatial statistics. The
 major methods implemented include cubic and thin plate splines, universal
 Kriging and Kriging for large data sets. One main feature is any
 covariance function implemented in R can be used for spatial prediction. 

Some major methods include:
\itemize{
\item \code{Tps}   Thin Plate spline regression (including GCV) 
\item \code{Krig}  Spatial process estimation (Kriging) 
\item \code{krig.image}   Spatial process estimate for large problems
}
The Kriging functions allow you to supply a covariance function that is
written in native S/R code. The Matern family (\code{Matern.cov}) is 
included as a built in 
covariance. 

Some other noteworthy functions are
\itemize{
\item \code{cover.design}  Space-filling designs where the distance 
function is expresed in R/S code

\item \code{as.image}    \code{image.plot}  
\code{image.count} \code{smooth.image}  convenient functions 
for working with image data

\item \code{sreg},  \code{qsreg} \code{splint}   Fast 1-D smoothing 
splines and 1-D 
quantile/robust and interpolating cubic splines
}

There are also generic functions that support 
these methods such as 

\code{plot} - diagnostic plots of fit \cr
\code{summary}- statistical summary of fit \cr
\code{print}- shorter version of summary \cr
\code{surface}- graphical display of fitted surface \cr
\code{predict}- evaluation fit at arbitrary points \cr
\code{predict.se}- prediction standard errors at arbitrary points. \cr
\code{sim.rf}- Simulate a random fields on a 2-d grid.

To get started, try some of the examples from help files for \code{Tps} or 
\code{Krig}. See also the manual/tutorial at 
\url{http://www.cgd.ucar.edu/stats/Software/fields}


DISCLAIMER:

This is software for statistical research and not for commercial uses. The
authors do not guarantee the correctness of any function or program in
this package. Any changes to the software should not be made without the
authors permission.
}
\examples{
fit<- Tps(ozone$x, ozone$y)  # fits a surface to ozone measurements.
summary(fit) #summary of the fit 
plot(fit) # diagnostic plots of  fit and residuals.
surface( fit, type="I") # image and contour plot of the fitted surface

}
\keyword{datasets}

\eof
\name{flame}
\alias{flame}
\title{
  Response surface experiment ionizing a reagent 
}
\description{
The characteristics of an ionizing flame are varied with the intent of 
maximizing the intensity of emitted light for lithuim in 
solution. Areas outside of the measurements are where the mixture may 
explode! Note that the optimum is close to the boundary. Source of data is 
from a master's level lab experiment in 
analytical chemistry from Chuck Boss's course at NCSU. 
<s-section name= "DATA DESCRIPTION">
This is list with the following components
}
\arguments{
\item{x}{
x is a 2 column matrix with the different Fuel and oxygen flow rates for 
the burner. 
}
\item{y}{
y is the response. The intensity of light at a particular 
wavelength indicative of Lithium ions. 
}
}
\keyword{datasets}
% docclass is data
% Converted by Sd2Rd version 1.21.

\eof
\name{grid list}
\alias{grid list}
\title{
  Grid list for describing equally spaced grids
}
\description{
    
The object grid.list refers to a list that contains information for  
evaluating a function on a 2-dimensional grid of points. If a function  
has more than two independent variables then one also needs to specify  
the constant levels for the variables that are not being varied. Also  
one needs to be able to  specify which variable should be identified  
with the horizontal or "X"  axis and which variable should be associated  
with the vertical or "Y" axis when the surface is  
plotted using contour or persp.   
This format is used extensively in fields   
functions that evaluate function estimates and plot surfaces. 
The form of a grid.list is  
list( var.name1= what  , var.name2=what , ... var.nameN=what)  
Here var.names are the names of the independent variables. 
The what options describe what should be done with this variable when  
generating the grid. The options are numerous reflecting some laziness  
in not wanting to type too much.   

The argument what can take on the following values: 
"x" Generate the grid using this variable as the  horizontal axis   
for  a contour plot. 
"y" Take this variable to be the vertical axis for a contour plot. 
Numerical vector with two or more elements.  If only two elements these  
are interpreted as the range for the grid. ( make.surface.grid has an  
option for specifying the number of grid points in this range with the  
default being 30.) If the vector has more than two elements these are  
assumed to be the actual grid values. Most of time  these are equally  
spaced and are easily generated using the seq function.  If two vectors  
are used to specify the x and y grids the first variable mentioned in  
the list is assumed as the x coordinate for contour and the second  
variable in order is the y coordinate. (There is an option in the  
as.surface function to flip these before plotting.)  
"c" This variable is held constant at its mean level.  
Numerical value.  This variable held constant at the specified value. 
There are are some important defaults that are assumed in this format. 
If a variable is omitted in the grid.list it is assumed to have value  
"c". If the variable names are omitted then the components are assumed  
to be in the same order as the variables. In this case one is not  
legal to omit a variable. Finally if a plotting or predict  
function takes a grid.list as an  
argument the default object when it is not specified is
list("x","y"). 
Sometimes it is easier not to specify either columns names for the X 
matrix paired with a grid list or for the grid list itself. In this case  
names are assigned as   X1, X2, ....
  
So for in the example below: 
  dimnames( X)<- list(NULL, c("X1","X2","X3")) 
this line is not needed because X does not have names for its columns and 
these will be assigned within the surface function.  
}
\seealso{
make.surface.grid, as.surface, predict.surface, plot.surface, surface
}
\examples{
#Given below are some examples of grid.list objects and the results  
#when they are used with make.surface.grid. Note that  
#make.surface.grid returns a matrix that retains the grid.list  
#information as an attribute. 

grid.l<- list( 1:3, 2:5) 
make.surface.grid(grid.l)
  
grid.l <- list( 1:3, 10, 1:3) 
make.surface.grid(grid.l) 

#The next set of examples show how the grid.list can be used to  
#control surface plotting and evaluation of an estimated function. 

# first create a test function  
X<- 2*cbind( runif(50), runif(50), runif(50))  
dimnames( X)<- list(NULL, c("X1","X2","X3")) 
y<- X[,1]**2 + X[,2]**2 + exp(X[,3])   

# fit an  interpolating thin plate spline  
out<- Tps( X,y,lambda=1e-8) 
grid.l<- list( X1="x", X2="y") 
surface( out, grid.l, type="I") # surface plot of estimated surface with  
#                       X3= mean value 


grid.l<- list( X1= seq( 0,2,,25), X2=1.0, X3=seq(0,2,,25)) 
surface( out,grid.l, type="I") 
#  surface plot based on a 25X25 grid in X1 an X3  
#                       over the square [0,2] and [0,2]   
#                       holding X2 equal to 1.0. 
#
}
\keyword{misc}
% docclass is function
% Converted by Sd2Rd version 1.21.

\eof
\name{image.count}
\alias{image.count}
\title{
  Creates image for a 2-d histogram from irregular locations 
}
\description{
Discretizes a matrix of 2-d locations and counts the
number of 
occurrences for each grid box.  
}
\usage{
image.count(x, grid=NULL, nrow=64, ncol=64)
}
\arguments{
\item{x}{

}
\item{grid}{
A list with components x and y of equally spaced values describing the 
centers of the grid points. The default is to use nrow and ncol and the 
ranges of the data locations (x)  to construct a grid. 
}
\item{nrow}{
Number of rows for the image. Note that nrows equals the number of x
values and corresponds to the horizontal dimension.  
}
\item{ncol}{
Number of columns for the image. Note that  
ncol= number of y values and will 
be the vertical dimension.  
}
}
\value{
An list in image format. Components x and y are the grid values , z is a 
nrow X ncol matrix 
with the Z values. NA's are placed at cell locations where Z data has 
not been supplied. 
}
\seealso{
image.smooth, image.plot, Krig.discretize, Krig.replicates  
}
\examples{
look<- image.count( precip$x, nrow=32, ncol=32)
image.plot( look) 
}
\keyword{smooth}
% docclass is function
% Converted by Sd2Rd version 1.21.

\eof
\name{image.cov}
\alias{exp.image.cov}
\alias{matern.image.cov}
\title{
 Exponential,Gaussian, "power" and Matern covariance functions for 2-d 
gridded locations 
}
\description{
Given two sets of locations defined on a 2-d grid efficiently multiplies a 
cross covariance with a vector. 
}
\usage{
exp.image.cov(ind1, ind2, Y, cov.obj = NULL, setup = FALSE, grid, ...) 
matern.image.cov(ind1, ind2, Y, cov.obj = NULL, setup = FALSE, grid,
M=NULL,N=NULL,...) 
}
\arguments{
\item{ind1}{
Matrix of indices for first set of locations this is a two column matrix
where each row is the row/column index of the image element. If missing
the default is to use all grid locations.
}
\item{ind2}{
Matrix of indices for second set of locations. If missing this is taken to
be ind2. If ind1 is missing ind2 is coerced to be all grid locations.
}
\item{Y}{
Vector to multiply by the cross covariance matrix. Y must be the same
locations as those referred to by ind2.
}
\item{cov.obj}{
A list with the information needed to do the multiplication by
convolutions. This is usually found by using the returned list when
setup=T.
}
\item{setup}{
If true do not do the multiplication but just return the covariance object
required by this function. 
}
\item{grid}{
A grid list giving the X and Y grids for the image. (See example below.)
This is only required if setup is true. 
}
\item{M} {
Size of x-grid used to compute multiplication (see notes on image.smooth 
for details) by the FFT. If NULL, the default for M is the largest power 
of 2 
greater than or equal to 2*m where m= length( grid$x). 
This  will give an exact 
result but  smaller values of M will yield an approximate, faster result. 
}

\item{N} {Size of y-grid used to compute multiplication by the FFT.}

\item{\dots}{
Any arguments to pass to the covariance in setting up the
covariance object. This is only required if setup is TRUE.
For the "exponential" the arguments are theta ( the range default=1), and 
p (the 
exponent default=1). For the matern  the arguments are theta 
(the range default=1),   
and smoothness (default=.5 giving the exponential).
}
}
\value{
A vector that is the multiplication of the cross covariance matrix with
the vector Y.
}
\details{
This function was provided to do fast computations for large numbers of
spatial locations and supports the conjugate gradient solution in
krig.image. In doing so the observations can be irregular spaced
but their coordinates must be 2-dimensional and be restricted to grid
points.
(The function as.image will take irregular, continuous coordinates and
overlay a grid on them.) 

Returned value: If ind1 and ind2 are matrices where nrow(ind1)=m and
nrow(ind2)=n then the cross covariance matrix, Sigma is an mXn matrix
(i,j) element is the covariance between the grid locations indexed at
ind1[i,] and ind2[j,]. The returned result is Sigma\%*\%Y. Note that one can
always recover the coordinates themselves by evaluating the grid list at
the indices.  e.g.  cbind( grid\$x[ ind1[,1]], grid\$y[ind1[,2])) will give
the coordinates associated with ind1. Clearly it is better just to work
with ind1!
  
Functional Form: Following the same form as exp.cov and matern.cov for 
irregular
locations, the covariance is defined as phi( D.ij) where D.ij is
the Euclidean distance between x1[i,] and x2[j,] but having first been
scaled by theta. Specifically,

D.ij = sqrt(  sum.k (( x1[i,k] - x2[j,k]) /theta[k])**2 ).

For the exponential phi(u) = exp( -u**p) and for the Matern
phi(u)= matern( u, smoothness). (See the help file on matern.cov for 
details.) 
 
Note that if theta is a scalar then this defines an isotropic covariance
function.  

Implementation: This function does the multiplication on the full
grid efficiently by a 2-d FFT. The irregular pattern in Y is handled by
padding with zeroes and once that multiplication is done only the
appropriate subset is returned. 

As an example assume that the grid is 100X100 let big.Sigma denote the big
covariance matrix among all grid points ( If the parent grid is 100x100
then big.Sigma is 10K by 10K !) Here are the computing steps:

temp<- matrix( 0, 100,100)

temp[ ind2] <- Y

temp2<- big.Sigma\%*\% temp

temp2[ind1]

Notice how much we pad with zeroes or at the end throw away!
Here the matrix multiplication is effected through convolution/FFT tricks
to avoid creating and multiplying big.Sigma explicitly. It is often faster
to multiply the regular grid and throw away the parts we do not need then
to deal directly with the irregular set of locations.

Confusion: In this entire discussion Y is treated as vector. However is
one has complete data then Y can also be interpreted as a image matrix
conformed to correspond to spatial locations. See the last example for
this distinction. 
  
}
\seealso{
  exp.cov, matern.cov,smooth.2d, as.image, krig.image 
}
\examples{
# multiply 2-d isotropic exponential with theta=4 by a random vector 
junk<- matrix(rnorm(100*100), 100,100)
cov.obj<- exp.image.cov( setup=TRUE, grid=list(x=1:100,y=1:100), theta=8)
result<-  exp.image.cov(Y=junk,cov.obj=cov.obj)

image( matrix( result, 100,100))
# do it again, no setup needed 
#  junk2<- matrix(rnorm(100**2, 100,10))
#  result2<-  exp.image.cov(Y=junk2, cov.obj=cov.obj)



# generate a grid and set of indices based on discretizing the locations
# in the precip dataset
data(precip)
out<-as.image( precip$y, x= precip$x)
ind1<- out$ind
grid<- list( x= out$x, y=out$y)
# there are 750 gridded locations 

# setup to create cov.obj for exponential covariance with range= 1.25
# p=1 is the default
cov.obj<- exp.image.cov( setup=TRUE, grid=grid, theta=1.25) 

# multiply covariance matrix by an arbitrary vector
junk<-  rnorm(750)
result<- exp.image.cov( ind1, ind1, Y= junk,cov.obj=cov.obj)

# The brute force way would be  
# result<- exp.cov( precip$x, precip$x,theta=1.25, C=junk)


# evaluate the covariance between all grid points and the center grid point
Y<- matrix(0,cov.obj$m, cov.obj$n)
Y[32,32]<- 1
result<- exp.image.cov( Y= Y,cov.obj=cov.obj)
# covariance surface with respect to the grid point at (32,32)
# 
# reshape "vector" as an image
temp<-  matrix( result, cov.obj$m,cov.obj$n)
image.plot(cov.obj$grid$x,cov.obj$grid$y, temp)
# or persp( cov.obj$grid$x,cov.obj$grid$y, temp) 

# check out the Matern. 
cov.obj<- matern.image.cov( setup=TRUE, grid=grid, theta=1.25, 
smoothness=2)
Y<- matrix(0,64,64)
Y[16,16]<- 1
result<- matern.image.cov( Y= Y,cov.obj=cov.obj)
temp<-  matrix( result, cov.obj$m,cov.obj$n)
image.plot( cov.obj$grid$x,cov.obj$grid$y, temp)
# Note we have centered at the location (16,16) for this case

}

\keyword{spatial}
% docclass is function
% Converted by Sd2Rd version 1.21.

\eof
\name{image.plot}
\alias{image.plot}
\title{
  Draws image plot with a legend strip for the color scale.  
}
\description{
This function combines the R image function with some automatic 
placement of a legend. This is done by splitting the plotting region  
into two parts. Putting the image in one and the legend in the other.  
}
\usage{
image.plot(..., add=TRUE, nlevel=64, legend.shrink=0.9, 
legend.width=0.02,  
graphics.reset=TRUE, horizontal=FALSE, offset=0.04,  
bigplot=NULL, smallplot=NULL, legend.only=FALSE, 
col=topo.colors(nlevel))
}
\arguments{
\item{\dots}{
The usual arguments to the image function. 
because this function may change the size of the plotting 
region. (See details below)  
}
\item{add}{
If true add image and a legend strip to the existing plot. 
}
\item{nlevel}{
Number of color levels used in legend strip  
}
\item{legend.shrink}{
 Amount to shrink the size of legend relative to the full height or width
of the plot.  
}
\item{legend.width}{
Width in plotting 
coordinates (the full size plot is [0,1]X[0,1]) of the legend strip. 
}
\item{offset}{
Amount that the legend strip is set in from the left edge or the bottom 
of the plotting region. Units are with respect to the plotting 
coordinates.
}
\item{graphics.reset}{
 If
FALSE (default)  the plotting region ( plt in par) will not be reset 
and
one can add more information onto the image plot. (e.g. using functions
such as points or lines.)  If TRUE will reset plot parameters to the
values before entering the function.  
}
\item{horizontal}{
If false (default) legend will be a vertical strip on the right side. If
true the legend strip will be along the bottom.  
}
\item{bigplot}{
Plot coordinates for image plot. If not passed
these will
be determined within the function.  
}
\item{smallplot }{
Plot coordinates for legend. If not passed these will be determined within
the function.  
}
\item{legend.only}{
If TRUE just add the
legend to a the plot in the plot region defined by the coordinates in
smallplot. In the abscence of other information the range for the legend 
is determined from the \code{zlim} argument. 
}
\item{col}{
Color table to use for image ( see help file on image for details).
Default is a pleasing range of 64 divisions on a topographic scale.
}
}
\section{Side Effects}{
After exiting, the
plotting region may be changed to make it possible to add more features to
the plot. To be explicit, \code{par()\$plt} may be changed to reflect a 
smaller plotting region that has accommodated room for the legend subplot.  
}
\details{
It is surprising how hard it is just to automatically add the
legend! All "plotting coordinates" mentioned here are in device
coordinates. The plot region is assumed to be [0,1]X[0,1] and plotting
regions are defined as rectangles within this square. We found these
easier to work with than user coordinates.  There are always problems with
default solutions to placing information on graphs but the choices made
here may be useful for most cases. The most annoying thing is that after
using plot.image and adding information the next plot that is made may
have the slightly smaller plotting region set by the image plotting.
The user should set \code{reset.graphics=TRUE} to avoid the plotting size 
some from changing. The disadvantage, however, of resetting the graphics 
is that one can no longer add additional graphics elements to the image 
plot. (Note that filled.contour always resets the graphics but provides 
another mechanism to pass through plotting commands. Apparently 
filled.contour,while very pretty, does not work for multiple plots ... )

The strategy for \code{image.plot} is simple, divide the plotting region 
into two smaller
regions \code{bigplot} and \code{smallplot}. The image goes in one and 
the legend in the other. This way
there is always room for the legend. Some adjustments are made to this
rule by not shrinking the \code{bigplot} if there is already room for the
legend strip and also sticking the legend strip close to the image plot.
One can specify the plot regions explicitly by \code{bigplot} and \
\code{smallplot}
if the default choices do not work. There may be problems with small
plotting regions in fitting both of these in the plot region and one may 
have to change the default character sizes or margins to make things fit.

By keeping the zlim argument the same across images one can generate the
same color scale. (See the image help file)  One useful technique for a
panel of images is to just draw the first with image.plot to get a legend
and just use image for subsequent plots. Also keep in mind one can just
add a legend to an existing plot without changing plotting parameters.
Usually a square plot (pty="s") done in a rectangular plot region will
have room for the legend with any adjustments stuck to the right side. 

Note that to add just the legend strip all one needs is the zlim argument!
The default color table for this function is the topographic color scale 
(\code{topo.colors}) showing our geophysical basis. 
See also \code{terrain.colors} for a subset. For using other color choices 
see how the \code{nlevels} argument figures into the legend and main plot
number of colors. 


}

\seealso{ image,filled.contour } 
\examples{
 x<- 1:10 
 y<- 1:15 
z<- outer( x,y,"+") 
image.plot(x,y,z) 
# or obj<- list( x=x,y=y,z=z); image.plot(obj)
# now add some points on diagonal with some clipping anticipated 
points( 5:12, 5:12, pch="X", cex=3)
#
#fat (5\% of figure) and short (50\% of figure)  legend strip on the bottom 
image.plot( x,y,z,legend.width=.05, legend.shrink=.5, horizontal=TRUE) 

# you can always add a legend arbitrarily to any plot;
# note that here the plot is too big for the vertical strip but the
# horizontal fits nicely.
plot( 1:10, 1:10)
image.plot( zlim=c(0,25), legend.only=TRUE)
image.plot( zlim=c(0,25), legend.only=TRUE, horizontal =TRUE)

# combining the  usual image function and adding a legend
# first change margin for some more room
\dontrun{
par( mar=c(10,5,5,5))
image( x,y,z, col=topo.colors(64))
image.plot( zlim=c(0,25), nlevel=64,legend.only=TRUE, horizontal=TRUE)
}
#
# 
 
}
\keyword{hplot}
% docclass is function
% Converted by Sd2Rd version 1.21.

\eof
\name{image.smooth}
\alias{image.smooth}
\title{
  Kernel smoother for irregular 2-d data 
}
\description{
Takes an image matrix and applies a kernel smoother to it. Missing values
are handled using the Nadaraya/Watson normalization of the kernel. 
}
\usage{
image.smooth
 (Y, wght = NULL, dx = 1, dy = 1, Nwidth = nrow(Y), Mwidth = ncol(Y),
    kernel.function = double.exp,
 theta = 1, grid = NULL, tol = 1e-08, xwidth = NULL, ywidth = NULL,
    weights = NULL)
}
\arguments{
\item{Y}{
A matrix image with missing values are indicated by NA. 
}
\item{wght}{
FFT of smoothing kernel. If this is NULL the default is to compute this
object. 
}
\item{grid}{
A list with x and y components. Each are equally spaced and define the rectangular. ( see grid.list)
}
\item{dx}{
Grid spacing in x direction 
}
\item{dy}{
Grid spacing in x direction 
}
\item{Nwidth}{
Half the width of the kernel in the y direction in numbers of grid 
points.  
Default is half the number of columns of Y 
}

\item{Mwidth}{
Half the width of the kernel in the x direction in numbers of grid 
points.
Default is half the number of columns of Y 
}
\item{kernel.function}{
An S function that takes as its argument the \emph{squared} distance 
between two 
points divided by the bandwidth. The default is exp( -x) yielding a normal 
kernel 
}
\item{theta}{
The bandwidth 
}
\item{\dots}{
Other arguments to be passed to the kernel function 
}
\item{xwidth}{
This has the same function as Mwidth but is in the scale of the x grid.
If specified  then  Mwidth = xwidth/ ( grid$x[2]- grid$x[1])
}
\item{ywidth}{
This has the same function as Nwidth but is in the scale of the x grid.
If specified  then  Nwidth = xwidth/ ( grid$x[2]- grid$x[1])
}
\item{weights}{
Weights to apply when smoothing.}
\item{tol} {
Tolerance for the weights of the N-W kernel. This avoids kernel estimates that are "far" away from data.
Grid points with weights less than tol are set to NA.
 }


}
\value{
The smoothed matrix. 
}
\details{
The function works by taking convolutions using an FFT. The missing pixels 
are taken into account and the kernel smoothing is correctly normalized
following the classical Nadaraya-Watson estimator. If the kernel has 
limited support then the width arguments can be set to reduce the amount 
of computation. (See example below.) }
\seealso{
image.smooth.setup, as.image  
}
\examples{
# first convert precip data to the 128X128 discretized image format ( with 
# missing  values to indicate where data is not observed) 
# 
out<- as.image( precip$y, x= precip$x, nrow=128, ncol=128) 
# out$z is the image matrix 

dx<- out$x[2]- out$x[1] 
dy<-  out$y[2] - out$y[1] 
#  
look<- image.smooth( out$z, dx=dx, dy=dy, theta= .25) 

# grid scale in degree and so kernel bandwidth is .25 degrees. 
image.plot( x= out$x, y=out$y, z= look) 
points( precip$x)

# to save on computation, decrease the padding with zeroes 

look<- image.smooth( out$z, dx=dx, dy=dy, theta= .25, Mwidth=32,Nwidth=32) 

# the range of these data is ~ 10 and so  32*( 10/128) =  2.5 
# about 10 standard deviations of the normal kernel so there is still 
# lots of room for padding  
# a minimal choice might be  Mwidth = 4* (.25/dx)  4 SD for the normal  
# 
# creating weighting object outside the call  
# this is useful when one wants to smooth different data sets but on the 
# same grid with the same kernel function 
# 

wght<- image.smooth.setup( nrow=128, ncol=128,  dx=dx, dy=dy, theta= .25,
Mwidth=32, Nwidth=32)

#
#  random fields from smoothing white noise with this filter.
#
look<- image.smooth( matrix( rnorm(128**2), 128,128), wght)
# take a look: image.plot( look)

}
}
\keyword{smooth}
% docclass is function
% Converted by Sd2Rd version 1.21.

\eof
\name{interp.surface}
\alias{interp.surface}
\title{
  Fast bilinear interpolator from a grid.
}
\description{
Uses bilinear weights to interpolate values on a rectangular
grid to arbitrary locations. 
}
\usage{
interp.surface(obj, loc)
}
\arguments{
\item{obj}{
A list with components x,y, and z in the same style as used by contour,
persp, image etc. x and y are the X and Y grid values and z is a matrix
with the corresponding values of the surface
}
\item{loc}{
A matrix of (irregular) locations to interpolate. First column of loc
isthe X coordinates and second is the Y's. 
}
}
\value{
 An vector of interpolated values.  NA are returned for
regions of the obj\$z that are NA and also for locations outside of the
range of the grid. 
}
\details{
Here is a brief explanation of
the interpolation:  Suppose that the location, (locx, locy)  lies in
between the first two grid points in both x an y. That is  locx is between
x1 and x2 and
locy is between y1 and y2.  Let ex= (l1-x1)/(x2-x1) ey= (l2-y1)/(y2-y1).
The
interpolant is

( 1-ex)(1-ey)*z11 + (1- ex)(ey)*z12 + ( ex)(1-ey)*z21 + ( ex)(ey)*z22  

Where the z's are the corresponding elements of the Z matrix. 
}
\seealso{
image.smooth, as.surface, as.image, image.plot, krig.image,Tps
}
\examples{
#
# evaluate an image at a finer grid
# 

data( lennon)
# create the surface object
obj<- list( x= 1:20, y=1:20, z= lennon[ 201:220, 201:220])

# sample at 50 equally spaced points 
temp<- seq( 1,20,,50)
make.surface.grid( list( temp,temp))-> loc
interp.surface( obj, loc)-> look
# take a look
image.plot( as.surface( loc, look))

}
\keyword{spatial}
% docclass is function
% Converted by Sd2Rd version 1.21.

\eof
\name{krig.image}
\alias{krig.image}
\title{
  Spatial process estimate for large irregular 2-d dats sets. 
}
\description{
Computes the spatial predictions for large numbers of irregularly spaced
observations using the standard Kriging equations. The main approximation
is that the locations are discretized to a regular grid, but the field
need not be observed at all grid boxes.  

 
In Bayesian terms this
function computes the posterior mean for the field given the observations
under the usual Gaussian assumptions for the fields and observations.  
The solution is found by the iterative solution of a large linear system
using the conjugate gradient algorithm (CGA). Part of the calculations
rely on discretizing the spatial locations to a regular grid to make use
of the FFT for fast multiplication of a covariance matrix with a vector.
}
\usage{
krig.image(x, Y, cov.function, m=NULL, n=NULL, lambda=0, start=NULL, 
tol=1e-05, kmax=25,  cov.obj=NULL, grid=NULL, 
weights=rep(1, length(Y)), verbose=FALSE, conv.verbose=FALSE, expand=1, ...)
}
\arguments{
\item{x}{
A 2 column matrix of observed locations  
}
\item{Y}{
Values of observed field. Missing values are omitted from computation.  
}
\item{cov.function}{
An S function that multiplies the covariance matrix by a vector. Two that 
are part of FIELDS are exp.image.cov ( Exponential and Gaussian) and  
W.image.cov ( W transform covariance model) 
}
\item{lambda}{
The value of the smoothing parameter. Should be nonnegative. See the notes 
below for more information about this parameter 
}
\item{m}{
Number of grid points in the x axis. Default is to use the length of  
grid\$x.  
}
\item{n}{
Number of grid points in the y axis. Default is to use the length of 
grid\$y. 
}
\item{cov.obj}{
A covariance object that contains information to be used by the  
covariance function  specified above.   
If this is not specified this object will be created within krig.image. 
}
\item{grid}{
A list with components x and y that specify the grid points in the  
x and y directions. The default is to use the number of point specified by 
m and n and use the ranges from the observed locations.  
}
\item{start}{
Starting values for omega2 in the iterative algorithm. Default is zero.   
}
\item{tol}{
Convergence tolerance for CGA. 
}
\item{kmax}{
Maximum number of iterations for CGA 
}
\item{weights}{
This vector is proportional to the reciprocal variance of the 
measurement errors. The default is a vector of ones.  
}
\item{verbose}{
If true all kinds of stuff is printed out! Default is false of course. 
}
\item{conv.verbose}{
If true the convergence criterion is printed out at each iteration of the  
CGA. The values are scaled as the criterion divided by the tolerance. So 
the algorithm terminates when the values are less than one.   
}
\item{expand}{
The amount the grid should be expanded beyond the range of the observed 
data. For example expand 1.1 will give a range that is 10 \% larger on 
each 
end.  
}
\item{\dots}{
Any extra arguments are considered as information for the covariance 
function and are used to create the covariance object.  
}
}
\value{
An list object of class krig.image.  
An explanation of some components: 

\item{call }{
The calling sequence   
}
\item{cov.function}{
A copy of the covariance S function  
}
\item{na.ind}{
logical indicating missing values in Y 
}
\item{xraw}{
Passed spatial locations having removed missing values 
}
\item{y}{
Observations having omitted missing values 
}
\item{N}{
Length of y 
}
\item{weights}{
passed weights having omitted missing cases.  
}
\item{lambda  }{
}
\item{grid}{
list with components x an y indicating grid for discretization 
}
\item{cov.obj}{
List object to use with cov.function 
}
\item{m}{
Number of grid point in x axis 
}
\item{n}{
Number of grid point in y axis 
}
\item{index}{
A two column matrix indicating the indices of the closest grid point to 
each observed location.  
}
\item{x}{
Observed locations discretized to nearest grid point 
}
\item{yM}{
Observed values but with a weighted average replacing multiple values
associated with the same grid point.  }
\item{xM}{
Discretized locations associated with yM
}
\item{weightsM}{
Weight vector
associated with YM.  }
\item{uniquerows}{
Logical indicating which rows of x
are unique.  
}
\item{shat.rep}{
Pooled standard
deviation among observations that fall within the same gird points
}
\item{indexM }{
A two column
matrix indicating the indices of the closest grid point to each observed
location, yM.  }
\item{qr.T}{
QR
decomposition of the matrix of constant and linear terms at xM
}
\item{multAx}{
The S function
that is used for matrix multiplication in the CGA.  }
\item{omega2}{
Parameter vector that describes the
spatial process part of the conditional mean.  }
\item{converge}{
CGA convergence information
}
\item{beta}{
Constant, and the
two linear parameters for the fixed linear part of the model
}
\item{delta}{
Covariance matrix
times delta give the spatial predictions.  }
\item{rhohat, rho}{
Conditional on lambda the MLE for
the parameter multiplying the covariance function.  }
\item{sigma2, shat.MLE}{
Conditional on lambda the MLE
for the parameter dividing the weight function.  }
\item{surface}{
A list giving the predicted surface at
the grid points.  }
\item{fitted.values}{
Predicted values at true
locations
}
}
\details{
 From a functional point of
view krig.image and supporting functions are similar to the class Krig.
The main difference is that only 2-dimensional problems are considered and
the solution is calculated for a fixed value of lambda. (The Krig function
can estimate lambda.)  For large data sets a practical way to estimate
lambda is by out of sample cross-validation and the FIELDS manual gives a
detailed example of this for the precip data set. Also see the manual for
an explanation of the computational strategy (Conjugate Gradient) here.

 Efficiency for large datasets comes with restrictions on the range of
covariance functions and some other features. Currently FIELDS just has
two covarince models: exponential/Gaussian and wavelet based. However, it
is not difficult to modify these to other models. The default
discretization is to a 64X64 grid however even 256X256 is manageable and
quite likely to separate irregular locations in most cases. The user
should also keep in mind that the estimate is the result of an iterative
algorithm and so issues such as good starting values and whether the
algorithm converged are present.

  
The spatial model includes a linear spatial drift and MLE estimates of the 
nugget variance and sill are found based on the values of lambda.  If the 
weights are all equal to one and the covariance function is actually a 
correlation function, in the notation of this function, the "sill" is 
sigma2 + rho and the "nugget" is sigma2. Moreover sigma2 and rho are 
constrained so sigma2/rho =lambda. This is why lambda is the crucial 
parameter in this model.  

Although the field is only estimated to the resolution of the grid, 
prediction off of the grid is supported by bilinear interpolation using
the FIELDS function interp.surface. 
}
\section{References}{
Large spatial prediction problems and nonstationary fields (1998) 
Nychka, D., Wikle, C. and Royle, J.A.  

FIELDS manual 
  
}
\seealso{
plot.krig.image, predict.krig.image, exp.image.cov, sim.krig.image  
}
\examples{
# 
# fit a monthly precipitation  field over the Rocky Mountains 
# grid is 64X64 
out<- krig.image( x= precip$x, Y = precip$y, m=64,n=64,cov.function= 
exp.image.cov,  
lambda=.5, theta=1, kmax=100)  

#  
# range parameter for exponential here is .5 degree in lon and lat.  
#diagnostic plots.  
plot( out)  

# CV predictions and RMSE to judge adequacy of lambda choice 
pred.cv<- predict( out, precip$x.cv) 
sqrt(mean( ( pred.cv- precip$y.cv)^2, na.rm=TRUE)) 

# look at the surface 
image.plot( out$surface)  #or just      surface( out)

#
#simulate 4 realizations from the conditional distribution 
look<- sim.krig.image( out, nreps=4) 
# take a look:  plot( look)
 
# check out another values of lambda reusing some of the objects from the 
# first fit 

out2<- krig.image( precip$x, precip$y, cov.function= exp.image.cov, 
lambda=4, 
start= out$omega2,cov.obj=out$cov.obj)
#
# some of the obsare lumped together into a singel grid box
#
# find residuals among grid box means and predictions
res<- predict( out2, out2$xM) - out2$yM
#compare with sizes of out2$residuals (raw y data) 

#starting values from first fit  in out$omega2 
# covariance and grid information are 
# bundled in the cov.obj 
## 

#
## fitting a thin plate spline. The default here is a linear null space 
## and  second derivative type penalty term.  
##  you will just have to try different values of lambda vary them on  
##  log scale to 
 
out<- krig.image( precip$x, precip$y, cov.function=rad.image.cov, 
lambda=1, m=64, n=64, p=2, kmax=300) 

# take a look: image.plot( out$surface) 

# check out  different values reuse some of the things to make it quicker 
# note addition of kmax argument to increase teh number of iterations

out2<- krig.image( precip$x, precip$y,cov.function=rad.image.cov,  
lambda=.5, start= out$omega2, cov.obj=out$cov.obj, kmax=400) 

# here is something rougher  
out3<- krig.image( precip$x, precip$y,cov.function=rad.image.cov, 
lambda=1e-2, start= out2$omega2, cov.obj=out$cov.obj,kmax=400,
tol=1e-3) 

# here is something close to an interpolation  
out4<- krig.image( precip$x, precip$y,cov.function=rad.image.cov, 
lambda=1e-7, start= out3$omega2, cov.obj=out$cov.obj,kmax=500, tol=1e-3)
 
#compare the the four surfaces: 
# but note the differences in scales ( fix zlim to make them the same) 
# 
# take a look
# set.panel( 2,2) 
# image.plot( out$surface) 
# points( out$x, pch=".") 

# image.plot( out2$surface) 
# image.plot( out3$surface) 
# image.plot( out4$surface) 
 
# some diagnostic plots) 
set.panel( 4,4) 
plot( out, graphics.reset=FALSE) 
plot( out2, graphics.reset=FALSE) 
plot( out3, graphics.reset=FALSE) 
plot( out4, graphics.reset=FALSE) 
set.panel(1,1)
}

\keyword{spatial}
% docclass is function
% Converted by Sd2Rd version 1.21.

\eof
\name{lennon}
\alias{lennon}
\title{
  Gray image of John Lennon.
}
\description{
A 256X256 image of John Lennon.
}
\keyword{datasets}
% docclass is data
% Converted by Sd2Rd version 1.21.

\eof
\name{make.Amatrix.Krig}
\alias{make.Amatrix.Krig}
\title{
  Computes the  prediction matrix for a Krig fit. 
}
\description{
For fixed covariance parameters the Krig estimate is a linear function of
the data. This function return the matrix that maps the observed y vector
into the predicted values.
}
\usage{
make.Amatrix.Krig(out, x0=out$x, lambda)
}
\arguments{
\item{out}{
The output object from using Krig to fit a data set 
}
\item{x0}{
The points where the function is to be predicted 
}
\item{lambda}{
Value of the smoothing parameter. Default is value from the Krig
object. 
}
}
\value{
A matrix such that when multiplied times the data vector Y gives the
predicted values 
of the spatial process estimate at the points x0. 
}
\seealso{
Krig, make.Amatrix, predict.se.Krig  
}
\examples{
# Compute the A matrix or "hat" matrix for a spatial process estimate
# with an exponential covariance, range= 100.
# check that this gives the same predicted values 
krig.out<- Krig( ozone$x, ozone$y, exp.cov, theta=100)
A<- make.Amatrix( krig.out, ozone$x)
test.fitted.values<- A\%*\%ozone$y  

# now compare this to predict( krig.out) or krig.out$fitted.values 
#                    they are all  the same! 
}
\keyword{spatial}
% docclass is function
% Converted by Sd2Rd version 1.21.

\eof
\name{make.Amatrix}
\alias{make.Amatrix}
\title{
  Matrix relating predicted values to the dependent (Y) values 
}
\description{
For a fixed value of the smoothing parameter or the covariance 
function some nonparametric curve estimates are linear functions of 
the observed data. This is a intermediate  level function that 
computes the linear weights to be applied to the observations to 
estimate the curve at a particular point. For example the predicted 
values can be represented as Ay where A is an N X N matrix of 
coefficients and Y is the vector of observed dependent variables. For 
linear smoothers the matrix A may depend on the smoothing parameter ( 
or covariance function and the independent variables (X) but NOT on Y.    
}
\usage{
make.Amatrix(object, ...)
}
\arguments{
Output object from fitting a data set using a FIELD regression
method. 
Currently this is supported only for Krig ( and Tps) functions. 

\item{object}{

}
\item{\dots}{
Additional arguments that indicate the value of the smoothing 
parameter to use and the X values where predictions should be made.  
}
}
\value{
A matrix where the number of rows is equal to the number of predicted points 
and the number of columns is equal to the length of the Y vector.  
}
\details{
The main use of this function is in finding prediction standard errors. 

For the Krig ( and Tps) functions the A matrix is constructed based on the
representation of the estimate as a generalized ridge regression.  The
matrix expressions are explained in the references from the FIELDS manual.
For linear regression the matrix that gives predicted values is often
referred to as the "hat" matrix and is useful for regression diagnostics.  
For smoothing problems the effective number of parameters in the fit is
usually taken to be the trace of the A matrix. Note that while the A
matrix is usually constructed to predict the estimated curve at the data
point this S function does not have such restrictions. This is possible
because any value of the estimated curve will be a linear function of Y.  
}
\section{References}{
Nychka (2000) "Spatial process estimates as smoothers." 
}
\seealso{
Krig, Tps 
}
\examples{
# Compute the A matrix or "hat" matrix for a thin plate spline 
# check that this gives the same predicted values  
tps.out<-Tps( ozone$x, ozone$y)
A<-make.Amatrix( tps.out, ozone$x)
test<- A\%*\%ozone$y 
# now compare this to predict( tps.out) or tps.out$fitted.values 
#                    they should be the same 
stats( test- tps.out$fitted.values)
}
\keyword{spatial}
% docclass is function
% Converted by Sd2Rd version 1.21.

\eof
\name{matern.cov}
\alias{matern.cov}
\title{
  Matern covariance function 
}
\description{
Given two sets of locations computes the Matern cross covariance matrix
for covariances among all pairings. 
}
\usage{
matern.cov
(x1, x2, theta = rep(1, ncol(x1)), smoothness = 0.5, scale=1)
}
\arguments{
\item{x1}{
Matrix of first set of locations where each row gives the coordinates of a
particular
point.
}
\item{x2}{
Matrix of second set of locations where each row gives the coordinates of
a particular point. If this is missing x1 is used. 
}
\item{theta}{
Range (or scale) parameter. This can be a scalar or a vector that is the
same length as the dimension of the locations. Default is theta=1.
}
\item{smoothness}{
The shape parameter for the Matern family. The exponential
is found with smoothness = 0.5 as smoothness goes to infinity one
recovers the Gaussian. 
}
\item{scale}{ 
Marginal variance. 
}
}
\value{
The cross covariance matrix between locations x1 and x2. If x1 is
equal to x2 then this is the covariance matrix for this set of locations. 
In general if nrow(x1)=m and nrow(
x2)=n then the returned matrix, Sigma will be mXn.
Under some cases when the range is very small  
calculation of the Bessel functions fails and if so an NA will be 
returned. 

}
\details{
Derivatives of sample paths:
In d dimensions a Gaussian process with Matern covariance and smoothness 
parameter 
nu will have nu + d/2 derivatives that exist in a mean square sense. 
The marginal variance is given by the parameter scale. When this 
parameter is set to one this yields a correlation 
function. 

There several different ways to parameterize the Matern family and the 
reader is referred to Stein's book page 49 for discussion. In terms 
of the more geostatistical terminology, we note that out theta is also the 
"range" and the scale is also the "sill" if there is no nugget variance 
included in the covariance. We caution that the range for this function 
gives a qualitatively different scaling as one varies the smoothness. 

Functional Form: If x1 and x2 are matrices where nrow(x1)=m and nrow(
x2)=n  and each row are the coordinates of a location, then this
function should return a mXn matrix where the (i,j) element is the
covariance between the locations x1[i,] and x2[j,]. The
covariance is found as  H( D.ij) where  D.ij is the Euclidean
distance between  x1[i,] and x2[j,] but having first been scaled by theta.
H is proportional to a modified Bessel function 
of third kind using denoted by K.nu .  In our parameterization we take 
smoothness = nu and H is normalized so that H(0)=1. (See the function matern for a succinct definition as R code.) 
The reader is referred 
to Stein's book, page 31 for more details. Note that we do not use Stein's 
normalization, however, as it seems more useful to normalize the 
covariance so that .     


Definition of the distance matrix: 
D.ij = sqrt(  sum.k (( x1[i,k] - x2[j,k]) /theta[k])**2 ).

Note that if theta is a scalar then this defines an isotropic covariance
function. 

Implementation: The function rdist is a useful FIELDS function that finds
the cross
distance matrix ( D defined above) for two sets of locations. Thus in
compact S code we have  

u <- t(t(x1)/theta)
v <- t(t(x2)/theta)
H(-rdist(u, v))

A simple modification of this function for the user would be to substitute
rdist.earth for rdist to give a distance metric that makes sense for
lon/lat coordinates. 
}
\seealso{
 Krig, matern, rdist, rdist.earth, gauss.cov, exp.image.cov 
}
\examples{
#
# Presenting the Matern family:
# the function matern is called by matern.cov
d<- seq( 0,5,,200)
sm<- seq( .5, 8,,5)
temp<- matrix( NA, 200, 5)
for ( k in 1:5){
temp[,k] <- matern(d, smoothness=sm[k])
}
matplot( d, temp, type="l", lty=1)
# note differing correlation scales depending on smoothness 


# Matern covariance matrix ( marginal variance =1) for the ozone
# locations 
out<- matern.cov( ozone$x, theta=100, smoothness=1.0)
# out is a 20X20 matrix

out2<- matern.cov( ozone$x[6:20,],ozone$x[1:2,], theta=100, 
smoothness=1.0)

# out2 is 15X2 cross covariance matrix 

# Kriging fit using a Matern covariance and where the nugget  and 
# sill variances are found by GCV 
fit<- Krig( ozone$x, ozone$y, matern.cov, theta=100, smoothness=1.0)

}
\keyword{spatial}
% docclass is function
% Converted by Sd2Rd version 1.21.

\eof
\name{minitri}
\alias{minitri}
\title{
  Mini triathlon results
}
\description{
Results from a mini triathlon sponsored by Bud Lite, held in
Cary, NC, June 1990. Times are in minutes for the male 30-34 
group. Man was it hot and humid! (DN)

The events in  order were
swim:  (1/2 mile)
bike:  (15 miles)
run:   (4 miles)

<s-section 
name= "DATA DESCRIPTION">
This is a dataframe. Row names are the place within this age group based 
on total time.  
}
\arguments{
\item{swim}{
swim times 
}
\item{bike}{
bike times 
}
\item{run}{
run times 
}
}
\keyword{datasets}
% docclass is data
% Converted by Sd2Rd version 1.21.

\eof
\name{nkreg}
\alias{nkreg}
\title{
  Normal kernel regression estimate 
}
\description{
Estimates a univariate or multivariate regression surface 
using a normal kernel function and a fixed bandwidth. 
}
\usage{
nkreg(data.x, data.y, bandwidth, n.points=50, grid=NULL, grid.list=NULL)
}
\arguments{
\item{data.x }{
a matrix of data locations
}
\item{data.y }{
a vector of values for smoothing 
}
\item{bandwidth}{
bandwidth for kernel if a vector then an estimate will be be found for each 
bandwidth. 
}
\item{n.points }{
Number of equally spaced points to evaluate a univariate estimate 
estimate or a 2-d estimate on a regular grid. 
}
\item{grid}{
matrix of locations to evaluate the kernel estimate
}
\item{grid.list }{
A grid.list that describes the regular grid to evaluate the estimate.
If it is missing the default for 2-d is to create a grid 
}
}
\value{

\item{x}{
Points for evaluation
}
\item{y}{
estimate of curve or surface. If more than one bandwidth is supplied then 
y is matrix with columns indexed by the bandwidth values
}
\item{h}{
bandwidths used. 
}
\item{grid.list}{
grid.list that was either passed or created. 
}
}
\seealso{
Tps, Krig, sreg, smooth.2d, image.smooth
}
\examples{
out<- nkreg( rat.diet$t, rat.diet$con, bandwidth=3, n.points=100)
plot( rat.diet$t, rat.diet$con)
lines( out$x, out$y)

# 2-d example evaluate at 40 points
out<- nkreg( precip$x, precip$y, bandwidth=.5, n.points=64)
image.plot( as.surface(out$x, out$y))
}
\keyword{smooth}
% docclass is function
% Converted by Sd2Rd version 1.21.

\eof
\name{ozone}
\alias{ozone}
\title{
  Data set of ozone measurements at 20 Chicago monitoring stations. 
}
\description{
The \code{ozone} data is a list of 
components, x and y.  x 
component is longitude and latitude position of each of the 20 
Chicago monitoring stations, y is the average 
daily ozone values over the time period 6/3/87-8/30/87 and lon.lat is 
the longitude-latitude locations of the data.
}
\usage{
data(ozone)
}
\format{
This data set is a list containing the following components: 
}
\describe{
\item{x}{
Longitude-latitude postion of monitoring stations. 
}
\item{y}{
Average daily ozone values over 1987 summer. 
}
}
\source{
AIRS, the EPA air quality data base. 
}
\seealso{
Tps, Krig  
}
\examples{
fit<- Tps(ozone$x, ozone$y) 
# fitting a surface to ozone measurements. 
surface( fit, type="I")
}
\keyword{datasets}
% docclass is function
% Converted by Sd2Rd version 1.21.

\eof
\name{ozone2}
\alias{ozone2}
\title{
  Daily 8-hour ozone averages for sites in the Midwest
}
\description{
The response is 8-hour average (surface) ozone ( from 9AM-4PM) measured in
parts per billion (PPB) for 153 sites in the midwestern US over the period
June 3,1987 through August 31, 1987, 89 days. This season of high 
ozone corresponds with a large modeling experiment using the EPA Regional
Oxidant Model.
}
\usage{
data(ozone2)
}
\format{
The data list has components:
<s-args>
<s-arg name="y">
a 89X153 matrix of ozone values. Rows are days and columns are the 
sites. 
</s-arg>
</s-arg name="lon.lat"> 
Site locations in longitude and latitude as a 153X2 table
</s-arg>
<s-arg name="chicago.subset">
Logical vector indicating stations that form teh smaller 
Chicagoland subset. (see FIELDS ozone data set)
</s-arg>
</s-args>
<s-section name="Reference">
Nychka, D., Cox, L., Piegorsch, W. (1998) Case Studies in Environmental 
Statistics Lecture Notes in Statistics, Springer
Verlag, New York 
}
\examples{
data( ozone2)

# pairwise correlation among all stations
# ( See cover.design to continue this example)
cor.mat<- cor( ozone2$y, use="pairwise")

#raw data image for day number 16 
good<- !is.na( ozone2$y[16,])
out<- as.image( ozone2$y[16,good], x=ozone2$lon.lat[good,])
image.plot( out)
}
\keyword{datasets}
% docclass is data
% Converted by Sd2Rd version 1.21.

\eof
\name{plot.Krig}
\alias{plot.Krig}
\title{
  Diagnostic and summary plots of the Krig object 
}
\description{
Plots a series of four diagnostic plots that summarize the fit from Krig. 
}
\usage{
plot.Krig(out, main=NA, digits=4, which=c(TRUE,T,T,TRUE), graphics.reset=TRUE,
...)
}
\arguments{
\item{out}{
A Krig output object. 
}
\item{main}{
Title of the plot. Default is the function call. 
}
\item{digits}{
Number of significant digits for the RMSE label. 
}
\item{graphics.reset}{
Reset to original graphics parameters after plotting. Default is TRUE.
}
\item{which}{
A vector of 4 logical values. 
Controls which of the four graphs to plot. 
}
\item{\dots}{
Optional graphics arguments to pass to each plot. 
}
}
\details{
This function creates four summary plots of the Krig object. The default
is to put these in a 2X2 panel. However if the screen is already divided
in some other fashion the plots will just be added according to that
scheme. This option is useful to compare to compare several different
model fits.

The first is a scatterplot of predicted value against observed.

The second plot is "standardized" residuals against predicted value.  
Here we mean that the residuals are divided by the GCV estimate for sigma
and multiplied by the square root of any weights that have been specified.
In the case of a "correlation model" the residuals are also divided by the
marginal standard deviation from this model.

The third plot are the values of the GCV function against the effective
degrees of freedom. When there are replicate points several versions of
the GCV function may be plotted.  GCV function is with respect to the
standardized data if a correlation model is specified. A vertical line
indicates the minimium found.

The fourth plot is a histogram of the standardized residuals. 
}
\seealso{
Krig, summary.Krig, Tps  
}
\examples{
fit<-Krig(ozone$x, ozone$y,exp.cov, theta=200)  
# fitting a surface to ozone  
# measurements 
plot(fit)
}
\keyword{spatial}
% docclass is function
% Converted by Sd2Rd version 1.21.

\eof
\name{plot.sreg}
\alias{plot.sreg}
\title{
  Plots smoothing spline regression object 
}
\description{
Plots a series of three plots that summarizes the smoothing spline regression 
object. 
}
\usage{
plot.sreg
(out, main = NA, digits = 4, which = c(TRUE, TRUE, TRUE, TRUE), graphics.reset
= TRUE, ...)
}
\arguments{
\item{out}{
A sreg object 
}
\item{main}{
Title of the plot. Default is the function call. 
}
\item{digits}{
Number of significant digits for the RMSE label. 
}
\item{which}{
Logical vector of length 4 that controls which of the four graphs to
plot. Default is to plot all 4. 
}
\item{graphics.reset}{
Reset to original graphics parameters after plotting. Default is TRUE.
}
\item{\dots}{
Optional plotting arguments that are passed to the first two scatterplots. 
e.g pch="."
}
}
\details{
This function creates four summary plots of the sreg object-- the results 
of fitting a cubic smoothing spline to a data set. The
first plot is a plot of the sreg fit(s) to the data. The second is
predicted values vs 
residuals, and the third is effective number of parameters vs estimated  
average squared prediction errors. The fourth is a histogram ( or
boxplots) of residuals. 
}
\seealso{
sreg, plot  
}
\examples{
fit<-sreg(rat.diet$t,rat.diet$con)
# fit rat data
plot(fit)                       # plot sreg fit 
}
\keyword{smooth}
% docclass is function
% Converted by Sd2Rd version 1.21.

\eof
\name{plot.surface}
\alias{plot.surface}
\title{
  Plots a surface 
}
\description{
Plots a surface object in several different ways to give 3-d
information e.g. a contour plots, perspective plots.  
}
\usage{
plot.surface
(obj, main = NULL, type = "b", zlab = NULL, xlab = NULL,
    ylab = NULL, levels = NULL, zlim = NULL, graphics.reset = NULL,
   ...)
}
\arguments{
\item{obj}{
A surface object. At the minimum a list with components x,y and z 
in the same form as the input list for the standard contour and persp
functions. This can also be an object from predict.surface. 
}
\item{main}{
Title for plot. 
 
}
\item{type}{
type="p" for a perspective plot, type="c" for a contour plot  
and type="b" for both (default). type="I" for an image plot with a legend
strip (see image.plot). type="C" is the "I" option with contours lines
added. 
}
\item{zlab}{
z-axes label 
}
\item{xlab}{
x-axes label 
}
\item{ylab}{
y-axes labels 
}
\item{levels}{
Vector of levels to be passed to contour function. 
}
\item{graphics.reset}{
Reset to original graphics parameters after function plotting. 
Default is to reset if type ="b" but not for the single plot options.  
}
\item{zlim}{
Sets z limits on perspective plot. }
\item{\dots}{
Other graphical parameters that are passed along to either persp, contour
or image. 
}
}
\seealso{
surface, predict.surface, as.surface,   
}
\examples{
fit<- Tps( BD[,1:4], BD$lnya) # fit surface to data 

# make grid list 
grid<-list( KCl="x", MgCl2=mean(BD[,2]),KPO4="y", dNTP=mean(BD[,4]))

# evalute on a grid on two 
# variables holding two fixed at their mean levels 
out.p<-predict.surface(fit, grid, extrap=TRUE)  

plot.surface(out.p, type="C") # surface plot  
}
\keyword{hplot}
% docclass is function
% Converted by Sd2Rd version 1.21.

\eof
\name{poisson.cov}
\alias{poisson.cov}
\title{
  Poisson spherical covariance function 
}
\description{
Given two sets of locations in lon/lat computes the cross covariance 
matrix for
the Poisson covariance among all pairings. 
}
\usage{
poisson.cov(x1, x2, eta = .2)
}
\arguments{
\item{x1}{
Matrix of first set of locations where each row gives the coordinates of a
particular
point. First column is longitudes and the second column is latitudes.
}
\item{x2}{
Matrix of second set of locations where each row gives the coordinates of
a particular point. If this is missing x1 is used. 
}
\item{eta}{
Range (or scale) parameter. Should be in the interval [0,1]
}
}
\value{
If nrow(x1)=m and nrow(x2)=n then the returned cross covariance matrix, 
will be mXn. 
}
\details{
This covariance is one of the few closed form covariances for the sphere
and also know as the Poisson kernel.  If x1 and x2 are matrices where
nrow(x1)=m and nrow(x2)=n then this function should return a mXn matrix
where the (i,j) element is the covariance between the locations x1[i,] and
x2[j,]. The covariance is found as
 
(1-eta**2)/(1 - 2 * eta * D.ij + eta**2)**(1.5)

where  D.ij is the great circle 
distance between  x1[i,] and x2[j,].
}
\seealso{
Krig, rdist.earth
}
\examples{
# plot of covariance

x<- make.surface.grid( list( x=seq( -180,180,,40), y= seq( -85,85,,40)))
x0<- matrix( c(0,0), ncol=2)
look<- poisson.cov( x,x0, eta=.5)
image.plot(as.surface(x,look))
}
\keyword{spatial}
% docclass is function
% Converted by Sd2Rd version 1.21.

\eof
\name{precip}
\alias{precip}
\title{
  Standardized monthly precipitation for August 1963 inteh Rocky Mountain 
Region
}
\description{
This is a useful spatial data set of moderate size consisting of 800 
locations The list has 
components:
}
\usage{
data(precip)
}
\format{
This data set is a list containing the following components: 
}
\describe{
\item{x}{
Longitude-latitude postion of monitoring stations. 
}
\item{y}{
Standardized precipitaton. The square root of precip has 
been standardized by subtracting the 30 year ( 1960-1989) mean and 
dividing 
by the standard deviation. This is a simple way to transform to a process  
that closer to a stationary Gaussian field.
}
\item{x.cv}{
Additional locations for cross-validation. The 
locations weere generated as a space-filling type design. 
}
\item{y.cv}{
values for cross validation
}
}
\keyword{datasets}
% docclass is data
% Converted by Sd2Rd version 1.21.

\eof
\name{predict.Krig}
\alias{predict.Krig}
\title{
  Evaluation of Krig spatial process estimate.  
}
\description{
Provides predictions from the Krig spatial process estimate at arbitrary
points, new data (Y) or other values of the smoothing parameter (lambda)
including a GCV estimate. 
}
\usage{
predict.Krig
(out, x = NULL, lambda = NA, df = NA, model = NA,
        eval.correlation.model = TRUE, y = NULL, verbose = FALSE, gcv = FALSE)
}
\arguments{
\item{out}{
Fit object from the Krig or Tps function. 
}
\item{x}{
Matrix of x values on which to evaluate the kriging surface. 
If omitted, the data x values, i.e. out\$x  will be used. 
}
\item{lambda}{
Smoothing parameter. If omitted, out\$lambda will be used. 
(See also df and gcv arguments)
}
\item{df}{
Effective degrees of freedom for the predicted surface. This can be used
in place of lambda ( see the function Krig.df.to.lambda)
}
\item{model}{
Generic argument that may be used to pass a different lambda.  
}
\item{eval.correlation.model}{
If true ( the default) will multiply the predicted function by marginal
sd's
and add the mean function. This usually what one wants. If false will
return predicted surface in the standardized scale. The main use of this
option is a call from Krig to find MLE's of rho and sigma2     
}
\item{y}{
Evaluate the estimate using the new data vector y (in the same order as
the old data). This is equivalent
to recomputing the Krig object with this new data but is more efficient
because many pieces can be reused. Note that the x values are assumed to
be the same. 
}
\item{verbose}{
Print out all kinds of intermediate stuff for debugging 
}
\item{gcv}{
 
Default is false. Find lambda from the y vector using GCV. See the
returned values for a side effect of setting equal to true. 
}
}
\value{
Vector of predicted responses if gcv=F ( the default)
BUT NOTE: If lambda is found by gcv then the returned values is a list
with the first component a vector of predictions and the second the
estimated value of lambda.  
}
\details{
The main goal in this function is to reuse the Krig object to rapidly
evaluate different estimates. Thus there is flexibility in changing the
value of lambda and also the independent data without having to recompute
the matrices associated with the Krig object. The reason this is possible
is that most on the calculations depend on the observed locations not on
lambda or the observed data.  
}
\seealso{
Krig, predict.surface  
}
\examples{
Krig(ozone$x,ozone$y,exp.cov, theta=50) ->fit
predict( fit) # gives predicted values at data points

grid<- make.surface.grid( list( seq( -40,40,,15), seq( -40,40,,15)))

look<- predict(fit,grid) # evaluate on a grid of points

# some useful graphing functions
out.p<- as.surface( grid, look) # reformat into $x $y $z image-type object
contour( out.p)  


# refit with 10 degrees of freedom in surface

look<- predict(fit,grid, df=15)

# re fit with random data and lambda found by GCV
look<- predict( fit, grid, y= rnorm( 20), gcv=TRUE)

# NOTE: look is a list now  look$predicted  predicted values and look$lambda
# the value of lambda

out.p<-as.surface( grid, look$predicted) 
contour( out.p)
}
\keyword{spatial}
% docclass is function
% Converted by Sd2Rd version 1.21.

\eof
\name{predict.se.Krig}
\alias{predict.se.Krig}
\title{
  Standard errors of predictions for Krig spatial process estimate 
}
\description{
Finds the standard error ( or covariance) of prediction based on a linear
combination of
the observed data. The linear combination is usually the "Best Linear
Unbiased Estimate" (BLUE) found from the Kriging equations. There are also
provisions to use a different covariance for evaluation than the one used
to define the BLUE.  
}
\usage{
predict.se.Krig(out, x, cov.function, rho, sigma2, weights=NULL, cov=FALSE,  
stationary=TRUE, fixed.mean=TRUE, ...)
}
\arguments{
\item{out}{
A Krig object.  
}
\item{x}{
Points to compute the SE. 
}
\item{cov.function}{
Name of the true covariance function for the random surface if different from the one  
used to generate predictions. If omitted, then the 
function from the Krig object 
}
\item{rho}{
Parameter that multiplies the covariance function. If omitted the
value 'out\$rho', estimated from the data is used. 
}
\item{sigma2}{
Variance of the measurement error. If omitted the value 'out\$sigma2', 
estimated from the data is used. 
}
\item{weights}{

}
\item{stationary}{
If true the covariance function is assumed to be stationary and more 
efficient computations can be used. 
}
\item{cov}{
If true the full covariance matrix for the predicted values is returned.
Make sure this will not be big if this option is used. ( e.g. 50X50 grid
will return a matrix that is 2500X2500!)  If false just the marginal
standard deviations of the predicted values are returned. Default is
false.
}
\item{fixed.mean}{
If true the mean function is assumed fixed and the variance of this 
component is taken to be zero. If False the variance for this component is 
added to the variance of prediction.   
}
\item{\dots}{
These additional arguments are given to cov.function the "true" covariance 
function, not the one associated with the Kriging weights.   
}
}
\value{
A vector of standard errors for the predicted values of the Kriging fit. 
}
\details{
The predictions are represented as a linear combination of the dependent 
variable, Y. Call this LY.  Based on this representation the conditional 
variance is the same as the expected value of (P(x) + Z(X) - LY)**2.
where 
P(x)+Z(x) is the value of the surface at x and LY is the linear 
combination that estimates this point. Finding this expected value is 
straight forward given the unbiasedness of LY for P(x) and the covariance 
for Z and Y. 

In these calculations it is assumed that the covariance parameters are fixed.
This is an approximation since in most cases they have been estimated from the 
data. It should also be noted that if one assumes a Gaussian field and known 
parameters in the covariance, the usual Kriging estimate is the 
conditional mean of the field given the data. This function finds the 
conditional standard deviations (or full covariance matrix) of the 
fields given the data.  

 There are two useful extensions supported by this function.  Adding
the variance to the estimate of the spatial mean if this is a correlation
model. (See help file for Krig)  and calculating the variances under
covariance misspecification.  Note that the linear combination is based
on the covariance function from the Krig object. One can view this first
step as simply defining a spatial estimator. If the covariance used is
correct it is BLUE, otherwise the MSE for the spatial estimate will be
larger than optimal.  The 'cov.function' argument in this function defaults
to the same covariance used to determine the spatial prediction but
it also can be specified separately, in this case it is interpreted as the true
covariance and the prediction variances are evaluated accordingly. 
}
\section{References}{
See Case Studies in Environmental Statistics  
}
\seealso{
Krig, predict.Krig, predict.surface.se  
}
\examples{
# 
# Note: in these examples predict.se will default to predict.se.Krig using 
# a Krig object  

fit<- Krig(ozone$x,ozone$y,exp.cov, theta=10)    # krig fit 
predict.se.Krig(fit)                        # std errors of predictions 

# make a  grid of X's  
xg<-make.surface.grid( list(seq(-27,34,,40),seq(-20,35,,40)))     
out<- predict.se.Krig(fit,xg)     # std errors of predictions 

#at the grid points out is a vector of length 1600 
# reshape the grid points into a 40X40 matrix etc.  
out.p<-as.surface( xg, out) 
image.plot( out.p) 

# this is equivalent to  the single step function  
# (but default is not to extrapolation beyond data
out<- predict.surface.se( fit) 
image.plot( out) 


# Investigate misspecification 
# 
# first call Krig to create the Krig object.  
# 
Krig( ozone$x, ozone$y, cov.function=exp.cov, theta=100)-> fit 

# note how the new cov. parameters are specified just like in Krig  
predict.se(fit,xg)-> look 
predict.se( fit, xg, cov.function=exp.cov, theta=2.0, sigma2=1)-> look2 

set.panel( 2,1)
image.plot( as.surface( xg, look))
points( fit$x)
image.plot( as.surface( xg, look2))
set.panel( 1,1)
}
\keyword{spatial}
% docclass is function
% Converted by Sd2Rd version 1.21.

\eof
\name{predict.se}
\alias{predict.se}
\title{
  Standard errors of predictions 
}
\description{
Calculates the standard error of predictions. This is
usually the fitted object from a function estimate such as from Krig
or Tps. 
}
\usage{
predict.se(object, ...)
}
\arguments{
\item{object}{
A fitted model object of a certain class 
}
\item{\dots}{
Additional arguments to be passed to 
a particular method. e.g. a grid.list or model specification. }
}
\value{
A vector of standard errors for the predicted values. 
}
\details{
This function is generic and will call the appropriate function to calculate 
the standard errors for the object class. The prediction standard error is
for
the estimated function or parameters (a mean value) not for the
prediction of a new observation.
}
\seealso{
predict, predict.surface.se, predict.se.Krig  
}
\examples{
fit<-Tps(ozone$x,ozone$y)
predict.se(fit)                             # std errors of predictions 
xg<- expand.grid(seq(-15,15,,40),seq(-20,20,,40)) 
out<- predict.se(fit,xg)
image.plot( matrix( out, 40))
}
\keyword{spatial}
% docclass is function
% Converted by Sd2Rd version 1.21.

\eof
\name{predict.surface}
\alias{predict.surface}
\title{
  Evaluates a fitted function as a surface object  
}
\description{
Evaluates a a fitted model on a 2-D grid keeping any other variables constant.
The resulting object is suitable for use with functions for viewing 3-d
surfaces.  
}
\usage{
predict.surface(out, grid.list=NA, extrap=FALSE, chull.mask, model=NA,
nx=30, ny=30,...)
}
\arguments{
\item{out}{
An object from fitting a function to data. In FIELDS this is usually a
Krig object. 
}
\item{grid.list}{
A list with as many components as variables describing the surface. 
All components should have a single value except the two that give the 
grid points for evaluation. If the matrix or data frame has column names,  
these must appear in the grid list. See the grid.list help file for more
details. If this is omitted and the fit just depends on two variables the
grid will be made from the ranges of the observed variables. 
 
}
\item{chull.mask}{
Whether to restrict the fitted surface to be on a convex hull, NA's
are assigned to values outside the
convex hull. chull.mask should be a sequence of points defining a convex
hull. Default is to form the convex hull from the observations if this
argument is missing (and extrap is false).  
}
\item{extrap}{
Extrapolation beyond the range of the data. If false function will be
restricted to the convex hull of the observed data or the hull defined
from the points from the argument chull.mask.
 
}
\item{model}{
Model information used to evaluate the fitted surface. ( E.g. a
lambda value for a Tps fit).
 
}
\item{\dots}{
Any other arguments to pass to the predict function associated with the fit
object. 
}
\item{nx}{
Number of grid points in X axis. }
\item{ny}{
Number of grid points in Y axis. }

}
\value{
The usual list components for making contour and perspective plots 
(x,y,z) along  
with the component containing the grid list. 
}
\details{
This function creates the right grid using the grid.list information or
the defaults (make.surface.grid), calls the predict function for the
object with these points
and also adding any extra arguments passed in the ... section, and then 
reforms the results as a surface object ( as.surface). To determine the 
what parts of the prediction grid are in the convex hull of the data the 
function in.poly is used. See the argument inflation in this function is 
used to include a small margin around the outside of the polygon so that 
point on convex hull are included. This funny addition is to prevent 
excluding grid points that fall exactly on the ranges of the data. 
 }
\seealso{
Tps, Krig, predict, grid.list, make.surface.grid, as.surface, surface , 
in.poly
}
\examples{
fit<- Tps( BD[,1:4], BD$lnya)  # fit surface to data 

# evaluate on a grid on two 
# variables holding two fixed  
# default surface and contour plot  
# make grid list
grid.list<- list( KCl="x", MgCl2=mean(BD[,2]),KPO4="y",dNTP=mean(BD[,4]))

out.p<- predict.surface(fit,grid.list, extrap=TRUE) 

surface(out.p) 

set.panel(1,1)
}
\keyword{spatial}
% docclass is function
% Converted by Sd2Rd version 1.21.

\eof
\name{predict.surface.se}
\alias{predict.surface.se}
\title{
  Standard errors of predictions 
}
\description{
Evaluates the standard error of predictions on a surface. 
}
\usage{
predict.surface.se(out, grid.list=NA, extrap=FALSE, chull.mask,...)
}
\arguments{
\item{out}{
A fitted model object of a certain class 
}
\item{grid.list}{
A list with as many components as variables describing the surface. 
All components should have a single value except the two that give the 
grid points for evaluation. If the matrix or data frame has column names,  
these must appear in the grid list. See the grid.list help file for more
details. If this is omitted and the fit just depends on two variables the
grid will be made from the ranges of the observed variables. 
 
}
\item{chull.mask}{
Whether to restrict the fitted surface to be on a convex hull, NA's
are assigned to values outside the
convex hull. chull.mask should be a sequence of points defining a convex
hull. Default is to form the convex hull from the observations if this
argument is missing (and extrap is false).  
}
\item{extrap}{
Extrapolation beyond the range of the data. If false function will be
restricted to the convex hull of the observed data or the convex hull
defined from the points from the argument chull.mask.
 
}
\item{\dots}{
Any additional arguments that will passed to the predict.se function
specific to the fit object. 
 
}
}
\value{
A surface object with components 
A vector of standard errors for the predicted values. 
}
\details{
This function is generic and will call the appropriate function to calculate 
the standard errors for the object class. It operation is simple  a grid
is created based on the grid list or from the fit object. The prediction
standard error are evaluated on the grid using predict.se. Finally the
standard errors are reformed into a surface object suitable for plotting. 
}
\seealso{
predict, predict.surface, predict.se.Krig, plot.surface, as.surface 
}
\examples{
fit<-Tps(ozone$x,ozone$y)                # tps fit 
out<- predict.surface.se( fit)

surface( out)

# or ... 

image.plot( out)
}
\keyword{spatial}
% docclass is function
% Converted by Sd2Rd version 1.21.

\eof
\name{print.Krig}
\alias{print.Krig}
\title{
  Print kriging fit results. 
}
\description{
Prints the results from a fitting a spatial process estimate (Krig)
}
\usage{
print.Krig(x,digits=4)
}
\arguments{
\item{x}{
Object from krig fitting. 
}
\item{digits}{
Number of significant digits in printed output. Default is 4. 
}
}
\value{
Selected summary results from Krig. 
}
\seealso{
print, summary.Krig, Krig 
}
\examples{
fit<- Krig(ozone$x,ozone$y,exp.cov, theta=100) 
print(fit) # print the summary 
fit # this will work too 
}
\keyword{spatial}
% docclass is function
% Converted by Sd2Rd version 1.21.

\eof
\name{qsreg}
\alias{qsreg}
\title{
  Quantile or Robust spline regression  
}
\description{
Uses a penalized likelihood approach to estimate the conditional  
quantile function for regression data. This method is only implemented  
for univariate data. For the pairs (X,Y) the  
conditional quantile, f(x), is  P( Y<f(x)| X=x) = alpha. This estimate  
is useful for determining the envelope of a scatterplot or assessing  
departures from a constant variance with respect to the independent  
variable.    
}
\usage{
qsreg(x, y, lam=NA, maxit=50, maxit.cv=10, tol=1e-7,  
offset=0, 
sc=sqrt(var(y)) * 1e-05, alpha=0.5, wt=rep(1, length(x)), cost=1, 
nstep.cv=100, hmin=NA, hmax=NA, trmin=2 * 1.05, trmax=0.95 * 
length(unique(x)))
}
\arguments{
\item{x}{
Vector of the independent variable in  y = f(x) + e}
\item{y}{
Vector of the dependent variable}
\item{lam}{
Values of the smoothing parameter. If omitted is found by GCV based on the  
the quantile criterion 
}
\item{maxit}{
Maximum number of iterations used to estimate each quantile spline. 
}
\item{maxit.cv}{
Maximum number of iterations to find GCV minimum. 
}
\item{tol}{
Tolerance for convergence when computing quantile spline. 
}
\item{cost}{
Cost value used in the GCV criterion. Cost=1 is the usual GCV  
denominator. 
}
\item{offset}{
Constant added to the effective degrees of freedom in the GCV function.  
}
\item{sc}{
Scale factor for rounding out the absolute value function at zero to a 
quadratic. Default is a small scale to produce something more like 
quantiles. Scales on the order of the residuals will result is a robust 
regression fit using the Huber weight function. The default is 1e-5 of the 
variance of the Y's. The larger this value the better behaved the problem 
is numerically and requires fewer iterations for convergence at each new 
value of lambda. 
}
\item{alpha}{
Quantile to be estimated. Default is find the median. 
}
\item{wt}{
Weight vector default is constant values. Passing nonconstant weights is a 
pretty strange thing to do.  
}
\item{nstep.cv}{
Number of points used in CV grid search 
}
\item{hmin}{
Minimum value of log( lambda) used for GCV grid search. 
}
\item{hmax}{
Maximum value of log( lambda) used for GCV grid search. 
}
\item{trmin}{
Minimum value of effective degrees of freedom in model used 
for specifying the range of lambda in the GCV grid search. 
}
\item{trmax}{
Maximum value of effective degrees of freedom in model used 
for specifying the range of lambda in the GCV grid search. 
}

}
\value{

\item{trmin trmax }{
Define the minimum and maximum values for the CV grid search in terms of 
the effective number of parameters. (see hmin, hmax) 
Object of class qsreg with many arguments similar to a sreg object.  
One difference is that cv.grid has five columns the last being  
the number of iterations for convergence at each value of lambda.  
}
}
\details{
This is an experimental function to find the smoothing parameter for a  
quantile or robust spline using a more appropriate criterion than mean squared  
error prediction.  
The quantile spline is found by an iterative algorithm using weighted  
least squares cubic splines. At convergence the estimate will also be a  
weighted natural  cubic spline but the weights will depend on the 
estimate. 
Alternatively at convergence the estimate will be a least squares spline applied to the 
empirical psuedo data. The user is referred to the paper by Oh and Nychka ( 2002) for the 
details and properties of the robust cross-validation using empirical psuedo data.
Of course these weights are crafted so that the resulting spline is an  
estimate of the alpha quantile instead of the mean. CV as function of 
lambda can be strange so it should be plotted. 
  
}
\seealso{
\code{\link{sreg}} 
}
\examples{

     # fit a CV  quantile spline
     fit50<- qsreg(rat.diet$t,rat.diet$con)
     # (default is .5 so this is an estimate of the conditional median)
     # control group of rats.
     plot( fit50)
     predict( fit50)
     # predicted values at data points
     xg<- seq(0,110,,50)
     plot( fit50$x, fit50$y)
     lines( xg, predict( fit50, xg))

     # A robust fit to rat diet data
     # 
     SC<- .5* median(abs((rat.diet$con- median(rat.diet$con))))
     fit.robust<- qsreg(rat.diet$t,rat.diet$con, sc= SC)
     plot( fit.robust)

     # The global GCV function suggests little smoothing so 
     # try the local
     # minima with largest lambda instead of this default value.
     # one should should consider redoing the three quantile fits in this
     # example after looking at the cv functions and choosing a good value for
     #lambda
     # for example
     lam<- fit50$cv.grid[,1]
     tr<- fit50$cv.grid[,2]
     # lambda close to df=6
     lambda.good<- max(lam[tr>=6])
     fit50.subjective<-qsreg(rat.diet$t,rat.diet$con, lam= lambda.good)
     fit10<-qsreg(rat.diet$t,rat.diet$con, alpha=.1, nstep.cv=200)
     fit90<-qsreg(rat.diet$t,rat.diet$con, alpha=.9, nstep.cv=200)
     # spline fits at 50 equally spaced points
     sm<- cbind(
 
     predict( fit10, xg),
     predict( fit50.subjective, xg),predict( fit50, xg),
     predict( fit90, xg))
 
     # and now zee data ...
     plot( fit50$x, fit50$y)
     # and now zee quantile splines at 10% 50% and 90%.
     #
     matlines( xg, sm, col=c( 3,3,2,3), lty=1) # the spline
  
}
\keyword{smooth}
% docclass is function
% Converted by Sd2Rd version 1.21.

\eof
\name{rat.diet}
\alias{rat.diet}
\title{
  Experiment studying an appetite supressant in rats.
}
\description{
The `rat.diet' data frame has 39 rows and 3 columns.
These are data from a study of an appetite supressant given to young rats.
The suppressant was removed from the treatment group at around 60 days.
The responses are the median food intake and  each group had approximately 
10 animals. 
}
\usage{
data(rat.diet)
}
\format{
This data frame contains the following columns:
}
\describe{
\item{t}{
Time in days
 
}
\item{con}{
Median food intake of the control group 
 
}
\item{trt}{
Median food intake of the treatment group
 
}
}
\keyword{datasets}
% docclass is data
% Converted by Sd2Rd version 1.21.

\eof
\name{rdist}
\alias{rdist}
\title{
  Euclidean distance matrix 
}
\description{
Given two sets of locations computes the Euclidean distance  matrix
among all pairings. 
}
\usage{
rdist(x1, x2)
}
\arguments{
\item{x1}{
Matrix of first set of locations where each row gives the coordinates of a
particular
point.
}
\item{x2}{
Matrix of second set of locations where each row gives the coordinates of
a particular point. If this is missing x1 is used. 
}
}
\value{
The distance matrix if nrow(x1)=m and nrow(
x2)=n then the returned matrix will be mXn. 
}
\details{
Let D be the mXn distance matrix.  The elements are 
the Euclidean distances between the all locations x1[i,] and x2[j,].

D.ij = sqrt(  sum.k (( x1[i,k] - x2[j,k]) **2 ).


FORTRAN: The default function calls FORTRAN to evaluate the
distances. A pure S code version also exists: rdist.S 
}
\seealso{
  exp.cov, rdist.earth 
}
\examples{
out<- rdist( ozone$x)
# out is a 20X20 matrix.
out2<- rdist( ozone$x[1:5,], ozone$x[11:20,])
#out2 is a 5X10 matrix
}
\keyword{spatial}
% docclass is function
% Converted by Sd2Rd version 1.21.

\eof
\name{rdist.earth}
\alias{rdist.earth}
\title{
  Great circle distance matrix 
}
\description{
Given two sets of longitude/latitude locations computes the Great circle
(geogrpahic)  distance matrix
among all pairings. 
}
\usage{
rdist.earth(loc1, loc2, miles = TRUE, R = NULL)
}
\arguments{
\item{loc1}{
Matrix of first set of lon/lat coordinates first column is the
longitudes
and second is the latitudes. 
}
\item{loc2}{
Matrix of second  set of lon/lat coordinates first column is the
longitudes
and second is the latitudes. If missing x1 is used. 
}
\item{miles}{
If true distances are in statute miles if false distances in kilometers. 
}
\item{R}{
Radius to use for sphere to find spherical distances. If NULL the radius
is either in miles or kilometers depending on the values of the miles
argument. If R=1 then distances are of course in radians. 
}
}
\value{
The great circle distance matrix if nrow(x1)=m and nrow(
x2)=n then the returned matrix will be mXn. 
}
\details{
Surprisingly this  all done efficiently in S.
}
\seealso{
  rdist, exp.earth.cov 
}
\examples{
out<- rdist.earth ( ozone$lon.lat)
#out is a 20X20 distance matrix
}
\keyword{spatial}
% docclass is function
% Converted by Sd2Rd version 1.21.

\eof
\name{set.panel}
\alias{set.panel}
\title{
  Specify a panel of plots 
}
\description{
Divides up the graphics window into a matrix of plots. 
}
\usage{
set.panel(m=1, n=1, relax=FALSE)
}
\arguments{
\item{m}{
Number of rows in the panel of plots 
}
\item{n}{
Number of columns in the panel. 
}
\item{relax}{
If true and the par command is already set for multiple plots,  
then the set.panel command is ignored. The default is  
relax set to false.  
}
}
\details{
After set.panel is called, the graphics screen is reset to 
put  plots  according to a m x n table. Plotting starts in 
the upper left hand corner and proceeds row by row.  After 
m x n plots have been drawn, the next plot will erase the 
window and start in the 1,1 position again.  This function 
is just a repackaging for specifying the mfrow argument to 
par. 
Setting up a panel of plots is a quick way to  change  the 
aspect  ratio  of  the graph (ratio of height to width) or 
the size. For example, plotting 2 plots to a page produces 
a  useful  size  graph  for including in a report. You can 
print out the graphs at any stage without having  to  fill 
up the entire window with plots. This function, except for the "relax"
option is equivalent to the  S sequence: par( mfrow=c(m,n)).
}
\section{Side Effects}{
The function will echo your choice of m and n to the terminal.  
}
\seealso{
\code{\link{par}} 
}
\examples{
set.panel(5,2) #divide screen to hold 10 plots where there are 5 rows  
	       #and 2 columns 
plot( 1:10) 
plot( 2:8)

set.panel() #reset screen to one plot per screen 
}
\keyword{hplot}
% docclass is function
% Converted by Sd2Rd version 1.21.

\eof
\name{sim.rf}
\alias{sim.rf}
\title{
  Simulates a random field  
}
\description{
Simulates a random Gaussian field on a regular grid. 
}
\usage{
sim.rf(obj,...)
}
\arguments{
\item{obj}{
A covariance object that includes information about the covariance function 
and the grid for evaluation. Usually this created by a setup call to 
exp.image.cov. (See details below.) 
}
\item{\dots}{
Additional arguments passed to a particular method.}

}
\value{
A matrix with the random field values 
}
\details{
This function takes an object that includes some preliminary calculations 
and so is more efficient for simulating more than one field from the same 
covariance. However, the algorithm using a 2-d FFT may not always if the
correlation scale is large (See the FIELDS manual for more details.)
For a stationary model the covariance object has the components: 

names( obj) 
 "m"    "n"    "grid" "N"    "M"    "wght"   

.
where m and n are the number of grid points in x and y grid is a list with 
the grid point values for x and y N and M is the size of the larger grid 
that is used for simulation ( usually M= 2*m and N=2*n) to minimize 
periodic effects. wght is a matrix from the FFT of the covariance 
function.  The easiest way to create this object is to use for example 
exp.image.cov with setup=T ( see below). 
To create the object for the wavelet model see  
W.image.cov with setup=T. The FIELDS manual has more information about
this function. 
}
\seealso{
W.image.cov, exp.image.cov, sim.rf.W  
}
\examples{
#Simulate a Gaussian random field with an exponential covariance function,  
#range parameter = 2.0 and the domain is  [0,5]X [0,5] evaluating the 
#field at a 100X100 grid.  
grid<- list( x= seq( 0,5,,100), y= seq(0,5,,100)) 
obj<-exp.image.cov( grid=grid, theta=.5, setup=TRUE)
look<- sim.rf( obj)
# Now simulate another ... 
look2<- sim.rf( obj)
# take a look 
# set.panel(2,1)
# image.plot( grid$x, grid$y, look) 
# image.plot( grid$x, grid$y, look2) 
}
\keyword{spatial}
% docclass is function
% Converted by Sd2Rd version 1.21.

\eof
\name{smooth.2d}
\alias{smooth.2d}
\title{
  Kernel smoother for irregular 2-d data
}
\description{
An approximate Nadaraya Watson kernel smoother is obtained by first
discretizing the locations to a grid and then using convolutions to find 
and to apply the kernel weights. The main advantage of this function
is a smoother that avoids explicit looping. 
}
\usage{
smooth.2d
 (Y, ind = NULL, weight.obj = NULL, setup = FALSE, grid = NULL,
    x = NULL, nrow = 64, ncol = 64, surface = TRUE, cov.function =
gauss.cov, Mwidth = NULL, Nwidth = NULL, ...)
}
\arguments{
\item{Y}{
A vector of 
data to be smoothed   
}
\item{ind}{
Row and column indices that correspond to 
the locations of the data on regular grid. This is most useful when
smoothing the same locations many times. (See also the x argument.)
}
\item{weight.obj }{
An object that 
has the FFT of the convolution kernel and other information ( i.e. the
result from calling this with setup=TRUE).   
}
\item{setup}{
If true creates a list that includes the FFT of the 
convolution kernel. In this case the function will return this
list. Default is false.  
}
\item{grid}{
A list with components x and y 
being equally spaced values that define the grid. Default are integers
1:nrow, 1:ncol. If x is given the ranges will be used to define the grid.  
}
\item{x}{
Actual locations 
of the Y values. Not needed if ind is specified.   
}
\item{nrow}{
 Number of 
points in the horizontal (x) axis of the grid. Not needed if grid is 
specified the default is 64  
}
\item{ncol}{
 Number of points in the vertical (y)
axis of the grid. Not needed if grid list is specified the default is 64 
}
\item{surface}{
If true (the default) a surface object is returned suitable for use by 
image, persp or 
contour functions. If false then just the nrowXncol matrix of smoothed 
values is returned. 
}
\item{cov.function}{
S function describing the kernel function. To be consistent with the other
spatial function this is in the form of a covariance function. The only
assumption is that this be stationary. Default is the (isotropic) Gaussian. 
}
\item{Nwidth}{
The size of the padding  regions of zeroes when computing the 
(exact) convolution of the kernel with the data. The most conservative 
values are 2*nrow and 2*ncol, the default. If the kernel has support of  
say 2L+1 grid points then the padding region need only be of size L+1. 
}
\item{Mwidth}{
See Nwidth.
}
\item{\dots}{
Parameters that are passed to the smoothing kernel. ( e.g. the scale
parameter theta for the
exponential or gaussian)
}
}
\value{
Either a matrix of smoothed values or a surface object.  
The surface object also has a component 'ind' that gives the subscripts of the image 
matrix where the data is present. 
}
\details{
The irregular locations are first discretized to a regular grid ( using
as.image)  
then a 2d- FFT is used to compute a 
Nadaraya-Watson type kernel estimator. Here we take advantage of two
features. The kernel estimator is a convolution and by padding the regular
by zeroes where data is not obsevred one can sum the kernel over irregular
sets of locations. 
A second convolutions to find the normalization of the kernel 
weights.  

The kernel function is specified by an function that should evaluate with
the kernel for two matrices of locations. Assume that the kernel has the
form:  K( u-v) for two locations u and v. The function given as the
argument to cov.function should
have the call myfun( x1,x2) where x1 and x2 are matrices of 2-d locations
if nrow(x1)=m and nrow( x2)=n then this function should return a mXn
matrix where the (i,j) element is K( x1[i,]- x2[j,]).  Optional arguments
that are included in the ... arguments are passed to this function when it
is used. The default kernel is the Gaussian and the argument theta is the
bandwidth. It is easy to write other other kernels, just use exp.cov.S as
a template. 
}
\examples{
# Normal kernel smooth of the precip data with bandwidth of .5 ( degree) 
#  
look<- smooth.2d( precip$y,  x=precip$x, theta=.25)

# finer resolution used in computing the smooth 
look3<-smooth.2d( precip$y, x=precip$x, theta=.25, nrow=256, 
ncol=256,Nwidth=32,
Mwidth=32) 
# if the width arguments were omitted the padding would create a  
# 512X 512 matrix with the data filled in the upper 256X256 part. 
# with a bandwidth of .25 degrees the normal kernel is essentially zero  
# beyond 32 grid points from its center ( about 6 standard deviations) 
#
# take a look:

#set.panel(2,1)
#image( look3, zlim=c(-8,12))
#points( precip$x, pch=".")  
#image( look, zlim =c(-8,12))
#points( precip$x, pch=".")  


# bandwidth changed to .25, exponential kernel   
look2<- smooth.2d( precip$y, x=precip$x, cov.function=exp.cov,theta=.25)
# 


 
}
\keyword{smooth}
% docclass is function
% Converted by Sd2Rd version 1.21.

\eof
\name{splint}
\alias{splint}
\title{
  Cubic spline interpolation 
}
\description{
A fast, FORTRAN based function for cubic spline interpolation. 
}
\usage{
splint(x, y, xgrid, derivative=0)
}
\arguments{
\item{x}{
The x values that define the curve or a two column matrix of  
x and y values. 
}
\item{y}{
The y values that are paired with the x's. 
}
\item{xgrid}{
The grid to evaluate the fitted cubic interpolating curve. 
}
\item{derivative}{
Indicates whether the function or a a first or second derivative 
should be evaluated. 
}
}
\value{
A vector consisting of the spline evaluated at the grid values. 
}
\details{
Fits a piecewise interpolating cubic polynomial to the x and y values
assuming that the second and third derivatives are zero at the range of the x 
values. For this reason extrapolation outside the range of the x 
values will be a linear function. 
}
\section{References}{
See Additive Models by Hastie and Tibshriani. 
}
\seealso{
sreg,  Tps  
}
\examples{
x<- seq( 0, 120,,200)

splint(rat.diet$t, rat.diet$trt,x )-> y

plot( rat.diet$t, rat.diet$trt)
lines( x,y)
#( this is weird!)
}
\keyword{smooth}
% docclass is function
% Converted by Sd2Rd version 1.21.

\eof
\name{sreg}
\alias{sreg}
\title{
  Smoothing spline regression
}
\description{
Fits a cubic smoothing spline to univariate data. The amount of
smoothness can be specified or estimated from the data by GCV. 
<!--brief description-->
}
\usage{
sreg
(x, y, lam = NA, df = NA, offset = 0, wt = rep(1, length(x)), cost = 1, 
nstep.cv = 80, find.diagA = TRUE, trmin = 2.01,
trmax = length(unique(x)) * 0.95, lammin = NA, lammax = NA, verbose = FALSE,
do.cv = TRUE, method = "GCV", rmse = NA, lambda = NA)
}
\arguments{
\item{x}{
Vector of x value
}
\item{y}{
Vector of y values
}
\item{lam}{
Single smoothing parameter or a vector of values . If omitted 
smoothing parameter estimated by GCV.
}
\item{df}{
Amount of smoothing in term of effective degrees of freedom for the
spline 
}
\item{offset}{
an offset added to the term cost*degrees of freedom in the denominator of
the GCV function. (This would be used for adjusting the df from fitting
other models such as in back-fitting additive models.)
}
\item{wt}{
A vector that is proportional to the reciprocal variances of the
errors.
}
\item{cost}{
Cost value to be used in the GCV criterion.
}
\item{nstep.cv }{
Number of grid points of smoothing parameter for GCV grid search
}
\item{find.diagA }{
If true calculate the diagonal elements of the smoothing matrix. The
effective
number of degrees of freedom is the sum of these diagonal elements.
Default is true. This requires more stores if a grid of smoothing
parameters is passed. ( See returned values below.)
 
}
\item{trmin}{
Sets the minimum of the smoothing parameter range  for the GCV grid
search in terms of effective degrees of freedom.
}
\item{trmax}{
Sets the maximum of the smoothing parameter range  for the GCV grid
search in terms of effective degrees of freedom.
}
\item{lammin}{
Same function as trmin but in the lambda scale.
}
\item{lammax}{
Same function as trmax but in the lambda scale.
}
\item{verbose}{
Print out all sorts of debugging info. Default is false! 
}
\item{do.cv }{
Evaluate the spline at the GCV minimum. Default is true.
}
\item{method}{
A character string giving the 
method for determining the smoothing
parameter. Choices are
"GCV", "GCV.one", "GCV.model", "pure error", "RMSE". Default is "GCV"
}
\item{rmse}{
Value of the root mean square error to match by varying lambda. 
}
\item{lambda}{
Another name for lam. This is just for consistency with Krig, Tps. 
}
}
\value{
Returns a list of class sreg. 
Some of the returned components are 

\item{call}{
Call to the function 
}
\item{y}{
Vector of dependent variables. If replicated data is given these are the
replicate group means. 
}
\item{x}{
Unique x values matching the y's. 
}
\item{wt}{
Reciprocal variances. If replicated data is given these are the results of
adding all combining the  weights in each replicate group.  
}
\item{xraw}{
Original  x   data. 
}
\item{yraw}{
Original  y   data. 
}
\item{method}{
Method used to find the smoothing parameter. 
}
\item{pure.ss}{
Pure error sum of squares from replicate groups. 
}
\item{shat.pure.error}{
Estimate of sigma from replicate groups.
}
\item{shat.GCV}{
Estimate of sigma using estimated lambda from GCV minimization 
}
\item{trace}{
Effective degrees of freedom for the spline estimate(s)
}
\item{gcv.grid}{
Values of trace, GCV, shat. etc. for a grid of smoothing parameters.
If lambda ( or df) is specified those values are used.  
}
\item{lambda.est}{
Summary of various estimates of the smoothing parameter
}
\item{lambda}{
If lambda is specified this vector. If missing this the estimated value.
}
\item{residuals}{
Residuals from spline(s). If lambda or df is specified the residuals from
these values. If lambda and df are omitted then the spline having
estimated lambda. This will be a matrix with as many columns as the values
of lambda. 
}
\item{fitted.values}{
Matrix of fitted values. See notes on residuals. 
}
\item{predicted}{
A list with components  x and y. x is the unique values of xraw in sorted
order. y is a matrix of the spline estimates at these values. 
}
\item{eff.df}{
Same as trace.
}
\item{diagA}{
Matrix containing diagonal elements of the smoothing matrix. Number of
columns is the number of lambda values. 
WARNING: If there is replicated data the
diagonal elements are those for the smoothing the group means at the
unique x locations. 
}
}
\details{
MODEL: The assumed model is Y.k=f(x.k) +e.k where e.k should be
approximately
normal and independent errors with variances sigma**2/w.k

ESTIMATE: A smoothing spline is a locally weighted average of the y's
based 
on the relative locations of the x values. Formally the estimate is 
the curve that minimizes the criterion: 

    
(1/n) sum(k=1,n) w.k( Y.k - f( X.k))**2  + lambda R(f) 

where R(f) is the integral of the squared second derivative of f over 
the range of the X values. The solution is a piecewise cubic 
polynomial with the join points at the unique set of X values. The 
polynomial segments are constructed so that the entire curve has 
continuous first and second derivatives and the second and third 
derivatives are zero at the boundaries.  The smoothing has the range 
[0,infinity]. Lambda equal to  zero gives a cubic spline interpolation 
of  the data. As lambda diverges to infinity ( e.g lambda =1e20) the  
estimate will converge to the straight line estimated by least squares.

    The values of the estimated function at the data points can be
expressed in the matrix form:

  
    predicted.values= A(lambda)Y 

where A is an nXn symmetric matrix that does NOT depend on Y. 
The diagonal elements are the leverage values for the estimate and the 
sum of these  (trace(A(lambda)) can be interpreted as the effective 
number of parameters that are used to define the spline function. 
IF there are replicate points the A matrix is the result of finding group
averages and applying a weighted spline to the means. 
The A matrix is also used to find "Bayesian" confidence intervals for the 
estimate, see the example below. 

CROSS-VALIDATION:The GCV criterion with no replicate points for a fixed
value of lambda is

 (1/n)(Residual sum of squares)/((1-(tr(A)-offset)*cost + offset)/n)**2, 

Usually offset =0 and cost =1. Variations on GCV with replicate points are
described in the documentation help file for Krig.  With an appropriate
choice for the smoothing parameter, the estimate of sigma**2 is found by
(Residual sum of squares)/tr(A).

COMPUTATIONS: The computations for 1-d splines exploit the banded
structure of the matrices needed to solve for the spline coefficients.
Banded structure also makes it possible to get the diagonal elements of A
quickly. This approach is different from the algorithms in Tps and
tremendously more efficient for larger numbers of unique x values ( say >
200). The advantage of Tps is getting "Bayesian" standard errors at
predictions different from the observed x values. This function is similar
to the S-Plus smooth.spline. The main advantages are more information and
control over the choice of lambda and also the FORTRAN source code is
available (css.f).
 
}
\seealso{
Krig, Tps  
}
\examples{
# fit a GCV spline to  
# control group of rats.  
fit<- sreg(rat.diet$t,rat.diet$con)
summary( fit)

plot(fit)                       # diagnostic plots of  fit 
predict( fit) # predicted values at data points 

xg<- seq(0,110,,50) 
sm<-predict( fit, xg) # spline fit at 50 equally spaced points 
der.sm<- predict( fit, xg, deriv=1) # derivative of spline fit 
set.panel( 2,1) 
plot( fit$x, fit$y) # the data 
lines( xg, sm) # the spline 
plot( xg,der.sm, type="l") # plot of estimated derivative 
set.panel() # reset panel to 1 plot


# the same fit using  the thin plate spline numerical algorithms 
# (NOTE: sreg is more efficient for 1-d problems) 
fit.tps<-Tps( rat.diet$t,rat.diet$con)
summary( fit.tps) 

# finding approximate standard errors at observations

SE<- fit$shat.GCV*sqrt(fit$diagA)

# compare to predict.se( fit.tps) differences are due to 
# slightly different lambda values and using shat.MLE instad of shat.GCV
#

# 95% pointwise prediction intervals
Zvalue<-  qnorm(.0975)
upper<- fit$fitted.values + Zvalue* SE
lower<- fit$fitted.values - Zvalue* SE
#
# conservative, simultaneous Bonferroni bounds
#
ZBvalue<-  qnorm(1- .025/fit$N)
upperB<- fit$fitted.values + ZBvalue* SE
lowerB<- fit$fitted.values - ZBvalue* SE
#
# take a look

plot( fit$x, fit$y)
lines( fit$predicted, lwd=2)
matlines( fit$x, 
cbind( lower, upper, lowerB, upperB), type="l", col=c( 2,2,4,4), lty=1)
title( "95 pct pointwise  and simultaneous intervals")
# or try the more visually  honest:
plot( fit$x, fit$y)
lines( fit$predicted, lwd=2)
segments(  fit$x, lowerB, fit$x, upperB, col=4)
segments(  fit$x, lower, fit$x, upper, col=2, lwd=2)
title( "95 pct pointwise  and simultaneous intervals")








# replicated data
# this is a simulated case. Find lambda by matching rmse to be .2
# and use this estimate of lambda
sreg( test.data2$x, test.data2$y, rmse=.2, method="RMSE")-> fit

set.panel( 1,1)
}
\keyword{smooth}
% docclass is function
% Converted by Sd2Rd version 1.21.

\eof
\name{stats}
\alias{stats}
\title{
  Calculate summary statistics 
}
\description{
Various summary statistics are calculated for different 
types of data. 
}
\usage{
stats(x, by)
}
\arguments{
\item{x}{
The data structure to compute the statistics. This can either be a 
vector, matrix (data sets are the columns), or a list (data sets are 
the components). 
}
\item{by}{
If x is a vector, an optional vector (either character or numerical) 
specifying the categories to divide x into separate data sets. 
}
}
\value{
A matrix where rows index the summary statistics and the columns 
index the separate data sets. 
}
\details{
Stats breaks x up into separate data sets and then calls describe 
to calculate the statistics. 
Statistics are found by columns for matrices, by components for a list and
by the relevent groups when a  numeric vector and a by  vector are given.
The default set of statistics are the number of 
(nonmissing) observations, mean, standard deviation, minimum, lower quartile, 
median, upper quartile, maximum, and number of missing observations.  If any 
data set is nonnumeric, missing values are returned for the statistics. 
The by argument is a useful way to calculate statistics on parts of a 
data set according to different cases. 
}
\seealso{
stats.bin, stats.bplot, describe
}
\examples{
#Statistics for 8 normal random samples: 
zork<- matrix( rnorm(200), ncol=8) 
stats(zork) 

zork<- rnorm( 200)
id<- sample( 1:8, 200, replace=TRUE)
stats( zork, by=id)
}
\keyword{univar}
% docclass is function
% Converted by Sd2Rd version 1.21.

\eof
\name{stats.bin}
\alias{stats.bin}
\title{
  Bins data and finds some summary statistics. 
}
\description{
Cuts up a numeric vector based on binning by a covariate and applies the
fields 
stats function to each group 
}
\usage{
stats.bin(x, y, N = 10, breaks = NULL)
}
\arguments{
\item{x}{
Values to use to decide bin membership
}
\item{y}{
A vector of data
}
\item{N}{
Number of bins. If the breaks is missing there are N bins equally spaced
on the range of x.
}
\item{breaks}{
The bin boundaries. If there are N+1 of these there will be N bins. 
The bin widths can be unequal.
}
}
\value{
A list with several components. stats is a matrix with columns indexing
the bins and
rows being summary statistics found by the stats function. These are:
 number of obs, mean, sd, min, quartiles, max and number of NA's. 
(If there is no data for a given bin, NA's are filled in. )
breaks are the breaks passed to the function and centers are the bin
centers. 
}
\seealso{
bplot, stats
}
\examples{
u<- rnorm( 2000)
v<- rnorm( 2000)
x<- u
y<- .7*u + sqrt(1-.7**2)*v

look<- stats.bin( x,y) 
look$stats["Std.Dev.",]

data( ozone2)
# make up a variogram day 16 of Midwest daily ozone ...
look<- vgram( ozone2$lon.lat, c(ozone2$y[16,]), lon.lat=TRUE)

# break points
brk<- seq( 0, 250,,40)

out<-stats.bin( look$d, look$vgram, breaks=brk)
# plot bin means, and some quantiles  Q1, median, Q3
matplot( out$centers, t(out$stats[ c("mean", "median","Q1", "Q3"),]), 
type="l",lty=c(1,2,2,2), col=c(3,4,3,4), ylab="ozone PPB")
}
\keyword{univar}
% docclass is function
% Converted by Sd2Rd version 1.21.

\eof
\name{summary.Krig}
\alias{summary.Krig}
\title{
  Summary for Krig spatial process estimate 
}
\description{
Creates a list of summary results including estimates for  the nugget
variance (sigma) and the smoothing
parameter (lambda). This list is usually printed using print.summary.Krig.
}
\usage{
summary.Krig(x, digits=4)
}
\arguments{
\item{x}{
A Krig object. 
}
\item{digits}{
Number of significant digits in summary. 
}
}
\value{
Gives a summary of the Krig object. The components 
include the function call, number of observations, effective degrees  
of freedom, residual degrees of freedom, root mean squared error,  
R-squared and adjusted R-squared, log10(lambda), cost, GCV minimum and  
a summary of the residuals.  
}
\details{
This function is a method for the generic function summary for class
Krig. The results are formatted and printed using print.summary.Krig.
}
\seealso{
Krig, summary, print.summary.Krig  
}
\examples{
fit<- Krig(ozone$x, ozone$y, exp.cov, theta=100)  
summary(fit)                            # summary of fit 
}
\keyword{spatial}
% docclass is function
% Converted by Sd2Rd version 1.21.

\eof
\name{surface.Krig}
\alias{surface.Krig}
\title{
  Plots a surface and contours 
}
\description{
Creates different plots of the fitted surface of a Krig object. This is a
quick way to look at the fitted function over reasonable default
ranges.  
}
\usage{
surface.Krig(obj, grid.list=NA, extrap=FALSE, graphics.reset=TRUE, 
 xlab = NULL, ylab = NULL, main = NULL, zlab = NULL, zlim = NULL, 
    levels = NULL, type = "b",  nx=30, ny=30,...)
}
\arguments{
\item{obj}{
A Krig object. 
}
\item{grid.list}{
A list with as many components as variables describing the surface. 
All components should have a single value except the two that give the 
grid points for evaluation. If the matrix or data frame has column names,  
these must appear in the grid list. If grid.list is missing an the
surface has just two dimensions the grid is based on the ranges of the
observed data.
 
}
\item{extrap}{
Extrapolation beyond the range of the data. If false only the
convex hull of the observations is plotted. Default is false. 
}
\item{graphics.reset}{
Reset to original graphics parameters after function plotting. 
}
\item{type}{
Type of plot as a character. "p" perspective plot (persp). "c" contour
plot (contour). "b" a two panel figure with perspective and contour
plots. "I" image plot with legend strip (image.plot). "C" image plot
with contours overlaid.  Both perspective and contour is the default.
  
}
\item{main}{
Title of plot}
\item{xlab}{
x axis label}
\item{ylab}{
y axis label}
\item{zlab}{
z axis label if "p" or "b" type is used.}
\item{zlim}{
Z limits passed to persp}
\item{levels}{
Contour levels passed to contour. }
\item{nx}{
 Number of grid points to evaluate surface on the horizontal 
axis (the x-axis). }

\item{ny}{
 Number of grid points to evaluate surface on the vertical  
axis (the y-axis). }

\item{\dots}{
Any other plotting options. 
}
}
\details{
This function is essentially a combination of predict.surface and
plot.surface. It may not always give a great rendition but is easy to use
for checking the fitted surface. The default of extrap=F is designed to
discourage looking at the estimated surface outside the range of
the observations.  
}
\seealso{
\code{\link{Krig}} 
predict.surface, plot.surface, image.plot
}
\examples{
fit<- Krig(ozone$x,ozone$y, theta=30)  # krig fit 

#Image plot of surface with nice, smooth  contours and shading

surface(fit, type="C", nx=128, ny=128) 
 
}
\keyword{spatial}
% docclass is function
% Converted by Sd2Rd version 1.21.

\eof
\name{tim.colors}
\alias{tim.colors}
\title{ Tim's useful color table }
\description{
A pleasing rainbow style color table patterned after that used in 
Matlab by Tim. 
}
\usage{
tim.colors(n = 64)
}
\arguments{
  \item{n}{ Number of color levels. The setting \code{n}=64 is the orignal 
definition.}
}
\details{
Ask Tim. 
}
\value{
A vector of character strings giving the colors in a hexadecimal format. 

}
\seealso{ topo.colors, terrain.colors }
\examples{

tim.colors(10) 
# returns an array of 10 strings in hex format
#e.g. (red, green,  blue) values of   (16,255, 239)
# translates to "#10FFEF" .

 

image( outer( 1:20,1:20,"+"), col=tim.colors( 75))
}
\keyword{ aplot}

\eof
\name{transformx}
\alias{transformx}
\title{
  Linear transformation   
}
\description{
Linear transformation of each column of a matrix. There are several 
choices of the type of centering and scaling.  
}
\usage{
transformx (x, scale.type = "unit.sd", x.center, x.scale)
}
\arguments{
\item{x}{
Matrix with columns to be transformed.
}
\item{scale.type}{
Type of transformation the default is "unit.sd": subtract the mean and 
divide by the standard deviation. 
Other  choices are "unscaled" (do nothing),  "range" (transform to 
[0,1]),"user" (subtract a supplied location and divide by a scale).
}
\item{x.center}{
A vector of centering values to subtract from each column. 
}
\item{x.scale}{
A vector of scaling values to subtract from each column.
}
}
\value{
A matrix whose columns have between transformed.
This matrix also has the attributes: scale.type, x.center and y.center 
with the transformation information. 
}
\details{
After deciding what the centering and scaling values should be for each 
column of x, this function just calls the standard utility scale. 
This function was created partly to attach the transformation information 
as attributes to the transformed matrix. It is used in Krig, cover.design, 
krig.image etc. to transform the independent variables.   
}
\seealso{
scale
}
\examples{
#
newx<-transformx( ozone$x, scale.type="range")
}
\keyword{manip}
% docclass is function
% Converted by Sd2Rd version 1.21.

\eof
\name{vgram}
\alias{vgram}
\title{
  Finds a traditional or robust variogram for spatial data. 
}
\description{
Computes pairwise squared differences as a function of distance. 
Returns either raw values or statistics from binning. 
}
\usage{
vgram(loc, y, id=NULL, d=NULL, lon.lat=FALSE, dmax=NULL, N=NULL, breaks=NULL)
}
\arguments{
\item{loc}{
Matrix where each row is the coordinates of an observed point
of the field
}
\item{y}{
Value of the field at locations
}
\item{id}{
A 2 column matrix that specifies which variogram differnces to find. 
If omitted all possible pairing are found. 
This can can used if the data has an additional covariate that determines
proximity, for example a time window. 
}
\item{d}{
Distances among pairs indexed by id. If not included distances from from
directly from loc. 
}
\item{lon.lat }{
If true, locations are assumed to be longitudes and latitudes
and 
distances found are great circle distances ( in miles see rdist.earth).
Default is false. 
}
\item{dmax}{
Maximum distance to compute variogram.
}
\item{N}{
Number of bins to use.
}
\item{breaks}{
Bin boundaries for binning variogram values. Need not be equally spaced
but must be ordered. 
}
}
\value{

name= vgram>
variogram values 
</s-return-component >

name= vgram>
variogram values 
</s-return-component >

name= d>
pairwise distances 
</s-return-component >

name= call>
calling string 
</s-return-component >

name= stats>
Matrix of statistics for values in each bin. 
Rows are the summaries returned by the stats function or describe.  
If not either breaks or N arguments are not supplied then this
component is not computed. 
</s-return-component >

name= centers>
Bin centers
</s-return-component >
}
\section{References}{
See any standard reference on spatial statistics. For example 
Cressie, Spatial Statistics  
}
\seealso{
vgram.matrix
bplot.xy, vgram.matrix 
}
\examples{
#
# compute variogram for the midwest ozone field  day 16
# (BTW this looks a bit strange!)
#
data( ozone2)
good<- !is.na(ozone2$y[16,])
x<- ozone2$lon.lat[good,] 
y<- ozone2$y[16,good]

look<-vgram( x,y, N=15, lon.lat=TRUE) # locations are in lon/lat so use right
#distance
# take a look:
#plot( look$d, look$vgram)
#lines(look$centers, look$stats["mean",], col=4)

brk<- seq( 0, 250,,25)
 
## or some boxplot bin summaries

bplot.xy( look$d, sqrt(look$vgram), breaks=brk,ylab="sqrt(VG)")
lines(look$centers, look$stats["mean",], col=4)

}
\keyword{spatial}
% docclass is function
% Converted by Sd2Rd version 1.21.

\eof
\name{vgram.matrix}
\alias{vgram.matrix}
\title{
  Computes a variogram from an image 
}
\description{
Computes a variogram for an image taking into account different directions 
and returning summary information about the differences in each of these 
directions.  
}
\usage{
vgram.matrix(dat, R=5, nsum=1:8, collapse=TRUE, dx = 1,dy = 1 )
}
\arguments{
\item{dat}{
A matrix spacing of rows and columns are assumed to have the same 
distance. 
}
\item{R}{
Maximum radius for finding variogram differences assuming that the grid
points are spaced one unit a part. Default is go out to a 
radius of 5.  
}
\item{nsum}{
The components returned from applying the fields stats function. 
Default is to return all 8 statistics, n, mean, s.d. quantiles etc.  
}
\item{collapse}{
If true the default just gives variogram as a function of distance between 
points.  
}
\item{dx}{
The spacing of grid points on the X axis. This is used to calculate the 
correct distance between grid points. If dx is not equal to dy then the 
collapse argument must be FALSE. 
}
\item{dy}{ The spacing of grid points on the Y axis.
See additional notes for dx.}

}
\value{
If collapse=T 
  
A list with components:  d, a vector of distances for the differences, 
and vgram, the variogram values. This is the traditional variogram 
ignoring direction.  
If collapse=F 
A list with components: d, a vector of distances for the differences, 
ind, a two column matrix giving the x and y increment used to compute the 
differences, stats, the result of applying the stats function to each set 
of differences,   and vgram, the mean of the differences 
}

\details{
When collapse=F this function is designed to look for departures from 
isotropy by separating the variogram differences according to 
orientation. For small R this runs efficiently because the differences are 
found by sub-setting the image matrix.  

For example, suppose that a row of the ind matrix is 
(2,3). The variogram value associated with this row is the mean of  
the differences (X(i,j)- X( i+2,j+3))**2 for all i and j. 
(Here X(.,.) are the values for the spatial field.)  In this example  
d= sqrt(13) and there will be another entry with the same distance 
but 
corresponding to the direction (3,2). 
plot.vgram.matrix attempts to organize all the different directions into a 
coherent image plot.
}
\seealso{
\code{\link{vgram}} 
}
\examples{
# variogram for Lennon image.
data(lennon)
out<-vgram.matrix( lennon) 

plot( out$d, out$vgram, xlab="separation distance", ylab="variogram") 
# image plot of vgram values by direction.  

# look at different directions 
out<-vgram.matrix( lennon, R=10, collapse=FALSE) #this takes a bit of time 

set.panel(2,1)
plot( out$d, out$vgram) 
plot(out$d, out$vgram.robust) 

#image plot of variogram values for different directions. 
set.panel(1,1)
plot.vgram.matrix( out)
# John Lennon appears remarkably isotropic!

}
\keyword{spatial}
% docclass is function
% Converted by Sd2Rd version 1.21.

\eof
\name{world}
\alias{world}
\title{Plot of the world}
\description{
Plots quickly, medium resolution outlines of large land masses and 
bodies of water.  
}
\usage{
world(ylim=c(-90, 90), xlim=c(-180, 180), add=FALSE, asp = 1,
      xlab = "", ylab = "",  xaxt = "n", yaxt = "n", 
eps=.1,shift=FALSE,...)
}
\arguments{
  \item{ylim}{range of latitudes}
  \item{xlim}{range of longitudes}
  \item{add}{logical; if true will add the world map to current plot.}
  \item{asp}{aspect ratio used if \code{add} is false, see
    \code{\link{plot.default}}.}
  \item{xlab,ylab}{labels for x- and y-axis; empty by default.}
  \item{xaxt,yaxt}{axis type for x- and y-axis; empty by default.}
\item{eps}{ Tolerance to decide when to insert line break about 0 if
map is to be shifted. (leave this at .1) }
\item{shift}{ If TRUE shifts to be centered on the Dateline and 
longitude runs from 0 to 360. If FALSE centers on Prime Meridian and 
longitude runs 
from -180 to 180.}

 \item{\dots}{
    These are graphical arguments that are passed to the
    \code{\link{lines}} (and \code{\link{plot}} if \code{add} is false)
    function that draws the outline.}
}
\details{
This function uses the FIELDS dataset world.dat for the coordinates. The 
main advantage of this function is that it is fast and easy to modify. 
The shift option to center over the dateline is useful because often 
plots of ocean and atmosphere information center the map this way. 
 }
\seealso{US}
\examples{
# Draw map in device color number 2 ( usually red?) 

world( col=2)
# add the US
US( add=TRUE)

## Western Europe (*which* big island is missing ?)
## with a (light color!) coordinate grid:

world(xlim=c(-10,18),ylim=c(36,60), xaxt = "s", yaxt = "s")
grid()


}
\keyword{hplot}
% docclass is function

\eof
\name{xline}
\alias{xline}
\title{
  Draw a vertical line 
}
\description{
Adds  vertical lines in the plot region. 
}
\usage{
xline(x, ...)
}
\arguments{
\item{x}{
Values on x axis specifying location of vertical lines. 
}
\item{\dots}{
Any ploting options for abline. 
}
}
\seealso{
 yline, abline 
}
\examples{

plot( 1:10)
xline( 6.5, col=2)
 
world( col=3) 
yline( seq( -80,80,10),col=4, lty=2)
xline( seq( -180,180,10),col=4,lty=2)
yline( 0, lwd=2, col=4)
}
\keyword{aplot}
% docclass is function
% Converted by Sd2Rd version 1.21.

\eof
\name{yline}
\alias{yline}
\title{
  Draw horizontal lines 
}
\description{
Adds  horizontal lines in the plot region. 
}
\usage{
yline(y, ...)
}
\arguments{
\item{y}{
Values on y axis specifying location of vertical lines. 
}
\item{\dots}{
Any ploting options for abline. 
}
}
\seealso{
 xline, abline 
}
\examples{
world( col=3)
yline( seq( -80,80,10),col=4, lty=2)
xline( seq( -180,180,10),col=4,lty=2)
yline( 0, lwd=2, col=4)
}
\keyword{aplot}
% docclass is function
% Converted by Sd2Rd version 1.21.

\eof
