image.plot              package:fields              R Documentation

_D_r_a_w_s _i_m_a_g_e _p_l_o_t _w_i_t_h _a _l_e_g_e_n_d _s_t_r_i_p _f_o_r _t_h_e _c_o_l_o_r _s_c_a_l_e.

_D_e_s_c_r_i_p_t_i_o_n:

     This function combines the R image function with some automatic 
     placement of a legend. This is done by splitting the plotting
     region   into two parts. Putting the image in one and the legend
     in the other.

_U_s_a_g_e:

     image.plot(..., add=TRUE, nlevel=64, legend.shrink=0.9, 
     legend.width=0.02,  
     graphics.reset=TRUE, horizontal=FALSE, offset=0.04,  
     bigplot=NULL, smallplot=NULL, legend.only=FALSE, 
     col=topo.colors(nlevel))

_A_r_g_u_m_e_n_t_s:

     ...: The usual arguments to the image function.  because this
          function may change the size of the plotting  region. (See
          details below)   

     add: If true add image and a legend strip to the existing plot.  

  nlevel: Number of color levels used in legend strip   

legend.shrink: Amount to shrink the size of legend relative to the full
          height or width of the plot.   

legend.width: Width in plotting  coordinates (the full size plot is
          [0,1]X[0,1]) of the legend strip.  

  offset: Amount that the legend strip is set in from the left edge or
          the bottom  of the plotting region. Units are with respect to
          the plotting  coordinates. 

graphics.reset: If FALSE (default)  the plotting region ( plt in par)
          will not be reset  and one can add more information onto the
          image plot. (e.g. using functions such as points or lines.) 
          If TRUE will reset plot parameters to the values before
          entering the function.   

horizontal: If false (default) legend will be a vertical strip on the
          right side. If true the legend strip will be along the
          bottom.   

 bigplot: Plot coordinates for image plot. If not passed these will be
          determined within the function.   

smallplot : Plot coordinates for legend. If not passed these will be
          determined within the function.   

legend.only: If TRUE just add the legend to a the plot in the plot
          region defined by the coordinates in smallplot. In the
          abscence of other information the range for the legend  is
          determined from the 'zlim' argument.  

     col: Color table to use for image ( see help file on image for
          details). Default is a pleasing range of 64 divisions on a
          topographic scale. 

_D_e_t_a_i_l_s:

     It is surprising how hard it is just to automatically add the
     legend! All "plotting coordinates" mentioned here are in device
     coordinates. The plot region is assumed to be [0,1]X[0,1] and
     plotting regions are defined as rectangles within this square. We
     found these easier to work with than user coordinates.  There are
     always problems with default solutions to placing information on
     graphs but the choices made here may be useful for most cases. The
     most annoying thing is that after using plot.image and adding
     information the next plot that is made may have the slightly
     smaller plotting region set by the image plotting. The user should
     set 'reset.graphics=TRUE' to avoid the plotting size  some from
     changing. The disadvantage, however, of resetting the graphics  is
     that one can no longer add additional graphics elements to the
     image  plot. (Note that filled.contour always resets the graphics
     but provides  another mechanism to pass through plotting commands.
     Apparently  filled.contour,while very pretty, does not work for
     multiple plots ... )

     The strategy for 'image.plot' is simple, divide the plotting
     region  into two smaller regions 'bigplot' and 'smallplot'. The
     image goes in one and  the legend in the other. This way there is
     always room for the legend. Some adjustments are made to this rule
     by not shrinking the 'bigplot' if there is already room for the
     legend strip and also sticking the legend strip close to the image
     plot. One can specify the plot regions explicitly by 'bigplot' and
     \ 'smallplot' if the default choices do not work. There may be
     problems with small plotting regions in fitting both of these in
     the plot region and one may  have to change the default character
     sizes or margins to make things fit.

     By keeping the zlim argument the same across images one can
     generate the same color scale. (See the image help file)  One
     useful technique for a panel of images is to just draw the first
     with image.plot to get a legend and just use image for subsequent
     plots. Also keep in mind one can just add a legend to an existing
     plot without changing plotting parameters. Usually a square plot
     (pty="s") done in a rectangular plot region will have room for the
     legend with any adjustments stuck to the right side. 

     Note that to add just the legend strip all one needs is the zlim
     argument! The default color table for this function is the
     topographic color scale  ('topo.colors') showing our geophysical
     basis.  See also 'terrain.colors' for a subset. For using other
     color choices  see how the 'nlevels' argument figures into the
     legend and main plot number of colors.

_S_i_d_e _E_f_f_e_c_t_s:

     After exiting, the plotting region may be changed to make it
     possible to add more features to the plot. To be explicit,
     'par()\$plt' may be changed to reflect a  smaller plotting region
     that has accommodated room for the legend subplot.

_S_e_e _A_l_s_o:

     image,filled.contour

_E_x_a_m_p_l_e_s:

      x<- 1:10 
      y<- 1:15 
     z<- outer( x,y,"+") 
     image.plot(x,y,z) 
     # or obj<- list( x=x,y=y,z=z); image.plot(obj)
     # now add some points on diagonal with some clipping anticipated 
     points( 5:12, 5:12, pch="X", cex=3)
     #
     #fat (5% of figure) and short (50% of figure)  legend strip on the bottom 
     image.plot( x,y,z,legend.width=.05, legend.shrink=.5, horizontal=TRUE) 

     # you can always add a legend arbitrarily to any plot;
     # note that here the plot is too big for the vertical strip but the
     # horizontal fits nicely.
     plot( 1:10, 1:10)
     image.plot( zlim=c(0,25), legend.only=TRUE)
     image.plot( zlim=c(0,25), legend.only=TRUE, horizontal =TRUE)

     # combining the  usual image function and adding a legend
     # first change margin for some more room
     ## Not run: 
     par( mar=c(10,5,5,5))
     image( x,y,z, col=topo.colors(64))
     image.plot( zlim=c(0,25), nlevel=64,legend.only=TRUE, horizontal=TRUE)
     ## End(Not run)
     #
     # 
      

