### Name: g.data.save
### Title: Create and Maintain Delayed-Data Packages
### Aliases: g.data.attach g.data.get g.data.put g.data.load g.data.save
### Keywords: data

### ** Examples

## Don't run: 
##D ddp <- tempfile("newdir")           # Where to put the files
##D g.data.attach(ddp)                  # Warns that this is a new directory
##D assign("x1", matrix(1, 1000, 1000), 2)
##D assign("x2", matrix(2, 1000, 1000), 2)
##D g.data.save()                       # Writes the files
##D detach(2)
##D 
##D g.data.attach(ddp)                  # No warning, because directory exists
##D ls(2)
##D system.time(print(dim(x1)))         # Takes time to load up
##D system.time(print(dim(x1)))         # Second time is faster!
##D find("x1")                          # x1 still lives in pos=2, is now real
##D assign("x3", x2*10, 2)
##D g.data.save()                       # Or just g.data.save(obj="x3")
##D detach(2)
##D 
##D myx2 <- g.data.get("x2", ddp)       # Get one objects without attaching
##D unlink(ddp, recursive=TRUE)         # Clean up this example
## End Don't run

## Don't run: 
##D ddp <- tempfile("newdir")           # New example
##D y <- list(x1=1:1000, x2=2:1001)
##D attach(y)                           # Attach an existing list or dataframe
##D g.data.save(ddp)
##D detach(2)
##D unlink(ddp, recursive=TRUE)         # Clean up this example
## End Don't run



