hap.em                  package:gap                  R Documentation

_G_e_n_e _c_o_u_n_t_i_n_g _f_o_r _h_a_p_l_o_t_y_p_e _a_n_a_l_y_s_i_s

_D_e_s_c_r_i_p_t_i_o_n:

     Gene counting for haplotype analysis with missing data, adapted
     for hap.score

_U_s_a_g_e:

     hap.em(id, data, locus.label=NA, converge.eps=1e-06, maxiter=500)

_A_r_g_u_m_e_n_t_s:

      id: a vector of individual IDs

    data: Matrix of alleles, such that each locus has a  pair  of
          adjacent  columns  of  alleles,  and  the order of columns
          corresponds to the order of  loci  on  a  chromosome.   If
          there  are  K  loci, then ncol(data) = 2*K. Rows represent
          alleles for each subject.

locus.label : Vector of  labels  for  loci,  of  length  K  (see
          definition of data matrix).

converge.eps : Convergence criterion, based on absolute  change in log
          likelihood (lnlike).

 maxiter: Maximum number of iterations of EM.

_V_a_l_u_e:

     List with components: 

converge: Indicator of convergence of the EM algorithm (1=converged, 0
          = failed).

   niter: Number of iterations completed in the EM alogrithm.

locus.info: A list with  a  component for each locus.  Each component
          is also a list, and  the  items of a locus- specific list are
          the locus name and a vector for the unique alleles for the
          locus.

locus.label: Vector of  labels  for  loci,  of  length  K  (see
          definition of input values).

haplotype: Matrix of unique haplotypes. Each row represents a unique 
          haplotype, and the number of columns is the number of loci.

hap.prob: Vector of mle's of haplotype probabilities.  The ith element
          of hap.prob corresponds to the ith row of haplotype.

  lnlike: Value of lnlike at last EM iteration (maximum lnlike if
          converged).

indx.subj: Vector for index of subjects, after  expanding  to all
          possible  pairs  of  haplotypes  for  each person. If indx=i,
          then i is the ith row of input matrix data. If the ith
          subject has  n possible  pairs  of haplotypes that correspond
          to their marker phenotype, then i is repeated n times.

   nreps: Vector for the count of haplotype pairs that map to each
          subject's marker genotypes.

hap1code: Vector of codes for each subject's first haplotype. The
          values in hap1code are the row numbers of the unique
          haplotypes in the returned matrix haplotype.

hap2code: Similar to hap1code, but for  each  subject's  second
          haplotype.

    post: Vector of posterior probabilities of pairs of haplotypes for
          a person, given thier marker phenotypes.

_R_e_f_e_r_e_n_c_e_s:

     Clayton DG (2001) SNPHAP.
     http://www-gene.cimr.cam.ac.uk/clayton/software

     Zhao JH and W Qian (2003) Association analysis of unrelated
     individuals using polymorphic genetic markers. RSS 2003, Hassalt,
     Belgium

_N_o_t_e:

     Adapted from HAP

_A_u_t_h_o_r(_s):

     Jing hua Zhao

_S_e_e _A_l_s_o:

     'hap', 'kbyl'

_E_x_a_m_p_l_e_s:

     ## Not run: 
     data(hla)
     hap.em(id=1:length(hla[,1]),data=hla[,3:8],locus.label=c("DQR","DQA","DQB"))
     ## End(Not run)

