### Name: hap.score
### Title: Score Statistics for Association of Traits with Haplotypes
### Aliases: hap.score


### ** Examples

## Not run: 
##D data(hla)
##D y<-hla[,2]
##D geno<-hla[,3:8]
##D hap.score(y,geno,locus.label=c("DRB","DQA","DQB"))
##D unlink("assign.dat")
##D 
##D ### note the differences in p values in the following runs
##D data(aldh2)
##D # to subset the data since hap doesn't handle one allele missing
##D deleted<-c(40,239,256)
##D aldh2[deleted,]
##D aldh2<-aldh2[-deleted,]
##D y<-aldh2[,2]
##D geno<-aldh2[,3:18]
##D # only one missing locus
##D hap.score(y,geno,handle.miss=1,n.miss.loci=1,method="hap")
##D # up to seven missing loci and with 10,000 permutations
##D hap.score(y,geno,handle.miss=1,n.miss.loci=7,method="hap",n.sim=10000)
##D 
##D # haplo.score takes considerably longer time and does not handle missing data
##D haplo.score(y,geno,n.sim=10000)
## End(Not run)



