\name{ac}
\alias{ac}
\alias{sil}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{ Clustering coefficients from package cluster.}
\description{
  Computes clustering coefficients from \code{cluster},
where \code{x} and  \code{y} give the object coordinates.
}
\usage{
ac(x, y, ...)
sil(x, y, groups, ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{is a numeric vector. }
  \item{y}{is a numeric vector. }
  \item{groups}{is a vector of group memberships, used by \code{sil} only.}
   
  \item{\dots}{are passed to \code{agnes} in \code{ac} and to \code{dist} 
  in \code{sil}.}
}
\details{
\code{ac} - Computes clustering coefficient from \code{agnes{cluster}}.

\code{sil} - Computes the silhouette coefficient from from package 
\code{cluster}.
}
\value{
  The clustering coefficient is returned.
}
\references{ Kaufman, L. and Rousseeuw, P.J. (1990). Finding Groups in Data: An Introduction to Cluster Analysis . Wiley, New York.  }
\author{ Catherine B. Hurley}
%\note{ ~~further notes~~ }


\seealso{  \code{\link{agnes}}, \code{\link{silhouette}}, \code{\link{dist}}.  }
\examples{
x <- runif(20)
y <- runif(20)
g <- rep(c("a","b"),10)

ac(x,y)
sil(x,y,g)
}
\keyword{cluster}

\eof
\name{bank}
\alias{bank}
\docType{data}
\title{Swiss bank notes data}
\description{
Data from "Multivariate Statistics  A practical approach", by
Bernhard Flury and Hans Riedwyl, Chapman and Hall, 1988,
Tables 1.1 and 1.2 pp. 5-8.  Six measurements made on 100 genuine
Swiss banknotes and 100 counterfeit ones.
}
\format{This data frame contains the following columns:
 \describe{
 \item{Status:}{0 = genuine, 1 = counterfeit}
 \item{Length:}{Length of bill, mm}
 \item{Left:}{ Width of left edge, mm}
\item{Right:}{Width of right edge, mm}
\item{Bottom:}{Bottom margin width, mm }
\item{Top:}{Top margin width, mm}
\item{Diagonal:}{ Length of image diagonal, mm}    
 }
}
\usage{data(bank)}

\source{
Flury, B. and Riedwyl, H. (1988), 
\emph{Multivariate Statistics  A Practical Approach},
London: Chapman and Hall.
}
\keyword{datasets}

\eof
\name{body}
\alias{body}
\docType{data}
\title{Exploring Relationships in Body Dimensions}
\description{


This dataset contains 21 body dimension measurements as well as age, 
weight, height, and gender on 507 individuals. The 247 men and 260 
women were primarily individuals in their twenties and thirties, with a 
scattering of older men and women, all exercising several hours a week.

Measurements were initially taken by Grete 
Heinz and Louis J. Peterson - at San Jose State University and at the 
U.S. Naval Postgraduate School in Monterey, California. Later, 
measurements were taken at dozens of California health and fitness 
clubs by technicians under the supervision of one of these authors.


}
\format{This data frame contains the following columns:
 \describe{
 \item{Biacrom:}{Biacromial diameter (cm)}
 \item{Biiliac:}{Biiliac diameter, or "pelvic breadth" (cm)}
 \item{Bitro:}{Bitrochanteric diameter (cm)}
 \item{ChestDp:}{Chest depth between spine and sternum at nipple level, 
            mid-expiration (cm)}
 \item{ChestD:}{Chest diameter at nipple level, mid-expiration (cm)}
 \item{ElbowD:}{Elbow diameter, sum of two elbows (cm)}
 \item{WristD:}{Wrist diameter, sum of two wrists (cm)}
 \item{KneeD:}{Knee diameter, sum of two knees (cm)}
 \item{AnkleD:}{Ankle diameter, sum of two ankles (cm)}
 \item{ShoulderG:}{Shoulder girth over deltoid muscles (cm)}
 \item{ChestG:}{Chest girth, nipple line in males and just above breast 
            tissue in females, mid-expiration (cm)}
 \item{WaistG:}{Waist girth, narrowest part of torso below the rib cage, 
            average of contracted and relaxed position (cm)}
 \item{AbdG:}{Navel (or "Abdominal") girth at umbilicus and iliac crest, 
            iliac crest as a landmark (cm)}
 \item{HipG:}{Hip girth at level of bitrochanteric diameter (cm)}
 \item{ThighG:}{Thigh girth below gluteal fold, average of right and left 
            girths (cm)}
 \item{BicepG:}{Bicep girth, flexed, average of right and left girths (cm)}
 \item{ForearmG:}{Forearm girth, extended, palm up, average of right and 
            left girths (cm)}
 \item{KneeG:}{Knee girth over patella, slightly flexed position, average 
            of right and left girths (cm)}
 \item{CalfG:}{Calf maximum girth, average of right and left girths (cm)}
 \item{AnkleG:}{Ankle minimum girth, average of right and left girths
 (cm)}
 \item{WristG:}{Wrist minimum girth, average of right and left girths (cm)}

 \item{Age:}{in years}
 \item{Weight:}{in kg}
 \item{Height:}{in cm}
 \item{Gender:}{1 - male, 0 - female}
 
}}
\usage{data(body)}



\source{
Heinz, G., Peterson, L.J., Johnson, R.W. and Kerk, C.J. (2003),
``Exploring Relationships in Body Dimensions'',
\emph{Journal of Statistics Education }, 11.

}
\reference{
The data file is taken from 
\url{http://www.amstat.org/publications/jse/datasets/body.dat}
This information file is based on
\url{http://www.amstat.org/publications/jse/datasets/body.txt}
}
\keyword{datasets}

\eof
\name{colpairs}
\alias{colpairs}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{ Applies a function to all pairs of columns }
\description{
Given an nxp matrix \code{m} and a function \code{f},
returns the pxp matrix got by applying \code{f}  to all pairs of columns of \code{m} .

}
\usage{
colpairs(m, f, diag = 0, na.omit = FALSE, ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{m}{ a matrix }
  \item{f}{ a function of two vectors, which returns a single result. }
  \item{diag}{ if supplied, this value is placed on the diagonal of the
result. }
  \item{na.omit}{ If \code{TRUE}, rows with missing values are omitted for each pair
of columns. }
  \item{\dots}{ argments are passed to \code{f}. }
}

\value{
a matrix matrix got by applying \code{f}  to all pairs of columns of \code{m} .
}
%-\references{ ~put references to the literature/web site here ~ }
\author{Catherine B. Hurley }


\seealso{ \code{\link{gave}}, \code{\link{partition.crit}}, 
\code{\link{order.single}},\code{\link{order.endlink}}}
\examples{
data(state)
state.m <- colpairs(state.x77, 
function(x,y)  cor.test(x,y,"two.sided","kendall")$estimate, diag=1)
state.col <- dmat.color(state.m)
# This is equivalent to state.m <- cor(state.x77,method="kendall")


layout(matrix(1:2,nrow=1,ncol=2))
cparcoord(state.x77, panel.color= state.col)
# Get rid of the panels with lots of line crossings (yellow) by reorderings
cparcoord(state.x77, order.endlink(state.m), state.col)
layout(matrix(1,1))


# m is a homogeneity measure of each pairwise variable plot
m <- -colpairs(scale(state.x77), gave)

o<- order.single(m)
pcols = dmat.color(m)
# Color panels by level of m and reorder variables so that
# pairs with high m are near the diagonal.
cpairs(state.x77,order=o, panel.colors=pcols)

# In this case panels showing either of Area or Population
# exhibit the most clumpiness because these variables
# are skewed.

}
\keyword{multivariate}

\eof
\name{cpairs}
\alias{cpairs}    
%- Also NEED an '\alias' for EACH other topic documented here.
\title{ Enhanced scatterplot matrix }
\description{
This function draws a scatterplot matrix of data. Variables
may be reordered and panels colored in the display.
}
\usage{
cpairs(data, order = NULL, panel.colors = NULL, border.color = "grey70", show.points = TRUE, ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{data}{a numeric matrix }
  \item{order}{the order of variables. Default is the order in data.}
  \item{panel.colors}{a matrix of panel colors. If supplied, dimensions 
  should match those of the pairs plot. Diagonal entries are ignored. }
  \item{border.color}{used for panel border. }
  \item{show.points}{ If FALSE, no points are drawn. }
  \item{\dots}{graphical parameters passed to \code{pairs.default}. }
}
%\details{
%}
%\value{
%}
\references{Hurley, Catherine B.  ``Clustering Visualisations of Multidimensional 
Data'', to appear in JCGS. }
\author{ Catherine B. Hurley }
%\note{ ~~further notes~~ }
\seealso{\code{\link{pairs}}, \code{\link{cparcoord}}, 
\code{\link{dmat.color}},\code{\link{colpairs}}, \code{\link{order.single}}.}
\examples{

data(USJudgeRatings)
judge.cor <- cor(USJudgeRatings)
judge.color <- dmat.color(judge.cor)
# Colors variables by their correlation.
cpairs(USJudgeRatings,panel.colors=judge.color,pch=".",gap=.5)
judge.o <- order.single(judge.cor)
# Reorder variables so that those with highest correlation 
# are close to the  diagonal.
cpairs(USJudgeRatings,judge.o,judge.color,pch=".",gap=.5)

# Specify your own color scheme
judge.color <- dmat.color(judge.cor, breaks=c(-1,0,.5,.9,1), colors = 
cm.colors(4))

data(bank)
# m is a homogeneity measure of each pairwise variable plot
m <- -colpairs(scale(bank[,-1]), partition.crit,gfun=gave,groups=bank[,1])

# Color panels by level of m and reorder variables so that
# pairs with high m are near the diagonal. Panels shown
# in pink have the highest amount of group homogeneity, as measured by 
# gave.
cpairs(bank[,-1],order=order.single(m), panel.colors=dmat.color(m),
gap=.3,col=c("purple","black")[bank[,"Status"]+1],
pch=c(5,3)[bank[,"Status"]+1])

}
\keyword{multivariate }
\keyword{color }
\keyword{hplot }


\eof
\name{cparcoord}
\alias{cparcoord}   

\title{Enhanced parallel coordinate plot }
\description{
This function draws a parallel coordinate plot of data. Variables
may be reordered and panels colored in the display. It is a modified
version of \code{parcoord {MASS}}.
}
\usage{
cparcoord(data, order = NULL, panel.colors = NULL, col = 1, lty = 1, horizontal = FALSE, mar = NULL, ...)
}

\arguments{
\item{data}{a numeric matrix }
  \item{order}{the order of variables. Default is the order in data.}
  \item{panel.colors}{either a vector or a matrix of panel colors. If a 
  vector is supplied, the ith color is used for the ith panel. If a matrix, dimensions 
  should match those of the variables. Diagonal entries are ignored. }
  \item{col}{ a vector of colours, recycled as necessary for each observation.  }
  \item{lty}{ a vector of line types, 
recycled as necessary for each observation.  }
  \item{horizontal}{ If TRUE, orientation is horizontal. }
  \item{mar}{ margin parameters, passed to \code{par}. }
  \item{\dots}{ graphics parameters which are passed to matplot.}
}
\details{
  If \code{panel.colors} is a matrix and \code{order} is supplied, \code{panel.colors} is 
  reordered.}

\references{Hurley, Catherine B.  ``Clustering Visualisations of Multidimensional 
Data'', to appear in JCGS. }
\author{ Catherine B. Hurley }

\seealso{\code{\link{cpairs}}, \code{\link{parcoord}},
\code{\link{dmat.color}}, \code{\link{colpairs}}, \code{\link{order.endlink}}.}
\examples{
data(state)
state.m <- colpairs(state.x77, 
function(x,y)  cor.test(x,y,"two.sided","kendall")$estimate, diag=1)
# OR, Works only in R1.8,  state.m <-cor(state.x77,method="kendall")  


state.col <- dmat.color(state.m)

cparcoord(state.x77, panel.color= state.col)
# Get rid of the panels with lots of line crossings (yellow) by reordering:
cparcoord(state.x77, order.endlink(state.m), state.col)

# To get rid of the panels with lots of long line segments:
#  use a different panel merit measure- pclen:

mins <- apply(state.x77,2,min)
ranges <- apply(state.x77,2,max) - mins
state.m <- -colpairs(scale(state.x77,mins,ranges), pclen)
cparcoord(state.x77, order.endlink(state.m), dmat.color(state.m))



}

\keyword{multivariate }
\keyword{color }
\keyword{hplot }

\eof
\name{diameter}
\alias{diameter}
\alias{star}
\alias{km2}
\alias{gtot}
\alias{gave}

\title{ Cluster heterogeneity of 2-d data }
\description{
Computes measures of cluster heterogeneity of 2-d data,
where \code{x} and  \code{y} give the object coordinates.
}
\usage{
diameter(x, y, ...)
star(x, y, ...)
km2(x,y)
gtot(x,y, ...)
gave(x,y, ...)
}
\arguments{
  \item{x}{is a numeric vector. }
  \item{y}{is a numeric vector. }
  \item{\dots}{are passed to \code{dist}. }
}
\details{
\code{diameter} computes the cluster diameter- the maximum distance
between objects. 

\code{star} computes the cluster star distance- the smallest
total distance from one object to another.

\code{km2} computes the kmeans distance.

\code{gtot} computes the sum of all inter-object distances.

\code{gave} computes the per-object average of all 
inter-object distances.

}
\value{The cluster measure is returned.
}
\references{ See Gordon, A. D. (1999).``Classification''. Second Edition. London:
     Chapman and Hall / CRC }
\author{ Catherine B. Hurley}


\seealso{ \code{\link{colpairs}}, \code{\link{cpairs}}, \code{\link{order.single}}}
\examples{
x <- runif(20)
y <- runif(20)
diameter(x,y)
}

\keyword{cluster}

\eof
\name{dmat.color}
\alias{dmat.color}
\alias{default.dmat.color}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{ Colors a symmetric matrix}
\description{
  Accepts a dissimilarity matrix or \code{dist} \code{m}, and
     returns a  matrix of colors.
     Values in \code{m} are \code{cut} into categories using \code{breaks} (ranked distances if 
     \code{byrank} is \code{TRUE}) and categories  are assigned the values 
     in \code{colors}. 
}
\usage{
dmat.color(m, colors = default.dmat.color, byrank = NULL, breaks = length(colors))
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{m}{a dissimilarity matrix or the result of \code{dist}}
  \item{colors}{a vector of colors. The default is 
  \code{default.dmat.color}.}
  \item{byrank}{boolean, default \code{TRUE} is unless \code{breaks} 
has length > 1.}
  \item{breaks}{the number of break points. }
}

\details{\code{breaks} are passed to the  function\code{cut}.
If \code{byrank} is \code{TRUE}, values in \code{m} are 
  ranked before they are categorized. 
  If \code{byrank} is \code{TRUE} and \code{breaks} is an integer, then
there are \code{breaks} equal-sized categories.}
\value{
  Returns a matrix of colors. The matrix is symmetric, with NAs on the 
  diagonal.
}
%\references{ ~put references to the literature/web site here ~ }
\author{ Catherine B. Hurley}
%\note{ ~~further notes~~ }

% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{ \code{\link{cut}}, \code{\link{cpairs}}, \code{\link{cparcoord}}}
\examples{
data(longley)
longley.cor <- cor(longley)
# A matrix with equal (or nearly equal) number of entries of each color.
longley.color <- dmat.color(longley.cor)

# Plot the colors
plotcolors(longley.color,dlabels=rownames(longley.color))

# Try different color schemes

# A matrix where each color represents an equal-length interval.
longley.color <- dmat.color(longley.cor, byrank=FALSE)
# Specify colors and breaks

longley.color <- dmat.color(longley.cor, breaks=c(-1,0,.5,.8,1), 
cm.colors(4))


# Could also reorder variables prior to plotting:

longley.o <- order.single(longley.cor)
longley.color <- longley.color[longley.o,longley.o]

# The colors can be used in a scatterplot matrix or parallel
# coordinate display:

cpairs(longley, panel.color= longley.color)
cparcoord(longley, panel.color= longley.color)

}
\keyword{multivariate }
\keyword{color }

\eof
\name{reorder.hclust}
\alias{reorder.hclust}
\title{Reorders object order of hclust, keeping objects within a cluster
contiguous to each other. }
\description{
Reorders objects so that  nearby object pairs are adjacent.
}
\usage{
reorder.hclust(x,dis,...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{is the result of \code{hclust}.}
  \item{dis}{is a distance matrix or \code{dist}.}  
  \item{...}{additional arguments.}  
}
\details{ 
In hierarchical cluster displays, a decision is needed at 
each merge to specify which subtree should go on the left 
and which on the right. 
This algorithm uses the order suggested by Gruvaeus and Wainer (1972).
At a merge of clusters A and B, the new cluster is one of
(A,B), (A',B), (A,B'),(A',B'), where A' denotes A in reverse order.
The new cluster is chosen to minimize the distance between
the object in A placed adjacent to an object from B.
}
\value{A permutation of the objects represented by \code{dis} is returned.
}
\references{Hurley, Catherine B.  ``Clustering Visualisations of Multidimensional 
Data'', to appear in JCGS.

Gruvaeus, G. and Wainer, H. (1972),
``Two Additions to Hierarchical Cluster Analysis",
 British Journal of Mathematical and Statistical Psychology, 25, 200-206.
 }
\author{ Catherine B. Hurley }
%\note{ ~~further notes~~ }
\seealso{\code{\link{hclust}}, 
\code{\link{order.hclust}} .}
\examples{

data(eurodist)
dis <- as.dist(eurodist)
hc <- hclust(dis, "ave")


layout(matrix(1:2,nrow=2,ncol=1))
op <- par(mar=c(1,1,1,1))
plot(hc)
hc1 <- reorder.hclust(hc, dis)
plot(hc1)
par(op)
layout(matrix(1,1))

# Both dedrograms correspond to the same tree structure,
# but the second one shows that
# Paris is closer to Cherbourg than Munich, and
# Rome is closer to Gibralter than to Barcelona.


# We can also compare both orderings with an
# image plot of the colors.
# The second ordering seems to place nearby cities
# closer to each other.


layout(matrix(1:2,nrow=2,ncol=1))
op <- par(mar=c(1,6,1,1))
cmat <- dmat.color(eurodist, rev(cm.colors(5)))
plotcolors(cmat[hc$order,hc$order], rlabels=labels(eurodist)[hc$order])

plotcolors(cmat[hc1$order,hc1$order], rlabels=labels(eurodist)[hc1$order])

layout(matrix(1,1))
par(op)

}




}
\keyword{multivariate }
\keyword{cluster }

\eof
\name{order.single}
\alias{order.single}
\alias{order.endlink}
\alias{order.hclust}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Orders objects using hierarchical clustering}
\description{
Reorders objects so that  similar (or high-merit) object pairs are adjacent.
A permutation vector is returned.
}
\usage{
order.single(merit,clusters=NULL)
order.endlink(merit,clusters=NULL)
order.hclust(merit, reorder=TRUE,...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{merit}{is either a symmetric matrix of merit or similarity score, 
  or a \code{dist}.}
  \item{clusters}{if non-null, specifies a partial ordering. It should be a list whose 
ith element contains 
the indices the  objects in the ith ordered cluster.}
  \item{reorder}{if TRUE, reorders the default ordering from \code{hclust}.}
   \item{...}{arguments are passed to \code{hclust}.}
  
}
\details{ \code{order.single} performs a variation on single-link cluster analysis,
devised by Gruvaeus and Wainer (1972).
When two ordered clusters are merged, the new cluster is formed by placing the
most similar endpoints of the joining clusters adjacent to each other.
When applied to variables, the resulting order is useful for scatterplot 
matrices.

\code{order.endlink} is another variation on single-link cluster analysis,
where the similarity between two ordered clusters is defined as the minimum distance
between their endpoints. When two ordered clusters are merged, the new cluster is formed by placing the
most similar endpoints of the joining clusters adjacent to each other.
When applied to variables, the resulting order is useful for parallel 
coordinate displays.

\code{order.hclust} returns the order of objects from \code{hclust} if
\code{reorder} is \code{FALSE}. Otherwise, it reorders the objects using
\code{hclust.reorder}
so that
when two ordered clusters are merged, the new cluster is formed by placing the
most similar endpoints of the joining clusters adjacent to each other.
\code{order.hclust(m,method="single")} is equivalent to 
\code{order.single} when \code{clusters} is \code{NULL}.
The default method of \code{hclust} is "complete", see \code{\link{hclust}}} for other 
possibilities.

}
\value{A permutation of the objects represented by \code{merit} is returned.
}
\references{Hurley, Catherine B.  ``Clustering Visualisations of Multidimensional 
Data'', to appear in JCGS.

Gruvaeus, G. and Wainer, H. (1972),
``Two Additions to Hierarchical Cluster Analysis",
 British Journal of Mathematical and Statistical Psychology, 25, 200-206.
 }
\author{ Catherine B. Hurley }
%\note{ ~~further notes~~ }
\seealso{\code{\link{cpairs}}, 
\code{\link{cparcoord}},\code{\link{plotcolors}}, 
\code{\link{reorder.hclust}},\code{\link{order.clusters}}, \code{\link{hclust}}.}
\examples{
data(state)
state.cor <- cor(state.x77)
order.single(state.cor)
order.endlink(state.cor)
order.hclust(state.cor,method="average")

# Use for plotting...

cpairs(state.x77, panel.colors=dmat.color(state.cor), order.single(state.cor),pch=".",gap=.4)
cparcoord(state.x77, order.endlink(state.cor),panel.colors=dmat.color(state.cor))


# Order the states instead of the variables...

state.d <- dist(state.x77)
state.o <- order.single(-state.d)

op <- par(mar=c(1,6,1,1))
cmat <- dmat.color(as.matrix(state.d), rev(cm.colors(5)))
plotcolors(cmat[state.o,state.o], rlabels=state.name[state.o])
par(op)


}
\keyword{multivariate }
\keyword{cluster }

\eof
\name{order.clusters}
\alias{order.clusters}
\title{Orders clustered objects using hierarchical clustering}
\description{
Reorders objects so that  similar (or high-merit) object pairs are adjacent.
The clusters argument specifies (possibly ordered) groups, and objects
within a group are kept together.
}
\usage{
order.clusters(merit,clusters,within.order = order.single, 
    between.order= order.single,...) 
}
\arguments{
  \item{merit}{is either a symmetric matrix of merit or similarity score, 
  or a \code{dist}.}
  \item{clusters}{specifies a partial grouping. It should either be a list whose 
ith element contains 
the indices of the  objects in the ith cluster, or a vector of integers whose ith element 
gives the cluster membership of the ith object. Either representation may 
be used to specify grouping, the first is preferrable to specify 
adjacencies.}
\item{within.order}{is a function used to order the objects within each 
cluster.}
\item{between.order}{is a function used to order the clusters.}
\item{...}{arguments are passed to \code{within.order}.}
  
}
\details{\code{within.order} may be NULL, in which case objects within a 
cluster are assumed to be in order. Otherwise, \code{within.order}
should be one of the ordering functions 
\code{order.single},\code{order.endlink} or \code{order.hclust}.

\code{between.order} may be NULL, in which case cluster order
is preserved. 
Otherwise, \code{betweem.order}
should be one of the ordering functions that uses a partial ordering,
\code{order.single} or \code{order.endlink}.
}
\value{A permutation of the objects represented by \code{merit} is returned.
}

\author{ Catherine B. Hurley }
%\note{ ~~further notes~~ }
\seealso{\link{order.single},\link{order.endlink},\link{order.hclust}.}
\examples{
data(state)
state.d <- dist(state.x77)


# Order the states, keeping states in a division together.
state.o <- order.clusters(-state.d, as.numeric(state.division))
cmat <- dmat.color(as.matrix(state.d), rev(cm.colors(5)))


op <- par(mar=c(1,6,1,1))
rlabels <- state.name[state.o]
plotcolors(cmat[state.o,state.o], rlabels=rlabels)
par(op)


# Alternatively, use kmeans to place the  states into 6 clusters
state.km <- kmeans(state.d,6)$cluster

# An ordering obtained from the kmeans clustering...
state.o <- unlist(memship2clus(state.km))


layout(matrix(1:2,nrow=1,ncol=2),widths=c(0.1,1))
op <- par(mar=c(1,1,1,.2))
state.colors <- cbind(state.km,state.km)
plotcolors(state.colors[state.o,])

par(mar=c(1,6,1,1))
rlabels <- state.name[state.o]
plotcolors(cmat[state.o,state.o], rlabels=rlabels)

par(op)
layout(matrix(1,1))



# In the ordering above, the ordering of clusters and the
# ordering of objects within the clusters is arbitrary.
# order.clusters gives an improved order but preserves the kmeans clusters.

state.o <- order.clusters(-state.d, state.km)

# and replot
layout(matrix(1:2,nrow=1,ncol=2),widths=c(0.1,1))
op <- par(mar=c(1,1,1,.2))
state.colors <- cbind(state.km,state.km)
plotcolors(state.colors[state.o,])

par(mar=c(1,6,1,1))
rlabels <- state.name[state.o]
plotcolors(cmat[state.o,state.o], rlabels=rlabels)

par(op)
layout(matrix(1,1))

}
\keyword{multivariate }
\keyword{cluster }

\eof
\name{ozone}
\alias{ozone}
\docType{data}
\title{Ozone data from Breiman and Friedman, 1985}
\description{
This is the Ozone data discussed in Breiman and Friedman (JASA, 1985, p. 580).
These data are for 330 days in 1976.  All measurements are in the area of
Upland, CA, east of Los Angeles.
}
\format{This data frame contains the following columns:
 \describe{
 \item{Ozone:}{Ozone conc., ppm, at Sandbug AFB.}
 
\item{Temp:}{Temperature F. (max?).}

 \item{InvHt:}{Inversion base height, feet}

 \item{Pres:}{Daggett pressure gradient (mm Hg)}

 \item{Vis:}{Visibility (miles)}

 \item{Hgt:}{Vandenburg 500 millibar height (m)}
 \item{Hum:}{Humidity, percent}

 \item{InvTmp:}{Inversion base temperature, degrees F.}
 \item{Wind:}{Wind speed, mph}
}}


\usage{data(ozone)}
\source{Breiman, L and  Friedman, J.  (1985),
 ``Estimating Optimal Transformations for Multiple Regression and Correlation'',
 \emph{Journal of the American Statistical Association}, 80,  580-598.
    }
\keyword{datasets}

\eof
\name{partition.crit}
\alias{partition.crit}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{ Combines the results of appplying an index to each group of 
observations }
\description{
Applies the function \code{gfun}  to each group of x and y values
and combines the results using the function \code{cfun}

}
\usage{
partition.crit(x, y, groups, gfun = gave, cfun = sum, ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
\item{x}{is a numeric vector. }
  \item{y}{is a numeric vector. }
  \item{groups}{ is a vector of group memberships. }
  \item{gfun}{ is applied to the \code{x}  and \code{y} data in each group. }
  \item{cfun}{ combines the values returned by \code{gfun}. }
  \item{\dots}{ arguements are passed to  \code{gfun}. }
}
\details{
 The function \code{gfun} is applied to each group of \code{x}  and \code{y}
values. The function \code{cfun} is applied to the vector or matrix of
\code{gfun} results.
}
\value{
  The result of applying \code{cfun}.
}
\references{ See Gordon, A. D. (1999). {\it Classification}. Second Edition. London:
     Chapman and Hall / CRC }
\author{ Catherine B. Hurley}

\seealso{ \code{\link{gave}}, \code{\link{colpairs}}, 
\code{\link{order.single}}}
\examples{
x <- runif(20)
y <- runif(20)
g <- rep(c("a","b"),10)

partition.crit(x,y,g)


data(bank)
# m is a homogeneity measure of each pairwise variable plot
m <- -colpairs(scale(bank[,-1]), partition.crit,gfun=gave,groups=bank[,1])

# Color panels by level of m and reorder variables so that
# pairs with high m are near the diagonal. Panels shown
# in pink have the highest amount of group homogeneity, as measured by 
# gave.
cpairs(bank[,-1],order=order.single(m), panel.colors=dmat.color(m),
gap=.3,col=c("purple","black")[bank[,"Status"]+1],
pch=c(5,3)[bank[,"Status"]+1])

# Try  a different measure
m <- -colpairs(scale(bank[,-1]), partition.crit,gfun=diameter,groups=bank[,1])

cpairs(bank[,-1],order=order.single(m), panel.colors=dmat.color(m),
gap=.3,col=c("purple","black")[bank[,"Status"]+1],
pch=c(5,3)[bank[,"Status"]+1])


# Result is the same, in this case.

}
\keyword{multivariate }
\keyword{cluster }

\eof
\name{pclen}
\alias{pclen}
\alias{pcglen}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{ Profile smoothness measures }
\description{
Computes measures of profile smoothness of 2-d data,
where \code{x} and  \code{y} give the object coordinates.

}
\usage{
pclen(x, y)
pcglen(x, y)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
\item{x}{is a numeric vector. }
 \item{y}{is a numeric vector. }
}
\details{Usually, the data is standardized prior to using these functions.}

\code{pclen} computes the total line length in a parallel coordinate plot
of x and y.

\code{pcglen} computes the average (per object) line length in a parallel coordinate plot
where all pairs of objects are connected.


}
\value {The panel measure is returned.
}
\references{Hurley, Catherine B.  ``Clustering Visualisations of Multidimensional 
Data'', to appear in JCGS. }
\author{ Catherine B. Hurley }
%\note{ ~~further notes~~ }

\seealso{\code{\link{cparcoord}}, 
\code{\link{colpairs}}, \code{\link{order.endlink}}.}

\examples{
x <- runif(20)
y <- runif(20)
pclen(x,y)


data(state)
mins <- apply(state.x77,2,min)
ranges <- apply(state.x77,2,max) - mins
state.m <- -colpairs(scale(state.x77,mins,ranges), pclen)
state.col <- dmat.color(state.m)
cparcoord(state.x77, panel.color= state.col)
# Get rid of the panels with long line segments (yellow) by reordering:
cparcoord(state.x77, order.endlink(state.m), state.col)

}
\keyword{hplot}
\keyword{multivariate}

\eof
\name{plotcolors}
\alias{plotcolors}
\alias{imageinfo}

%- Also NEED an '\alias' for EACH other topic documented here.
\title{Plots a matrix of colors}
\description{
\code{plotcolors} plots a matrix of colors 
as an image or as points.

\code{imageinfo} is a utility that given a matrix of colors,
returns a structure useful for the \code{image} function.

} 
\usage{
plotcolors(cmat, na.color = "white", dlabels = NULL, rlabels = FALSE, clabels = FALSE, 
ptype = "image", border.color = "grey70", pch = 15, cex = 3, label.cex = 0.6, ...)

imageinfo(cmat)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
 \item{cmat}{a matrix of numbers, nas are allowed.}
 \item{na.color}{used for NAs in \code{cmat}.}
 \item{dlabels}{vector of labels for the diagonals.}
 \item{rlabels}{vector of labels for the rows.}
 \item{clabels}{vector of labels for the columns.}
  \item{ptype}{should be "image" or "points"}
  \item{border.color}{color of border drawn around the plot.}
  \item{pch}{point type used when ptype="points".}
  \item{cex}{point cex used when ptype="points".}
  \item{label.cex}{cex parameter used for labels.}

 \item{\dots}{graphical parameters}
}

\value{
  \code{imageinfo} returns a list with components:
\item{x}{a vector of x coordinates.}
\item{y}{a vector of y coordinates.}
\item{z}{a matrix containing values to be plotted.}
\item{col}{the colors to be used.}
}

\author{ Catherine B. Hurley }

\seealso{\code{\link{plot}}, \code{\link{image}}}


\examples{

plotcolors(matrix(1:20,nrow=4,ncol=5))

plotcolors(matrix(1:20,nrow=4,ncol=5),ptype="points",cex=6)

plotcolors(matrix(1:20,nrow=4,ncol=5),rlabels = c("a","b","c","d"))


data(longley)
longley.cor <- cor(longley)
# A matrix with equal (or nearly equal) number of entries of each color.
longley.color <- dmat.color(longley.cor)


plotcolors(longley.color, dlabels=rownames(longley.color))

# Could also reorder variables prior to plotting:
longley.o <- order.single(longley.cor)
longley.color <- longley.color[longley.o,longley.o]

op <- par(mar=c(1,6,6,1))
plotcolors(longley.color,rlabels=rownames(longley.color),clabels=rownames(longley.color) )
par(op)

}
\keyword{color }
\keyword{hplot }

\eof
\name{vec2distm}
\alias{vec2distm}
\alias{vec2dist}
\alias{lower2upper.tri.inds}
\alias{diag.off}
\alias{clus2memship}
\alias{memship2clus}

\title{ Various utility functions}
\description{
  \code{vec2distm} converts a vector to a distance matrix.

  \code{vec2dist} converts a vector to a \code{dist} structure.

  \code{lower2upper.tri.inds} is the same as \code{lower.to.upper.tri.inds}
  from package cluster. It computes an index vector for extracting or reordering a lower     
triangular matrix that is stored as a contiguous vectors. 

\code{diag.off}  returns a vector of off-diagonal elements of a matrix.
\code{off} specifies the distance above the main (0) diagonal.

\code{clus2memship} converts  a list whose ith element contains the indices
of objects in the ith cluster into a vector whose ith 
element gives the cluster number of the ith object.

\code{memship2clus} converts  a vector whose ith 
element gives the cluster number of the ith object into a list 
whose ith element contains the indices
of objects in the ith cluster.

}
\usage{
vec2distm(vec)
vec2dist(vec)
lower2upper.tri.inds(n)
diag.off(m,off=1)
clus2memship(clusters)
memship2clus(memship)
}
\arguments{
  \item{vec}{is a vector. }
  \item{n}{is an integer > 1. }
 \item{m} {is a matrix.}
 \item{clusters}{is a list whose ith element contains the indices of the 
 objects belonging to the ith cluster.}
\item{off}{is an integer specifying the distance above the main (0) diagonal.}
\item{memship}{is a vector whose ith element gives the cluster number of 
the ith object.}

}
\author{ Catherine B. Hurley}
%\note{ ~~further notes~~ }


\seealso{  \code{\link{dist}}, \code{\link{diag}}. }
\examples{
vec <- 1:15
vec2distm(vec)
vec2dist(vec)
diag.off(vec2distm(vec))
lower2upper.tri.inds(5)
clus2memship(list(c(1,3,5),c(2,6),4))
memship2clus(c(1,3,4,2,1,4,2,3,2,3))
}
\keyword{cluster}

\eof
\name{wine}
\alias{wine}
\docType{data}
\title{Wine recognition data}
\description{
Data from the machine learning repository.
A chemical analysis
of 178 Italian wines from three different cultivars yielded 13  measurements.
This dataset is often used to test and compare the performance of various
classification algorithms.

}
\format{This data frame contains the following columns:
 \describe{
 \item{Class:}{There are 3 classes}
 \item{Alcohol:}{Alcohol}
 \item{Malic:}{Malic acid}
 \item{Ash:}{Ash}
 \item{Alcalinity:}{Alcalinity of ash}
 \item{Magnesium:}{Magnesium}
 \item{Phenols:}{Total phenols}
 \item{Flavanoids:}{Flavanoids}
 \item{Nonflavanoid:}{Nonflavanoid phenols}
 \item{Proanthocyanins:}{Proanthocyanins}
 \item{Intensity:}{Color intensity}
 \item{Hue:}{Hue}
 \item{OD280:}{OD280/OD315 of diluted wines}
 \item{Proline:}{Proline}
}}
\usage{data(wine)}


\source{
Forina, M. et al, PARVUS - An Extendible Package for Data
       Exploration, Classification and Correlation. Institute of Pharmaceutical
       and Food Analysis and Technologies, Via Brigata Salerno, 
       16147 Genoa, Italy.
}
\reference{
Blake, C.L. and Merz, C.J. (1998), UCI Repository of machine learning databases, \\
\url{http://www.ics.uci.edu/~mlearn/MLRepository.html}. Irvine, CA: University of California, Department of
Information and Computer Science. 

The database does not list the variable names. These were
located at 
\url{http://www.radwin.org/michael/projects/learning/about-wine.html}.
}
\keyword{datasets}

\eof
