### Name: HWE.test
### Title: Estimate Disequilibrium and Test for Hardy-Weinberg Equilibrium
### Aliases: HWE.test HWE.test.genotype HWE.test.data.frame print.HWE.test
### Keywords: misc

### ** Examples

## Don't show:
set.seed(4657613)
## End Don't show
example.data   <- c("D/D","D/I","D/D","I/I","D/D",
                    "D/D","D/D","D/D","I/I","")
g1  <- genotype(example.data)
g1

HWE.test(g1)

#compare with
diseq(g1)
diseq.ci(g1)
HWE.chisq(g1)
HWE.exact(g1)

three.data   <- c(rep("A/A",8),
                  rep("C/A",20),
                  rep("C/T",20),
                  rep("C/C",10),
                  rep("T/T",3))

g3  <- genotype(three.data)
g3

HWE.test(g3, ci.B=10000)




