### Name: points.geodata
### Title: Plots Spatial Locations and Data Values
### Aliases: points.geodata
### Keywords: spatial dplot aplot

### ** Examples

data(s100)
op <- par(no.readonly = TRUE)
par(mfrow=c(2,2), mar=c(3,3,1,1), mgp = c(2,1,0))
points(s100, xlab="Coord X", ylab="Coord Y")
points(s100, xlab="Coord X", ylab="Coord Y", pt.divide="rank.prop")
points(s100, xlab="Coord X", ylab="Coord Y", cex.max=1.7,
               col=gray(seq(1, 0.1, l=100)), pt.divide="equal")
points(s100, pt.divide="quintile", xlab="Coord X", ylab="Coord Y")
par(op)

data(ca20)
points(ca20, pt.div='quartile', x.leg=4900, y.leg=5850, bor=borders)



