\name{GeneralisedLambdaDistribution}
\alias{dgl}
\alias{qdgl}
\alias{qdgl.fmkl}
\alias{qdgl.rs}
\alias{pgl}
\alias{qgl}
\alias{qgl.fmkl}
\alias{qgl.rs}
\alias{rgl}
\alias{GeneralizedLambdaDistribution}
\alias{GeneralisedLambdaDistribution}
\alias{gld}
\title{The Generalised Lambda Distribution}
\description{Density, quantile density, distribution function, quantile 
function and random generation for the generalised lambda distribution 
(also known as the asymmetric lambda, or Tukey lambda).  Works for 
both the \code{fmkl} (recommended) and \code{rs} parameterisations.
}
\usage{
dgl(x, lambda1, lambda2, lambda3, lambda4,
param="fmkl",inverse.eps=1e-8,max.iterations=500)
qdgl(p, lambda1, lambda2, lambda3, lambda4, param="fmkl")
qdgl.fmkl(p, lambda1, lambda2, lambda3, lambda4)
qdgl.rs(p, lambda1, lambda2, lambda3, lambda4)
pgl(q, lambda1, lambda2, lambda3, lambda4,
param="fmkl",inverse.eps=1e-8,max.iterations=500)
qgl(p, lambda1, lambda2, lambda3, lambda4, param="fmkl")
qgl.fmkl(p, lambda1, lambda2, lambda3, lambda4)
qgl.rs(p, lambda1, lambda2, lambda3, lambda4)
rgl(n, lambda1, lambda2, lambda3, lambda4, param="fmkl")
}
\arguments{
  \item{x,q}{vector of quantiles.}
  \item{p}{vector of probabilities.}
  \item{n}{number of observations.}
  \item{lambda1}{\eqn{\lambda_1}{lambda 1} - location parameter
% This note needed to be put inside an item, otherwise R cmd check can't find
% the documentation for the other arguments
  \emph{Note that the numbering of the \eqn{\lambda}{lambda} parameters 
	is different to that used by Freimer, Mudholkar, Kollia and Lin.}
	}
  \item{lambda2}{\eqn{\lambda_2}{lambda 2} - scale parameter}
  \item{lambda3}{\eqn{\lambda_3}{lambda 3} - first shape parameter}
  \item{lambda4}{\eqn{\lambda_4}{lambda 4} - second shape parameter}
  \item{param}{choose parameterisation: 
  \code{fmkl} uses \emph{Freimer, Mudholkar, Kollia and Lin (1988)} (default).
  \code{rs} uses \emph{Ramberg and Schmeiser (1974)}}
  \item{inverse.eps}{Accuracy of calculation for the numerical determination of 
	\eqn{F(x)}, defaults to \eqn{10^{-8}}{1e-8}}
  \item{max.iterations}{Maximum number of iterations in the numerical 
	determination of \eqn{F(x)}, defaults to 500}
}
\details{
The generalised lambda distribution, also known as the asymmetric lambda, 
or Tukey lambda distribution, is a distribution with a wide range of shapes.  
The distribution is defined by its quantile function, the inverse of the
distribution function.  There are two parameterisations of the distribution.  
The default parameterisation is that due to \emph{Freimer Mudholkar, Kollia 
and Lin (1988)} (see references below), with a quantile function:
\deqn{F^{-1}(u)= \lambda_1 + { { \frac{u^{\lambda_3}-1}{\lambda_3} - 	%
\frac{(1-u)^{\lambda_4}-1}{\lambda_4} } \over \lambda_2 } 		%
}{F inverse (u) = lambda1 + ( (u^lambda3 -1)/lambda3 - ((1-u)^lambda4 	%
-1)/lambda4 ) / lambda 2}
for \eqn{\lambda_2 > 0}{lambda2 >0}.

The alternative parameterisation, chosen by setting
\code{param="rs"} is that due to \emph{Ramberg and Schmeiser
(1974)}, with the quantile function:
\deqn{F^{-1}(u)= \lambda_1 + \frac{u^{\lambda_3} - (1-u)^{\lambda_4}} 	%
{\lambda_2} }{F inverse (u) = lambda1 + ( u^lambda3 - (1-u)^lambda4 ) / % 
lambda 2}

This parameterisation has a complex series of rules determining which values 
of the parameters produce valid statistical distributions.  See 
\link{gl.check.lambda} for details.

The distribution is defined by its quantile function and its distribution and
density functions do not exist in closed form.  Accordingly, the results 
from \code{pgl} and \code{dgl} are the result of a numerical solutions to
equations, using the Newton-Raphson method.  Since the quantile density
function, \eqn{f(F^{-1}(u))}, does exist, an additional function, \code{qdgl},
computes this.

\code{qdgl.fmkl} and \code{qdgl.rs} are versions of \code{qdgl} that assume the 
FMKL and RS parameterisations, respectively.

\code{qgl.fmkl} and \code{qgl.rs} are versions of \code{qgl} that assume the 
FMKL and RS parameterisations, respectively.
}
\value{
  \code{dgl} gives the density (based on the quantile density and a 
  numerical solution to \eqn{F^{-1}(u)=x}{F inv (u)=x}), 

  \code{qdgl} gives the quantile density,
  
  \code{pgl} gives the distribution function (based on a numerical
	solution to \eqn{F^{-1}(u)=x}{F inv (u)=x}),

  \code{qgl} gives the quantile function, and

  \code{rgl} generates random deviates.
}
\references{ Freimer, M., Mudholkar, G. S., Kollia, G. & Lin, C. T. (1988), 
	\emph{A study of the generalized tukey lambda family}, Communications 
	in Statistics - Theory and Methods \bold{17}, 3547--3567.

Karian, Z.E., Dudewicz, E.J., and McDonald, P. (1996), \emph{The extended 
    generalized lambda distribution system for fitting distributions to data: 
    history, completion of theory, tables, applications, the ``Final Word'' 
    on Moment fits}, Communications in Statistics - Simulation and Computation 
    \bold{25}, 611--642.

Ramberg, J. S. & Schmeiser, B. W. (1974), \emph{An approximate method for
generating asymmetric random variables}, Communications of the ACM \bold{17}, 
78--82.

\url{http://maths.newcastle.edu.au/~rking/gld/}
}
\author{Robert King, \email{robert.king@newcastle.edu.au}, \url{http://maths.newcastle.edu.au/~rking/}}

\examples{
qgl(seq(0,1,0.02),0,1,0.123,-4.3)
pgl(seq(-2,2,0.2),0,1,-.1,-.2,param="fmkl",inverse.eps=.Machine$double.eps)
# calculate the probabilities more accurately than normal
}
\keyword{distribution}

\eof
\name{gl.check.lambda}
\alias{gl.check.lambda}
\title{Function to check the validity of parameters of the generalized lambda 
distribution}
\description{
  Checks the validity of parameters of the generalized lambda.  In the case of 
  the FMKL parameterisation, this is just a case of checking that 
  \eqn{\lambda_2}{lambda 2} is positive.  The RS parameterisation is much more 
  complex.
}
\usage{
gl.check.lambda(lambda1, lambda2, lambda3, lambda4, param="fmkl")
}
\arguments{
  \item{lambda1}{\eqn{\lambda_1}{lambda 1} - location parameter
% This note needed to be put inside an item, other R cmd check can't find
% the documentation for the other arguments
  \emph{Note that the numbering of the \eqn{\lambda}{lambda} parameters 
	is different to that used by Freimer, Mudholkar, Kollia and Lin.}
	}
  \item{lambda2}{\eqn{\lambda_2}{lambda 2} - scale parameter}
  \item{lambda3}{\eqn{\lambda_3}{lambda 3} - first shape parameter}
  \item{lambda4}{\eqn{\lambda_4}{lambda 4} - second shape parameter}
  \item{param}{choose parameterisation:
  \code{fmkl} uses \emph{Freimer, Mudholkar, Kollia and Lin (1988)} (default).
  \code{rs} uses \emph{Ramberg and Schmeiser (1974)}}
}
\details{
  See \code{\link{GeneralisedLambdaDistribution}} for details on the 
  generalised lambda distribution.  This function determines the validity of 
  parameters of the distribution.
  
  The FMKL parameterisation gives a valid 
  statistical distribution for any real values of \eqn{\lambda_1}{lambda 1},
  \eqn{\lambda_3}{lambda 3},\eqn{\lambda_4}{lambda 4} and any positive real 
  values of \eqn{\lambda_2}{lambda 2}.

  For the RS parameterisation, the combinations of parameters value that give 
  valid distributions are the following (the region numbers in the table 
  correspond to the labelling of the regions in \emph{Ramberg and 
  Schmeiser (1974)} and \emph{Karian, Dudewicz and McDonald (1996)}):

\tabular{cccccc}{
region \tab \eqn{\lambda_1}{lambda 1} \tab \eqn{\lambda_2}{lambda 2}	
\tab \eqn{\lambda_3}{lambda 3} \tab \eqn{\lambda_4}{lambda 4} \tab note \cr
1 \tab	all 	\tab \eqn{<0}	\tab \eqn{< -1}		\tab \eqn{> 1} \tab \cr
2 \tab	all 	\tab \eqn{<0}	\tab \eqn{> 1}		\tab \eqn{< -1} \tab \cr
3 \tab	all 	\tab \eqn{>0}	\tab \eqn{\ge 0}	\tab \eqn{\ge 0} \tab 
one of \eqn{\lambda_3}{lambda 3} and \eqn{\lambda_4}{lambda 4} must be non-zero \cr
4 \tab  all     \tab \eqn{<0} 	\tab \eqn{\le 0}	\tab \eqn{\le 0} \tab 
one of \eqn{\lambda_3}{lambda 3} and \eqn{\lambda_4}{lambda 4} must be non-zero \cr
5 \tab 	all	\tab \eqn{<0}	\tab \eqn{> -1} and \eqn{< 0} 	\tab \eqn{>1}
\tab equation 1 below must also be satisfied \cr
6 \tab 	all	\tab \eqn{<0}	\tab \eqn{>1} 	\tab \eqn{> -1} and \eqn{< 0}
\tab equation 2 below must also be satisfied \cr
}

Equation 1

\deqn{  \frac{(1-\lambda_3) ^{1-\lambda_3}(\lambda_4-1)^{\lambda_4-1}}
{(\lambda_4-\lambda_3)^{\lambda_4-\lambda_3}} <
- \frac{\lambda_3}{\lambda_4} }{% non TeX version
( (1-lambda3) ^ ( 1 - lambda3) * (lambda4 -1) ^ (lambda4 -1) ) /
( (lambda4 - lambda3) ^ (lambda4 - lambda3) ) <
- lambda3 / lambda 4 }

Equation 2

\deqn{  \frac{(1-\lambda_4) ^{1-\lambda_4}(\lambda_3-1)^{\lambda_3-1}}
{(\lambda_3-\lambda_4)^{\lambda_3-\lambda_4}} <
- \frac{\lambda_4}{\lambda_3} }{%
( (1-lambda4) ^ ( 1 - lambda4) * (lambda3 -1) ^ (lambda3 -1) ) /
( (lambda3 - lambda4) ^ (lambda3 - lambda4) ) <
- lambda4 / lambda 3
}

}
\value{This logical function takes on a value of TRUE if the parameter values 
given produce a valid statistical distribution and FALSE if they don't}
\references{ Freimer, M., Mudholkar, G. S., Kollia, G. & Lin, C. T. (1988),
        \emph{A study of the generalized tukey lambda family}, Communications
       in Statistics - Theory and Methods \bold{17}, 3547--3567.

Karian, Z.E., Dudewicz, E.J., and McDonald, P. (1996), \emph{The extended 
    generalized lambda distribution system for fitting distributions to data:
    history, completion of theory, tables, applications, the ``Final Word'' 
    on Moment fits}, Communications in Statistics - Simulation and
Computation 
    \bold{25}, 611--642.

Ramberg, J. S. & Schmeiser, B. W. (1974), \emph{An approximate method for
generating asymmetric random variables}, Communications of the ACM \bold{17},
78--82.

\url{http://maths.newcastle.edu.au/~rking/gld/}
}
\author{Robert King, \email{robert.king@newcastle.edu.au}, \url{http://maths.newcastle.edu.au/~rking/}}
\note{The complex nature of the rules in this function for the RS
parameterisation are the reason for the invention of the FMKL
parameterisation and its status as the default parameterisation in the other
generalized lambda functions.}

\seealso{The generalized lambda functions \code{\link{GeneralisedLambdaDistribution}}  }

\examples{
gl.check.lambda(0,1,.23,4.5) ## TRUE
gl.check.lambda(0,-1,.23,4.5) ## FALSE 
gl.check.lambda(0,1,0.5,-0.5,"rs") ## FALSE
}
\keyword{distribution}

\eof
\name{plotgl}
\alias{plotgl}
\alias{plotglc}
\alias{plotgld}
\title{Plots of density and distribution function for the generalised lambda
distribution}
\description{
Produces plots of density and distribution function for the generalised lambda
distribution.  Although you could use \code{plot(function(x)dgl(x))} to do
this, the fact that the density and quantiles of the generalised lambda are
defined in terms of the depth, \eqn{u}, means that a seperate function that
uses the depths to produce the values to plot is more efficient
}
\usage{
plotgld(lambda1 = 0, lambda2 = 1, lambda3, lambda4, param = "fmkl", 
new.plot = TRUE, truncate = 0, bnw = FALSE, col.or.type = 1, 
granularity = 4000, xlab = NULL, ylab = NULL, quant.probs = seq(0,1,.25), ...)
plotglc(lambda1 = 0, lambda2 = 1, lambda3, lambda4, param = "fmkl", 
granularity = 4000, xlab = "x", ylab = "cumulative probability", ...)
}
\arguments{
  \item{lambda1}{\eqn{\lambda_1}{lambda 1} - location parameter
% This note needed to be put inside an item, other R cmd check can't find
% the documentation for the other arguments
  \emph{Note that the numbering of the \eqn{\lambda}{lambda} parameters 
	is different to that used by Freimer, Mudholkar, Kollia and Lin.}
	}
  \item{lambda2}{\eqn{\lambda_2}{lambda 2} - scale parameter}
  \item{lambda3}{\eqn{\lambda_3}{lambda 3} - first shape parameter}
  \item{lambda4}{\eqn{\lambda_4}{lambda 4} - second shape parameter}
  \item{param}{choose parameterisation: 
  \code{fmkl} uses \emph{Freimer, Mudholkar, Kollia and Lin (1988)} (default).
  \code{rs} uses \emph{Ramberg and Schmeiser (1974)}}
  \item{new.plot}{a logical value describing whether this should produce a
new plot (using \code{plot}), or add to an existing plot (using
\code{lines})}
  \item{truncate}{for \code{plotgld}, a minimum density value at which the
plot should be truncated.}
  \item{bnw}{a logical value, true for a black and white plot, with different
densities identified using line type (\code{lty}), false for a colour plot, 
with different
densities identified using line colour (\code{col})}
  \item{col.or.type}{Colour or type of line to use}
  \item{granularity}{Number of points to calculate quantiles and density at
--- see \em{details}}
  \item{xlab}{X axis label}
  \item{ylab}{Y axis label}
  \item{quant.probs}{Quantiles of distribution to return (see \em{value}
below).  Set to NULL to suppress this return entirely.}
  \item{...}{arguments that get passed to \code{plot} if this is a new plot}
}
\details{
The generalised lambda distribution is defined in terms of its quantile
function.  The density of the distribution is available explicitly as a
function of depths, \eqn{u}, but not explicitly available as a function of 
\eqn{x}.  This function calculates quantiles and depths as a function of
depths to produce a density plot \code{plotgld} or cumulative probability plot
\code{plotglc}.

The plot can be truncated, either by restricting the values using \code{xlim}
--- see \code{par} for details, or by the \code{truncate} argument, which
specifies a minimum density.  This is recommended for graphs of densities
where the tail is very long.
}
\value{
  A number of quantiles from the distribution, the default being the minimum,
maximum and quartiles.
}
\references{ 
 Freimer, M., Mudholkar, G. S., Kollia, G. & Lin, C. T. (1988), 
	\emph{A study of the generalized tukey lambda family}, Communications 
	in Statistics - Theory and Methods \bold{17}, 3547--3567.

Ramberg, J. S. & Schmeiser, B. W. (1974), \emph{An approximate method for
generating asymmetric random variables}, Communications of the ACM \bold{17}, 
78--82.

Karian, Z.E. & Dudewicz, E.J. (2000), \emph{Fitting Statistical Distributions to
Data: The generalised Lambda Distribution and the Generalised Bootstrap
Methods}, CRC Press.

\url{http://maths.newcastle.edu.au/~rking/gld/}

}
\author{Robert King, \email{robert.king@newcastle.edu.au}, \url{http://maths.newcastle.edu.au/~rking/}}

\seealso{\code{\link{GeneralisedLambdaDistribution}}}
\examples{
plotgld(0,1.4640474,.1349,.1349,main="Approximation to Standard Normal", 
sub="But you can see this isn't on infinite support")
}

plotgld(1.42857143,1,.7,.3,main="The whale")
plotglc(1.42857143,1,.7,.3)
plotgld(0,-1,5,-0.3,param="rs")
plotgld(0,-1,5,-0.3,param="rs",xlim=c(1,2))
# A bizarre shape from the RS paramterisation
plotgld(0,1,5,-0.3,param="fmkl")
plotgld(10/3,,.3,-1,truncate=1e-3)

plotgld(0,1,.0742,.0742,col.or.type=2,param="rs",main="All distributions 
have the same moments",sub="Full Range of all distributions")
plotgld(0,1,6.026,6.026,col.or.type=3,new.plot=F,param="rs")
plotgld(0,1,35.498,2.297,col.or.type=4,new.plot=F,param="rs")
legend(0.25,3.5,lty=1,col=c(2,3,4),legend=c("(0,1,.0742,.0742)",
"(0,1,6.026,6.026)","(0,1,35.498,2.297)"),cex=0.9)
# An illustration of problems with moments as a method of characterising shape

\keyword{distribution}
\keyword{hplot}
\keyword{aplot}


\eof
\name{qqgl}
\alias{qqgl}
\title{Quantile-Quantile plot against the generalised lambda distribution}
\description{\code{qqgl} produces a Quantile-Quantile plot against the
generalised lambda distribution.  It does for the generalised lambda
distribution what \code{\link{qqnorm}} does for the normal.
}
\usage{
qqgl(y, lambda1, lambda2, lambda3, lambda4, param = "fmkl", abline = TRUE, ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{y}{The data sample}
\item{lambda1}{\eqn{\lambda_1}{lambda 1} - location parameter
% This note needed to be put inside an item, otherwise R cmd check can't find
% the documentation for the other arguments
  \emph{Note that the numbering of the \eqn{\lambda}{lambda} parameters 
	is different to that used by Freimer, Mudholkar, Kollia and Lin.}
	}
  \item{lambda2}{\eqn{\lambda_2}{lambda 2} - scale parameter}
  \item{lambda3}{\eqn{\lambda_3}{lambda 3} - first shape parameter}
  \item{lambda4}{\eqn{\lambda_4}{lambda 4} - second shape parameter}
  \item{param}{choose parameterisation: 
  \code{fmkl} uses \emph{Freimer, Mudholkar, Kollia and Lin (1988)} (default).
  \code{rs} uses \emph{Ramberg and Schmeiser (1974)}}
  \item{abline}{A logical value, TRUE adds a line through the origian
with a slope of 1 to the plot}
  \item{\dots}{graphical parameters}
}
\details{
See \code{\link{gld}} for more details on the Generalised Lambda
Distribution.  A Q-Q plot provides a way to visually assess the
correspondence between a dataset and a particular distribution. 
}
\value{
  A list of the same form as that returned by \code{\link{qqline}}
  \item{x}{The x coordinates of the points that were/would be plotted,
corresponding to a generalised lambda distibution with parameters 
\eqn{\lambda_1}{lambda 1}, \eqn{\lambda_2}{lambda 2},
\eqn{\lambda_3}{lambda 3}, \eqn{\lambda_4}{lambda 4}. }
  \item{y}{The original \code{y} vector, i.e., the corresponding y
    coordinates.}
}
\references{
King, R.A.R. & MacGillivray, H. L. (1999), \emph{A starship method for
fitting the generalised \eqn{\lambda}{lambda} distributions},
Australian and New Zealand Journal of
Statistics \bold{41}, 353--374

\url{http://maths.newcastle.edu.au/~rking/gld/}
}
\author{Robert King, \email{robert.king@newcastle.edu.au},
\url{http://maths.newcastle.edu.au/~rking/}}

\seealso{\code{\link{gld}},\code{\link{starship}} }
\examples{
qqgl(rgl(100,0,1,0,-.1),0,1,0,-.1)
}
\keyword{distribution}
\keyword{hplot}
\keyword{aplot}

\eof
\name{starship}
\alias{starship}
\title{Carry out the ``starship'' estimation method for the generalised
lambda distribution} 
\description{
Calculates estimates for the FMKL parameterisation of the generalised lambda
distribution on the basis of data, using the starship method.
The starship method is built on the fact that the 
generalised lambda distribution (\code{\link{gld}})
is a transformation of the uniform distribution.  This method finds the 
parameters that transform the data closest to the uniform distribution.
This function uses a grid-based search to find a suitable starting point (using
\code{\link{starship.adaptivegrid}}) then uses \code{\link{optim}} to find
the parameters that do this.
}
\usage{
starship(data, optim.method = "Nelder-Mead", initgrid = NULL, param="FMKL",
optim.control=NULL)
}
\arguments{
  \item{data}{Data to be fitted, as a vector}
  \item{optim.method}{Optimisation method for \code{\link{optim}} to use, 
defaults to Nelder-Mead}
  \item{initgrid}{Grid of values of \eqn{\lambda_3}{lambda 3} and
\eqn{\lambda_4}{lambda 4}
to try, in \code{\link{starship.adaptivegrid}}.  This should be a list, with
elements \code{lcvect} (a vector of values of \eqn{\lambda_3}{lambda 3}) 
and \code{ldvect} (a vector of values of \eqn{\lambda_4}{lambda 4}).  
If it is left as NULL, these both default to
\tabular{ccccccccccc}{-1.5\tab -1\tab -.5\tab -.1\tab 0\tab .1\tab .2\tab .4\tab .8\tab 1\tab 1.5}
	}
\item{param}{choose parameterisation: 
  \code{fmkl} uses \emph{Freimer, Mudholkar, Kollia and Lin (1988)} (default).
  \code{rs} uses \emph{Ramberg and Schmeiser (1974)}}
\item{optim.control}{List of options for the optimisation step.  See
\code{\link{optim}} for details.  If left as NULL, the parscale 
control is set to scale \eqn{\lambda_1}{lambda 1}
and \eqn{\lambda_2}{lambda 2} by the absolute value of their starting points.
}
}
\details{
The starship method is described in King \& MacGillivray, 1999 (see
references). It is built on the fact that the 
generalised lambda distribution (\code{\link{gld}})
is a transformation of the uniform distribution.  Thus the inverse of this
transformation is the distribution function for the gld.  The starship method
applies different values of the parameters of the distribution to the
distribution function, calculates the depths {\em q} corresponding to the data
and chooses the parameters that make the depths closest to a uniform
distribution.

The closeness to the uniform is assessed by calculating the Anderson-Darling
goodness-of-fit test on the transformed data against the uniform, for a
sample of size \code{length(data)}.

This is implemented in 2 stages in this function.  First a grid search is
carried out, over a small number of possible parameter values
(see \code{\link{starship.adaptivegrid}} for details).  Then the minimum from
this search is given as a starting point for an optimisation of the 
Anderson-Darling value using optim, with method given by \code{optim.method}

See \code{\link{GeneralisedLambdaDistribution}} for details on
parameterisations.
}
\value{
Returns a list, with 
  \item{lambda}{A vector of length 4, giving 
the estimated parameters, in order,
  \eqn{\lambda_1}{lambda 1} - location parameter
  \eqn{\lambda_2}{lambda 2} - scale parameter
  \eqn{\lambda_3}{lambda 3} - first shape parameter
  \eqn{\lambda_4}{lambda 4} - second shape parameter }
  \item{grid.results}{output from the grid search - see
\code{\link{starship.adaptivegrid}} for details}
  \item{optim}{output from the optim search -
\code{\link{optim}} for details}
}
\references{ Freimer, M., Mudholkar, G. S., Kollia, G. & Lin, C. T. (1988), 
	\emph{A study of the generalized tukey lambda family}, Communications 
	in Statistics - Theory and Methods \bold{17}, 3547--3567.

Ramberg, J. S. & Schmeiser, B. W. (1974), \emph{An approximate method for
generating asymmetric random variables}, Communications of the ACM \bold{17}, 
78--82.
 
King, R.A.R. & MacGillivray, H. L. (1999), \emph{A starship method for
fitting the generalised \eqn{\lambda}{lambda} distributions},
Australian and New Zealand Journal of
Statistics \bold{41}, 353--374

Owen, D. B. (1988), \emph{The starship}, Communications in Statistics - 
Computation and Simulation \bold{17}, 315--323.

\url{http://maths.newcastle.edu.au/~rking/gld/}
}
\author{Robert King, \email{robert.king@newcastle.edu.au}, \url{http://maths.newcastle.edu.au/~rking/}

Darren Wraith, \email{Darren.Wraith@studentmail.newcastle.edu.au}}
\seealso{ 
\code{\link{starship.adaptivegrid}}, 
\code{\link{starship.obj}} 
}
\examples{
data <- rgl(100,0,1,.2,.2)
starship(data,optim.method="Nelder-Mead",initgrid=list(lcvect=(0:4)/10,
ldvect=(0:4)/10))
}
\keyword{distribution}

\eof
\name{starship.adaptivegrid}
\alias{starship.adaptivegrid}
\title{Carry out the ``starship'' estimation method for the generalised
lambda distribution using a grid-based search}
\description{
Calculates estimates for the generalised lambda
distribution on the basis of data, using the starship method.
The starship method is built on the fact that the 
generalised lambda distribution (\code{\link{gld}})
is a transformation of the uniform distribution.  This method finds the 
parameters that transform the data closest to the uniform distribution.
This function uses a grid-based search.
}
\usage{
starship.adaptivegrid(data, lcvect = c(-1.5, -1, -0.5, -0.1, 0, 0.1, 0.2,
0.4, 0.8, 1, 1.5), ldvect = c(-1.5, -1, -0.5, -0.1, 0, 0.1, 0.2, 0.4, 0.8, 
1, 1.5),param="FMKL")
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{data}{Data to be fitted, as a vector}
  \item{lcvect}{Vector of values to form \eqn{\lambda_3}{lambda 3} part of the grid} 
  \item{ldvect}{Vector of values to form \eqn{\lambda_4}{lambda 4} part of the grid} 
  \item{param}{choose parameterisation: 
  \code{fmkl} uses \emph{Freimer, Mudholkar, Kollia and Lin (1988)} (default).
  \code{rs} uses \emph{Ramberg and Schmeiser (1974)}}
}
\details{
The starship method is described in King \& MacGillivray, 1999 (see
references). It is built on the fact that the 
generalised lambda distribution (\code{\link{gld}})
is a transformation of the uniform distribution.  Thus the inverse of this
transformation is the distribution function for the gld.  The starship method
applies different values of the parameters of the distribution to the
distribution function, calculates the depths {\em q} corresponding to the data
and chooses the parameters that make the depths closest to a uniform
distribution.

The closeness to the uniform is assessed by calculating the Anderson-Darling
goodness-of-fit test on the transformed data against the uniform, for a
sample of size \code{length(data)}.

This function carries out a grid-based search.  This was the original method
of King \& MacGillivray, 1999, but you are advised to instead use 
\code{\link{starship}} which uses a grid-based search together with an
optimisation based search.

See \code{\link{GeneralisedLambdaDistribution}} for details on
parameterisations.
}
\value{
  \item{response}{The minimum ``response value'' --- the result of the
internal goodness-of-fit measure.  This is the return value of starship.obj.
See King \& MacGillivray, 1999 for more details}
  \item{lambda}{A vector of length 4 giving the values of
\eqn{\lambda_1}{lambda 1} to \eqn{\lambda_4}{lambda 4} that produce this
minimum response, i.e. the estimates}
}
\references{ Freimer, M., Mudholkar, G. S., Kollia, G. & Lin, C. T. (1988), 
	\emph{A study of the generalized tukey lambda family}, Communications 
	in Statistics - Theory and Methods \bold{17}, 3547--3567.

Ramberg, J. S. & Schmeiser, B. W. (1974), \emph{An approximate method for
generating asymmetric random variables}, Communications of the ACM \bold{17}, 
78--82.
 
King, R.A.R. & MacGillivray, H. L. (1999), \emph{A starship method for
fitting the generalised \eqn{\lambda}{lambda} distributions},
Australian and New Zealand Journal of
Statistics \bold{41}, 353--374

Owen, D. B. (1988), \emph{The starship}, Communications in Statistics - 
Computation and Simulation \bold{17}, 315--323.

\url{http://maths.newcastle.edu.au/~rking/gld/}
}
\author{Robert King, \email{robert.king@newcastle.edu.au}, \url{http://maths.newcastle.edu.au/~rking/}

Darren Wraith, \email{Darren.Wraith@studentmail.newcastle.edu.au}}
\seealso{ 
\code{\link{starship}}, 
\code{\link{starship.obj}} 
}
\examples{
data <- rgl(100,0,1,.2,.2)
starship.adaptivegrid(data,lcvect=(0:4)/10,ldvect=(0:4)/10)
}
\keyword{distribution}

\eof
\name{starship.obj}
\alias{starship.obj}
\title{Objective function that is minimised in starship estimation method}
\description{
The starship is a method for fitting the generalised lambda distribution.
See \code{\link{starship}} for more details.

This function is the objective funciton minimised in the methods.  It is a
goodness of fit measure carried out on the depths of the data.
}
\usage{
starship.obj(par, data, param = "fmkl")
}
\arguments{
  \item{par}{parameters of the generalised lambda distribution, a vector of
length 4, giving \eqn{\lambda_1}{lambda 1} to \eqn{\lambda_4}{lambda 4}.
See \code{\link{GeneralisedLambdaDistribution}} for details on the
definitions of these parameters}
  \item{data}{Data --- a vector}
  \item{param}{choose parameterisation: 
  \code{fmkl} uses \emph{Freimer, Mudholkar, Kollia and Lin (1988)} (default).
  \code{rs} uses \emph{Ramberg and Schmeiser (1974)}}
}
\details{
The starship method is described in King \& MacGillivray, 1999 (see
references). It is built on the fact that the 
generalised lambda distribution (\code{\link{gld}})
is a transformation of the uniform distribution.  Thus the inverse of this
transformation is the distribution function for the gld.  The starship method
applies different values of the parameters of the distribution to the
distribution function, calculates the depths {\em q} corresponding to the data
and chooses the parameters that make the depths closest to a uniform
distribution.

The closeness to the uniform is assessed by calculating the Anderson-Darling
goodness-of-fit test on the transformed data against the uniform, for a
sample of size \code{length(data)}.

This function returns that objective function.  It is provided as a seperate
function to allow users to carry out minimisations using \code{\link{optim}}
or other methods.  The recommended method is to use the \code{link{starship}}
function.
}
\value{
The Anderson-Darling goodness of fit measure, computed on the transformed
data, compared to a uniform distribution.  \emph{Note that this is NOT the
goodness-of-fit measure of the generalised lambda distribution
with the given parameter values to the data.}
}
\references{ Freimer, M., Mudholkar, G. S., Kollia, G. & Lin, C. T. (1988), 
	\emph{A study of the generalized tukey lambda family}, Communications 
	in Statistics - Theory and Methods \bold{17}, 3547--3567.

Ramberg, J. S. & Schmeiser, B. W. (1974), \emph{An approximate method for
generating asymmetric random variables}, Communications of the ACM \bold{17}, 
78--82.
 
King, R.A.R. & MacGillivray, H. L. (1999), \emph{A starship method for
fitting the generalised \eqn{\lambda}{lambda} distributions},
Australian and New Zealand Journal of
Statistics \bold{41}, 353--374

Owen, D. B. (1988), \emph{The starship}, Communications in Statistics - 
Computation and Simulation \bold{17}, 315--323.

\url{http://maths.newcastle.edu.au/~rking/gld/}
}
\author{Robert King, \email{robert.king@newcastle.edu.au}, \url{http://maths.newcastle.edu.au/~rking/}
Darren Wraith, \email{Darren.Wraith@studentmail.newcastle.edu.au}}
\seealso{ 
\code{\link{starship}} 
\code{\link{starship.adaptivegrid}}, 
}
\examples{
data <- rgl(100,0,1,.2,.2)
starship.obj(c(0,1,.2,.2),data,"fmkl")
}
\keyword{distribution}

\eof
