### Name: print.glmmML
### Title: Prints a 'glmmML' object.
### Aliases: print.glmmML
### Keywords: print

### ** Examples

## The function is currently defined as
function (x, digits = max(3, getOption("digits") - 3), na.print = "", 
    ...) 
{
  cat("\nCall: ", deparse(x$call), "\n\n")
  cat("Coefficients:\n")
  print.default(format(x$coefficients, digits = digits), print.gap = 2, 
                quote = FALSE)
  cat("Standard errors:\n")
  print.default(format(x$sd, digits = digits), print.gap = 2, 
                quote = FALSE)
  if(x$mixed){
    cat("Standard deviation in mixing distribution: ", x$sigma, "\n")
    cat("Std. Error:                                ", x$sigma.sd, "\n")
  }
  cat("\nDegrees of Freedom:", 
      x$df.residual, "Residual\n")
  cat("Residual Deviance:",
      format(signif(x$deviance, digits)),
      "\tAIC:",
      format(signif(x$aic, digits)), "\n")
  invisible(x)
  }



