\name{glmmML}
\alias{glmmML}

\title{Generalized Linear Models with random intercept}
\description{
Fits GLMs with random intercept by Maximum Likelihood and numerical
integration via Gauss-Hermite quadrature.
}
\usage{
glmmML(formula, data = list(), cluster = NULL, family = binomial,
start.coef = NULL, start.sigma = NULL, offset = NULL, method = "vmmin",
control = glm.control(epsilon = 1e-08, maxit = 100, trace = FALSE),
n.points = 16) 
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{formula}{ a symbolic description of the model to be fit. The details of
          model specification are given below.}
  \item{data}{an optional data frame containing the variables in the model.
           By default the variables are taken from
          `environment(formula)', typically the environment from which
          `glmmML' is called.
}
  \item{cluster}{Factor indicating which items are correlated}
  \item{family}{Currently, the only valid values are \code{binomial} and
  \code{poisson}. The binomial family allows for the \code{logit} and
  \code{cloglog} links, but can only be represented as binary data.}
  \item{start.coef}{starting values for the parameters in the linear predictor.
 Defaults to zero.}
  \item{start.sigma}{starting value for the mixing standard
    deviation. Defaults to 0.5.}
  \item{offset}{this can be used to specify an a priori known component to be
          included in the linear predictor during fitting.}
  \item{method}{the method to be used in fitting the model. The default (and
          presently only) method `vmmin' uses the BFGS method in the
	  'optim' function.}
  \item{control}{Controls the convergence criteria. See
  \code{\link{glm.control}} for details.} 
  \item{n.points}{Number of points in the Gauss-hermite quadrature. If
    n.points == 1, an ordinary glm is fitted.}
}
\details{
After the 'vmmin' function has converged, an ordinary Newton-Raphson
procedure finishes the maximization. As a by-product, the
variance-covariance is estimated. 
}
\value{
  The return value is a list, an object of class 'glmmML'.
}
\references{Brostrm (2003). Generalized linear models with random
  intercepts. \url{http://www.stat.umu.se/forskning/glmmML.pdf}
 }
\author{Gran Brostrm}
\note{This is a very preliminary version. The optimization may fail with
the default value of \code{start.sigma}. In that case, try different
start values for sigma.}

\seealso{\code{\link{optim}},  \code{\link[repeated]{glmm}} in Lindsey's
\code{repeated} package, and \code{\link[MASS]{glmmPQL}} in \code{MASS}.}

\examples{
x <- cbind(rep(1, 14), rnorm(14))
y <- rbinom(14, prob = 0.5, size = 1)
id <- rep(1:7, 2)
dat <- data.frame(y = y, x1 = x[, 2])
glmmML(y ~ x1, data = dat, cluster = id)
}
\keyword{regression}% at least one, from doc/KEYWORDS
%\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
\eof
\name{glmmML.fit}
\alias{glmmML.fit}

\title{Generalized Linear Model with random intercept}
\description{
This function is called by \code{glmmML}, but it can also be called
directly by the user.
}
\usage{
glmmML.fit(X, Y, start.coef = NULL, start.sigma = NULL, mixed = FALSE, cluster = NULL, offset = rep(0, nobs), family = binomial(), n.points = 16, control = glm.control(), method, intercept = TRUE)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{X}{Design matrix of covariates}
  \item{Y}{Response vector}
  \item{start.coef}{Starting values for the coefficients. }
  \item{start.sigma}{Starting value for the mixing standard deviation.}
  \item{mixed}{Logical. If FALSE, an ordinary glm is fitted.}
  \item{cluster}{The clustring variable.}
  \item{offset}{The offset in the model.}
  \item{family}{Family of distributions. Defaults to binomial with logit
  link. Other possibilities are binomial with cloglog link and poisson
  with log link.}
  \item{n.points}{Number of points in the Gauss-hermite quadrature.}
  \item{control}{Control of the iterations. See \code{\link{glm.control}}}
  \item{method}{Which optimizer? Only choice is "vmmin".}
  \item{intercept}{Logical. If TRUE, an intercept is fitted.}
}
\details{
"vmmin" is followed by some Newton-Raphson steps, until convergence. As
a by-product we get the estimated variance-covariance matrix.
}
\value{
  A list. For details, see the code.
}
\references{Brostrm (2003)}
\author{Gran Brostrm}
\note{A preliminary version, with high potential for bugs. However, when
it works, it is very fast, compared to \code{glmm} and \code{glmmPQL}}

\seealso{\code{\link{glmmML}}, \code{\link[MASS]{glmmPQL}}, and \code{\link[repeated]{glmm}}}

\examples{
x <- cbind(rep(1, 14), rnorm(14))
y <- rbinom(14, prob = 0.5, size = 1)
id <- rep(1:7, 2)

glmmML.fit(x, y, cluster = id, mixed = TRUE, method = 1)


}
\keyword{regression}% at least one, from doc/KEYWORDS
\eof
\name{print.glmmML}
\alias{print.glmmML}
\title{Prints a 'glmmML' object.}
\description{
A glmmML object is the output of \code{glmmML}.
}
\usage{
print.glmmML(x, digits = max(3, getOption("digits") - 3), na.print = "", ...)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{x}{The glmmML object}
  \item{digits}{Number of printed digits.}
  \item{na.print}{How to print NAs}
  \item{\dots}{Additional parameters, which are ignored.}
}
\details{
Nothing in particular.
}
\value{
  A short summary of the object is printed.
}
\references{Brostrm (2003)}
\author{Gran Brostrm}
\note{This is the only summary method available for the moment.}

\seealso{\code{\link{glmmML}}}

\examples{
## The function is currently defined as
function (x, digits = max(3, getOption("digits") - 3), na.print = "", 
    ...) 
{
  cat("\nCall: ", deparse(x$call), "\n\n")
  cat("Coefficients:\n")
  print.default(format(x$coefficients, digits = digits), print.gap = 2, 
                quote = FALSE)
  cat("Standard errors:\n")
  print.default(format(x$sd, digits = digits), print.gap = 2, 
                quote = FALSE)
  if(x$mixed){
    cat("Standard deviation in mixing distribution: ", x$sigma, "\n")
    cat("Std. Error:                                ", x$sigma.sd, "\n")
  }
  cat("\nDegrees of Freedom:", 
      x$df.residual, "Residual\n")
  cat("Residual Deviance:",
      format(signif(x$deviance, digits)),
      "\tAIC:",
      format(signif(x$aic, digits)), "\n")
  invisible(x)
  }
}
\keyword{print}% at least one, from doc/KEYWORDS

\eof
