\name{grasp.GUI}
\alias{grasp.GUI}
\alias{grasp.README.GUI}
\alias{grasp.options.GUI}
\alias{grasp.about.GUI}
\alias{grasp.gpl.GUI}
\alias{grasp.import.GUI}
\alias{grasp.model.GUI}
\alias{grasp.select.responses}
\alias{grasp.select.predictors}
\alias{grasp.TODO.GUI}
\alias{grasp.import}
\alias{grasp.in.GUI}
\alias{grasp.GRASS}
\alias{grasp.dump}
\title{GRASP-R Graphical User Interface}
\description{Launches the Graphical User Interface of GraspeR}
\usage{grasp.GUI(grass.on=FALSE)}
\arguments{
	\item{grass.on}{If TRUE, functions for GRASS will be activated}
}
\details{
    Grasp.GUI can be used instead of \code{\link{grasp.in}}. It initiliazes all the libraries, including the tcltk library which makes the GUI work. It has menues for about all the functions of GRASP-R, plus links to Interfaces to different functions.
}
\note{
    The help menu is not yet totally implemented. Look at the documentation for more details at \code{\url{http://www.cscf.ch/grasp}}. If you want to use the GRASS commands, install the GRASS package from CRAN, and launch grass5 BEFORE launching R FROM THE grass5 COMMAND LINE INTERFACE.
}
\author{
Fabien Fivaz \email{fabien.fivaz@bluewin.ch}. Ported to R from GRASP \url{http://www.cscf.ch/grasp/} for S-Plus written by A. Lehmann, J.R. Leathwich and J. McC Overton. Have a look at \url{http://www.cscf.ch/grasp} for details and update.
}
\seealso{
    \code{\link{grasp.in}}
}
\keyword{models} \keyword{regression}

\eof
\name{grasp.RvsP}
\alias{grasp.RvsP}
\title{GRASP-R plot of RV vs. PV}
\description{Plots the reponses (RV) versus the predictor variables (PV)}
\usage{grasp.RvsP(gr.Yi, sX)}
\arguments{
    \item{gr.Yi}{Selected responses to be used in the form of a vector with column numbers}
    \item{sX}{Selected predictors to be used in the form of a vector with column numbers}
}
\details{
    This is a visual check. A smoothing function \code{\link{spline}} is applied to the relationships between the responses and each continuous predictor. The degrees of freedom for the smooth function are the same as for the model (df = 4). To change df, you have to edit the function directly.
}
\author{
	Fabien Fivaz \email{fabien.fivaz@bluewin.ch}. Ported to R from GRASP for S-Plus written by A. Lehmann, J.R. Leathwich and J. McC Overton.
}
\seealso{
	\code{\link{grasp.histo}}, \code{\link{grasp.datamap}}, \code{\link{grasp.cormat}}
}
\keyword{models} \keyword{smooth} \keyword{regression}

\eof
\name{grasp.ascii}
\alias{grasp.ascii}
\title{Export data as an ascii grid file}
\description{Export data as ascii grid file that can be directly imported as a grid in Arcview for instance}
\usage{grasp.ascii(gr.Yi, var, resolution)}
\arguments{
	\item{gr.Yi}{Selected responses to be used in the form of a vector with column numbers}
	\item{var}{Dataframe to export. As default gr.predmat generated by grasp.pred()}
	\item{resolution}{Output grid resolution, 1000 as default}
}
\details{
    This function exports the result of prediction as a ascii grid file. It can then be directly imported in Arcview for instance.
    The filename is generated automatically and with pred, an underscore and the name of the variable Y you export, with the asc file extension.
}
\Note{If you export predictions of the same variable many times, the file is always overwritten.}
\author{
    Fabien Fivaz \email{fabien.fivaz@bluewin.ch}. Ported to R from GRASP \url{http://www.cscf.ch/grasp/} for S-Plus written by A. Lehmann,
    J.R. Leathwich and J. McC Overton. Look at \url{http://www.cscf.ch/grasp} for details and update.
}
\seealso{
    \code{\link{grasp.pred}} and \code{\link{grasp.export}}
}
\keyword{models} \keyword{smooth} \keyword{regression}

\eof
\name{grasp.corlim}
\alias{grasp.corlim}
\title{GRASP-R spatial correlation plot}
\description{Calculates correlations for two variables with differentiation of presences and absences}
\usage{grasp.corlim(gr.Yi, cols, thin = 1)}
\arguments{
    \item{gr.Yi}{Selected responses to be used in the form of a vector with column numbers}
    \item{cols}{Selected predictors to be used in the form of a vector with column numbers}
    \item{thin}{Leave 1}
}
\details{
    This function plots correlation between variables, somehow like the \code{\link{grasp.cormat}} function, but with the difference that presences and absences are differentiated. By looking at this plot before and after applying limits to your dataset, you can see the different distributions of presences and absences.
}
\author{
    Fabien Fivaz \email{fabien.fivaz@bluewin.ch}. Ported to R from GRASP \url{http://www.cscf.ch/grasp/} for S-Plus written by A. Lehmann, 
    J.R. Leathwich and J. McC Overton. Look at \url{http://www.cscf.ch/grasp} for details and updates.
}
\seealso{
    \code{\link{grasp.histo}}, \code{\link{grasp.datamap}}, \code{\link{grasp.RvsP}} and \code{\link{grasp.cormat}}
}
\keyword{models} \keyword{smooth} \keyword{regression} \keyword{plot}

\eof
\name{grasp.cormat}
\alias{grasp.cormat}
\title{GRASP-R correlations map and matrix}
\description{Calculates correlation between PVs and plots a matrix of correlation}
\usage{grasp.cormat(gr.Yi, cols, thin = 1)}
\arguments{
    \item{gr.Yi}{Selected responses to be used in the form of a vector with column numbers}
    \item{cols}{Selected predictors to be used in the form of a vector with column numbers}
    \item{thin}{Leave 1}
}
\details{
    This function calculates correlation between PVs and plots a matrix of correlation. It is a visual check. 
    Too highly correlated PVs have to be eliminated manually, after checking.
}
\author{
    Fabien Fivaz \email{fabien.fivaz@bluewin.ch}. Ported to R from GRASP \url{http://www.cscf.ch/grasp/} for S-Plus written by A. Lehmann, 
    J.R. Leathwich and J. McC Overton. Look at \url{http://www.cscf.ch/grasp} for details and update.
}
\seealso{
    \code{\link{grasp.histo}}, \code{\link{grasp.datamap}}, \code{\link{grasp.RvsP}} and \code{\link{grasp.corlim}}
}
\keyword{models} \keyword{smooth} \keyword{regression} \keyword{plot}

\eof
\name{grasp.datamap}
\alias{grasp.datamap}
\title{GRASP-R spatial distribution plot}
\description{Plots the spatial distribution of the input response data}
\usage{grasp.datamap(gr.Yi)}
\arguments{
    \item{gr.Yi}{Selected responses to be used in the form of a vector with column numbers}
}
\details{
    This function is a visual check of the spatial distribution of the input response data in case of spatial use of GRASP-R. The geographic coordinates of points must be contained in the XXX data frame, columns 2 and 3 with x and y column name respectively.
}
\author{
    Fabien Fivaz \email{fabien.fivaz@bluewin.ch}. Ported to R from GRASP \url{http://www.cscf.ch/grasp/} for S-Plus written by A. Lehmann, 
    J.R. Leathwich and J. McC Overton. Look at \url{http://www.cscf.ch/grasp} for details and update.
}
\seealso{
    \code{\link{grasp.histo}}, \code{\link{grasp.RvsP}}, \code{\link{grasp.cormat}}
}
\keyword{models} \keyword{smooth} \keyword{regression}

\eof
\name{grasp.export}
\alias{grasp.export}
\title{Export data as a point file}
\description{Export data as a point file readable with for instance Arcview}
\usage{grasp.export(var = gr.predmat)}
\arguments{
    \item{var}{Dataframe to export. As default: gr.predmat generated by \code{\link{grasp.pred}}}
}
\details{
    This function exports the result of prediction as a text file with index, coordinates and predictions with the first line containing the headers. 
    It can then be openend in Arcview. The filename is generated automatically and with pred, an underscore and the name of the variable Y you export, with the .txt 
    file extension.
}
\Note{If you export predictions of the same variable many times, the file is always overwritten.}
\author{
    Fabien Fivaz \email{fabien.fivaz@bluewin.ch}. Ported to R from GRASP \url{http://www.cscf.ch/grasp/} for S-Plus written by A. Lehmann, 
    J.R. Leathwich and J. McC Overton. Look at \url{http://www.cscf.ch/grasp} for details and update.
}
\seealso{
    \code{\link{grasp.pred}} and \code{\link{grasp.ascii}}
}
\keyword{models} \keyword{regression}

\eof
\name{grasp.histo}
\alias{grasp.histo}
\title{GRASP-R Histograms of VOI on IED}
\description{Plots the histograms of the of the VOI on the IED}
\usage{grasp.histo(gr.Yi, sX, nbar)}
\arguments{
    \item{gr.Yi}{Selected responses to be used in the form of a vector with column numbers}
    \item{sX}{Selected predictors to be used in the form of a vector with column numbers}
    \item{nbar}{Number of bars to be displayed in the hstogramms}
}
\details{
    This function is for visual check of both response (RV) and predictor variables (PV). First, a simple histogram of the selected explanatory variables is produced. On top of each bar, the number of response observations observed is written, and also drawn in each bar. The dashed line represents the overall proportion of response observations greater than zero (presences) in comparison to the total number of observations. Finally, a black continuous line is added showing whether the proportion of presences in each bar is higher or lower than the overall proportion.
}
\author{
Fabien Fivaz \email{fabien.fivaz@bluewin.ch}. Ported to R from GRASP \url{http://www.cscf.ch/grasp/} for S-Plus written by A. Lehmann, J.R. Leathwich and J. McC Overton.
}
\seealso{
	\code{\link{grasp.datamap}}, \code{\link{grasp.RvsP}}, \code{\link{grasp.cormat}}
}
\keyword{models} \keyword{smooth} \keyword{regression}

\eof
\name{grasp.in}
\alias{grasp.in}
\title{Initialize GRASP-R variables}
\description{
Initializes the main objects that are used throughout the GRASP-R session
}
\usage{grasp.in(Ymat, Xmat, Xpred)}
\arguments{
    \item{Ymat}{name of the data frame of variables of interest.}
    \item{Xmat}{name of the data frame of environmental drivers.}
    \item{Xpred}{name of the data frame of new environmental drivers to predict from}
}
\details{
    Grasp.in does several steps. It loads the required libraries (mgcv, modreg and MASS) and copies Ymat to YYY, Xmat to XXX and Xpred to XXXpred. 
    Then it creates a first model using random variables (note that it overwrites all previous models). It also creates the weights (WEIGHTS data frame). 
    After initialisation, you can change the weights by editing the WEIGHTS variable. It also intialises a few other objects usefull to GRASP-R. 
    If you are not aiming at making predictions and therefore not using XXXpred, simply use grasp.in(Ymat, Xmat, Xmat). 
    The File / Import... menu from grasp.GUI automates importation of ascii files and automatically launches grasp.in after importation. 
    If you want to import files using the R prompt, look at the following functions : \code{\link{load}}, \code{\link{read.table}} and \code{\link{scan}}. 
    You can save R objects back to the disk using the command \code{\link{save}}
}
\author{
    Fabien Fivaz \email{fabien.fivaz@bluewin.ch}. Ported to R from GRASP \url{http://www.cscf.ch/grasp/} for S-Plus written by A. Lehmann, 
    J.R. Leathwich and J. McC Overton. Look at \url{http://www.cscf.ch/grasp} for details and update.
}
\seealso{
    \code{\link{grasp.GUI}}
}
\keyword{models} \keyword{smooth} \keyword{regression}

\eof
\name{grasp.limits}
\alias{grasp.limits}
\alias{grasp.limits.GUI}
\title{GRASP-R limits}
\description{GRASP-R - Restricting the data within limits}
\usage{grasp.limits(gr.Yi, sX, npast, lim)}
\arguments{
    \item{gr.Yi}{Selected responses to be used in the form of a vector with column numbers}
    \item{sX}{Selected predictors to limit from}
    \item{npast}{Number of 0 observations kept on each side of the last presence}
    \item{lim}{Limits type generaly "and" }
}
\details{
    The grasp.limits function is optional. It restricts the data within limits defined for selected response variables by keeping a given number of 0 
    observations on each side of the last presence along selected predictors.
}
\note{
    You have to call grasp.limits before calling other functions in case you want to apply limits to all the other computations. 
    The function can be accessed through \code{\link{grasp.GUI}}() in menu Edit / Set limits...
}
\author{
Fabien Fivaz \email{fabien.fivaz@bluewin.ch}. Ported to R from GRASP \url{http://www.cscf.ch/grasp/} for S-Plus written by A. Lehmann, J.R. Leathwich and J. McC Overton.
}
\seealso{
    \code{\link{grasp.GUI}}
}
\keyword{models} \keyword{smooth} \keyword{regression}

\eof
\name{grasp.lut}
\alias{grasp.lut}
\title{GRASP-R lookup tables}
\description{Create lookup tables (LUT)}
\usage{grasp.lut(gr.Yi, grasp.model=grasp.start, path="pred1.lutSp1"}
\arguments{
    \item{gr.Yi}{Selected responses to be used in the form of a vector with column numbers}
    \item{grasp.model}{Name of the model, created by grasp.model, to use}
    \item{path}{Path for the two files that will be created}
}
\details{
    This function creates two files containing the lookup tables, one with prediction, the other with standard deviation errors. These exportation format is interesting when predictions must be done on huge datasets, i.e. when XXXpred is too big to be directly predicted from R (usually files that have more than 100'000 lines). Use the ArcView script available on our website to predict inside ArcView. Look at the help attached with this script for details.
}
\author{
	Fabien Fivaz \email{fabien.fivaz@bluewin.ch}. Ported to R from GRASP \url{http://www.cscf.ch/grasp/} for S-Plus written by A. Lehmann, J.R. Leathwich and J. McC Overton.
}
\seealso{
	\code{\link{grasp.export}} and \code{\link{grasp.ascii}}
}
\keyword{models} \keyword{smooth} \keyword{regression}

\eof
\name{grasp.model}
\alias{grasp.model}
\alias{grasp.validate}
\alias{grasp.roc}
\title{GRASP-R model creator}
\description{Creates a model from the given variables}
\usage{grasp.model(gr.Yi, sX, family, trace, df, calcdf}
\arguments{
    \item{gr.Yi}{Selected responses to be used in the form of a vector with column numbers}
    \item{sX}{Selected predictors to be used in the form of a vector with column numbers}
    \item{family}{Family to be used for the model, see details}
    \item{trace}{Verbose}
    \item{df}{Degrees of freedom to be used for each variable}
    \item{calcdf}{If TRUE, the df are calculated by the gam function}
}
\details{
    This function creates the model from the given variables. The family is important. You can choose between \code{\link{gaussian}}, \code{\link{binomial}}, \code{\link{quasibinomial}} and \code{\link{quasipoisson}}. See \code{\link{family}} for details. To create the model, the function uses the \code{\link{gam}} function provided by the mgcv package. The \code{\link{grasp.GUI}} function provides method for selecting the appropriate family based on which type of variable you have.Grasp.model has to be used before the stepwise selection procedure (see \code{\link{grasp.step.gam}}.
}
\author{
	Fabien Fivaz \email{fabien.fivaz@bluewin.ch}. Ported to R from GRASP \url{http://www.cscf.ch/grasp/} for S-Plus written by A. Lehmann, J.R. Leathwich and J. McC Overton.
}
\seealso{
	\code{\link{grasp.step.gam}}, \code{\link{gam}} and \code{\link{grasp.pred}}
}
\keyword{models} \keyword{smooth} \keyword{regression}

\eof
\name{grasp.pred}
\alias{grasp.pred}
\alias{grasp.pred.plot}
\title{GRASP-R Predict}
\description{Predicts each RVs using a new set of PVs}
\usage{grasp.pred(gr.Yi)}
\arguments{
    \item{gr.Yi}{Selected responses to be used in the form of a vector with column numbers}
}
\details{
    This function is the most time and ressource consuming, along with the stepwise selection. 
    It predicts each response variables (RVs) using a new set of predictor variables (PVs) contained in XXXpred. 
    The XXXpred variable is initialized by \code{\link{grasp.in}}. The \code{\link{predict.gam}} function from the mgcv package is used.
    The predictions are saved in the variable gr.predmat. The grasp.pred.plot() function plots the results.
}
\Note{
    The function won't work if a model has not been calculated with \code{\link{grasp.model}} before running grasp.pred()
}
\author{
    Fabien Fivaz \email{fabien.fivaz@bluewin.ch}. Ported to R from GRASP for S-Plus written by A. Lehmann, J.R. Leathwich and J. McC Overton. Look at \url{http://www.cscf.ch/grasp} for details and update.
}
\seealso{
    \code{\link{grasp.step.gam}}, \code{\link{grasp.model}} and \code{\link{predict.gam}}
}
\keyword{models} \keyword{smooth} \keyword{regression}

\eof
\name{grasp.scope}
\alias{grasp.scope}
\title{Scope list Creator}
\description{Scope list creator, generally called by \code{\link{grasp.model}} and to be used with \code{\link{grasp.step.gam}} in stepwise selection.}
\usage{grasp.scope(sX = gr.selX, df = 4, calcdf = FALSE, trace = TRUE)}
\arguments{
    \item{sX}{List coontaining the different Xs for each Ys}
    \item{df}{Number of degrees of freedom}
    \item{calcdf}{Let the smooth function "calculate" the degrees of freedom, see \code{\link{gam}} for details.}
    \item{trace}{Verbose output}
}
\details{
    This function creates the scope list. It isn't of any use by itself. It is called by \code{\link{grasp.model}} and used by 
    \code{\link{grasp.step.gam}} for stepwise selection.
}
\author{
    Fabien Fivaz \code{\email{fabien.fivaz@bluewin.ch}}. Ported to R from GRASP for S-Plus written by A. Lehmann, J.R. Leathwich and J. McC Overton. Look at \url{http://www.cscf.ch/grasp} for details and update.
}
\seealso{
    \code{\link{grasp.model}}, \code{\link{grasp.start}} and \code{\link{grasp.step.gam}}.
}
\keyword{models} \keyword{regression}

\eof
\name{grasp.start}
\alias{grasp.start}
\title{Formula Creator}
\description{Starting formula creator, generally called by \code{\link{grasp.model}}}
\usage{grasp.start(cX, sX, df = 4, calcdf = FALSE, trace = TRUE)}
\arguments{
    \item{cX}{Selected predictors to be used in the form of a vector with column numbers}
    \item{sX}{List coontaining the different Xs for each Ys}
    \item{df}{Number of degrees of freedom}
    \item{calcdf}{Let the smooth function "calculate" the degrees of freedom, see \code{\link{gam}} for details.}
    \item{trace}{Verbose output}
}
\details{
    This function creates the starting formula. It isn't of any use by itself. It is called by \code{\link{grasp.model}}
}
\Note{Look at the \code{\link{grasp.model}} code to see how sX is related to cX}
\author{
    Fabien Fivaz \email{fabien.fivaz@bluewin.ch}. Ported to R from GRASP for S-Plus written by A. Lehmann, 
    J.R. Leathwich and J. McC Overton. Look at \url{http://www.cscf.ch/grasp} for details and update.
}
\seealso{
    \code{\link{grasp.model}} and \code{\link{grasp.scope}}.
}
\keyword{models} \keyword{regression}

\eof
\name{grasp.step.gam}
\alias{grasp.step.gam}
\alias{grasp.anova.glmlist}
\alias{grasp.anova.gam}
\alias{grasp.stat.anova}
\title{GRASP-R stepwise selection}
\description{Performs a stepwise selection using anova}
\usage{grasp.step.gam(object, scope, scale, direction, trace, keep, steps, limit, test)}
\arguments{
    \item{object}{starting gam object. Use \code{\link{grasp.model}} to create it.}
    \item{scope}{scope list. Use \code{\link{grasp.scope}} to create it.}
    \item{scale}{if test = "Chisq", then scale = 1. If test = "F", scale is calculated. Leave it blank.}
    \item{direction}{Direction of the stepwise selection. Either "both", "backward" or "forward".}
    \item{trace}{If true, the function is verbose and shows details of all the stepwise selection steps.}
    \item{keep}{Leave equal to NULL.}
    \item{steps}{Maximal number of steps to be done.}
    \item{limit}{p-limit for the selection}
    \item{test}{Test to be used for selection, either "Chisq" or "F".}
}
\details{
    This function is central to GRASP-R. It statistically selects significant predictors for each response variable. grasp.step.gam starts by default with the complete model you first created. You have to create a model first with grasp.model, where gr.selX will hold the selected predictors (see \code{\link{grasp.GUI}} for details on graphical selection of variables). The procedure goes in loop to try to eliminate one variable at a time. At each step, the lest significant variable is dropped from the model, and the loop starts again with the new model holding the remaining variables. When direction is "both", the procedure also reintroduce variables in the model. The tests (F or Chisq) are used to decide whether a variable should be kept, dropped or reintroduced. At the end of the procedure, the new model is stored in the variable gam.start. It overwrites the precedent model.
}
\Note{
    The grasp.anova.glmlist(), grasp.anova.gam() and grasp.stat.anova() function are dependent on the grasp.step.gam() function but aren't of any use by themselves!
}
\author{
    Fabien Fivaz \email{fabien.fivaz@bluewin.ch}. Ported to R from GRASP \url{http://www.cscf.ch/grasp/} for S-Plus written by A. Lehmann, J.R. Leathwich and J. McC Overton. Look at \url{http://www.fivaz.ch/grasper/index.html} for details and update.
}
\seealso{
    \code{\link{grasp.model}},\code{\link{grasp.pred}} and \code{\link{stat.anova}}
}
\keyword{models} \keyword{smooth} \keyword{regression}

\eof
\name{grasp.summary}
\alias{grasp.summary}
\title{Summary of the Xs and Ys data}
\description{Export data as point file redable with for instance Arcview}
\usage{grasp.summary(gr.Yi = gr.selY)}
\arguments{
    \item{gr.Yi}{Selected responses to be used in the form of a vector with column numbers}
}
\details{
    This function summarizes the data using the \code{\link{summary}}
}
\Note{
    If you defined limits with the \code{\link{grasp.limits}}() function, the summary takes this limits into account.
    You can access the function through \code{\link{grasp.GUI}}(), menu Analysis / Summary.
}
\author{
    Fabien Fivaz \email{fabien.fivaz@bluewin.ch}. Ported to R from GRASP \url{http://www.cscf.ch/grasp/} for S-Plus written by A. Lehmann, 
    J.R. Leathwich and J. McC Overton. Look at \url{http://www.fivaz.ch/grasper/index.html} for details and update.
}
\seealso{
    \code{\link{grasp.limits}} and \code{\link{summary}}.
}
\keyword{models} \keyword{regression}

\eof
