### Name: plot.gstatVariogram
### Title: Plot a Sample Variogram
### Aliases: plot.gstatVariogram plot.variogramMap
### Keywords: dplot

### ** Examples

data(meuse)
vgm1 <- variogram(log(zinc)~1, ~x+y, meuse)
plot(vgm1)
model.1 <- fit.variogram(vgm1,vgm(1,"Sph",300,1))
plot(vgm1, model=model.1)
plot(vgm1, plot.numbers = TRUE, pch = "+")
vgm2 <- variogram(log(zinc)~1, ~x+y, meuse, alpha=c(0,45,90,135))
plot(vgm2)
# the following demonstrates plotting of directional models:
model.2 <- vgm(.59,"Sph",926,.06,anis=c(0,0.3))
plot(vgm2, model=model.2)
 
g = gstat(id="zinc < 200", form=I(zinc<200)~1,loc=~x+y,data=meuse)
g = gstat(g, id="zinc < 400", form=I(zinc<400)~1,loc=~x+y,data=meuse)
g = gstat(g, id="zinc < 800", form=I(zinc<800)~1,loc=~x+y,data=meuse)
# calculate multivariable, directional variogram:
v = variogram(g, alpha=c(0,45,90,135))
plot(v, group.id = FALSE, auto.key = TRUE) # id and id pairs panels
plot(v, group.id = TRUE, auto.key = TRUE)  # direction panels

if (require(sp)) {
  plot(variogram(g, cutoff=1000, width=100, map=TRUE),
        main = "(cross) semivariance maps")
  plot(variogram(g, cutoff=1000, width=100, map=TRUE), np=TRUE,
        main = "number of point pairs")
}



