### Name: PreEM
### Title: Pre-process the data before fitting it with EM
### Aliases: PreEM
### Keywords: methods

### ** Examples

data(hypoDat)
example.preEM<-PreEM(hypoDat, numSNPs=3)

# To get the initial haplotype frequencies:
example.preEM$initGamma
#      h000       h001       h010       h011       h100       h101       h110 
#0.25179111 0.26050418 0.23606001 0.09164470 0.10133627 0.02636844 0.01081260 
#      h111 
#0.02148268 
# The '001' haplotype is estimated to be the most frequent

example.preEM$pooledHaplos
# "h101" "h110" "h111"
# These haplotypes are to be pooled in the design matrix for the risk model

names(example.preEM$haploDM)
# "h000"   "h001"   "h010"   "h011"   "h100"   "pooled"



