% 
% Copyright 2001 Mayo Foundation for Medical Education and Research. 
% 
% This program is free software; you can redistribute it and/or
% modify it under the terms of the GNU General Public License
% as published by the Free Software Foundation; either version 2
% of the License, or (at your option) any later version.
% 
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
% 
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
% 02111-1307, USA.
% 
% 
\name{Ginv}
\alias{Ginv}
\title{
  Compute Generalized Inverse of Input Matrix
}
\description{
Singular value decomposition (svd) is used to compute a
generalized inverse of input matrix.
}
\usage{
Ginv(x)
}
\arguments{



\item{x}{
A matrix.
}
}
\value{
List with components:

\item{Ginv}{
Generalized inverse of x.
}
\item{rank}{
Rank of matrix x.
}
}
\section{Side Effects}{

}
\details{
The function svd is used to compute the singular values of
the input matrix, and the rank of the matrix is determined
by the number of singular values  that  are  at  least  as
large   as  max(svd)*eps,  where  eps  is  a  small  value
(currently eps = .000001).
}
\section{References}{
Press  WH,  Teukolsky  SA,  Vetterling  WT,  Flannery  BP.
Numerical  recipes  in C. The art of scientific computing.
2nd ed. Cambridge University Press,  Cambridge.1992.  page
61.
}
\seealso{
svd
}
\examples{
\dontrun{
save <- Ginv(x)
ginv.x <- save$Ginv
rank.x <- save$rank
}
}
\keyword{}
% docclass is function
% Converted by Sd2Rd version 1.21.
\eof
% 
% Copyright 2001 Mayo Foundation for Medical Education and Research. 
% 
% This program is free software; you can redistribute it and/or
% modify it under the terms of the GNU General Public License
% as published by the Free Software Foundation; either version 2
% of the License, or (at your option) any later version.
% 
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
% 
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
% 02111-1307, USA.
% 
% 
\name{allele.recode}
\alias{allele.recode}
\title{
  Recode allele values to integer ranks
}
\description{
Genotypes for subjects represented by a pair  of  vectors,
with the vectors containing allele values (either numeric,
factor, or character), are recoded to the  rank  order  of
allele values.
}
\usage{
allele.recode(a1, a2, miss.val=NA)
}
\arguments{


\item{a1}{
Vector of "first" alleles.
}
\item{a2}{
Vector of "second" alleles.
}
\item{miss.val }{
Vector of missing value codes for alleles.
}
}
\value{
List with components:

\item{a1}{
Vector of recoded "first" alleles.
}
\item{a2}{
Recode of recoded "second" alleles.
}
\item{allele.label}{
Vector of labels for unique alleles.
}
}
\section{Side Effects}{

}
\details{
If alleles are numeric, they are recoded to the rank order
of the alleles.  If the alleles are factor or character,
they are recoded to interger values that correspond to the
indices of the sorted values of the unique alleles, but
sorted as character values.
}
\section{References}{

}
\seealso{
geno.recode
}
\examples{

}
\keyword{}
% docclass is function
% Converted by Sd2Rd version 1.21.
\eof
% 
% Copyright 2001 Mayo Foundation for Medical Education and Research. 
% 
% This program is free software; you can redistribute it and/or
% modify it under the terms of the GNU General Public License
% as published by the Free Software Foundation; either version 2
% of the License, or (at your option) any later version.
% 
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
% 
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
% 02111-1307, USA.
% 
% 
\name{banner}
\alias{banner}
\title{
  Print a nice banner
}
\description{

}
\usage{
banner(str, banner.width=80, char.perline=60, border="=")
}
\arguments{


\item{str}{
character string - a title within the banner
}
\item{banner.width }{
width of banner
}
\item{char.perline }{
number of characters per line for the title
}
\item{border}{
type of character for the border
}
}
\value{

}
\section{Side Effects}{

}
\details{

}
\section{References}{

}
\seealso{

}
\examples{

banner("This is a pretty banner", banner.width=40, char.perline=30)

# ========================================
#          This is a pretty banner
# ========================================
}
\keyword{}
% docclass is function
% Converted by Sd2Rd version 1.21.
\eof
% 
% Copyright 2001 Mayo Foundation for Medical Education and Research. 
% 
% This program is free software; you can redistribute it and/or
% modify it under the terms of the GNU General Public License
% as published by the Free Software Foundation; either version 2
% of the License, or (at your option) any later version.
% 
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
% 
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
% 02111-1307, USA.
% 
% 
\name{gcode}
\alias{gcode}
\title{
  Numeric Code for Genotypes
}
\description{
For a one-locus genotype, composed of two vectors of
alleles, create a single vector of numeric codes that
represent the genotypes.
}
\usage{
gcode(a1, a2)
}
\arguments{



\item{a1}{
Vector of "first" alleles.
}
\item{a2}{
Vector of "second" alleles.
}
}
\value{
Vector of integer codes for genotypes.
}
\section{Side Effects}{

}
\details{
Alleles are assumed to be coded as rank order (see
allele.recode).
}
\section{References}{
Zykin D., Zhivotovsky L. and  Weir  B,  "Exact tests for
association  between alleles at arbitrary numbers of loci"
Human Identification: The Use of DNA Markers, 169-178, 1995.
}
\seealso{
ungcode, allele.recode, geno.recode
}
\examples{

}
\keyword{}
% docclass is function
% Converted by Sd2Rd version 1.21.
\eof
% 
% Copyright 2001 Mayo Foundation for Medical Education and Research. 
% 
% This program is free software; you can redistribute it and/or
% modify it under the terms of the GNU General Public License
% as published by the Free Software Foundation; either version 2
% of the License, or (at your option) any later version.
% 
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
% 
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
% 02111-1307, USA.
% 
% 
\name{geno.recode}
\alias{geno.recode}
\title{
  Recode Genotypes
}
\description{
For all loci as pairs of columns in a matrix, recode
alleles
}
\usage{
geno.recode(geno, miss.val=0)
}
\arguments{


\item{geno}{
Matrix of alleles, such that each locus has a  pair  of
adjacent  columns  of  alleles.  If there are K loci, then
ncol(geno) = 2*K. Rows represent alleles for each subject.
}
\item{miss.val }{
Vector of codes for missing values of alleles.
}
}
\value{
List with components:

\item{grec}{
Matrix of recoded alleles - see allele.recode
}
\item{alist}{
List of allele labels.  For K loci, there are K
components in the list, and the kth  component is a vector
of sorted unique allele labels for the kth locus.
}
}
\section{Side Effects}{

}
\details{

}
\section{References}{

}
\seealso{
allele.recode
}
\examples{

}
\keyword{}
% docclass is function
% Converted by Sd2Rd version 1.21.
\eof
% 
% Copyright 2001 Mayo Foundation for Medical Education and Research. 
% 
% This program is free software; you can redistribute it and/or
% modify it under the terms of the GNU General Public License
% as published by the Free Software Foundation; either version 2
% of the License, or (at your option) any later version.
% 
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
% 
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
% 02111-1307, USA.
% 
% 
\name{haplo.em}
\alias{haplo.em}
\title{
  EM Computation of Haplotype Probabilities
}
\description{
For genotypes measured on unrelated subjects, with linkage
phase  unknown,  compute  maximum  likelihood estimates of
haplotype probabilities. Because linkage phase is unknown,
there  may be  more than one pair of haplotypes that are
consistent with  the oberved marker phenotypes, so
posterior probabilities of pairs of haplotypes for each
subject are also computed.
}
\usage{
haplo.em(geno, locus.label=NA, converge.eps=1e-06, maxiter=500)
}
\arguments{


\item{geno}{
Matrix of alleles, such that each locus has a  pair  of
adjacent  columns  of  alleles,  and  the order of columns
corresponds to the order of  loci  on  a  chromosome.   If
there  are  K  loci, then ncol(geno) = 2*K. Rows represent
alleles for each subject.
}
\item{locus.label }{
Vector of  labels  for  loci,  of  length  K  (see
definition of geno matrix).
}
\item{converge.eps }{
Convergence criterion, based on absolute  change
in log likelihood (lnlike).
}
\item{maxiter}{
Maximum number of iterations of EM.
}
}
\value{
List with components:

\item{converge}{
Indicator of convergence of the EM algorithm
(1=converge, 0 = failed).
}
\item{niter}{
Number of iterations completed in the EM alogrithm.
}
\item{locus.info}{
A list with  a  component for each locus.  Each
component is also a list, and  the  items of a locus-
specific list are the locus name and a vector for the
unique alleles for the locus.
}
\item{locus.label}{
Vector of  labels  for  loci,  of  length  K  (see
definition of input values).
}
\item{haplotype}{
Matrix of unique haplotypes. Each row represents a
unique  haplotype, and the number of columns is the number
of loci.
}
\item{hap.prob}{
Vector of mle's of haplotype probabilities.  The ith
element of hap.prob corresponds to the ith row of 
haplotype.
}
\item{hap.prob.noLD}{
Similar to hap.prob, but assuming no linkage
disequilibrium.
}
\item{lnlike}{
Value of lnlike at last EM iteration (maximum lnlike if converged).
}
\item{lr}{
Likelihood ratio statistic to test no linkage
disequilibrium among all loci.
}
\item{indx.subj}{
Vector for index of subjects, after  expanding  to
all possible  pairs  of  haplotypes  for  each person. If
indx=i, then i is the ith row of input matrix geno. If the
ith subject has  n possible  pairs  of haplotypes that
correspond to their marker phenotype, then i is repeated n
times.
}
\item{nreps}{
Vector for the count of haplotype pairs that map to
each subject's marker genotypes.
}
\item{hap1code}{
Vector of codes for each subject's first haplotype.
The values in hap1code are the row numbers of the unique
haplotypes in the returned matrix haplotype.
}
\item{hap2code}{
Similar to hap1code, but for  each  subject's  second
haplotype.
}
\item{post}{
Vector of posterior probabilities of pairs of
haplotypes for a person, given thier marker phenotypes.
}
}
\section{Side Effects}{

}
\details{
The input data are arranged  as  a  matrix,  with  N  rows
representing N subjects, and 2K columns representing pairs
of alleles for K loci whose phase is  unknown.  The  input
data  matrix  is  reduced to the distinguishable un-phased
multilocus marker phenotypes, along with their counts. For
each  distinguishable  phenotype,  all  possible  pairs of
haplotypes are enumerated. Maximum likelihood  estimation,
implemented    by    the   expectation-maximization   (EM)
algorithm, proceeds by assuming Hardy-Weinberg proportions
of underlying genotypes, so that the probability of a pair
of haplotypes is the product of their probabilities (times
2  if  haplotypes differ), and then relative probabilities
are assigned to the list of possible underlying  pairs  of
haplotypes for each genotype. The haplotypes are "counted"
from the enumerated list of  all  possibilities,  but  the
relative  probabilities  are  used  as  weights. These new
counts are used to determine  new  haplotype  frequencies,
which   in   turn   are   used   to  update  the  relative
probabilities  to  new  values.  This   cyclic   iteration
continues until the likelihood is maximized (i.e., minimal
change in the lnlike).
}
\section{References}{

Excoffier, L., and Slatkin, M.,  1995,  Maximum-likelihood
estimation of molecular haplotype frequencies in a diploid
population, Mol. Biol. Evol. 12(5):921-927.

Hawley, M. E., and Kidd, K. K.,  1995,  HAPLO:  a  program
using  the  EM  algorithm  to  estimate  the frequenciesof
multi-site haplotypes, J.Heredity. 86:409-411.

Long, J. C., Williams, R. C., and Urbanek,  M.,  1995,  An
E-M  algorithm  and  testing  strategy  for multiple-locus
haplotypes, Am.J.Hum.Genet. 56:799-810.

Terwilliger, J. D., and Ott, J., 1994, Handbook  of  human
gentic linkage, Johns Hopkins University Press, Baltimore.

}
\seealso{
haplo.enum, haplo.hash, haplo.score
}
\examples{
\dontrun{
haplo <- haplo.em(geno)
}
}
\keyword{}
% docclass is function
% Converted by Sd2Rd version 1.21.
\eof
% 
% Copyright 2001 Mayo Foundation for Medical Education and Research. 
% 
% This program is free software; you can redistribute it and/or
% modify it under the terms of the GNU General Public License
% as published by the Free Software Foundation; either version 2
% of the License, or (at your option) any later version.
% 
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
% 
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
% 02111-1307, USA.
% 
% 
\name{haplo.enum}
\alias{haplo.enum}
\title{
  Enumerate all possible pairs of haplotypes  that  are  consistent
with a set of un-phased multilocus markers
}
\description{
Given input vectors h1 and h2  (one  possible  pair  of
haplotypes), enumerate all possible pairs of haplotypes,
and return enumerated pairs in matrices h1 and h2.
}
\usage{
haplo.enum(h1, h2)
}
\arguments{



\item{h1}{
A haplotype vector of length K (K = number of loci), with
values of alleles for each of the loci.
}
\item{h2}{
A second haplotype vector.
}
}
\value{
List with components:

\item{h1}{
A matrix of enumerated haplotypes.  If there are N
enumerations, h1 will have dimension N x K.
}
\item{h2}{
Similar to h1, a matrix of enumerated haplotypes for the
second members of the pairs of haplotypes.
}
}
\section{Side Effects}{

}
\details{
  For a pair of haplotypes, if there are H sites that are heterozygous,
  then there are \eqn{2^{(H-1)}}{2^(H-1)} possible pairs to
  enumerate. To achieve this, the algorithm moves across the loci that
  are heterozygous (after the 1st heterozygous locus), flipping alleles
  at heterozygous locations to enumerate all possible pairs of
  haplotpes, and appending results as rows of the output matrices h1,
  and h2.
 }
\section{References}{

}
\seealso{
haplo.em
}
\examples{

}
\keyword{}
% docclass is function
% Converted by Sd2Rd version 1.21.
\eof
% 
% Copyright 2001 Mayo Foundation for Medical Education and Research. 
% 
% This program is free software; you can redistribute it and/or
% modify it under the terms of the GNU General Public License
% as published by the Free Software Foundation; either version 2
% of the License, or (at your option) any later version.
% 
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
% 
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
% 02111-1307, USA.
% 
% 
\name{haplo.hash}
\alias{haplo.hash}
\title{
  Integer Rank Codes for Haplotypes
}
\description{
Create a vector of integer codes for the input  matrix  of
haplotypes.   The haplotypes in the input matrix are
converted to character strings, and if there are C unique
strings, the integer codes for the haplotypes will be 1,
2, ..., C.
}
\usage{
haplo.hash(hap)
}
\arguments{



\item{hap}{
A matrix of haplotypes. If there are N haplotypes for K
loci, hap have dimensions N x K.
}
}
\value{
List with elements:

\item{hash}{
Vector of integer codes for the input data  (hap).  The
value of hash is the row number of the unique haplotypes
given in the returned matrix hap.mtx.
}
\item{hap.mtx}{
Matrix of unique haplotypes.
}
}
\section{Side Effects}{

}
\details{
The alleles that make  up  each  row  in  hap  are  pasted
together  as character strings, and the unique strings are
sorted so that the rank order of  the  sorted  strings  is
used as the integer code for the unique haplotypes.
}
\section{References}{

}
\seealso{
haplo.em
}
\examples{

}
\keyword{}
% docclass is function
% Converted by Sd2Rd version 1.21.
\eof
% 
% Copyright 2001 Mayo Foundation for Medical Education and Research. 
% 
% This program is free software; you can redistribute it and/or
% modify it under the terms of the GNU General Public License
% as published by the Free Software Foundation; either version 2
% of the License, or (at your option) any later version.
% 
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
% 
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
% 02111-1307, USA.
% 
% 
\name{haplo.score}
\alias{haplo.score}
\title{
  Score Statistics for Association of Traits with Haplotypes
}
\description{
Compute score statistics to evaluate the association of  a
trait  with  haplotypes, when linkage phase is unknown and
diploid marker phenotypes  are  observed  among  unrelated
subjects. For now, only autosomal loci are considered.
}
\usage{
haplo.score(y, geno, trait.type="gaussian", offset=NA, x.adj=NA, skip.haplo=0.005, locus.label=NA, miss.val=0, n.sim=0)
}
\arguments{


\item{y}{
Vector of trait values. For  trait.type  =  "binomial",  y
must have values of 1 for event, 0 for no event.
}
\item{geno}{
Matrix of alleles, such that each locus has a  pair  of
adjacent  columns  of  alleles,  and  the order of columns
corresponds to the order of  loci  on  a  chromosome.   If
there  are  K  loci, then ncol(geno) = 2*K. Rows represent
alleles for each subject.
}
\item{trait.type }{
Character string  defining  type  of  trait,  with
values of "gaussian", "binomial", "poisson", "ordinal".
}
\item{offset}{
Vector of offset when trait.type = "poisson"
}
\item{x.adj }{
Matrix of non-genetic covariates  used  to  adjust  the
score  statistics.  Note  that  intercept  should  not  be
included, as it will be added in this function.
}
\item{skip.haplo }{
Skip score statistics for haplotypes with frequencies < skip.haplo
}
\item{locus.label }{
Vector of labels for loci, of length K (see definition of geno matrix).
}
\item{miss.val }{
Vector of codes for missing values of alleles.
}
\item{n.sim }{
Number of simulations for empirical p-values.  If
n.sim=0, no empirical p-values are computed.
}
None.
}
\value{
List with the following components:

\item{score.global}{
Global statistic to test association of trait
with haplotypes that have frequencies >= skip.haplo.
}
\item{df}{
Degrees of freedom for score.global.
}
\item{score.global.p}{
P-value of score.global based on chi-square
distribution, with degrees of freedom equal to df.
}
\item{score.global.p.sim}{
P-value of score.global based on simulations
(set equal to NA when n.sim=0).
}
\item{score.haplo}{
Vector of score statistics for individual
haplotypes that have frequencies >= skip.haplo.
}
\item{score.haplo.p}{
Vector of p-values for score.haplo, based on a
chi-square distribution with 1 df.
}
\item{score.haplo.p.sim}{
Vector of p-values for score.haplo, based on
simulations (set equal to NA when n.sim=0).
}
\item{score.max.p.sim}{
P-value  of  maximum  score.haplo, based on
simulations  (set equal to NA when n.sim=0).
}
\item{haplotype}{
Matrix of hapoltypes  analyzed.  The ith row of
haplotype corresponds to the ith item of score.haplo,
score.haplo.p, and score.haplo.p.sim.
}
\item{hap.prob}{
Vector of haplotype probabilies, corresponding to the
haplotypes in the matrix haplotype.
}
\item{locus.label}{
Vector of labels for loci, of length  K  (same  as
input argument).
}
\item{n.sim}{
Number of simulations.
}
\item{n.val.global}{
Number of valid simulated global statistics.
}
\item{n.val.haplo}{
Number of valid simulated score statistics
(score.haplo) for individual haplotypes.
}
}
\section{Side Effects}{

}
\details{
Using haplo.enum, all possible haplotypes consistent with
the observed marker phenotypes are enumerated, and
haplo.em is used to compute the maximum likelihood
estimates  of  the  haplotype frequencies, as well as the
posterior probabilities of the pairs of haplotypes for
each subject. These posterior probabilities are used to
compute the score statistics for the association of
(ambiguous) haplotypes  with  traits. The glm function is
used to compute residuals of the regression of the trait
on the non-genetic covariates.
}
\section{References}{
Schaid DJ, Rowland CM, Tines DE, Jacobson RM,  Poland  GA.
Score tests for association of traits with haplotypes when
linkage phase is ambiguous. Submitted to Amer J Hum Genet.
}
\seealso{
plot.haplo.score, print.haplo.score
}
\examples{
\dontrun{
# For quantitative, normally distributed trait:

  haplo.score(y, geno, trait.type = "gaussian")

# For a  binary trait

  haplo.score(y, geno, trait.type = "binomial")

# For a binary trait, adjusted for sex and age:

  x <- cbind(sex, age)  
  haplo.score(y, geno, trait.type = "binomial", x.adj=x)

# For poisson trait:

  haplo.score(y, geno, trait.type="poisson", offset = personYears)

# For ordinal trait:

  haplo.score(y, geno, trait.type="ordinal")
}
}
\keyword{}
% docclass is function
% Converted by Sd2Rd version 1.21.
\eof
% 
% Copyright 2001 Mayo Foundation for Medical Education and Research. 
% 
% This program is free software; you can redistribute it and/or
% modify it under the terms of the GNU General Public License
% as published by the Free Software Foundation; either version 2
% of the License, or (at your option) any later version.
% 
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
% 
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
% 02111-1307, USA.
% 
% 
\name{haplo.score.glm}
\alias{haplo.score.glm}
\title{
  Compute haplotype score statistics for GLM
}
\description{
This function is used by haplo.score when analyzing traits
by a GLM score.
}
\usage{
haplo.score.glm(y, mu, a, v, x.adj, nreps, x.post, post, x)
}
\arguments{


\item{y}{
Vector of trait values.
}
\item{mu}{
Expected value of y.
}
\item{a}{
scale parameter
}
\item{v}{
v= b''/a for a GLM.
}
\item{x.adj }{
Matrix of non-genetic covariates used  to  adjust  the
score  statistics. Note that intercept should  be included
in this matrix.
}
\item{nreps}{
Vector for the count of haplotype  pairs  that  map  to
each subject's marker genotypes (see haplo.em).
}
\item{x.post }{
Matrix for posterior mean of x per subject.
}
\item{post}{
Vector of posterior probabilities of pairs of
haplotypes for a person, given thier marker phenotypes
(see haplo.em).
}
\item{x}{
Matrix  of  scores  for  enumerated  haplotypes  for  each
subject,  with  elements  0,  1,  2  (counts  of  specific
haplotypes).
}
None.
}
\value{
List with components:

\item{u.score}{
Vector of scores for the chosen haplotypes
}
\item{v.score}{
Covariance matrix for u.score
}
}
\section{Side Effects}{

}
\details{
Using posterior probabilities of pairs of haplotypes,  the
"design" matrix for the haplotype effects, and the GLM
residuals, compute the score vector and its variance
matrix, adjusted for the non-genetic covariates.
}
\section{References}{
Schaid DJ, Rowland CM, Tines DE, Jacobson RM,  Poland  GA.
Score tests for association of traits with haplotypes when
linkage phase is ambiguous. Submitted to Amer J Hum Genet.
}
\seealso{
haplo.score
}
\examples{

}
\keyword{}
% docclass is functionhaplo
% Converted by Sd2Rd version 1.21.
\eof
% 
% Copyright 2001 Mayo Foundation for Medical Education and Research. 
% 
% This program is free software; you can redistribute it and/or
% modify it under the terms of the GNU General Public License
% as published by the Free Software Foundation; either version 2
% of the License, or (at your option) any later version.
% 
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
% 
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
% 02111-1307, USA.
% 
% 
\name{haplo.score.podds}
\alias{haplo.score.podds}
\title{
  Compute Haplotype Score Statistics for Ordinal Traits with
Proportional Odds Model
}
\description{
This function is used by haplo.score when analyzing ordinal traits
by a proportional odds model score statistic.
}
\usage{
haplo.score.podds(y, alpha, beta=NA, x.adj=NA, nreps, x.post, post, x)
}
\arguments{


\item{y}{
Vector of ordinal trait values.
}
\item{alpha}{
Intercept parameters for ordinal logistic regression model.
}
\item{beta}{
Regression parameters for adjusted covariates (x.adj).
}
\item{x.adj }{
Matrix of non-genetic covariates used  to  adjust  the
score  statistics. Note that intercept should NOT  be included
in this matrix.
}
\item{nreps}{
Vector for the count of haplotype  pairs  that  map  to
each subject's marker genotypes (see haplo.em).
}
\item{x.post }{
Matrix for posterior mean of x per subject.
}
\item{post}{
Vector of posterior probabilities of pairs of
haplotypes for a person, given thier marker phenotypes
(see haplo.em).
}
\item{x}{
Matrix  of  scores  for  enumerated  haplotypes  for  each
subject,  with  elements  0,  1,  2  (counts  of  specific
haplotypes).
}
None.
}
\value{
List with components:

\item{u.score}{
Vector of scores for the chosen haplotypes
}
\item{v.score}{
Covariance matrix for u.score
}
}
\section{Side Effects}{

}
\details{
Using posterior probabilities of pairs of haplotypes,  the
"design" matrix for the haplotype effects, and the proportional odds model, compute the score vector and its variance
matrix, adjusted for the non-genetic covariates.
}
\section{Warning}{
To analyze an  ordinal trait with adjustment for x.adj
covariates, the user will need to have Frank Harrell's librarys
(Design and Hmisc). However, the unadjusted ordinal trait  works fine
without these libraries.
}
\section{References}{
Schaid DJ, Rowland CM, Tines DE, Jacobson RM,  Poland  GA.
Score tests for association of traits with haplotypes when
linkage phase is ambiguous. Submitted to Amer J Hum Genet.
}
\seealso{
haplo.score
}
\examples{

}
\keyword{}
% docclass is function
% Converted by Sd2Rd version 1.21.
\eof
\name{hla.demo}
\alias{hla.demo}
\title{HLA Gene Variantion and Serologic Response to Measles Vaccination}
\description{This data set gives markers of HLA gene variantion and
  antibody levels in response to measles vaccination for 220 unrelated
  subjects, from a study by the Mayo Clinic.
}
\usage{data(hla.demo)}
\format{A data frame containing 220 rows and 10 columns:
  \describe{
    \item{resp}{quantitative antibody response to measles vaccination}
    \item{resp.cat}{a factor with levels "low", "normal", "high", for
      categorical antibody response}
    \item{male}{sex code with 1="male" ,  0="female"}
    \item{age}{age (months) at immunization}
  }
  
  The remaining variables are genotypes for 3 HLA loci, with a prefix
  name (e.g., "DQB") and a suffix for each of two alleles (".a1" and
  ".a2").
}
\source{
  Poland G, Ovsyannikova I, Jacobson R, Vierkant R, Jacobsen S,
  Pankratz V, Schaid D (2002) Identification of an association between
  HLA class II alleles and low antibody levels after measles
  immunization. Vaccine 20:430?438
}
\keyword{datasets}
\eof
% 
% Copyright 2001 Mayo Foundation for Medical Education and Research. 
% 
% This program is free software; you can redistribute it and/or
% modify it under the terms of the GNU General Public License
% as published by the Free Software Foundation; either version 2
% of the License, or (at your option) any later version.
% 
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
% 
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
% 02111-1307, USA.
% 
% 
\name{locator.haplo}
\alias{locator.haplo}
\title{
  Find Location from Mouse Clicks and Print Haplotypes on Plot
}
\description{
Much like the Splus locator() is used to find x-y coordinates on a plot,
locator.haplo() finds all x-y coordinates that are clicked on by a
user, and then prints haplotypes at the chosen positions.
}
\usage{
locator.haplo(obj)
}
\arguments{
\item{obj}{
An object (of class haplo.score) which contains the analysis results
that are returned from the function haplo.score.
}
}
\value{
List with the following components:

\item{x.coord}{
Vector of x-coordinates.
}
\item{y.coord}{
Vector of y-coordinates.
}
\item{hap.txt}{
Vector of character strings for haplotypes.
}
}
\details{
After plotting the results in obj, as from plot(obj), the function
locator.haplo is used to place on the plot the text strings for
haplotypes of interest. After the function call (e.g.,
locator.haplo(obj)), the user can click, with the left mouse button,
on as many points in the plot as desired. Then, clicking with the
middle mouse button will cause the haplotypes to be printed on the
plot. The format of a haplotype is "a:b:c", where a, b, and c are
alleles, and the separator ":" is used to separate alleles on a
haplotype. The algorithm chooses the closest point that the user
clicks on, and prints the haplotype either above the point (for points
on the lower-half of the plot) or below the point (for points in the
upper-half of the plot).
}
\seealso{
haplo.score
}
\examples{
\dontrun{
save <-  haplo.score(y, geno, trait.type = "binomial")

plot(save)

locator.haplo(save)
}
}
\keyword{}
% docclass is function
% Converted by Sd2Rd version 1.21.
\eof
% 
% Copyright 2001 Mayo Foundation for Medical Education and Research. 
% 
% This program is free software; you can redistribute it and/or
% modify it under the terms of the GNU General Public License
% as published by the Free Software Foundation; either version 2
% of the License, or (at your option) any later version.
% 
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
% 
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
% 02111-1307, USA.
% 
% 
\name{plot.haplo.score}
\alias{plot.haplo.score}
\title{
  Plot Haplotype Frequencies versus Haplotype Score Statistics
}
\description{
Method function to plot a class of type haplo.score
}
\usage{
plot.haplo.score(x, ...)
}
\arguments{
\item{x}{The object returned from haplo.score (which has class haplo.score).}
\item{...}{Optional arguments}
}
\value{
Nothing is returned.
}
\section{Side Effects}{

}
\details{
This is a plot method function used to plot haplotype frequencies on
the x-axis and haplotype-specific scores on the y-axis. Because
haplo.score is a class, the generic plot function 
can be used, which in turn calls this plot.haplo.score function.
}
\section{References}{
Schaid DJ, Rowland CM, Tines DE, Jacobson RM,  Poland  GA.
Score tests for association of traits with haplotypes when
linkage phase is ambiguous. Submitted to Amer J Hum Genet.
}
\seealso{
haplo.score
}
\examples{
\dontrun{
save <- haplo.score(y, geno, trait.type = "gaussian")

# Example illustrating generic plot function:
plot(save)

# Example illustrating specific method plot function:
plot.haplo.score(save)
}
}
\keyword{}
% docclass is function
% Converted by Sd2Rd version 1.21.
\eof
% 
% Copyright 2001 Mayo Foundation for Medical Education and Research. 
% 
% This program is free software; you can redistribute it and/or
% modify it under the terms of the GNU General Public License
% as published by the Free Software Foundation; either version 2
% of the License, or (at your option) any later version.
% 
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
% 
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
% 02111-1307, USA.
% 
% 
\name{print.haplo.score}
\alias{print.haplo.score}
\title{
  Print a haplo.score object

}
\description{
Method function to print a class of type haplo.score
}
\usage{
print.haplo.score(x, ...)
}
\arguments{
\item{x}{ The object returned from haplo.score (which has class haplo.score).}
\item{...}{Optional argunents.}
}
\value{
Nothing is returned.
}
\section{Side Effects}{

}
\details{
This is a print method function used to print information from
haplo.score class, with haplotype-specific information given in a
table. Because haplo.score is a class, the generic print function 
can be used, which in turn calls this print.haplo.score function.
}
\section{References}{
Schaid DJ, Rowland CM, Tines DE, Jacobson RM, Poland  GA.
Score tests for association of traits with haplotypes when
linkage phase is ambiguous. Submitted to Amer J Hum Genet.
}
\seealso{
haplo.score
}
\examples{
\dontrun{
save <- haplo.score(y, geno, trait.type = "gaussian")

# Example illustrating generic print function:
print(save)

# Example illustrating specific method print function:
print.haplo.score(save)
}
}
\keyword{}
% docclass is function
% Converted by Sd2Rd version 1.21.
\eof
% 
% Copyright 2001 Mayo Foundation for Medical Education and Research. 
% 
% This program is free software; you can redistribute it and/or
% modify it under the terms of the GNU General Public License
% as published by the Free Software Foundation; either version 2
% of the License, or (at your option) any later version.
% 
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
% 
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
% 02111-1307, USA.
% 
% 
\name{ungcode}
\alias{ungcode}
\title{
  Uncode Numeric Genotype Codes to Alleles
}
\description{
Convert a vector with numeric codes that represents the
geneotypes to two vectors of alleles for genotypes
(alleles coded as rank order).
}
\usage{
ungcode(x)
}
\arguments{


\item{x}{
Vector of integer codes for genotypes.
}
None.
}
\value{
A matrix, with the first column for the "first" allele,
and the second column for the "second" allele.
}
\section{Side Effects}{

}
\details{
The input vector of genotypes must have been coded by  the
function gcode.
}
\section{References}{

Zykin D., Zhivotovsky L. and Weir B,  "Exact tests for
association  between alleles at arbitrary numbers of loci"
Human Identification: The Use of DNA Markers, 169-178, 1995.


The algorithm by Zykin  was  not  quite  correct,  and  we
needed  to  add  a  patch  in  the  code  (see comments in
ungcode).

}
\seealso{
gcode, allele.recode, geno.recode
}
\examples{
}
\keyword{}
% docclass is function
% Converted by Sd2Rd version 1.21.
\eof
