\name{dof.profile}
\alias{dof.profile}
\title{
Internal profile likelihood function 
}
\description{
Internal profile log-likelihood function for \code{tlm} function 
}
\usage{
dof.profile(dof, n, sqResid, orthoI, X, Z)
}
\arguments{
\item{dof}{
degrees freedom value 
}
\item{n}{
number of values in the response vector
}
\item{sqResid}{
squared residuals
}
\item{orthoI}{
orthogonalized scale parameters
}
\item{X}{
design matrix of explanatory variables for the location model  
}
\item{Z}{
design matrix of explanatory variables for the scale model 
}}
\value{
  a profile log-liklehood value
}
\details{
 This function is \emph{not} intended to be directly called by users. 
}
\keyword{internal}

\eof
\name{mm}
\alias{mm}
\docType{data}
\title{Excess returns for Martin Marietta company}
\description{
Data from the Martin Marietta company collected overa period of 5 years
on a monthly basis}
}
\usage{data(mm)}
\format{
  A data frame with 60 observations on the following 4 variables.
  \describe{
    \item{date}{the month the data was collected}
    \item{am.can}{a numeric vector}
    \item{m.marietta}{excess returns from the Martin Marietta company}
    \item{CRSP}{an index for the excess rate returns for the New York
      stock exchange}
  }
}
\source{
  Bulter et al (1990).
  Robust and partly adpative estimation of regression models.
  \emph{Review of Economic Statistics},
  \bold{72}, 321-327.  
}
\examples{

data(mm, package = "hett")
attach(mm)
plot(CRSP, m.marietta)
lines(CRSP, fitted(lm(m.marietta ~ CRSP)), lty = 2)

}
\keyword{datasets}

\eof
\name{rent}
\alias{rent}
\docType{data}
\title{Rent for Land PLanted to Alfalfa}
\description{
Dataset collected in 1977 from Minnesota to study the variation in land
rented for growing alfalfa
}
\usage{data(rent)}
\format{
  A data frame with 67 observations on the following 5 variables.
  \describe{
    \item{Rent}{a numeric vector average rent per acre.}
    \item{AllRent}{a numeric vector describing average rent paid for all tillable land.}
    \item{Cows}{a numeric vector describing the density of dairy cows (number per square mile).}
    \item{Pasture}{a numeric vector describing the proportion of farmland used as pasture.}
    \item{Liming}{a factor with levels \code{No} if no liming is
      required to grow alfalfa and \code{Yes} if it does.}
  }
}
\source{
  Weisberg, S (1985).
  \emph{Applied Linear Regression}
  Wiley: New York
}
\examples{

library(lattice)
data(rent, package = "hett")
attach(rent)
xyplot(log(Rent/AllRent) ~ sqrt(Cows), groups = Liming, panel = panel.superpose) 

}
\keyword{datasets}

\eof
\name{summary.tlm}
\alias{summary.tlm}
\alias{print.summary.tlm}
\title{
summary method for class "tlm"
}
\description{
Summarizes the heteroscedastic \emph{t} regression object
}
\usage{
\method{summary}{tlm}(object, correlation = FALSE, ...)
\method{print}{summary.tlm}(x, ...) 
}
\arguments{
\item{object}{
heteroscedastic t regression object called from \code{tlm()}
}
\item{x}{
an object of class "\code{summary.tlm}" containing the values below
}
\item{correlation}{
should the calaculation of the parameter correlation matrix be
supressed. If the fit includes a location and a scale formula then both
correlation matrices are printed. The default is \code{FALSE}.  
} 
\item{\dots}{
arguments passed to or from other methods
}
}
\value{
a list containing the following components:

\item{loc.summary}{
an object containing a list of objects that summarize the location model
}
\item{scale.summary}{
an object containing a list of objects that summarize the scale model
}
\item{iter}{
the number of iterations of the algorithm
}
\item{dof}{
value of the fixed or estimated degrees of freedom
}
\item{dofse}{
the standard error associated with the degrees of freedom if estimated
}
\item{logLik}{
the maximised log-likelihood   
}
\item{method}{
the method used to maximize the likelihood  
}
\item{endTime}{
the time taken for the algorithm to converge
}}
\details{  
The table summary produced by this function should be used with
caution. A more appropriate test between nested models is to use the
score statistic function \code{tscore}.   
}

\seealso{
\code{\link{tsum}}, \code{\link{tlm}}
}
\examples{

data(mm, package = "hett")
attach(mm)

## fit a model with heteroscedasticity and estimating the degrees of freedom

tfit2 <- tlm(m.marietta ~ CRSP, ~ CRSP, data = mm, start = list(dof =
3), estDof = TRUE)
summary(tfit2) 
}
\keyword{regression}
\keyword{distribution}

\eof
\name{tlm}
\alias{tlm}
\alias{print.tlm}
\title{
Maximum likelihood estimation for heteroscedastic t regression
}
\description{
Fits a heteroscedastic t regression to given data for known and unknown
degrees of freedom.
}
\usage{
tlm(lform, sform =  ~ 1, data = sys.parent(), subset = NULL, contrasts =
    NULL, na.action = na.fail, start = NULL, control = tlm.control(...),
    obs = FALSE, estDof = FALSE, ... )

\method{print}{tlm}(x, ...)
}
\arguments{
\item{x}{
an object of class "\code{tlm}"
}  
\item{lform}{
a formula of the type \code{response ~ terms}, where \code{terms} can
be of the form, for example, \code{first + second} or
\code{first*second}(see \code{lm} for details)   
}
\item{sform}{
a formula of the type \code{~ terms}, where \code{terms} can
be of the form, for example, \code{first + second} or
\code{first*second}(see \code{lm} for details).
}
\item{data}{
the data in the form of a \code{data.frame} where the column names can
be matched to the variable names supplied in \code{lform} and \code{sform} 
}
\item{subset}{
numerical vector to subset the \code{data} argument 
}
\item{contrasts}{
set of contrasts for the location model (see \code{contrasts.arg} for details)
}
\item{na.action}{
the action to proceed with in the event of \code{NA}'s in the
response. Currently \code{NA}'s are not allowed and therefore
\code{na.fail} is the sole argument.  
}
\item{start}{
is a list of possibly four named components, ("\code{beta}",
"\code{lambda}", "\code{dof}", "\code{omega}"), for the location, scale,
degrees of freedom parameters and random scale effects
respectively. Each component must be of the appropriate
length.
}
\item{control}{
is an argument to a function that maintains the control of the
algorithm. The \code{tlm.control()}function contains the arguments,
\code{epsilon} to determine how small the relative difference of
likelihoods should be for convergence (default is 1e-06), \code{maxit}
to determine the maximum iterations required (default = 50),
\code{trace} if the user requires printing of estimates etc. as
algorithm runs (default = \code{FALSE}), \code{verboseLev} to determine
the amount of verbose printing to the screen as the algorithm runs
(verboseLev = 1 displays location scale and dof estimates and the
likelihood, verboseLev = 2 displays all of 1 plus the random scale effects)
}
\item{obs}{
should the location parameters be calculated using the observed or
expected information(default = \code{FALSE}). (Note: using the observed
information does not calculate the appropriate standard errors, see DETAILS) 
}
\item{estDof}{
should the degrees of freedom parameter be estimated or not. If \code{FALSE}
then the value given for \code{dof} in the \code{start} argument
will be the fixed value used for the algorithm. If \code{TRUE} then the
value given for \code{dof} in the \code{start} argument supplies an
initial value only.
}
\item{\dots}{
arguments passed to \code{tlm.control() or to the \code{print} method}
}}
\value{
a list containing the following components:

\item{loc.fit}{
an object containing the estimated location parameters and other
elements associated with the location parameter model 
}
\item{scale.fit}{
an object containing the estimated scale parameters and other
elements associated with the scale parameter model 
}
\item{random}{
the random scale effects
}
\item{dof}{
fixed or estimated degrees of freedom
}
\item{dofse}{
the standard error associated with the degrees of freedom
}
\item{iter}{
the number of iterations of the algorithm
}
\item{logLik}{
the maximised log-likelihood   
}
\item{endTime}{
the time taken for the algorithm to converge
}}
\details{
When the degrees of freedom is unknown the code uses the non-linear optimiser
\code{nlm}. If the data is tending toward the Gaussian this optimisation
will still converge but with with very high degrees of freedom.

To obtain the appropriate standard errors from \code{summary} the user
must specify the argument \code{obs = F} to ensure that the location
parameter is calculated using the expected information component.
}
\section{Background}{
The theoretical background for this function can be found in Taylor and Verbyla (2004)
}
\references{
Taylor, J. D. & Verbyla, A. P (2004).
Joint modelling of the location and scale parameters of the \emph{t}-distribution.
\emph{Statistical Modelling}
\bold{4}, to appear.
}

\seealso{
\code{\link{summary.tlm}}
}
\examples{

data(mm, package = "hett")
attach(mm)

## fit a model with no heteroscedasticity and fixed degrees of freedom

tfit <- tlm(m.marietta ~ CRSP, data = mm, start = list(dof = 3))

## fit a model with heteroscedasticity and fixed degrees of freedom

tfit1 <- tlm(m.marietta ~ CRSP, ~ CRSP, data = mm, start = list(dof = 3))

## fit a model with heteroscedasticity and estimating the degrees of freedom

tfit2 <- tlm(m.marietta ~ CRSP, ~ CRSP, data = mm,
start = list(dof = 3), estDof = TRUE) 
}
\keyword{regression}
\keyword{distribution}

\eof
\name{tlm.control}
\alias{tlm.control}
\title{
Auxiliary for Controlling tlm Fitting
}
\description{
Auxiliary function for fitting \code{tlm} model. Generally only used
when calling \code{tlm}
}
\usage{
tlm.control(epsilon = 1e-07, maxit = 50, trace = FALSE, verboseLev = 1)
}
\arguments{
\item{epsilon}{
positive convergence tolerance value. The iterations converge when
[newlik - oldlik] < epsilon/2
}
\item{maxit}{
integer giving the maximum iterations allowable for the routine
}
\item{trace}{
logical. If \code{TRUE} output is printted to the screen during each iteration
}
\item{verboseLev}{
integer. If 1 then print accroding to \code{trace}. If 2 then print
random scale effects also.
}}
\value{
  A list with the argument as values
  }
\details{  
}
\seealso{
\code{\link{tlm}}
}
\examples{

data(mm, package = "hett")
attach(mm)

## change the maximum amount of iterations for the algorithm

fit1 <- tlm(m.marietta ~ CRSP, ~ 1, data = mm, start = list(dof = 3),
estDof = TRUE, control = tlm.control(maxit = 100))

}
\keyword{regression}
\keyword{distribution}

\eof
\name{tscore}
\alias{tscore}
\title{
Score test for heteroscedastic t models
}
\description{
Provides a score test for the location and scale parameters of the
heteroscedastic t regression model. 
}
\usage{
tscore(..., data = NULL, scale = FALSE)
}
\arguments{
\item{...}{
Any number of arguments containing nested model fits from \code{tlm()}
(see Details)
}
\item{data}{
the data used to fit the models involved
}
\item{scale}{
logical. If \code{TRUE} the scale model is tested}
}
\value{
Output containing the hypothesis, the score statistic, degrees of
freedom for the test and the p-value are printed to the screen.

....  
}}
\details{
The user must supply nested models that test, \emph{either}, the scale
or the location component of the model. The model objects \emph{must} be
nested from left to right. Currently there are no traps if the arguments
are not given in this order.

The models must also have either, all fixed degrees of freedom or
estimated degrees of freedom. 
}
\seealso{
\code{\link{tlm}}
}
\examples{

data(mm, package = "hett")
attach(mm)
tfit1 <- tlm(m.marietta ~ CRSP, ~ 1, data = mm, start = list(dof = 3),
estDof = TRUE)

tfit2 <- tlm(m.marietta ~ CRSP, ~ CRSP, data = mm, start = list(dof =
3), estDof = TRUE)

tscore(tfit1, tfit2, data = mm, scale = TRUE)
}
\keyword{regression}
\keyword{distribution}

\eof
\name{tsum}
\alias{tsum}
\alias{print.tsum}
\title{Summary function for the scale or location component of a
  heteroscedastic t model}
\description{
Summarizes the location \emph{or} scale components of a heteroscedastic \emph{t} model
}
\usage{

tsum(object, dispersion = NULL, correlation = FALSE,
             symbolic.cor = FALSE, ...)

\method{print}{tsum}(x, digits = max(3, getOption("digits") - 3), symbolic.cor =
      x$symbolic.cor, signif.stars = getOption("show.signif.stars"),
      scale = TRUE, ...)
}
\arguments{
  \item{object}{either the location \emph{or} scale object created by fitting
    a heteroscedastic t object with \code{tlm}}
  \item{x}{an object of class "\code{tsum}"}
  \item{dispersion}{1 if summarizing the location model; 2 if
    summarizing the scale model (see Details)} 
  \item{correlation}{logical; if \code{TRUE}, the correlation matrix of the
    estimated parameters is returned and printed.}
  \item{digits}{ the number of significant digits to be printed.}
  \item{symbolic.cor}{logical. If \code{TRUE}, print the correlations in
    a symbolic form (see `symnum') rather than as numbers.}
  \item{signif.stars}{logical. if \code{TRUE}, "significance stars" are
    printed for each coefficient.}
  \item{scale}{logical. If \code{TRUE} then the dispersion is known in
    advance (2), and is printed accordingly.}  
  \item{\dots}{further arguments passed to or from other methods.}
}
\details{The argument supplied to \code{dispersion} must be either 1
  (location model) or 2 (scale model). The reason for this is because
  the fitting of the model has already
  scaled the covariance matrix for the location coefficients. Hence the
  scaled and unscaled versions of covariance matrix for the location
  model are identical.     
  
  This function will not be generally called by the user as it
  will only summarize the location or scale model but not both. Instead
  the user should refer to \code{summary.tlm} to print a summary of both models.
}
\value{
  \code{tsum} returns an object of class "\code{tsum}", a list
     with components

\item{call}{the component from \code{object}}
\item{df.residual}{the component from \code{object}}
\item{coefficients}{the matrix of coefficients, standard errors, z-values and
  p-values}
\item{dispersion}{the supplied dispersion argument}
\item{df}{a 2-vector of the rank of the model and the number of
          residual degrees of freedom}
\item{cov.unscaled}{the unscaled (\code{dispersion = 1}) estimated covariance
	    matrix of the estimated coefficients}
\item{cov.scaled}{ditto, scaled by \code{dispersion}}
\item{correlation}{ (only if \code{correlation} is true.)  The estimated
          correlations of the estimated coefficients}
\item{symbolic.cor}{(only if \code{correlation} is true.)  The value of the
          argument \code{symbolic.cor}}
      }
\seealso{\code{\link{summary.tlm}}, \code{\link{tlm}}}
\examples{

data(mm, package = "hett")
attach(mm)
tfit <- tlm(m.marietta ~ CRSP, ~ CRSP, data = mm, start = list(dof = 3),
estDof = TRUE) 
tsum(tfit$loc.fit, dispersion = 1) 
}
\keyword{regression}
\keyword{distribution}

\eof
