\name{IndianIrish}
\alias{IndianIrish}
\non_function{}
\title{Observed genotype frequencies at MN and S loci, for 2 populations}
\usage{data(IndianIrish)}
\description{
The \code{IndianIrish} data frame has 18 rows and 4 columns.
The data are genotype frequencies for two locations, for
Xavante Indian and Irish populations respectively
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{Population}{Factor with levels:
    \code{Indian} and \code{Irish} }
    \item{locus1}{Factor with levels:
    \code{MM}, \code{MN} and \code{NN}}
    \item{locus2}{Factor with levels:
    \code{SS}, \code{Ss} and \code{ss}}
    \item{Observed}{a numeric vector giving the frequency for each
    category of the tale}
  }
}
\source{
  Mourant et al (1977) and Huttley and Wilson (2000).
}
\references{
  1. Huttley, G.A. and Wilson, S.R. 2000. Testing for concordant
  equilibria between population samples. \emph{Genetics} \bold{156}, 2127-2135. \cr
  2. Mourant, A.E., Kopec, A.C. and Domaniewska-Sobczak, K. 1976.
\em{The Distribution of the Human Blood Groups and Other Polymorphisms.}
Oxford University Press.\cr
  3. Weir, B.S. 1996.  \em{Genetic Data Analysis II.} Sinauer.
}
\seealso{\code{\link{hwde}}}

\examples{
data(IndianIrish)
hwde(data=IndianIrish)
}
\keyword{datasets}

\eof
\name{mendelABC}
\alias{mendelABC}
\non_function{}
\title{Mendel's F2 trifactorial data for seed shape (A), cotyledon color (B)
  and seed coat color (C)}
\usage{data(mendelABC)}
\description{
  The \code{mendel3} data frame has 27 rows and 4 columns. Data are
  from Mendel (1886), and are reproduced in Fisher (1936) and Weir (1996).
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{seedshape}{Factor with levels:
    \code{AA}, \code{Aa} and \code{aa}}
    \item{cotylcolor}{Factor with levels: 
    \code{BB}, \code{Bb} and \code{bb}}
    \item{coatcolor}{Factor with levels:
    \code{CC}, \code{Cc} and \code{cc}}
    \item{Observed}{a numeric vector that holds the frequencies.}
  }
}
\details{
    The data are reviewed in detail in Fisher (1936).  For a brief
  discussion, and references to work that revisits Fisher's
  conclusions, see Weir (1996).
}
\source{
Data are from Mendel (1886), and are reproduced in Fisher (1936) and
Weir (1996).
}
\references{
  1. Fisher, R.A. 1936. Has Mendel's work been rediscovered?
  \em{Annals of Science} \bold{1}:115-137.\cr
  2. Mendel, G. 1886. Versuche \"{u}ber Pflanzen-Hybriden.  Verhandlugen
  des Naturforschenden Vereines in Br\"{u}nn \bold{4}:3-47.
  (English translation by Royal Horticultural Society of London,
  reprinted in Peters, J.A. 1959. \em{Classic Papers in Genetics.}
  Prentice-Hall.\cr
3. Weir, B.S. 1996.  \em{Genetic Data Analysis II.} Sinauer.
}
\examples{
data(mendelABC)
hwde(mendelABC, loci=c("seedshape","cotylcolor","coatcolor"))
}
\keyword{datasets}

\eof
\name{decode.genotypes}
\alias{decode.genotypes}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Creates contrasts that relate to a single locus}
\description{
Vectors ma, maa and oset (offset) are returned.
}
\usage{
decode.genotypes(genotype)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{genotype}{The vector \code{genotype} holds two-letter codes
  for the three genotypes.  For example, the values may be AA, Aa and aa.}
}
\value{
  \item{oset}{The offset values that would be appropriate, in the
    multiplicative version of the model, if there was just this one
  locus.}
  \item{ma}{A contrast for the Hardy-Weinberg model, at this locus.}
  \item{maa}{A contrast that measures departure from the Hardy-Weinberg
    model, at this locus.}
  \item{types}{A vector of length three whose elements are the
    two-letter codes used for the three genotypes.}
}
\author{J.H. Maindonald}
\note{Called by \code{make.contrasts}}
\seealso{\code{hwde}}

\examples{
decode.genotypes(rep(c("AA","Aa","aa"),2))
}

\keyword{models}

\eof
\name{hwde}
\alias{hwde}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Fit relevant models, and test for various types of departure from
  Hardy-Weinberg equilibrium.  Allows only 2 alleles per locus.  The
  number of loci is arbitrary.
}
\description{
Fits models for genotypic disequilibria, as described in Huttley and
Wilson (2000), Weir (1996) and Weir and Wilson (1986).
}
\usage{
hwde(data = IndianIrish, gp = "Population", termlist = NULL, refmodel = NULL, loci = paste("locus", 1:(dim(data)[2] - 1), sep = ""), observed = "Observed", keep.models = FALSE, aovtable.print = TRUE, group.terms = TRUE, allele.chars = letters)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{data}{Must have a column of frequencies, by default called
    \code{Observed}, and one or more columns giving genotype
    information,
    in the form AA, Aa, aa. or e.g., MM, MN, NN.  (The choice of letters
    is arbitrary.)  Additionally, there may be a column that gives
    information on groupings, by default called \code{Population}.
  }
  \item{gp}{Gives the name of the column, if any, that has information
    on groups within the data.}
  \item{termlist}{Use to specify a user-defined sequence of models.
  See the vignette \bold{hwde.pdf} or \bold{hwde.html}}
  \item{refmodel}{For each model in \code{termlist}, specifies a
    reference model, which will be updated to include the additional terms.}
  \item{loci}{Gives name(s) of columns that hold information on
  genotypes. By default, these are taken to be \code{locus1},
  \code{locus2}, etc.}
  \item{observed}{Name (by default \code{Observed}) of the column that
holds the frequenceies.}
  \item{keep.models}{Should a list be returned that holds the full
    sequence of models that were fitted?}
  \item{aovtable.print}{Should the anova table be printed?}
  \item{group.terms}{Should model terms be grouped according to
    hierarchy,
  for the anova table?}
\item{allele.chars}{A sequence of letters used to code for the loci.
By default \em{a}, \em{b}, \em{c}, ... are used}
}
\details{
  See the document \bold{hwde.pdf} or \bold{hwde.html} for details.
  See the references (below) for information on the interpretation of
  model parameters.
}
\value{
  \item{anovatab}{anova (analysis of deviance) table}
  \item{data.df}{Data, and contrasts used in fitting the various
    models.}
  \item{aovtab.terms}{This string holds, for each model that is
    fitted. the terms that have appeared in the model formula.
    The text strings for the distinct models are concatenated.}
  \item{models}{Optionally, this holds the complete sequence of
    qmodel objects that were fitted}
}
\references{
  1. Huttley, G.A. and Wilson, S.R. 2000. Testing for concordant
  equilibria between population samples. \emph{Genetics} \bold{156}:2127-2135. \cr
  2. Weir, B.S. 1996.  \em{Genetic Data Analysis II.} Sinauer.\cr
  3. Weir, B.S. and Wilson, S.R. 1986.  Log-linear models for
linked loci. \em{Biometrics} \bold{42}:665-670.
}
\author{J.H. Maindonald}

\seealso{\code{\link{make.contrasts}}, \code{\link{decode.genotypes}} }

\examples{
data(IndianIrish)
hwde(data=IndianIrish)
data(mendelABC)
hwde(data=mendelABC, loci=c("seedshape", "cotylcolor", "coatcolor"))
}
\keyword{models}

\eof
\name{make.contrasts}
\alias{make.contrasts}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Calculate contrasts required by the function}
\description{
  Calculates the contrasts that \code{hwde} uses in fitting models
  for genotypic disequilibrium.  At present these are limited to
  first order interaction terms between the distinct loci,
  possibly with distinct values foe each different level of a
  grouping factor.
}
\usage{
make.contrasts(data = data[, loci], allele.chars = letters)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{data}{Data frame, with one column per locus, and as
    many rows as there are observations. Genotypes are represented
    using a two-letter code, e.g., AA, Aa, aa}
  \item{allele.chars}{By default the letters "a", "b", ...,
    one for each locus, are used.}
}
\details{
  Any pair of letters can be used for the two alleles.  The setting
  of \code{allele.chars} determines the coding used in the model
  formulae.  This function is called by \code{hwde}}
}
\value{
  \item{contrasts.df}{Data frame whose columns hold the contrasts that
  will be explanatory variables for the Poisson regression model.}
\item{list.columns}{List in which each element is a text string
that holds the codes for a sequence of model terms.}
}
\author{J.H. Maindonald}

\seealso{\code{identify.genotypes}, called by \code{make.contrasts}}

\examples{
make.contrasts(data=c("AA","Aa","aa"))
}

\keyword{models}

\eof
