% file ifs/man/ifs.FT.Rd
% copyright (C) 2001-2 S.M. Iacus    
%
\name{ifs.FT}
\alias{ifs.FT}
\alias{ifs.setup.FT}
\alias{ifs.pf.FT}
\alias{ifs.df.FT}
\alias{IFS.pf.FT}
\alias{IFS.df.FT}
\title{
IFS estimator
}
\description{
  Distribution function estimator based on inverse Fourier transform of ans IFSs.  
}
\usage{
ifs.FT(x, p, s, a, k = 2)
ifs.setup.FT(m, p, s, a, k = 2, cutoff)
ifs.pf.FT(x,b,nterms)
ifs.df.FT(x,b,nterms)
IFS.pf.FT(y, k = 2, n = 512, maps=c("quantile","wl1","wl2")) 
IFS.df.FT(y, k = 2, n = 512, maps=c("quantile","wl1","wl2")) 
}
\arguments{
  \item{x}{where to estimate the function}
  \item{p}{the vector of coefficients \eqn{p_i}}
  \item{s}{the vector of coefficients \eqn{s_i} in: \eqn{w_i = s_i *x + a_i}}
  \item{a}{the vector of coefficients \eqn{a_i} in: \eqn{w_i = s_i *x + a_i}}
  \item{m}{the vector of sample moments}
  \item{k}{number of iterations, default = 2}
  \item{y}{a vector of sample observations}
  \item{n}{the number of points in which to calculate the estimator}
  \item{maps}{type of affine maps}
  \item{b}{the Fourier coefficients}
  \item{nterms}{the number of significant Fourier coefficients after the cutoff}
  \item{cutoff}{cutoff used to determine how many Fourier coefficients are needed}
}
\value{
  The estimated value of the Fourier transform  for \code{ifs.FT}, the estimated value
  of the distribution function for \code{ifs.pf.FT} and the estimated value
  of the density function for \code{ifs.df.FT}. 
  A list of `x' and `y' coordinates plus the Fourier coefficients and the number of
  significant coefficients of the distribution function estimator for \code{IFS.pf.FT} 
  and the density function for \code{IFS.df.FT}.
  The function \code{ifs.setup.FT} return a list of Fourier coefficients and the number
  of significant coefficients.
}
\details{
  This estimator is intended to estimate the continuous distribution
  function, the charateristic function (Fourier transform) and the density function
  of a random variable on [0,1]. 
 }
\note{
 Details of this tecnique can be found in Iacus and La Torre, 2002.
 }
\author{S. M. Iacus}
\references{
  S. M. Iacus and D. La Torre (2002)
  \emph{Approximating distribution functions by iterated function systems}, JAM\&DS,
  to appear.
}
\seealso{
\code{\link{ecdf}}
}
\examples{
library(ifs)
library(stepfun)

nobs <- 100
y<-rbeta(nobs,2,4)

# uncomment if you want to test the normal distribution
# y<-sort(rnorm(nobs,3,1))/6


IFS.est <- IFS(y)
xx <- IFS.est$x
tt <- IFS.est$y

ss <- pbeta(xx,2,4)

# uncomment if you want to test the normal distribution   
# ss <- pnorm(6*xx-3)
     
par(mfrow=c(3,1))   
  
plot(ecdf(y),xlim=c(0,1),main="IFS estimator versus EDF")
lines(xx,ss,col="blue")
lines(IFS.est,col="red")
IFS.FT.est <- IFS.pf.FT(y)
xxx <- IFS.FT.est$x
uuu <- IFS.FT.est$y
sss <- pbeta(xxx,2,4)
# uncomment if you want to test the normal distribution   
# sss <- pnorm(6*xxx-3)

lines(IFS.FT.est,col="green")


# calculates MSE


ww <- ecdf(y)(xx)
mean((ww-ss)^2)
mean((tt-ss)^2)
mean((uuu-sss)^2)

plot(xx,(ww-ss)^2,main="MSE",type="l",xlab="x",ylab="MSE(x)")
lines(xx,(tt-ss)^2,col="red")
lines(xxx,(uuu-sss)^2,col="green")

plot(IFS.df.FT(y),type="l",col="green",ylim=c(0,3),main="IFS vs Kernel")
lines(density(y),col="blue")
curve(dbeta(x,2,4),0,1,add=TRUE)
# uncomment if you want to test the normal distribution   
# curve(6*dnorm(x*6-3,0,1),0,1,add=TRUE)
}
\keyword{distribution}


\eof
% file ifs/man/ifs.Rd
% copyright (C) 2001-2 S.M. Iacus    
%
\name{ifs}
\alias{ifs}
\alias{ifs.flex}
\alias{IFS}
\title{
IFS estimator
}
\description{
  Distribution function estimator based on sample quantiles.  
}
\usage{
ifs(x, p, s, a, k = 5)
ifs.flex(x, p, s, a, k = 5, f = NULL)
IFS(y, k = 5, q = 0.5, f = NULL, n = 512, maps = c("quantile", 
    "wl1", "wl2"))
}
\arguments{
  \item{x}{where to estimate the distribution function}
  \item{p}{the vector of coefficients \eqn{p_i}}
  \item{s}{the vector of coefficients \eqn{s_i} in: \eqn{w_i = s_i *x + a_i}}
  \item{a}{the vector of coefficients \eqn{a_i} in: \eqn{w_i = s_i *x + a_i}}
  \item{k}{number of iterations, default = 5}
  \item{y}{a vector of sample observations}
  \item{q}{the proportion of quantiles to use in the construction of the 
  estimator, default = 0.5. The number of quantiles is the 
  \code{q * length(y)}.} 
  \item{f}{the starting point in the space of distribution functions}
  \item{n}{the number of points in which to calculate the IFS}
  \item{maps}{type of affine maps}
}
\value{
  The estimated value of the distribution function for \code{ifs} and \code{ifs.flex} or
  a list of `x' and `y' coordinates of the IFS(x) graph for \code{IFS}.
}
\details{
  This estimator is intended to estimate the continuous distribution
  function of a random variable on [0,1]. The estimator is a continuous
  function not everywhere differentiable.
 }
\note{
 It is asymptotically as good as the empirical distribution function
  (see Iacus and La Torre, 2001).  
 This function is called by \link{IFS}. If you need to call the function
 several times, you should better use \code{ifs} providing the
 points and coefficients once instead of \code{IFS}.
 Empirical evidence shows that the IFS-estimator is better than the edf (even 
 for very small samples) in the sup-norm metric. It is also better in the MSE
 sense outside of the distribution's tails if the sample quantiles are used
 as points.
}
\author{S. M. Iacus}
\references{
  S. M. Iacus and D. La Torre (2002)
  \emph{Approximating distribution functions by iterated function systems}, JAM\&DS,
  to appear.
}
\seealso{
\code{\link{ecdf}}
}
\examples{
library(ifs)
library(stepfun)

y<-rbeta(50,.5,.1)

# uncomment if you want to test the normal distribution
# y<-sort(rnorm(50,3,1))/6


IFS.est <- IFS(y)
xx <- IFS.est$x
tt <- IFS.est$y

ss <- pbeta(xx,.5,.1)

# uncomment if you want to test the normal distribution   
# ss <- pnorm(6*xx-3)
     
par(mfrow=c(2,1))   
  
plot(ecdf(y),xlim=c(0,1),main="IFS estimator versus EDF")
lines(xx,ss,col="blue")
lines(xx,tt,col="red")


# calculates MSE


ww <- ecdf(y)(xx)
mean((ww-ss)^2)
mean((tt-ss)^2)

plot(xx,(ww-ss)^2,main="MSE",type="l",xlab="x",ylab="MSE(x)")
lines(xx,(tt-ss)^2,col="red")
}
\keyword{nonparametric}


\eof
% file ifs/man/ifs.cf.Rd
% copyright (C) 2001-2 S.M. Iacus    
%
\name{ifs.cf}
\alias{ifs.cf}
\title{Calculates the main parameters of the IFS estimators}
\description{
  Tool function to construct and find the solution of the minimization
  problem involving the quadratic form \eqn{x'Qx + b'x}. Not an optimal one.
  You can provide one better then this.
}
\usage{
ifs.cf(Q,b)
}
\arguments{
  \item{Q}{the matrix \eqn{Q} of \eqn{x'Qx + b'x}}
  \item{b}{the vector \eqn{b} of \eqn{x'Qx + b'x}}
}
\value{
	\item{p}{the vector of the coefficients to be plugged into the IFS}
}
\seealso{
\code{\link{ifs}}
}
\keyword{misc}



\eof
% file ifs/man/ifs.setup.Rd
% copyright (C) 2001-2 S.M. Iacus    
%
\name{ifs.setup}
\alias{ifs.setup}
\title{Set up the parameters for the maps of the IFS estimator}
\description{
 This is called before calling \code{setQF} to prepear the
 parameters to be passed in \code{setQF}.
}
\usage{
ifs.setup(y, maps = c("quantile","wl1","wl2"), qtl)
}
\arguments{
  \item{y}{the vector of the sample observations}
  \item{maps}{type of maps: quantile, wl1 or wl2}
  \item{qtl}{instead of passing the data y you can pass a vector
   of quantiles}
}
\value{
	\item{m}{the vector of the empirical moments}
	\item{a}{the vector of the coefficents `a' in the maps}	
	\item{s}{the vector of the coefficents `s' in the maps}	
	\item{n}{the number of maps}	
}
\author{S. M. Iacus}
\seealso{
\code{\link{ifs}}
}
\keyword{misc}



\eof
% file ifs/man/setQF.Rd
% copyright (C) 2001-2 S.M. Iacus    
%
\name{setQF}
\alias{setQF}
\title{Set up the Quadratic Form}
\description{
  Tool function to construct the quadratic form \eqn{x'Qx + b'x} to be minimized
  to construct the IFS estimator.
}
\usage{
setQF(m, s, a, n = 10)
}
\arguments{
  \item{m}{the vector of the sample or true moments}
  \item{s}{the vector of coefficients \eqn{s_i} in: \eqn{w_i = s_i *x + a_i}}
  \item{a}{the vector of coefficients \eqn{a_i} in: \eqn{w_i = s_i *x + a_i}}
  \item{n}{number of parameter to use in the IFS estimator, default = 10}
}
\value{
	\item{Q}{the matrix of the quadratic form}
	\item{b}{the matrix of the quadratic form}	
}
\details{
  This estimator is intended to estimate the continuous distribution
  function of a random variable on [0,1]. The estimator is a continuous
  function not everywhere differentiable.
 }
\author{S. M. Iacus}
\references{
  S. M. Iacus and D. La Torre (2002)
  \emph{Approximating distribution functions by iterated function systems}, JAM\&DS,
  to appear.
}
\seealso{
\code{\link{ifs}}
}
\keyword{nonparametric}


\eof
