\name{dowjones}
\alias{dowjones}
\title{Daily Closing Prices of The Dow Jones Index}
\usage{data(dowjones)}
\description{
  The \code{dowjones} data frame has 1304 rows and 2 columns.
  The second column contains daily closing prices of the Dow
  Jones Index over the period 1996 to 2000. The first column
  contains a \code{\link{POSIXct}} object giving the dates of
  each observation.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{Date}{A \code{\link{POSIXct}} object containing dates.}
    \item{Index}{A numeric vector containing daily closing
      prices of the Dow Jones Index.}
  }
}
\source{
  Coles, S. G. (2001)
  \emph{An Introduction to Statistical Modelling of
    Extreme Values.} London: Springer.
}
\keyword{datasets}

\eof
\name{engine}
\alias{engine}
\title{Engine Failure Time Data}
\usage{data(engine)}
\description{
  The \code{engine} data frame has 32 rows and 2 columns.
  The first column contains the corrosion level, the second
  column gives the engine failure time.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{Time}{A numeric vector of corrosion levels.}
    \item{Corrosion}{A numeric vector of failure times.}
  }
}
\source{
  Unknown.
}
\keyword{datasets}

\eof
\name{euroex}
\alias{euroex}
\title{UK/Euro Exchange Rates}
\usage{data(euroex)}
\description{
  A numeric vector of daily exchange rates between
  the Euro and UK sterling.
}
\format{A vector containing 975 observations.}
\source{
  Unknown.
}  
\keyword{datasets}

\eof
\name{exchange}
\alias{exchange}
\title{UK/US and UK/Canada Exchange Rates}
\usage{data(exchange)}
\description{
  The \code{exchange} data frame has 975 rows and 2 columns.
  The columns contain daily exchange rates; UK sterling
  against the US dollar (first column) and UK sterling
  against the Canadian dollar (second column).
  The rownames contain the corresponding dates in a character
  string with the format \code{"2000/05/26"}. This can be
  converted into a \code{POSIXct} or \code{POSIXlt} object
  using \code{\link{as.POSIXct}} or \code{\link{as.POSIXlt}}.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{USD.GBP}{US against UK exchange rate.}
    \item{CAD.GBP}{Canada against UK exchange rate.}
  }
}
\source{
  Coles, S. G. (2001)
  \emph{An Introduction to Statistical Modelling of
    Extreme Values.} London: Springer.
}

\keyword{datasets}

\eof
\name{fremantle}
\alias{fremantle}
\title{Annual Maximum Sea Levels at Fremantle, Western Australia}
\usage{data(fremantle)}
\description{
  The \code{fremantle} data frame has 86 rows and 3 columns.
  The second column gives 86 annual maximimum sea levels
  recorded at Fremantle, Western Australia, within the period
  1897 to 1989.
  The first column gives the corresponding years.
  The third column gives annual mean values of the Southern
  Oscillation Index (SOI), which is a proxy for meteorological
  volitility.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{Year}{A numeric vector of years.}
    \item{Sea Level}{A numeric vector of annual sea level
      maxima.}
    \item{SOI}{A numeric vector of annual mean values of
      the Southern Oscillation Index.}
  }
}
\source{
  Coles, S. G. (2001)
  \emph{An Introduction to Statistical Modelling of
    Extreme Values.} London: Springer.
}

\keyword{datasets}

\eof
\name{gev.diag}
\alias{gev.diag}

\title{Diagnostic Plots for GEV Models}
\description{
  Produces diagnostic plots for GEV models using the output
  of the function \code{gev.fit}.
}
\usage{
gev.diag(z)
}
\arguments{
  \item{z}{An object returned by \code{gev.fit}.} 
}
\value{
  For stationary models four plots are produced; a probability
  plot, a quantile plot, a return level plot and a histogram
  of data with fitted density.

  For non-stationary models two plots are produced; a residual
  probability plot and a residual quantile plot.
}

\seealso{\code{\link{gev.fit}}, \code{\link{gev.prof}}}

\examples{
data(portpirie)
ppfit <- gev.fit(portpirie[,2])
gev.diag(ppfit)
}
\keyword{hplot}

\eof
\name{gev.fit}
\alias{gev.fit}

\title{Maximum-likelihood Fitting of the GEV Distribution}
\description{
  Maximum-likelihood fitting for the generalized extreme value distribution,
  including generalized linear modelling of each parameter.
}
\usage{
gev.fit(xdat, ydat = NULL, mul = NULL, sigl = NULL, shl = NULL, 
    mulink = identity, siglink = identity, shlink = identity, 
    show = TRUE, method = "Nelder-Mead", maxit = 10000, \dots)
}
\arguments{
  \item{xdat}{A numeric vector of data to be fitted.}
  \item{ydat}{A matrix of covariates for generalized linear modelling
    of the parameters (or \code{NULL} (the default) for stationary
    fitting). The number of rows should be the same as the length
    of \code{xdat}.}
  \item{mul, sigl, shl}{Numeric vectors of integers, giving the columns
    of \code{ydat} that contain covariates for generalized linear
    modelling of the location, scale and shape parameters repectively
    (or \code{NULL} (the default) if the corresponding parameter is
    stationary).}
  \item{mulink, siglink, shlink}{Inverse link functions for generalized
    linear modelling of the location, scale and shape parameters
    repectively.}
  \item{show}{Logical; if \code{TRUE} (the default), print details of
    the fit.}
  \item{method}{The optimization method (see \code{\link{optim}} for
    details).}
  \item{maxit}{The maximum number of iterations.}
  \item{\dots}{Other control parameters for the optimization. These
    are passed to components of the \code{control} argument of
    \code{optim}.}
}
\details{
  For non-stationary fitting it is recommended that the covariates
  within the generalized linear models are (at least approximately)
  centered and scaled (i.e.\ the columns of \code{ydat} should be
  approximately centered and scaled).
}
\value{
  A list containing the following components. A subset of these
  components are printed after the fit. If \code{show} is
  \code{TRUE}, then assuming that successful convergence is
  indicated, the components \code{nllh}, \code{mle} and \code{se}
  are always printed.
  
  \item{trans}{An logical indicator for a non-stationary fit.}
  \item{model}{A list with components \code{mul}, \code{sigl}
    and \code{shl}.}
  \item{link}{A character vector giving inverse link functions.}
  \item{conv}{The convergence code, taken from the list returned by
    \code{\link{optim}}. A zero indicates successful convergence.}
  \item{nllh}{The negative logarithm of the likelihood evaluated at
    the maximum likelihood estimates.}
  \item{data}{The data that has been fitted. For non-stationary
    models, the data is standardized.}
  \item{mle}{A vector containing the maximum likelihood estimates.}
  \item{cov}{The covariance matrix.}
  \item{se}{A vector containing the standard errors.}
  \item{vals}{A matrix with three columns containing the maximum
    likelihood estimates of the location, scale and shape parameters
    at each data point.}  
}

\seealso{\code{\link{gev.diag}}, \code{\link{optim}},
  \code{\link{gev.prof}}}

\examples{
data(portpirie)
gev.fit(portpirie[,2])
}
\keyword{models}

\eof
\name{gev.prof}
\alias{gev.prof}
\alias{gev.profxi}

\title{Profile Log-likelihoods for Stationary GEV Models}
\description{
  Produce profile log-likelihoods for shape parameters and
  m year/block return levels for stationary GEV models using
  the output of the function \code{gev.fit}.
}
\usage{
gev.prof(z, m, xlow, xup, conf = 0.95, nint = 100)
gev.profxi(z, xlow, xup, conf = 0.95, nint = 100)
}
\arguments{
  \item{z}{An object returned by \code{gev.fit}. The object
    should represent a stationary model.}
  \item{m}{The return level (i.e.\ the profile likelihood is for
    the value that is exceeded with probability 1/\code{m}).}
  \item{xlow, xup}{The least and greatest value at which to
    evaluate the profile likelihood.}
  \item{conf}{The confidence coefficient of the plotted profile
    confidence interval.}
  \item{nint}{The number of points at which the profile
    likelihood is evaluated.}
}
\value{
  A plot of the profile likelihood is produced, with a horizontal
  line representing a profile confidence interval with confidence
  coefficient \code{conf}.
}

\seealso{\code{\link{gev.fit}}, \code{\link{gev.diag}}}

\examples{
data(portpirie)
ppfit <- gev.fit(portpirie[,2])
\dontrun{gev.prof(ppfit, m = 10, 4.1, 5)}
\dontrun{gev.profxi(ppfit, -0.3, 0.3)}
}
\keyword{hplot}

\eof
\name{glass}
\alias{glass}
\title{Breaking Strengths of Glass Fibres}
\usage{data(glass)}
\description{
  A numeric vector containing breaking strengths of 63 glass
  fibres of length 1.5 centimetres, recorded under experimental
  conditions.
}
\format{A vector containing 63 observations.}
\source{
  Smith, R. L. and Naylor, J. C. (1987)
  A comparison of maximum likelihood and Bayesian estimators
  for the three-parameter Weibull distribution.
  \emph{Applied Statistics} \bold{36}, 358--396.
}

\references{
  Coles, S. G. (2001)
  \emph{An Introduction to Statistical Modelling of
    Extreme Values.} London: Springer.
}

\keyword{datasets}

\eof
\name{gpd.diag}
\alias{gpd.diag}

\title{Diagnostic Plots for GPD Models}
\description{
  Produces diagnostic plots for GPD models using the output
  of the function \code{gpd.fit}.
}
\usage{
gpd.diag(z)
}
\arguments{
  \item{z}{An object returned by \code{gpd.fit}.} 
}
\value{
  For stationary models four plots are produced; a probability
  plot, a quantile plot, a return level plot and a histogram
  of data with fitted density.

  For non-stationary models two plots are produced; a residual
  probability plot and a residual quantile plot.
}

\seealso{\code{\link{gpd.fit}}, \code{\link{gpd.prof}},
  \code{\link{pp.fit}}}

\examples{
data(rain)
rnfit <- gpd.fit(rain, 10)
gpd.diag(rnfit)
}
\keyword{hplot}

\eof
\name{gpd.fit}
\alias{gpd.fit}

\title{Maximum-likelihood Fitting for the GPD Model}
\description{
  Maximum-likelihood fitting for the GPD model,
  including generalized linear modelling of each parameter.
}
\usage{
gpd.fit(xdat, threshold, npy = 365, ydat = NULL, sigl = NULL,
    shl = NULL, siglink = identity, shlink = identity, show = TRUE,
    method = "Nelder-Mead", maxit = 10000, \dots)
}
\arguments{
  \item{xdat}{A numeric vector of data to be fitted.}
  \item{threshold}{The threshold; a single number or a numeric
    vector of the same length as \code{xdat}.}
  \item{npy}{The number of observations per year/block.}
  \item{ydat}{A matrix of covariates for generalized linear modelling
    of the parameters (or \code{NULL} (the default) for stationary
    fitting). The number of rows should be the same as the length
    of \code{xdat}.}
  \item{sigl, shl}{Numeric vectors of integers, giving the columns
    of \code{ydat} that contain covariates for generalized linear
    modelling of the scale and shape parameters repectively
    (or \code{NULL} (the default) if the corresponding parameter is
    stationary).}
  \item{siglink, shlink}{Inverse link functions for generalized
    linear modelling of the scale and shape parameters repectively.}
  \item{show}{Logical; if \code{TRUE} (the default), print details of
    the fit.}
  \item{method}{The optimization method (see \code{\link{optim}} for
    details).}
  \item{maxit}{The maximum number of iterations.}
  \item{\dots}{Other control parameters for the optimization. These
    are passed to components of the \code{control} argument of
    \code{optim}.}
}
\details{
  For non-stationary fitting it is recommended that the covariates
  within the generalized linear models are (at least approximately)
  centered and scaled (i.e.\ the columns of \code{ydat} should be
  approximately centered and scaled).
}
\value{
  A list containing the following components. A subset of these
  components are printed after the fit. If \code{show} is
  \code{TRUE}, then assuming that successful convergence is
  indicated, the components \code{nexc}, \code{nllh},
  \code{mle}, \code{rate} and \code{se} are always printed.
  
  \item{trans}{An logical indicator for a non-stationary fit.}
  \item{model}{A list with components \code{sigl} and \code{shl}.}
  \item{link}{A character vector giving inverse link functions.}
  \item{threshold}{The threshold, or vector of thresholds.}
  \item{nexc}{The number of data points above the threshold.}
  \item{data}{The data that lie above the threshold. For
    non-stationary models, the data is standardized.}
  \item{conv}{The convergence code, taken from the list returned by
    \code{\link{optim}}. A zero indicates successful convergence.}
  \item{nllh}{The negative logarithm of the likelihood evaluated at
    the maximum likelihood estimates.}
  \item{vals}{A matrix with three columns containing the maximum
    likelihood estimates of the scale and shape parameters, and
    the threshold, at each data point.} 
  \item{mle}{A vector containing the maximum likelihood estimates.}
  \item{rate}{The proportion of data points that lie above the
    threshold.}
  \item{cov}{The covariance matrix.}
  \item{se}{A vector containing the standard errors.}
  \item{n}{The number of data points (i.e.\ the length of
    \code{xdat}).}
  \item{npy}{The number of observations per year/block.}
  \item{xdata}{The data that has been fitted.} 
}

\seealso{\code{\link{gpd.diag}}, \code{\link{optim}},
  \code{\link{gpd.prof}}, \code{\link{gpd.fitrange}},
  \code{\link{mrl.plot}}, \code{\link{pp.fit}}}

\examples{
data(rain)
gpd.fit(rain, 10)
}
\keyword{models}

\eof
\name{gpd.fitrange}
\alias{gpd.fitrange}

\title{Fitting the GPD Model Over a Range of Thresholds}
\description{
  Maximum-likelihood fitting for a stationary GPD model,
  over a range of thresholds. Graphs of parameter estimates
  which aid the selection of a threshold are produced.
}
\usage{
gpd.fitrange(data, umin, umax, nint = 10, show = FALSE)
}
\arguments{
  \item{data}{A numeric vector of data to be fitted.}
  \item{umin, umax}{The minimum and maximum thresholds at which
    the model is fitted.}
  \item{nint}{The number of fitted models.}
  \item{show}{Logical; if \code{TRUE}, print details of each
    fit.}
}
\value{
  Two graphs showing maximum likelihood estimates and confidence
  intervals of the shape and modified scale parameters over a
  range of thresholds are produced.
}

\seealso{\code{\link{gpd.fit}}, \code{\link{mrl.plot}},
  \code{\link{pp.fit}}, \code{\link{pp.fitrange}}}

\examples{
\dontrun{data(rain)}
\dontrun{gpd.fitrange(rain, 10, 40)}
}
\keyword{hplot}

\eof
\name{gpd.prof}
\alias{gpd.prof}
\alias{gpd.profxi}

\title{Profile Log-likelihoods for Stationary GPD Models}
\description{
  Produce profile log-likelihoods for shape parameters and
  m year/block return levels for stationary GPD models using
  the output of the function \code{gpd.fit}.
}
\usage{
gpd.prof(z, m, xlow, xup, npy = 365, conf = 0.95, nint = 100)
gpd.profxi(z, xlow, xup, conf = 0.95, nint = 100)
}
\arguments{
  \item{z}{An object returned by \code{gpd.fit}. The object
    should represent a stationary model.}
  \item{m}{The return level (i.e.\ the profile likelihood is for
    the value that is exceeded with probability 1/\code{m}).}
  \item{xlow, xup}{The least and greatest value at which to
    evaluate the profile likelihood.}
  \item{npy}{The number of observations per year.}
  \item{conf}{The confidence coefficient of the plotted profile
    confidence interval.}
  \item{nint}{The number of points at which the profile
    likelihood is evaluated.}
}
\value{
  A plot of the profile likelihood is produced, with a horizontal
  line representing a profile confidence interval with confidence
  coefficient \code{conf}.
}

\seealso{\code{\link{gpd.fit}}, \code{\link{gpd.diag}}}

\examples{
data(rain)
rnfit <- gpd.fit(rain, 10)
\dontrun{gpd.prof(rnfit, m = 10, 55, 75)}
\dontrun{gpd.profxi(rnfit, -0.02, 0.15)}
}
\keyword{hplot}

\eof
\name{gum.diag}
\alias{gum.diag}

\title{Diagnostic Plots for Gumbel Models}
\description{
  Produces diagnostic plots for Gumbel models using the output
  of the function \code{gum.fit}.
}
\usage{
gum.diag(z)
}
\arguments{
  \item{z}{An object returned by \code{gum.fit}.} 
}
\value{
  For stationary models four plots are produced; a probability
  plot, a quantile plot, a return level plot and a histogram
  of data with fitted density.

  For non-stationary models two plots are produced; a residual
  probability plot and a residual quantile plot.
}

\seealso{\code{\link{gev.fit}}, \code{\link{gum.fit}}}

\examples{
data(portpirie)
ppfit <- gum.fit(portpirie[,2])
gum.diag(ppfit)
}
\keyword{hplot}

\eof
\name{gum.fit}
\alias{gum.fit}

\title{Maximum-likelihood Fitting of the Gumbel Distribution}
\description{
  Maximum-likelihood fitting for the gumbel distribution,
  including generalized linear modelling of each parameter.
}
\usage{
gum.fit(xdat, ydat = NULL, mul = NULL, sigl = NULL, mulink = identity,
    siglink = identity, show = TRUE, method = "Nelder-Mead",
    maxit = 10000, \dots)
}
\arguments{
  \item{xdat}{A numeric vector of data to be fitted.}
  \item{ydat}{A matrix of covariates for generalized linear modelling
    of the parameters (or \code{NULL} (the default) for stationary
    fitting). The number of rows should be the same as the length
    of \code{xdat}.}
  \item{mul, sigl}{Numeric vectors of integers, giving the columns
    of \code{ydat} that contain covariates for generalized linear
    modelling of the location and scale parameters repectively
    (or \code{NULL} (the default) if the corresponding parameter is
    stationary).}
  \item{mulink, siglink}{Inverse link functions for generalized
    linear modelling of the location and scale parameters
    repectively.}
  \item{show}{Logical; if \code{TRUE} (the default), print details of
    the fit.}
  \item{method}{The optimization method (see \code{\link{optim}} for
    details).}
  \item{maxit}{The maximum number of iterations.}
  \item{\dots}{Other control parameters for the optimization. These
    are passed to components of the \code{control} argument of
    \code{optim}.}
}
\details{
  For non-stationary fitting it is recommended that the covariates
  within the generalized linear models are (at least approximately)
  centered and scaled (i.e.\ the columns of \code{ydat} should be
  approximately centered and scaled).
}
\value{
  A list containing the following components. A subset of these
  components are printed after the fit. If \code{show} is
  \code{TRUE}, then assuming that successful convergence is
  indicated, the components \code{nllh}, \code{mle} and \code{se}
  are always printed.
  
  \item{trans}{An logical indicator for a non-stationary fit.}
  \item{model}{A list with components \code{mul} and \code{sigl}.}
  \item{link}{A character vector giving inverse link functions.}
  \item{conv}{The convergence code, taken from the list returned by
    \code{\link{optim}}. A zero indicates successful convergence.}
  \item{nllh}{The negative logarithm of the likelihood evaluated at
    the maximum likelihood estimates.}
  \item{data}{The data that has been fitted. For non-stationary
    models, the data is standardized.}
  \item{mle}{A vector containing the maximum likelihood estimates.}
  \item{cov}{The covariance matrix.}
  \item{se}{A vector containing the standard errors.}
  \item{vals}{A matrix with two columns containing the maximum
    likelihood estimates of the location and scale parameters
    at each data point.}  
}

\seealso{\code{\link{gum.diag}}, \code{\link{optim}},
  \code{\link{gev.fit}}}

\examples{
data(portpirie)
gum.fit(portpirie[,2])
}
\keyword{models}

\eof
\name{ismev-internal}

\alias{gev.pp}
\alias{gpd.pp}
\alias{pp.pp}
\alias{rlarg.pp}

\alias{gev.qq}
\alias{gpd.qq}
\alias{pp.qq}
\alias{rlarg.qq}

\alias{gev.rl}
\alias{gum.rl}
\alias{gpd.rl}

\alias{gev.his}
\alias{gpd.his}

\alias{gevf}
\alias{gpdf}
\alias{ppf}
\alias{rlargf}
\alias{gum.df}

\alias{gevq}
\alias{gpdq}
\alias{gpdq2}
\alias{ppq}
\alias{rlargq}
\alias{rlargq2}
\alias{gum.q}

\alias{gev.dens}
\alias{gpd.dens}
\alias{gum.dens}
\alias{ppp}

\alias{identity}
\alias{q.form}

\title{Internal Functions}

\description{
  Not to be called by the user.
}

\keyword{internal}

\eof
\name{mrl.plot}
\alias{mrl.plot}

\title{Mean Residual Life Plot}
\description{
  An empirical mean residual life plot, including confidence
  intervals, is produced. The mean residual life plot aids
  the selection of a threshold for the GPD or point process
  models.
}
\usage{
mrl.plot(data, umin = min(data), umax = max(data) - 0.1,
    conf = 0.95, nint = 100)
}
\arguments{
  \item{data}{A numeric vector of data to be fitted.}
  \item{umin, umax}{The minimum and maximum thresholds at which
    the mean residual life function is calculated.}
  \item{conf}{The confidence coefficient for the confidence
    intervals depicted in the plot.}
  \item{nint}{The number of points at which the mean residual
    life function is calculated.}
}

\seealso{\code{\link{gpd.fit}}, \code{\link{gpd.fitrange}},
  \code{\link{pp.fit}}}

\examples{
data(rain)
mrl.plot(rain)
}
\keyword{hplot}

\eof
\name{portpirie}
\alias{portpirie}
\title{Annual Maximum Sea Levels at Port Pirie, South Australia}
\usage{data(portpirie)}
\description{
  The \code{portpirie} data frame has 65 rows and 2 columns.
  The second column gives annual maximimum sea levels recorded
  at Port Pirie, South Australia, from 1923 to 1987.
  The first column gives the corresponding years.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{Year}{A numeric vector of years.}
    \item{Sea Level}{A numeric vector of annual sea level
      maxima.}
  }
}
\source{
  Coles, S. G. (2001)
  \emph{An Introduction to Statistical Modelling of
    Extreme Values.} London: Springer.
}
\keyword{datasets}

\eof
\name{pp.diag}
\alias{pp.diag}

\title{Diagnostic Plots for Point Process Models}
\description{
  Produces diagnostic plots for point process models using the
  output of the function \code{pp.fit}.
}
\usage{
pp.diag(z)
}
\arguments{
  \item{z}{An object returned by \code{pp.fit}.} 
}
\value{
  For stationary models two plots are produced; a probability
  plot and a quantile plot.

  For non-stationary models two plots are produced; a residual
  probability plot and a residual quantile plot.
}

\seealso{\code{\link{pp.fit}}, \code{\link{gpd.fit}}}

\examples{
data(rain)
rnfit <- pp.fit(rain, 10)
pp.diag(rnfit)
}
\keyword{hplot}

\eof
\name{pp.fit}
\alias{pp.fit}

\title{Maximum-likelihood Fitting for the Point Process Model}
\description{
  Maximum-likelihood fitting for the point process model,
  including generalized linear modelling of each parameter.
}
\usage{
pp.fit(xdat, threshold, npy = 365, ydat = NULL, mul = NULL, sigl =
    NULL, shl = NULL, mulink = identity, siglink = identity, shlink =
    identity, show = TRUE, method = "Nelder-Mead", maxit = 10000, \dots)
}
\arguments{
  \item{xdat}{A numeric vector of data to be fitted.}
  \item{threshold}{The threshold; a single number or a numeric
    vector of the same length as \code{xdat}.}
  \item{npy}{The number of observations per year/block.}
  \item{ydat}{A matrix of covariates for generalized linear modelling
    of the parameters (or \code{NULL} (the default) for stationary
    fitting). The number of rows should be the same as the length
    of \code{xdat}.}
  \item{mul, sigl, shl}{Numeric vectors of integers, giving the columns
    of \code{ydat} that contain covariates for generalized linear
    modelling of the location, scale and shape parameters repectively
    (or \code{NULL} (the default) if the corresponding parameter is
    stationary).}
  \item{mulink, siglink, shlink}{Inverse link functions for generalized
    linear modelling of the location, scale and shape parameters
    repectively.}
  \item{show}{Logical; if \code{TRUE} (the default), print details of
    the fit.}
  \item{method}{The optimization method (see \code{\link{optim}} for
    details).}
  \item{maxit}{The maximum number of iterations.}
  \item{\dots}{Other control parameters for the optimization. These
    are passed to components of the \code{control} argument of
    \code{optim}.}
}
\details{
  For non-stationary fitting it is recommended that the covariates
  within the generalized linear models are (at least approximately)
  centered and scaled (i.e.\ the columns of \code{ydat} should be
  approximately centered and scaled).
}
\value{
  A list containing the following components. A subset of these
  components are printed after the fit. If \code{show} is
  \code{TRUE}, then assuming that successful convergence is
  indicated, the components \code{nexc}, \code{nllh}, \code{mle}
  and \code{se} are always printed.
  
  \item{trans}{An logical indicator for a non-stationary fit.}
  \item{model}{A list with components \code{mul}, \code{sigl}
    and \code{shl}.}
  \item{link}{A character vector giving inverse link functions.}
  \item{threshold}{The threshold, or vector of thresholds.}
  \item{npy}{The number of observations per year/block.}
  \item{nexc}{The number of data points above the threshold.}
  \item{data}{The data that lie above the threshold. For
    non-stationary models, the data is standardized.}
  \item{conv}{The convergence code, taken from the list returned by
    \code{\link{optim}}. A zero indicates successful convergence.}
  \item{nllh}{The negative logarithm of the likelihood evaluated at
    the maximum likelihood estimates.}
  \item{vals}{A matrix with four columns containing the maximum
    likelihood estimates of the location, scale and shape
    parameters, and the threshold, at each data point.}
  \item{gpd}{A matrix with three rows containing the maximum
    likelihood estimates of corresponding GPD location, scale
    and shape parameters at each data point.}
  \item{mle}{A vector containing the maximum likelihood estimates.}
  \item{cov}{The covariance matrix.}
  \item{se}{A vector containing the standard errors.}
}

\seealso{\code{\link{pp.diag}}, \code{\link{optim}},
  \code{\link{pp.fitrange}}, \code{\link{mrl.plot}},
  \code{\link{gpd.fit}}}

\examples{
data(rain)
pp.fit(rain, 10)
}
\keyword{models}

\eof
\name{pp.fitrange}
\alias{pp.fitrange}

\title{Fitting the Point Process Model Over a Range of Thresholds}
\description{
  Maximum-likelihood fitting for a stationary point process model,
  over a range of thresholds. Graphs of parameter estimates
  which aid the selection of a threshold are produced.
}
\usage{
pp.fitrange(data, umin, umax, npy = 365, nint = 10, show = FALSE)
}
\arguments{
  \item{data}{A numeric vector of data to be fitted.}
  \item{umin, umax}{The minimum and maximum thresholds at which
    the model is fitted.}
  \item{npy}{The number of observations per year/block.}
  \item{nint}{The number of fitted models.}
  \item{show}{Logical; if \code{TRUE}, print details of each
    fit.}
}
\value{
  Three graphs showing maximum likelihood estimates and confidence
  intervals of the location, scale and shape parameters over a
  range of thresholds are produced.
}

\seealso{\code{\link{pp.fit}}, \code{\link{mrl.plot}},
  \code{\link{gpd.fit}}, \code{\link{gpd.fitrange}}}

\examples{
\dontrun{data(rain)}
\dontrun{pp.fitrange(rain, 10, 40)}
}
\keyword{hplot}

\eof
\name{rain}
\alias{rain}
\title{Daily Rainfall Accumulations in South-West England}
\usage{data(rain)}
\description{
  A numeric vector containing daily rainfall accumulations
  at a location in south-west England over the period 1914
  to 1962.
}
\format{A vector containing 17531 observations.}
\source{
  Coles, S. G. and Tawn, J. A. (1996)
  Modelling extremes of the areal rainfall process.
  \emph{Journal of the Royal Statistical Society, B}
  \bold{53}, 329--347.
}
\references{
  Coles, S. G. (2001)
  \emph{An Introduction to Statistical Modelling of
    Extreme Values.} London: Springer.
}

\keyword{datasets}

\eof
\name{rlarg.diag}
\alias{rlarg.diag}

\title{Diagnostic Plots for Order Statistics Models}
\description{
  Produces diagnostic plots for order statistics models using
  the output of the function \code{rlarg.fit}.
}
\usage{
rlarg.diag(z, n = z$r)
}
\arguments{
  \item{z}{An object returned by \code{rlarg.fit}.}
  \item{n}{Probability and quantile plots are produced for the
    largest \code{n} order statistics.}
}
\value{
  For stationary models four plots are initially produced;
  a probability plot, a quantile plot, a return level plot
  and a histogram of data with fitted density.
  Then probability and quantile plots are produced for the
  largest \code{n} order statistics.

  For non-stationary models residual probability plots and
  residual quantile plots are produced for the largest
  \code{n} order statistics.
}

\seealso{\code{\link{rlarg.fit}}}

\examples{
\dontrun{data(venice)}
\dontrun{venfit <- rlarg.fit(venice[,-1])}
\dontrun{rlarg.diag(venfit)}
}
\keyword{hplot}

\eof
\name{rlarg.fit}
\alias{rlarg.fit}

\title{Maximum-likelihood Fitting of Order Statistics Model}
\description{
  Maximum-likelihood fitting for the order statistic model,
  including generalized linear modelling of each parameter.
}
\usage{
rlarg.fit(xdat, r = dim(xdat)[2], ydat = NULL, mul = NULL, sigl = NULL,
  shl = NULL, mulink = identity, siglink = identity, shlink = identity,
  show = TRUE, method = "Nelder-Mead", maxit = 10000, \dots)
}
\arguments{
  \item{xdat}{A numeric matrix of data to be fitted. Each row
    should be a vector of decreasing order, containing the
    largest order statistics for each year (or time period).
    The first column therefore contains annual (or period)
    maxima.
    Only the first \code{r} columns are used for the fitted
    model. By default, all columns are used.
    If one year (or time period) contains fewer order statistics
    than another, missing values can be appended to the end
    of the corresponding row.}
  \item{r}{The largest \code{r} order statistics are used for
    the fitted model.}
  \item{ydat}{A matrix of covariates for generalized linear modelling
    of the parameters (or \code{NULL} (the default) for stationary
    fitting). The number of rows should be the same as the number
    of rows of \code{xdat}.}
  \item{mul, sigl, shl}{Numeric vectors of integers, giving the columns
    of \code{ydat} that contain covariates for generalized linear
    modelling of the location, scale and shape parameters repectively
    (or \code{NULL} (the default) if the corresponding parameter is
    stationary).}
  \item{mulink, siglink, shlink}{Inverse link functions for generalized
    linear modelling of the location, scale and shape parameters
    repectively.}
  \item{show}{Logical; if \code{TRUE} (the default), print details of
    the fit.}
  \item{method}{The optimization method (see \code{\link{optim}} for
    details).}
  \item{maxit}{The maximum number of iterations.}
  \item{\dots}{Other control parameters for the optimization. These
    are passed to components of the \code{control} argument of
    \code{optim}.}
}
\details{
  For non-stationary fitting it is recommended that the covariates
  within the generalized linear models are (at least approximately)
  centered and scaled (i.e.\ the columns of \code{ydat} should be
  approximately centered and scaled).
}
\value{
  A list containing the following components. A subset of these
  components are printed after the fit. If \code{show} is
  \code{TRUE}, then assuming that successful convergence is
  indicated, the components \code{nllh}, \code{mle} and \code{se}
  are always printed.
  
  \item{trans}{An logical indicator for a non-stationary fit.}
  \item{model}{A list with components \code{mul}, \code{sigl}
    and \code{shl}.}
  \item{link}{A character vector giving inverse link functions.}
  \item{conv}{The convergence code, taken from the list returned by
    \code{\link{optim}}. A zero indicates successful convergence.}
  \item{nllh}{The negative logarithm of the likelihood evaluated at
    the maximum likelihood estimates.}
  \item{data}{The data that has been fitted. For non-stationary
    models, the data is standardized.}
  \item{mle}{A vector containing the maximum likelihood estimates.}
  \item{cov}{The covariance matrix.}
  \item{se}{A vector containing the standard errors.}
  \item{vals}{A matrix with three columns containing the maximum
    likelihood estimates of the location, scale and shape parameters
    at each data point.}
  \item{r}{The number of order statistics used.}
}

\seealso{\code{\link{rlarg.diag}}, \code{\link{optim}}}

\examples{
\dontrun{data(venice)}
\dontrun{rlarg.fit(venice[,-1])}
}
\keyword{models}

\eof
\name{venice}
\alias{venice}
\title{Venice Sea Levels}
\usage{data(venice)}
\description{
  The \code{venice} data frame has 51 rows and 11 columns.
  The final ten columns contain the 10 largest sea levels
  observed within the year given by the first column.
  The ten largest sea levels are given for every year in
  the period 1931 to 1981, excluding 1935 in which only
  the six largest measurements are available.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{Year}{A numeric vector of years.}
    \item{r1}{Annual sea level maxima.}
    \item{r2}{The second largest sea level.}
    \item{r3}{The third largest sea level.}
    \item{r4}{The forth largest sea level.}
    \item{r5}{The fifth largest sea level.}
    \item{r6}{The sixth largest sea level.}
    \item{r7}{The seventh largest sea level.}
    \item{r8}{The eigth largest sea level.}
    \item{r9}{The ninth largest sea level.}
    \item{r10}{The tenth largest sea level.}
  }
}
\source{
  Smith, R. L. (1986)
  Extreme value theory based on the \emph{r} largest annual
  events.
  \emph{Journal of Hydrology} \bold{86}, 27--43.
}
\references{
  Coles, S. G. (2001)
  \emph{An Introduction to Statistical Modelling of
    Extreme Values.} London: Springer.
}

\keyword{datasets}

\eof
\name{wavesurge}
\alias{wavesurge}
\title{Wave and Surge Heights in South-West England}
\usage{data(wavesurge)}
\description{
  The \code{wavesurge} data frame has 2894 rows and 2 columns.
  The columns contain wave and surge heights (in metres) at a
  single location off south-west England.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{wave}{A numeric vector of wave heights.}
    \item{surge}{A numeric vector of surge heights.}
  }
}
\source{
  Coles, S. G. (2001)
  \emph{An Introduction to Statistical Modelling of
    Extreme Values.} London: Springer.
}
\keyword{datasets}

\eof
\name{wind}
\alias{wind}
\title{Annual Maximum Wind Speeds at Albany and Hartford}
\usage{data(wind)}
\description{
  The \code{wind} data frame has 40 rows and 3 columns.
  The second and third columns contain annual maximum wind
  speeds at Albany, New York and Hartford, Connecticut
  respectively, over the period 1944 to 1983.
  The first column gives the corresponding years.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{Year}{A numeric vector of years.}
    \item{Hartford}{Annual maximum wind speeds at Hartford.}
    \item{Albany}{Annual maximum wind speeds at Albany.}
  }
}
\source{
  Coles, S. G. (2001)
  \emph{An Introduction to Statistical Modelling of
    Extreme Values.} London: Springer.
}

\keyword{datasets}

\eof
\name{wooster}
\alias{wooster}
\title{Minimum Temperatures at Wooster, Ohio}
\usage{data(wooster)}
\description{
  A numeric vector containing daily minimum temperatures,
  in degrees Fahrenheit, at Wooster, Ohio, over the period
  1983 to 1988.
}
\format{A vector containing 1826 observations.}
\source{
  Coles, S. G., Tawn, J. A. and Smith, R. L. (1994)
  A seasonal Markov model for extremely low temperatures.
  \emph{Environmetrics} \bold{5}, 221--239.
}
\references{
  Coles, S. G. (2001)
  \emph{An Introduction to Statistical Modelling of
    Extreme Values.} London: Springer.

  Smith, R. L., Tawn, J. A. and Coles, S. G. (1997)
  Markov chain models for threshold exceedences.
  \emph{Biometrica} \bold{84}, 249--268.
}

\keyword{datasets}

\eof
