print.MD                package:BsMD                R Documentation

_P_r_i_n_t _B_e_s_t _M_D _F_o_l_l_o_w-_U_p _E_x_p_e_r_i_m_e_n_t_s

_D_e_s_c_r_i_p_t_i_o_n:

     Printing method for  lists of class 'MD'. Displays the best MD
     criterion set of runs and their MD for follow-up experiments.

_U_s_a_g_e:

     print.MD(x, X = FALSE, resp = FALSE, Xcand = TRUE, models = TRUE, nMod = x$nMod,
                 digits = 3, verbose=FALSE, ...)

_A_r_g_u_m_e_n_t_s:

       x: list of class 'MD'. Output list of the 'MD' function.

       X: logical. If 'TRUE', the initial design matrix is printed.

    resp: logical If 'TRUE', the response vector of initial design is
          printed.

   Xcand: logical. Prints the candidate runs if 'TRUE'.

  models: logical. Competing models are printed if 'TRUE'.

    nMod: integer. Top models to print.

  digits: integer. Significant digits to use in the print out.

 verbose: logical. If 'TRUE', the 'unclass'-ed 'x' is displayed.

     ...: additional arguments passed to 'print' generic function.

_V_a_l_u_e:

     The function is mainly called for its side effects. Prints out the
     selected components of the class 'MD' objects, output of the 'MD'
     function. For example the marginal factors and models posterior
     probabilities and the top MD follow-up experiments with their
     corresponding MD statistic. It returns invisible list with the
     components: 

    calc: Numeric vector with basic calculation information.

  models: Data frame with the competing models posterior probabilities.

follow-up: Data frame with the runs for follow-up experiments and their
          corresponding MD statistic.

_A_u_t_h_o_r(_s):

     Ernesto Barrios.

_R_e_f_e_r_e_n_c_e_s:

     Meyer, R. D., Steinberg, D. M. and Box, G. E. P. (1996).
     "Follow-Up Designs to Resolve Confounding in Multifactor
     Experiments (with discussion)". _Technometrics_, Vol. 38, No. 4,
     pp. 303-332.

     Box, G. E. P and R. D. Meyer (1993). "Finding the Active Factors
     in Fractionated Screening Experiments". _Journal of Quality
     Technology._ Vol. 25. No. 2. pp. 94-105.

_S_e_e _A_l_s_o:

     'MD', 'BsProb'

_E_x_a_m_p_l_e_s:

     # Injection Molding Experiment. Meyer et al. 1996. Example 2.
     # MD for one extra experiment.
     library(BsMD)
     data(BM93.e3.data,package="BsMD")
     X <- as.matrix(BM93.e3.data[1:16,c(1,2,4,6,9)])
     y <- BM93.e3.data[1:16,10]
     nBlk <- 1
     nFac <- 4
     mInt <- 3
     g <- 2
     nMod <- 5
     p <- c(0.2356,0.2356,0.2356,0.2356,0.0566)
     s2 <- c(0.5815,0.5815,0.5815,0.5815,0.4412)
     nf <- c(3,3,3,3,4)
     facs <- matrix(c(2,1,1,1,1,3,3,2,2,2,4,4,3,4,3,0,0,0,0,4),nrow=5,
         dimnames=list(1:5,c("f1","f2","f3","f4")))
     nFDes <- 1
     Xcand <- matrix(c(1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
                         -1,-1,-1,-1,1,1,1,1,-1,-1,-1,-1,1,1,1,1,
                         -1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,
                         -1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,
                         -1,1,1,-1,1,-1,-1,1,1,-1,-1,1,-1,1,1,-1),
                         nrow=16,dimnames=list(1:16,c("blk","f1","f2","f3","f4"))
                     )
     mIter <- 0
     startDes <- matrix(c(9,11,12,15),nrow=4)
     top <- 10
     injectionMolding.MD <- MD(X=X,y=y,nFac=nFac,nBlk=nBlk,mInt=mInt,g=g,
                 nMod=nMod,p=p,s2=s2,nf=nf,facs=facs,
                 nFDes=nFDes,Xcand=Xcand,mIter=mIter,startDes=startDes,top=top)

     print(injectionMolding.MD)
     summary(injectionMolding.MD)

