summary.MD               package:BsMD               R Documentation

_S_u_m_m_a_r_y _o_f _B_e_s_t _M_D _F_o_l_l_o_w-_U_p _E_x_p_e_r_i_m_e_n_t_s

_D_e_s_c_r_i_p_t_i_o_n:

     Reduced printing method for lists of class 'MD'. Displays the best
     MD criterion set of runs and their MD for follow-up experiments.

_U_s_a_g_e:

     summary.MD(object, digits = 3, verbose=FALSE, ...)

_A_r_g_u_m_e_n_t_s:

  object: list of 'MD' class. Output list of 'MD' function.

  digits: integer. Significant digits to use in the print out.

 verbose: logical. If 'TRUE', the 'unclass'-ed 'object' is displayed.

     ...: additional arguments passed to 'summary' generic function.

_V_a_l_u_e:

     It prints out the marginal factors and models posterior
     probabilities and the top MD follow-up experiments with their
     corresponding MD statistic.

_A_u_t_h_o_r(_s):

     Ernesto Barrios.

_R_e_f_e_r_e_n_c_e_s:

     Meyer, R. D., Steinberg, D. M. and Box, G. E. P. (1996).
     "Follow-Up Designs to Resolve Confounding in Multifactor
     Experiments (with discussion)". _Technometrics_, Vol. 38, No. 4,
     pp. 303-332.

     Box, G. E. P and R. D. Meyer (1993). "Finding the Active Factors
     in Fractionated Screening Experiments". _Journal of Quality
     Technology._ Vol. 25. No. 2. pp. 94-105.

_S_e_e _A_l_s_o:

     'print.MD' and 'MD'

_E_x_a_m_p_l_e_s:

     ### Reactor Experiment. Meyer et al. 1996, example 3.
     library(BsMD)
     data(Reactor.data,package="BsMD")

     # Posterior probabilities based on first 8 runs
     X <- as.matrix(cbind(blk = rep(-1,8), Reactor.data[c(25,2,19,12,13,22,7,32), 1:5]))
     y <- Reactor.data[c(25,2,19,12,13,22,7,32), 6]
     reactor.BsProb <- BsProb(X = X, y = y, blk = 1, mFac = 5, mInt = 3,
             p =0.25, g =0.40, ng = 1, nMod = 32)

     # MD optimal 4-run design
     p <- reactor.BsProb$ptop
     s2 <- reactor.BsProb$sigtop
     nf <- reactor.BsProb$nftop
     facs <- reactor.BsProb$jtop
     nFDes <- 4
     Xcand <- as.matrix(cbind(blk = rep(+1,32), Reactor.data[,1:5]))
     reactor.MD <- MD(X = X, y = y, nFac = 5, nBlk = 1, mInt = 3, g =0.40, nMod = 32,
             p = p,s2 = s2, nf = nf, facs = facs, nFDes = 4, Xcand = Xcand,
             mIter = 20, nStart = 25, top = 5)
     print(reactor.MD)
     summary(reactor.MD)

