\name{BM86.data}
\alias{BM86.data}
\docType{data}
\title{Data sets in Box and Meyer (1986)}
\description{ Design factors and responses used in the examples of Box and
Meyer (1986) } \usage{data(BM86.data)} \format{
  A data frame with 16 observations on the following 19 variables.
  \describe{
    \item{X1}{numeric vector. Contrast factor.}
    \item{X2}{numeric vector. Contrast factor.}
    \item{X3}{numeric vector. Contrast factor.}
    \item{X4}{numeric vector. Contrast factor.}
    \item{X5}{numeric vector. Contrast factor.}
    \item{X6}{numeric vector. Contrast factor.}
    \item{X7}{numeric vector. Contrast factor.}
    \item{X8}{numeric vector. Contrast factor.}
    \item{X9}{numeric vector. Contrast factor.}
    \item{X10}{numeric vector. Contrast factor.}
    \item{X11}{numeric vector. Contrast factor.}
    \item{X12}{numeric vector. Contrast factor.}
    \item{X13}{numeric vector. Contrast factor.}
    \item{X14}{numeric vector. Contrast factor.}
    \item{X15}{numeric vector. Contrast factor.}
    \item{y1}{numeric vector. Log drill advance response.}
    \item{y2}{numeric vector. Tensile strength response.}
    \item{y3}{numeric vector. Shrinkage response.}
    \item{y4}{numeric vector.  Yield of isatin response.}
  }
}
\source{
Box, G. E. P and R. D. Meyer (1986). "An Analysis of Unreplicated
Fractional Factorials". \emph{Technometrics.} Vol. 28. No. 1. pp. 11--18.
}
\examples{
library(BsMD)
data(BM86.data,package="BsMD")
print(BM86.data)
}
\keyword{datasets}

\eof
\name{BM93.e1.data}
\alias{BM93.e1.data}
\docType{data}
\title{Example 1 data in Box and Meyer (1993)}
\description{
12-run Plackett-Burman design from the $2^5$ reactor
    example from Box, Hunter and Hunter (1977).
}
\usage{data(BM93.e1.data)}
\format{
  A data frame with 12 observations on the following 7 variables.
  \describe{
    \item{Run}{a numeric vector. Run number from a $2^5$ factorial design in standard order.}
    \item{A}{a numeric vector. Feed rate factor.}
    \item{B}{a numeric vector. Catalyst factor.}
    \item{C}{a numeric vector. Agitation factor.}
    \item{D}{a numeric vector. Temperature factor.}
    \item{E}{a numeric vector. Concentration factor.}
    \item{y}{a numeric vector. Percent reacted response.}
  }
}
\source{
Box G. E. P, Hunter, W. C. and Hunter, J. S. (1978).
    \emph{Statistics for Experimenters}. Wiley.

Box, G. E. P and R. D. Meyer (1993). "Finding the Active Factors
in Fractionated Screening Experiments".
\emph{Journal of Quality Technology.} Vol. 25. No. 2. pp. 94--105.
}
\examples{
library(BsMD)
data(BM93.e1.data,package="BsMD")
print(BM93.e1.data)
}
\keyword{datasets}

\eof
\name{BM93.e2.data}
\alias{BM93.e2.data}
\docType{data}
\title{Example 2 data in Box and Meyer (1993)}
\description{
12-run Plackett-Burman design for the study of fatigue
    life of weld repaired castings.
}
\usage{data(BM93.e2.data)}
\format{
  A data frame with 12 observations on the following 8 variables.
  \describe{
    \item{A}{a numeric vector. Initial structure factor.}
    \item{B}{a numeric vector. Bead size factor.}
    \item{C}{a numeric vector. Pressure treat factor.}
    \item{D}{a numeric vector. Heat treat factor.}
    \item{E}{a numeric vector. Cooling rate factor.}
    \item{F}{a numeric vector. Polish factor.}
    \item{G}{a numeric vector. Final treat factor.}
    \item{y}{a numeric vector. Natural log of fatigue life response.}
  }
}
\source{
Hunter, G. B., Hodi, F. S., and Eager, T. W. (1982). "High-Cycle Fatigue
of Weld Repaired Cast Ti-6A1-4V". \emph{Metallurgical Transactions} 13A,
pp. 1589--1594.

Box, G. E. P and R. D. Meyer (1993). "Finding the Active Factors
in Fractionated Screening Experiments".
\emph{Journal of Quality Technology.} Vol. 25. No. 2. pp. 94--105.
}
\examples{
library(BsMD)
data(BM93.e2.data,package="BsMD")
print(BM93.e2.data)
}
\keyword{datasets}

\eof
\name{BM93.e3.data}
\alias{BM93.e3.data}
\docType{data}
\title{Example 3 data in Box and Meyer (1993)}
\description{
\eqn{2^{8-4}} Fractional factorial design in the injection molding example from
Box, Hunter and Hunter (1978).
}
\usage{data(BM93.e3.data)}
\format{
  A data frame with 20 observations on the following 10 variables.
  \describe{
    \item{blk}{a numeric vector}
    \item{A}{a numeric vector. Mold temperature factor.}
    \item{B}{a numeric vector. Moisture content factor.}
    \item{C}{a numeric vector. Holding Pressure factor.}
    \item{D}{a numeric vector. Cavity thickness factor.}
    \item{E}{a numeric vector. Booster pressure factor.}
    \item{F}{a numeric vector. Cycle time factor.}
    \item{G}{a numeric vector. Gate size factor.}
    \item{H}{a numeric vector. Screw speed factor.}
    \item{y}{a numeric vector. Shrinkage response.}
  }
}
\source{
Box G. E. P, Hunter, W. C. and Hunter, J. S. (1978).
    \emph{Statistics for Experimenters}. Wiley.

Box G. E. P, Hunter, W. C. and Hunter, J. S. (2004).
    \emph{Statistics for Experimenters II}. Wiley.

Box, G. E. P and R. D. Meyer (1993). "Finding the Active Factors
in Fractionated Screening Experiments".
\emph{Journal of Quality Technology.} Vol. 25. No. 2. pp. 94--105.
}
\examples{
library(BsMD)
data(BM93.e3.data,package="BsMD")
print(BM93.e3.data)
}
\keyword{datasets}

\eof
\name{BsMD-internal}
\title{Internal BsMD objects}
\alias{.First.lib}
\description{Internal BsMD objects.}
\details{These are not to be called by the user.}
\keyword{internal}
\eof
\name{BsProb}
\alias{BsProb}
\title{Posterior Probabilities from Bayesian Screening Experiments}
\description{
Marginal factor posterior probabilities and model posterior probabilities
from designed screening experiments are calculated according to Box and Meyer's
Bayesian procedure.
}
\usage{
    BsProb(X, y, blk, mFac, mInt = 2, p = 0.25, g = 2, ng = 1, nMod = 10)
}
\arguments{
  \item{X}{Matrix. The design matrix.}
  \item{y}{vector. The response vector.}
  \item{blk}{integer. Number of blocking factors (>=0). These factors are
      accommodated in the first columns of matrix \code{X}. There are
      \code{ncol(X)-blk} design factors.}
  \item{mFac}{integer. Maximum number of factors included in the models.}
  \item{mInt}{integer <= 3. Maximum order of interactions considered in the models.}
  \item{p}{numeric. Prior probability assigned to active factors.}
  \item{g}{vector. Variance inflation factor(s) \eqn{\gamma}associated to active and interaction factors.}
  \item{ng}{integer <=20. Number of different variance inflation factors (\code{g}) used in calculations.}
  \item{nMod}{integer <=100. Number of models to keep with the highest posterior probability.}
}
\details{
Factor and model posterior probabilities are computed by Box and Meyer's Bayesian
procedure. The design factors are accommodated in the matrix \code{X} after
\code{blk} columns of the blocking factors. So, \code{ncol(X)-blk} design factors
are considered. If \code{g}, the variance inflation factor (VIF) \eqn{\gamma},
is a vector of length 1, the same VIF is used for factor main effects and interactions.
If the length of \code{g} is 2 and \code{ng} is 1, \code{g[1]} is used for factor
main effects and \code{g[2]} for the interaction effects. If \code{ng} greater than 1,
then \code{ng} values of VIFs between \code{g[1]} and \code{g[2]} are used for
calculations with the same \eqn{gamma} value for main effects and interactions.
The function calls the \acronym{FORTRAN} subroutine \file{bm} and captures summary results.
The complete output of the \acronym{FORTRAN} code is save in the \file{BsPrint.out}
file in the working directory. The output is a list of class \code{BsProb} for which
\code{print}, \code{plot} and \code{summary} methods are available.
}
\value{
A list with all output parameters of the \acronym{FORTRAN} subroutine \file{bm}.
The names of the list components are such that they match the original \acronym{FORTRAN}
code. Small letters used for capturing program's output.
  \item{X}{matrix. The design matrix.}
  \item{Y}{vector. The response vector.}
  \item{N}{integer. The number of runs.}
  \itme{COLS}{integer. The number of design factors.}
  \item{BLKS}{integer. The number of blocking factors accommodated in the first
                columns of matrix \code{X}.}
  \item{MXFAC}{integer. Maximum number of factors considered in the models.}
  \item{MXINT}{integer. Maximum interaction order considered in the models.}
  \item{PI}{numeric. Prior probability assigned to the active factors.}
  \item{INDGAM}{integer. If 0, the same variance inflation factor (\code{GAMMA})
                is used for main and interactions effects.
                If \code{INDGAM ==1}, then \code{NGAM} different values
                of \code{GAMMA} were used.}
  \item{INDG2}{integer. If 1, the variance inflation factor \code{GAM2} was used for
                the interaction effects.}
  \item{NGAM}{integer. Number of different VIFs used for computations.}
  \item{GAMMA}{vector. Vector of variance inflation factors of length 1 or 2.}
  \item{NTOP}{integer. Number of models with the highest posterior probability}.
  \item{mdcnt}{integer. Total number of models evaluated.}
  \item{ptop}{vector. Vector of probabilities of the top \code{ntop} models.}
  \item{sigtop}{vector.  Vector of sigma-squared of the top \code{ntop} models.}
  \item{nftop}{integer.  Number of factors in each of the \code{ntop} models.}
  \item{jtop}{matrix. Matrix of the number of factors and their labels
                of the top \code{ntop} models.}
  \item{del}{numeric. Interval width of the \code{GAMMA} partition.}
  \item{sprob}{vector. Vector of posterior probabilities. If \code{ng>1} the
                probabilities are weighted averaged over \code{GAMMA}.}
  \item{pgam}{vector. Vector of values of the unscaled posterior density of \code{GAMMA}.}
  \item{prob}{matrix. Matrix of marginal factor posterior probabilities for each of
                the different values of \code{GAMMA}.}
  \item{ind}{integer. Indicator variable. \code{ind} is 1 if the \file{bm}
                subroutine exited properly. Any other number correspond to
                the format label number in the \acronym{FORTRAN} subroutine script.}

}
\references{
Box, G. E. P and R. D. Meyer (1986).
"An Analysis for Unreplicated Fractional Factorials".
\emph{Technometrics.} Vol. 28. No. 1. pp. 11--18.

Box, G. E. P and R. D. Meyer (1993). "Finding the Active Factors
in Fractionated Screening Experiments".
\emph{Journal of Quality Technology.} Vol. 25. No. 2. pp. 94--105.

}
\author{R. Daniel Meyer. Adapted for \R by Ernesto Barrios.}
\note{
The function is a wrapper to call the \acronym{FORTRAN} subroutine \file{bm},
modification of Daniel Meyer's original program, \file{mbcqp5.f}, for the
application of Bayesian design and analysis of fractional factorial experiments,
part of the \pkg{mdopt} bundle, available at \emph{StatLib}.
}
\seealso{
    \code{\link{print.BsProb}}, \code{\link{print.BsProb}}, \code{\link{summary.BsProb}}.
}
\examples{
library(BsMD)
data(BM86.data,package="BsMD")
X <- as.matrix(BM86.data[,1:15])
y <- BM86.data["y1"]
# Using prior probability of p = 0.20, and k = 10 (gamma = 2.49)
drillAdvance.BsProb <- BsProb(X = X, y = y, blk = 0, mFac = 15, mInt = 1,
            p = 0.20, g = 2.49, ng = 1, nMod = 10)
plot(drillAdvance.BsProb)
summary(drillAdvance.BsProb)

# Using prior probability of p = 0.20, and a 5 <= k <= 15 (1.22 <= gamma <= 3.74)
drillAdvance.BsProbG <- BsProb(X = X, y = y, blk = 0, mFac = 15, mInt = 1,
            p = 0.25, g = c(1.22, 3.74), ng = 3, nMod = 10)
plot(drillAdvance.BsProbG, code = FALSE, prt = TRUE)
}
\keyword{ design }

\eof
\name{DanielPlot}
\alias{DanielPlot}
\title{Normal Plot of Effects}
\description{
Normal plot of effects from a two level factorial experiment.
}
\usage{
DanielPlot(fit, code = FALSE, faclab = NULL, block = FALSE,
    datax = TRUE, half = FALSE, pch = "*", cex.lab = par("cex.lab"),
    cex.pch = par("cex.axis"), ...)
}
\arguments{
  \item{fit}{object of class \code{lm}. Fitted model from \code{lm} or \code{aov}.}
  \item{code}{logical. If \code{TRUE} labels "A","B", etc are used instead of the
        names of the coefficients (factors).}
  \item{faclab}{list. If \code{NULL} points are labelled accordingly to \code{code},
    otherwise \code{faclab} should be a list with \code{idx} (integer vector) and \code{lab}
    (character vector) components. See Details.}
  \item{block}{logical. If \code{TRUE}, the first factor is labelled as "BK" (block).}
  \item{datax}{logical. If \code{TRUE}, the x-axis is used for the factor effects the
                the y-axis for the normal scores. The opposite otherwise.}
  \item{half}{logical. If \code{TRUE}, half-normal plot of effects is display.}
  \item{pch}{numeric or character. Points character.}
  \item{cex.lab}{numeric. Labels character size.}
  \item{cex.pch}{numeric. Points character size.}
  \item{\dots}{graphical parameters passed to \code{plot}.}
}
\details{
    The two levels design are assumed -1 and 1. Factor effects assumed \code{2*coef(obj)}
    ((Intercept) removed) are displayed in a \code{qqnorm} plot with the effects in
    the x-axis by default. If \code{half=TRUE} the half-normal plots of effects is
    plotted as the normal quantiles of \code{0.5*(rank(abs(effects))-0.5)/length(effects)+1}
    versus \code{abs(effects)}.
}

\value{
    The function returns invisible data frame with columns: \code{x}, \code{y}
    and \code{no}, for the coordinates and the enumeration of plotted points.
    Names of the factor effects (coefficients) are the row names of the data frame.
}
\references{
    C. Daniel (1976).
    \emph{Application of Statistics to Industrial Experimentation.}
    Wiley.

Box G. E. P, Hunter, W. C. and Hunter, J. S. (1978).
    \emph{Statistics for Experimenters}.
    Wiley.
}
\author{Ernesto Barrios.}
\seealso{\code{\link{qqnorm}}, \code{\link{LenthPlot}}}
\examples{
### Injection Molding Experiment. Box et al. 1978.
library(BsMD)
# Data
data(BM86.data,package="BsMD")     # Design matrix and response
print(BM86.data)    # from Box and Meyer (1986)

# Model Fitting. Box and Meyer (1986) example 3.
injectionMolding.lm <- lm(y3 ~ X1 + X2 + X3 + X4 + X5 + X6 + X7 + X8 + X9 +
                    X10 + X11 + X12 + X13 + X14 + X15, data = BM86.data)
print(coef(injectionMolding.lm)) # Model coefficients

# Daniel Plots
par(mfrow=c(1,3),oma=c(0,0,1,0),pty="s")
DanielPlot(injectionMolding.lm, half = TRUE, main = "Half-Normal Plot")
DanielPlot(injectionMolding.lm, main = "Normal Plot of Effects")
DanielPlot(injectionMolding.lm,
        faclab = list(idx = c(12,4,13), lab = c(" -H"," VG"," -B")),
        main = "Active Contrasts")
}
\keyword{design}

\eof
\name{LenthPlot}
\alias{LenthPlot}
\title{Lenth's Plot of Effects}
\description{
Plot of the factor effects with significance levels based on robust
estimation of contrast standard errors.}
}
\usage{
LenthPlot(obj, alpha = 0.05, plt = TRUE, limits = TRUE,
    xlab = "factors", ylab = "effects", faclab = NULL, cex.fac = par("cex.lab"),
    cex.axis=par("cex.axis"), adj = 1, ...)
}
\arguments{
  \item{obj}{object of class \code{lm} or vector with the factor effects.}
  \item{alpha}{numeric. Significance level used for the \emph{margin of error} (ME)
            and \emph{simultaneous margin of error} (SME). See Lenth(1989).}
  \item{plt}{logical. If \code{TRUE}, a spikes plot with the factor effects is displayed.
            Otherwise, no plot is produced.}
  \item{limits}{logical. If \code{TRUE} ME and SME limits are displayed and labeled.}
  \item{xlab}{character string. Used to label the x-axis. "factors" as default.}
  \item{ylab}{character string. Used to label the y-axis. "effects" as default.}
  \item{faclab}{list with components \code{idx} (numeric vector)
        and \code{lab} (character vector). The \code{idx} entries of
        effects vector (taken from \code{obj}) are labelled as \code{lab}.
        The rest of the effect names are blanked. If \code{NULL} all factors
        are labelled using the coefficients' name.}
  \item{cex.fac}{numeric. Character size used for the factor labels.}
  \item{cex.axis}{numeric. Character size used for the axis.}
  \item{adj}{numeric between 0 and 1. Determines where to place the
    "ME" (margin of error) and the "SME" (simultaneous margin of error) labels
    (character size of 0.9*\code{cex.axis}).
    0 for extreme left hand side, 1 for extreme right hand side.}
  \item{\dots}{extra parameters passed to \code{plot}.}
}
\details{
    If \code{obj} is of class \code{lm}, \code{2*coef(obj)} is used as factor
    effect with the intercept term removed. Otherwise, \code{obj} should be a
    vector with the factor effects. Robust estimate of the contrasts standard
    error is used to calculate \emph{marginal} (ME) and \emph{simultaneous margin
    of error} (SME) for the provided significance (\code{1 - alpha}) level.
    See Lenth(1989).  Spikes are used to display the factor effects.
    If \code{faclab} is \code{NULL}, factors are labelled with the effects or
    coefficient names. Otherwise, those \code{faclab\$idx} factors are labelled
    as \code{faclab\$lab}. The rest of the factors are blanked.
}
\value{
    The function is called mainly for its side effect. It returns a vector with
    the value of alpha used, the estimated PSE, ME and SME.
}
\references{Lenth, R. V. (1989).
    "Quick and Easy Analysis of Unreplicated Factorials".
    \emph{Technometrics} Vol. 31, No. 4. pp. 469--473.
}
\author{Ernesto Barrios}
\seealso{\code{\link{DanielPlot}}, \code{\link{BsProb}} and \code{\link{plot.BsProb}}}
\examples{
### Tensile Strength Experiment. Taguchi and Wu. 1980
library(BsMD)
# Data
data(BM86.data,package="BsMD")     # Design matrix and responses
print(BM86.data)    # from Box and Meyer (1986)

# Model Fitting. Box and Meyer (1986) example 2.
tensileStrength.lm <- lm(y2 ~ X1 + X2 + X3 + X4 + X5 + X6 + X7 + X8 + X9 +
                    X10 + X11 + X12 + X13 + X14 + X15, data = BM86.data)
print(coef(tensileStrength.lm)) # Model coefficients

par(mfrow=c(1,2),pty="s")
DanielPlot(tensileStrength.lm, main = "Daniel Plot")
LenthPlot(tensileStrength.lm, main = "Lenth's Plot")
}
\keyword{design}

\eof
\name{MD}
\alias{MD}
\title{Best Model Discrimination (MD) Follow-Up Experiments}
\description{
Best follow-up experiments based on the MD criterion
are suggested to discriminate between competing models.
}
\usage{
MD(X, y, nFac, nBlk = 0, mInt = 3, g = 2,  nMod, p, s2, nf, facs, nFDes = 4,
Xcand, mIter = 20, nStart = 5, startDes = NULL, top = 20, eps = 1e-05)
}
\arguments{
  \item{X}{matrix. Design matrix of the initial experiment.}
  \item{y}{vector. Response vector of the initial experiment.}
  \item{nFac}{integer. Number of factors in the initial experiment.}
  \item{nBlk}{integer >=1. The number of blocking factors in the initial experiment.
                They are accommodated in the first columns of matrix \code{X}.}
  \item{mInt}{integer. Maximum order of the interactions in the models.}
  \item{g}{vector. Variance inflation factor for main effects (\code{g[1]})
        and interactions effects (\code{g[2]}). If vector length
        is 1 the same inflation factor is used for main and
        interactions effects.}
  \item{nMod}{integer. Number of competing models.}
  \item{p}{vector. Posterior probabilities of the competing models.}
  \item{s2}{vector. Competing model variances.}
  \item{nf}{vector. Factors considered in each of the models.}
  \item{facs}{matrix. Matrix [\code{nMod x max(nf)}] of factor numbers in the design matrix.}
  \item{nFDes}{integer. Number of runs to consider in the follow-up experiment.}
  \item{Xcand}{matrix. Candidate runs to be chosen for the follow-up design.}
  \item{mIter}{integer. If 0, then user-entered designs \code{startDes} are
        evaluated, otherwise the maximum number of iterations for each Wynn search.}
  \item{nStart}{integer. Number of starting designs.}
  \item{startDes}{matrix. Matrix \code{[nStart x nFDes]}. Each row has the row numbers
        of the user-supplied starting design.}
  \item{top}{integer. Highest MD follow-up designs recorded.}
  \item{eps}{numeric. A small number (1e-5 by default) used for computations.}
}
\details{
The MD criterion, proposed by Meyer, Steinberg and Box is used to discriminate
among competing models. Random starting runs chosen from \code{Xcand} are used
for the Wynn search of best MD follow-up designs. \code{nStart} starting points are
tried in the search limited to \code{mIter} iterations. If \code{mIter=0} then
\code{startDes} user-provided designs are used. Posterior probabilities and
variances of the competing models are obtained from \code{\link{BsProb}}.
The function calls the \acronym{FORTRAN} subroutine \file{md} and captures
summary results. The complete output of the \acronym{FORTRAN} code is save in
the \file{MDPrint.out} file in the working directory.
}
\value{
A list with all input and output parameters of the \acronym{FORTRAN}
subroutine \code{MD}. Most of the variable names kept to match \acronym{FORTRAN} code.
    \item{NSTART}{Number of starting designs.}
    \item{NRUNS}{Number of runs used in follow-up designs.}
    \item{ITMAX}{Maximum number of iterations for each Wynn search.}
    \item{INITDES}{Number of starting points.}
    \item{NO}{Numbers of runs already completed before follow-up.}
    \item{IND}{Indicator; 0 indicates the user supplied starting designs.}
    \item{X}{Matrix for initial data (\code{nrow(X)=N0}; \code{ncol(X)=COLS+BL}).}
    \item{Y}{Response values from initial experiment (\code{length(Y)=N0}).}
    \item{GAMMA}{Variance inflation factor.}
    \item{GAM2}{If \code{IND=1}, \code{GAM2} was used for interaction factors.}
    \item{BL}{Number of blocks (>=1) accommodated in first columns of \code{X} and \code{Xcand}}.
    \item{COLS}{Number of factors.}
    \item{N}{Number of candidate runs.}
    \item{Xcand}{Matrix of candidate runs. (\code{nrow(Xcand)=N}, \code{ncol(Xcand)=ncol(X)}).}
    \item{NM}{Number of models considered.}
    \item{P}{Models posterior probability.}
    \item{SIGMA2}{Models variances.}
    \item{NF}{Number of factors per model.}
    \item{MNF}{Maximum number of factor in models. (\code{MNF=max(NF)}).}
    \item{JFAC}{Matrix with the factor numbers for each of the models.}
    \item{CUT}{Maximum interaction order considered.}
    \item{MBEST}{If \code{INITDES=0}, the first row of the \code{MBEST[1,]} matrix
        has the first user-supplied starting design. The last row the
        \code{NSTART}-th user-supplied starting design.}
    \item{NTOP}{Number of the top best designs.}
    \item{TOPD}{The D value for the best \code{NTOP} designs.}
    \item{TOPDES}{Top \code{NTOP} design factors.}
    \item{ESP}{"Small number" provided to the \file{md} \acronym{FORTRAN}
        subroutine. 1e-5 by default.}
    \item{flag}{Indicator = 1, if the \file{md} subroutine finished properly,
        -1 otherwise.}
}

\note{
The function is a wrapper to call the \acronym{FORTAN} subroutine \file{md},
modification of Daniel Meyer's original program, \file{MD.f}, part of the
\pkg{mdopt} bundle for Bayesian model discrimination of multifactor
experiments.
}
\references{
Meyer, R. D., Steinberg, D. M. and Box, G. E. P. (1996). "Follow-Up Designs
to Resolve Confounding in Multifactor Experiments (with discussion)".
\emph{Technometrics}, Vol. 38, No. 4, pp. 303--332.

Box, G. E. P and R. D. Meyer (1993). "Finding the Active Factors
in Fractionated Screening Experiments".
\emph{Journal of Quality Technology.} Vol. 25. No. 2. pp. 94--105.
}

\author{R. Daniel Meyer. Adapted for \R by Ernesto Barrios.}
\seealso{
    \code{\link{print.MD}}, \code{\link{BsProb}}
}
\examples{
### Injection Molding Experiment. Meyer et al. 1996, example 2.
library(BsMD)
data(BM93.e3.data,package="BsMD")
X <- as.matrix(BM93.e3.data[1:16,c(1,2,4,6,9)])
y <- BM93.e3.data[1:16,10]
p <- c(0.2356,0.2356,0.2356,0.2356,0.0566)
s2 <- c(0.5815,0.5815,0.5815,0.5815,0.4412)
nf <- c(3,3,3,3,4)
facs <- matrix(c(2,1,1,1,1,3,3,2,2,2,4,4,3,4,3,0,0,0,0,4),nrow=5,
    dimnames=list(1:5,c("f1","f2","f3","f4")))
nFDes <- 4
Xcand <- matrix(c(1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
                    -1,-1,-1,-1,1,1,1,1,-1,-1,-1,-1,1,1,1,1,
                    -1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,
                    -1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,
                    -1,1,1,-1,1,-1,-1,1,1,-1,-1,1,-1,1,1,-1),
                    nrow=16,dimnames=list(1:16,c("blk","f1","f2","f3","f4"))
                )
injectionMolding.MD <- MD(X = X, y = y, nFac = 4, nBlk = 1, mInt = 3,
            g = 2, nMod = 5, p = p, s2 = s2, nf = nf, facs = facs,
            nFDes = 4, Xcand = Xcand, mIter = 20, nStart = 25, top = 10)
summary(injectionMolding.MD)



### Reactor Experiment. Meyer et al. 1996, example 3.
par(mfrow=c(1,2),pty="s")
data(Reactor.data,package="BsMD")

# Posterior probabilities based on first 8 runs
X <- as.matrix(cbind(blk = rep(-1,8), Reactor.data[c(25,2,19,12,13,22,7,32), 1:5]))
y <- Reactor.data[c(25,2,19,12,13,22,7,32), 6]
reactor8.BsProb <- BsProb(X = X, y = y, blk = 1, mFac = 5, mInt = 3,
        p =0.25, g =0.40, ng = 1, nMod = 32)
plot(reactor8.BsProb,prt=TRUE,,main="(8 runs)")

# MD optimal 4-run design
p <- reactor8.BsProb$ptop
s2 <- reactor8.BsProb$sigtop
nf <- reactor8.BsProb$nftop
facs <- reactor8.BsProb$jtop
nFDes <- 4
Xcand <- as.matrix(cbind(blk = rep(+1,32), Reactor.data[,1:5]))
reactor.MD <- MD(X = X, y = y, nFac = 5, nBlk = 1, mInt = 3, g =0.40, nMod = 32,
        p = p,s2 = s2, nf = nf, facs = facs, nFDes = 4, Xcand = Xcand,
        mIter = 20, nStart = 25, top = 5)
summary(reactor.MD)

# Posterior probabilities based on all 12 runs
X <- rbind(X, Xcand[c(4,10,11,26), ])
y <- c(y, Reactor.data[c(4,10,11,26),6])
reactor12.BsProb <- BsProb(X = X, y = y, blk = 1, mFac = 5, mInt = 3,
        p = 0.25, g =1.20,ng = 1, nMod = 5)
plot(reactor12.BsProb,prt=TRUE,main="(12 runs)")
}
\keyword{ design }

\eof
\name{PB12Des}
\alias{PB12Des}
\docType{data}
\title{ 12-run Plackett-Burman Design Matrix}
\description{
12-run Plackett-Burman design matrix.
}
\usage{data(PB12Des)}
\format{
  A data frame with 12 observations on the following 11 variables.
  \describe{
    \item{x1}{numeric vectors. Contrast factor.}
    \item{x2}{numeric vectors. Contrast factor.}
    \item{x3}{numeric vectors. Contrast factor.}
    \item{x4}{numeric vectors. Contrast factor.}
    \item{x5}{numeric vectors. Contrast factor.}
    \item{x6}{numeric vectors. Contrast factor.}
    \item{x7}{numeric vectors. Contrast factor.}
    \item{x8}{numeric vectors. Contrast factor.}
    \item{x9}{numeric vectors. Contrast factor.}
    \item{x10}{numeric vectors. Contrast factor.}
    \item{x11}{numeric vectors. Contrast factor.}
  }
}
\source{
Box G. E. P, Hunter, W. C. and Hunter, J. S. (2004).
    \emph{Statistics for Experimenters II}. Wiley.
}
\examples{
library(BsMD)
data(PB12Des,package="BsMD")
str(PB12Des)
X <- as.matrix(PB12Des)
print(t(X)\%*\%X)
}
\keyword{datasets}

\eof
\name{Reactor.data}
\alias{Reactor.data}
\docType{data}
\title{Reactor Experiment Data}
\description{
Data of the Reactor Experiment from Box, Hunter and Hunter (1978).
}
\usage{data(Reactor.data)}
\format{
  A data frame with 32 observations on the following 6 variables.
  \describe{
    \item{A}{numeric vector. Feed rate factor.}
    \item{B}{numeric vector. Catalyst factor.}
    \item{C}{numeric vector. Agitation rate factor.}
    \item{D}{numeric vector. Temperature factor.}
    \item{E}{numeric vector. Concentration factor.}
    \item{y}{numeric vector. Percentage reacted response.}
  }
}
\source{
Box G. E. P, Hunter, W. C. and Hunter, J. S. (2004).
    \emph{Statistics for Experimenters II}. Wiley.

Box G. E. P, Hunter, W. C. and Hunter, J. S. (1978).
    \emph{Statistics for Experimenters}. Wiley.
}
\examples{
library(BsMD)
data(Reactor.data,package="BsMD")
print(Reactor.data)
}
\keyword{datasets}

\eof
\name{plot.BsProb}
\alias{plot.BsProb}
\title{Plotting of Posterior Probabilities from Bayesian Screening}
\description{
Method function for plotting marginal factor posterior probabilities for Bayesian screening.
}
\usage{
    plot.BsProb(x, code = TRUE, prt = FALSE, cex.axis=par("cex.axis"), ...)
}
\arguments{
  \item{x}{list. List of class \code{BsProb} output from the
        \code{\link{BsProb}} function.}
  \item{code}{logical. If \code{TRUE} coded factor names are used.}
  \item{prt}{logical. If \code{TRUE}, summary of the posterior probabilities
        calculation is printed.}
  \item{cex.axis}{Magnification used for the axis annotation.
        See  \code{\link{par}}.}
  \item{\dots}{additional graphical parameters passed to \code{plot}.}
}
\details{
    A spike plot, similar to barplots, is produced with a spike for each factor.
    Marginal posterior probabilities are used for the vertical axis.
    If \code{code=TRUE}, \code{X1}, \code{X2}, ... are used to label the factors
    otherwise the original factor names are used.
    If \code{prt=TRUE}, the \code{\link{print.BsProb}} function is called
    and the posterior probabilities are displayed.
    When \code{\link{BsProb}} is called for more than one value of gamma (\code{g}),
    the spikes for each factor probability are overlapped to show the
    resulting range of each marginal probability.
}
\value{
    The function is called for its side effects. It returns an invisible
    \code{NULL}.
}

\references{
Box, G. E. P and R. D. Meyer (1986).
"An Analysis for Unreplicated Fractional Factorials".
\emph{Technometrics.} Vol. 28. No. 1. pp. 11--18.

Box, G. E. P and R. D. Meyer (1993). "Finding the Active Factors
in Fractionated Screening Experiments".
\emph{Journal of Quality Technology.} Vol. 25. No. 2. pp. 94--105.

}
\author{Ernesto Barrios.}
\seealso{
    \code{\link{BsProb}}, \code{\link{print.BsProb}}, \code{\link{summary.BsProb}}.
}
\examples{
library(BsMD)
data(BM86.data,package="BsMD")
X <- as.matrix(BM86.data[,1:15])
y <- BM86.data["y1"]
# Using prior probability of p = 0.20, and k = 10 (gamma = 2.49)
drillAdvance.BsProb <- BsProb(X = X, y = y, blk = 0, mFac = 15, mInt = 1,
            p = 0.20, g = 2.49, ng = 1, nMod = 10)
plot(drillAdvance.BsProb)
summary(drillAdvance.BsProb)

# Using prior probability of p = 0.20, and a 5 <= k <= 15 (1.22 <= gamma <= 3.74)
drillAdvance.BsProbG <- BsProb(X = X, y = y, blk = 0, mFac = 15, mInt = 1,
            p = 0.25, g = c(1.22, 3.74), ng = 3, nMod = 10)
plot(drillAdvance.BsProbG, code = FALSE, prt = TRUE)
}
\keyword{ design }
\keyword{ hplot }

\eof
\name{print.BsProb}
\alias{print.BsProb}
\title{Printing Posterior Probabilities from Bayesian Screening}
\description{
    Printing method for  lists of class \code{BsProb}. Prints the posterior
    probabilities of factors and models from the Bayesian screening procedure.
}
\usage{
    print.BsProb(x, X = TRUE, resp = TRUE, factors = TRUE, models = TRUE,
            nMod = 10, digits = 3, plt = FALSE, verbose = FALSE, ...)
}
\arguments{
  \item{x}{list. Object of \code{BsProb} class, output from the \code{\link{BsProb}} function.}
  \item{X}{logical. If \code{TRUE}, the design matrix is printed.}
  \item{resp}{logical. If \code{TRUE}, the response vector is printed.}
  \item{factors}{logical. Marginal posterior probabilities are printed if \code{TRUE}.}
  \item{models}{logical. If \code{TRUE} models posterior probabilities are printed.}
  \item{nMod}{integer. Number of the top ranked models to print.}
  \item{digits}{integer. Significant digits to use for printing.}
  \item{plt}{logical. Factor marginal probabilities are plotted if \code{TRUE}.}
  \item{verbose}{logical. If \code{TRUE}, the \code{unclass}-ed list \code{x} is displayed.}
  \item{...}{additional arguments passed to \code{print} function.}
}
\value{
    The function prints out marginal factors and models posterior probabilities.
    Returns invisible list with the components:
    \item{calc}{numeric vector with general calculation information.}
    \item{probabilities}{Data frame with the marginal posterior factor probabilities.}
    \item{models}{Data frame with model the posterior probabilities.}
}

\references{ Box, G. E. P and R. D. Meyer (1986). "An Analysis for
Unreplicated Fractional Factorials". \emph{Technometrics.} Vol. 28. No. 1.
pp. 11--18.

Box, G. E. P and R. D. Meyer (1993). "Finding the Active Factors
in Fractionated Screening Experiments".
\emph{Journal of Quality Technology.} Vol. 25. No. 2. pp. 94--105.

}
\author{Ernesto Barrios.}
\seealso{
    \code{\link{BsProb}}, \code{\link{summary.BsProb}}, \code{\link{plot.BsProb}}.
}
\examples{
library(BsMD)
data(BM86.data,package="BsMD")
X <- as.matrix(BM86.data[,1:15])
y <- BM86.data["y1"]
# Using prior probability of p = 0.20, and k = 10 (gamma = 2.49)
drillAdvance.BsProb <- BsProb(X = X, y = y, blk = 0, mFac = 15, mInt = 1,
            p = 0.20, g = 2.49, ng = 1, nMod = 10)
print(drillAdvance.BsProb)
plot(drillAdvance.BsProb)

# Using prior probability of p = 0.20, and a 5 <= k <= 15 (1.22 <= gamma <= 3.74)
drillAdvance.BsProbG <- BsProb(X = X, y = y, blk = 0, mFac = 15, mInt = 1,
            p = 0.25, g = c(1.22, 3.74), ng = 3, nMod = 10)
print(drillAdvance.BsProbG, X = FALSE, resp = FALSE)
plot(drillAdvance.BsProbG)
}
\keyword{ design }

\eof
\name{print.MD}
\alias{print.MD}
\title{Print Best MD Follow-Up Experiments}
\description{
    Printing method for  lists of class \code{MD}. Displays the
    best MD criterion set of runs and their MD for follow-up experiments.}
}
\usage{
print.MD(x, X = FALSE, resp = FALSE, Xcand = TRUE, models = TRUE, nMod = x$nMod,
            digits = 3, verbose=FALSE, ...)
}
\arguments{
  \item{x}{list of class \code{MD}. Output list of the \code{\link{MD}} function.}
  \item{X}{logical. If \code{TRUE}, the initial design matrix is printed.}
  \item{resp}{logical If \code{TRUE}, the response vector of initial design is printed.}
  \item{Xcand}{logical. Prints the candidate runs if \code{TRUE}.}
  \item{models}{logical. Competing models are printed if \code{TRUE}.}
  \item{nMod}{integer. Top models to print.}
  \item{digits}{integer. Significant digits to use in the print out.}
  \item{verbose}{logical. If \code{TRUE}, the \code{unclass}-ed \code{x} is displayed.}
  \item{...}{additional arguments passed to \code{print} generic function.}
}
\value{
    The function is mainly called for its side effects. Prints out the selected
    components of the class \code{MD} objects, output of the \code{MD} function.
    For example the marginal factors and models posterior probabilities and
    the top MD follow-up experiments with their corresponding MD statistic.
    It returns invisible list with the components:
    \item{calc}{Numeric vector with basic calculation information.}
    \item{models}{Data frame with the competing models posterior probabilities.}
    \item{follow-up}{Data frame with the runs for follow-up experiments and
        their corresponding MD statistic.}
}
\references{
Meyer, R. D., Steinberg, D. M. and Box, G. E. P. (1996). "Follow-Up Designs
to Resolve Confounding in Multifactor Experiments (with discussion)".
\emph{Technometrics}, Vol. 38, No. 4, pp. 303--332.

Box, G. E. P and R. D. Meyer (1993). "Finding the Active Factors
in Fractionated Screening Experiments".
\emph{Journal of Quality Technology.} Vol. 25. No. 2. pp. 94--105.

}
\author{Ernesto Barrios.}
\seealso{\code{\link{MD}}, \code{\link{BsProb}}}
\examples{
# Injection Molding Experiment. Meyer et al. 1996. Example 2.
# MD for one extra experiment.
library(BsMD)
data(BM93.e3.data,package="BsMD")
X <- as.matrix(BM93.e3.data[1:16,c(1,2,4,6,9)])
y <- BM93.e3.data[1:16,10]
nBlk <- 1
nFac <- 4
mInt <- 3
g <- 2
nMod <- 5
p <- c(0.2356,0.2356,0.2356,0.2356,0.0566)
s2 <- c(0.5815,0.5815,0.5815,0.5815,0.4412)
nf <- c(3,3,3,3,4)
facs <- matrix(c(2,1,1,1,1,3,3,2,2,2,4,4,3,4,3,0,0,0,0,4),nrow=5,
    dimnames=list(1:5,c("f1","f2","f3","f4")))
nFDes <- 1
Xcand <- matrix(c(1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
                    -1,-1,-1,-1,1,1,1,1,-1,-1,-1,-1,1,1,1,1,
                    -1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,
                    -1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,
                    -1,1,1,-1,1,-1,-1,1,1,-1,-1,1,-1,1,1,-1),
                    nrow=16,dimnames=list(1:16,c("blk","f1","f2","f3","f4"))
                )
mIter <- 0
startDes <- matrix(c(9,11,12,15),nrow=4)
top <- 10
injectionMolding.MD <- MD(X=X,y=y,nFac=nFac,nBlk=nBlk,mInt=mInt,g=g,
            nMod=nMod,p=p,s2=s2,nf=nf,facs=facs,
            nFDes=nFDes,Xcand=Xcand,mIter=mIter,startDes=startDes,top=top)

print(injectionMolding.MD)
summary(injectionMolding.MD)

}
\keyword{ design }

\eof
\name{summary.BsProb}
\alias{summary.BsProb}
\title{Summary of Posterior Probabilities from Bayesian Screening}
\description{
    Reduced printing method for class \code{BsProb} lists. Prints
    posterior probabilities of factors and models from Bayesian screening
    procedure.}
\usage{
    summary.BsProb(object, nMod = 10, digits = 3, ...)
}
\arguments{
  \item{object}{list. \code{BsProb} class list. Output list of \code{\link{BsProb}} function.}
  \item{nMod}{integer. Number of the top ranked models to print.}
  \item{digits}{integer. Significant digits to use.}
  \item{...}{additional arguments passed to \code{summary} generic function.}
} \value{
    The function prints out the marginal factors and models posterior
    probabilities. Returns invisible list with the components:
    \item{calc}{Numeric vector with basic calculation information.}
    \item{probabilities}{Data frame with the marginal posterior factor probabilities.}
    \item{models}{Data frame with the models posterior probabilities.}
}

\references{ Box, G. E. P and R. D. Meyer (1986). "An Analysis for
Unreplicated Fractional Factorials". \emph{Technometrics.} Vol. 28. No. 1.
pp. 11--18.

Box, G. E. P and R. D. Meyer (1993). "Finding the Active Factors
in Fractionated Screening Experiments".
\emph{Journal of Quality Technology.} Vol. 25. No. 2. pp. 94--105.

}
\author{Ernesto Barrios.}
\seealso{
    \code{\link{BsProb}}, \code{\link{print.BsProb}}, \code{\link{plot.BsProb}}.
}
\examples{
library(BsMD)
data(BM86.data,package="BsMD")
X <- as.matrix(BM86.data[,1:15])
y <- BM86.data["y1"]
# Using prior probability of p = 0.20, and k = 10 (gamma = 2.49)
drillAdvance.BsProb <- BsProb(X = X, y = y, blk = 0, mFac = 15, mInt = 1,
            p = 0.20, g = 2.49, ng = 1, nMod = 10)
plot(drillAdvance.BsProb)
summary(drillAdvance.BsProb)

# Using prior probability of p = 0.20, and a 5 <= k <= 15 (1.22 <= gamma <= 3.74)
drillAdvance.BsProbG <- BsProb(X = X, y = y, blk = 0, mFac = 15, mInt = 1,
            p = 0.25, g = c(1.22, 3.74), ng = 3, nMod = 10)
plot(drillAdvance.BsProbG)
summary(drillAdvance.BsProbG)
}
\keyword{ design }

\eof
\name{summary.MD}
\alias{summary.MD}
\title{Summary of Best MD Follow-Up Experiments}
\description{
    Reduced printing method for lists of class \code{MD}. Displays the
    best MD criterion set of runs and their MD for follow-up experiments.}
}
\usage{
summary.MD(object, digits = 3, verbose=FALSE, ...)
}
\arguments{
  \item{object}{list of \code{MD} class. Output list of \code{\link{MD}} function.}
  \item{digits}{integer. Significant digits to use in the print out.}
  \item{verbose}{logical. If \code{TRUE}, the \code{unclass}-ed \code{object} is displayed.}
  \item{...}{additional arguments passed to \code{summary} generic function.}
}
\value{
    It prints out the marginal factors and models posterior probabilities and
    the top MD follow-up experiments with their corresponding MD statistic.}
\references{
Meyer, R. D., Steinberg, D. M. and Box, G. E. P. (1996). "Follow-Up Designs
to Resolve Confounding in Multifactor Experiments (with discussion)".
\emph{Technometrics}, Vol. 38, No. 4, pp. 303--332.

Box, G. E. P and R. D. Meyer (1993). "Finding the Active Factors
in Fractionated Screening Experiments".
\emph{Journal of Quality Technology.} Vol. 25. No. 2. pp. 94--105.
}
\author{Ernesto Barrios.}
\seealso{\code{\link{print.MD}} and \code{\link{MD}}}
\examples{
### Reactor Experiment. Meyer et al. 1996, example 3.
library(BsMD)
data(Reactor.data,package="BsMD")

# Posterior probabilities based on first 8 runs
X <- as.matrix(cbind(blk = rep(-1,8), Reactor.data[c(25,2,19,12,13,22,7,32), 1:5]))
y <- Reactor.data[c(25,2,19,12,13,22,7,32), 6]
reactor.BsProb <- BsProb(X = X, y = y, blk = 1, mFac = 5, mInt = 3,
        p =0.25, g =0.40, ng = 1, nMod = 32)

# MD optimal 4-run design
p <- reactor.BsProb$ptop
s2 <- reactor.BsProb$sigtop
nf <- reactor.BsProb$nftop
facs <- reactor.BsProb$jtop
nFDes <- 4
Xcand <- as.matrix(cbind(blk = rep(+1,32), Reactor.data[,1:5]))
reactor.MD <- MD(X = X, y = y, nFac = 5, nBlk = 1, mInt = 3, g =0.40, nMod = 32,
        p = p,s2 = s2, nf = nf, facs = facs, nFDes = 4, Xcand = Xcand,
        mIter = 20, nStart = 25, top = 5)
print(reactor.MD)
summary(reactor.MD)
}
\keyword{ design }

\eof
