rcspline.plot             package:Hmisc             R Documentation

_P_l_o_t _R_e_s_t_r_i_c_t_e_d _C_u_b_i_c _S_p_l_i_n_e _F_u_n_c_t_i_o_n

_D_e_s_c_r_i_p_t_i_o_n:

     Provides plots of the estimated restricted cubic spline function
     relating a single predictor to the response for a logistic or Cox
     model. The 'rcspline.plot' function does not allow for
     interactions as do 'lrm' and 'cph', but it can provide detailed
     output for checking spline fits. This function uses the
     'rcspline.eval', 'lrm.fit', and Therneau's 'coxph.fit' functions
     and plots the estimated spline regression and confidence limits,
     placing summary statistics on the graph. If there are no
     adjustment variables, 'rcspline.plot' can also plot two
     alternative estimates of the regression function when
     'model="logistic"':  proportions or logit proportions on grouped
     data, and a nonparametric estimate. The nonparametric regression
     estimate is based on smoothing the binary responses and taking the
     logit transformation of the smoothed estimates, if desired. The
     smoothing uses 'supsmu'.

_U_s_a_g_e:

     rcspline.plot(x,y,model="logistic",xrange,event,nk=5,knots=NULL,
                  show="xbeta",adj=NULL,xlab,ylab,ylim,plim=c(0,1),plotcl=TRUE,
                  showknots=TRUE,add=FALSE,subset,lty=1,noprint=FALSE,m,smooth=FALSE,bass=1,
                  main="auto",statloc)

_A_r_g_u_m_e_n_t_s:

       x: a numeric predictor 

       y: a numeric response. For binary logistic regression, 'y'
          should be '0-1'. 

   model: '"logistic"' or '"cox"'. For '"cox"', uses the 'coxph.fit'
          with 'method="efron"'. function. 

  xrange: range for evaluating 'x', default is 'f' and '1-f' quantiles
          of 'x', where 'f=10/max(n,200)' 

   event: event/censoring indicator if 'model="cox"'. If 'event' is
          present, 'model' is assumed to be '"cox"' 

      nk: number of knots 

   knots: knot locations, default based on quantiles of 'x' (by
          'rcspline.eval') 

    show: '"xbeta"' or '"prob"' - what is plotted on 'y'-axis 

     adj: optional matrix of adjustment variables 

    xlab: 'x'-axis label, default is '"label"' attribute of 'x' 

    ylab: same for 'y'

    ylim: 'y'-axis limits for logit or log hazard 

    plim: 'y'-axis limits for probability scale 

  plotcl: plot confidence limits 

showknots: show knot locations with arrows 

     add: add this plot to an already existing plot 

  subset: subset of observations to process, e.g. 'subset=sex=="male"' 

     lty: line type for plotting estimated spline function 

 noprint: suppress printing regression coefficients and standard errors 

       m: for 'model="logistic"', plot grouped estimates with
          triangles. Each group contains 'm' ordered observations on
          'x'. 

  smooth: plot nonparametric estimate if 'model="logistic"' and 'adj'
          is not specified 

    bass: smoothing parameter (see 'supsmu') 

    main: main title, default is e.g. '"Estimated Spline
          Transformation"' 

 statloc: location of summary statistics. Default positioning by
          clicking left mouse button where upper left corner of
          statistics should appear. Alternative is '"ll"' to place
          below the graph on the lower left, or the actual 'x' and 'y'
          coordinates. Use '"none"' to suppress statistics. 

_V_a_l_u_e:

     list with components 'knots, x, xbeta, lower, upper' which are
     respectively the knot locations, design matrix, linear predictor,
     and lower and upper confidence limits

_A_u_t_h_o_r(_s):

     Frank Harrell 
      Department of Biostatistics, Vanderbilt University 
      f.harrell@vanderbilt.edu

_S_e_e _A_l_s_o:

     'lrm', 'cph', 'rcspline.eval', 'plot', 'supsmu', 'coxph.fit',
     'lrm.fit'

_E_x_a_m_p_l_e_s:

     # rcspline.plot(cad.dur, tvdlm, m=150)
     # rcspline.plot(log10(cad.dur+1), tvdlm, m=150)

