### Name: latex
### Title: Convert an S object to LaTeX, and Related Utilities
### Aliases: latex latex.default latex.function latex.list latexTranslate
###   latexSN latexVerbatim dvi print.dvi dvi.latex dvips dvips.latex
###   dvips.dvi dvigv dvigv.latex dvigv.dvi print.latex show.latex show.dvi
### Keywords: utilities interface methods file character manip

### ** Examples

## Not run: 
##D x <- matrix(1:6, nrow=2, dimnames=list(c('a','b'),c('c','d','enLine 2')))
##D latex(x)   # creates x.tex in working directory
##D w <- latex(x, file='/tmp/my.tex')
##D d <- dvi(w)  # compile LaTeX document, make .dvi
##D              # latex assumed to be in path
##D d            # or show(d) : run xdvi (assumed in path) to display
##D w            # or show(w) : run dvi then xdvi
##D dvips(d)     # run dvips to print document
##D dvips(w)     # run dvi then dvips
##D latex(x, file="")   # just write out LaTeX code to screen
##D 
##D # After running latex( ) multiple times with different special styles in
##D # effect, make a file that will call for the needed LaTeX packages when
##D # latex is run (especially when using Sweave with R)
##D if(exists(latexStyles))
##D   cat(paste('\usepackage{',latexStyles,'}',sep=''),
##D       file='stylesused.tex', sep='\n')
##D # Then in the latex job have something like:
##D # \documentclass{article}
##D # \input{stylesused}
##D # \begin{document}
##D # ...
## End(Not run)



