### Name: ldBands
### Title: Group Sequential Boundaries using the Lan-DeMets Approach
### Aliases: ldBands summary.ldBands print.ldBands plot.ldBands
###   print.summary.ldBands
### Keywords: distribution htest design

### ** Examples

## Not run: 
##D # Get boundaries for O'Brien-Fleming spending function, 5 looks, alpha=.05
##D b <- ldBands(5, pr=FALSE)
##D plot(b)
##D # Same but times are irregular, and information times are different than
##D # test times.  Use Pocock spending function.
##D b <- ldBands(times=      c(.4, .6, .8, .9, .95),
##D              information=c(.42,.65,.83,.89,.94), spending='Pocock')
##D 
##D # Get power calculations
##D u <- ldBands(times=c(.4, .6, .8, .9, .95),  power=.9)
##D u$drift                  # standardize difference * sqrt(n per arm)
##D                          # needed to provide power=.9
##D summary(u, n=50)         # obtain detectable standardized difference
##D summary(u, p1=.4, p2=.5) # get sample size per arm, two-sample binomial
##D summary(u, hr=1.5)       # get number of events per arm needed
##D                          # to detect a hazard ratio of 1.5
##D 
##D # Asymmetric boundaries with different spending functions, truncate
##D b <- ldBands(5, sided=3, spending='alpha*t^phi', phi=1, phi2=1.5,
##D              alphaLower=.01, alphaUpper=.04, truncate=4)
##D b
##D plot(b)
##D # Compute differences in proportions and odds ratios needed to cross
##D # the boundaries, given a mean probability in two treatment arms of 0.1
##D # and given a vector of sample sizes per arm corresponding to the looks
##D s <- summary(b, n=seq(200,1000,by=200), pbar=.1)
##D s
##D d <- s$data
##D plot(d$n, d$or.lower, xlab='N Per Arm',
##D      ylab='Critical Odds Ratio', type='b',
##D      ylim=range(d$or.lower, d$or.upper), log='y')
##D lines(d$n, d$or.upper, type='b')
##D abline(h=1, lty=2)
## End(Not run)



