### Name: ps.slide
### Title: Postscript and Adobe PDF Setup for 35mm Slides and Other Formats
### Aliases: ps.slide setps setpdf topdf tex showPsfrag
### Keywords: hplot device

### ** Examples

## Not run: 
##D ps.slide("myslide")   # myslide is file name prefix
##D # use ps.slide("myslide",back="green") to use e.g. green background
##D plot(x, y)
##D title("My Title")
##D 
##D ps.slide(view=TRUE)   # makes myslide.ps file
##D                    # use ps.slide(close=TRUE) to close file without viewing with
##D                    # ghostview.
##D ps.slide(view=TRUE, pcx=TRUE)
##D                    # converts myslide.ps into myslide.pcx (PC Paintbrush
##D                    # format suitable for importing in PC graphics packages)
##D mgp.axis.labels(c(.4,1.2))  # override 2nd mgp parameters for x- and y axes
##D mgp.axis.labels(type='x')   # retrieve 3 mgp parameters for x-axis
##D 
##D setps(myfile)      # equiv. to setps('myfile', type='char')
##D                    # setps(myfile, trellis=TRUE, other args) for Trellis
##D # plotting commands
##D dev.off()
##D topdf()            # topdf created by setps
##D                    # makes Ghostscript create "myfile.pdf"
##D setpdf(myfile)
##D # plotting commands
##D dev.off()
##D 
##D # Put math and Greek symbols in a graph
##D setps(test)
##D x <- seq(0,15,length=100)
##D plot(x, dchisq(x, 5), xlab=tex('$x$'),
##D         ylab=tex('$f(x)$'), type='l')
##D title(tex('Density Function of the $\chi_{5}^{2}$ Distribution'))
##D dev.off()
##D # To process this file in LaTeX do something like
##D #\documentclass{article}
##D #\usepackage[scanall]{psfrag}
##D #\begin{document}
##D #\begin{figure}
##D #\includegraphics{test.ps}
##D #\caption{This is an example}
##D #\end{figure}
##D #\end{document}
## End(Not run)



