### Name: rcorrp.cens
### Title: Rank Correlation for Paired Predictors with a Censored Response
### Aliases: rcorrp.cens
### Keywords: survival nonparametric

### ** Examples

set.seed(1)
if(.R.) library(survival)
x1 <- rnorm(400)
x2 <- x1 + rnorm(400)
d.time <- rexp(400) + (x1 - min(x1))
cens   <- runif(400,.5,2)
death  <- d.time <= cens
d.time <- pmin(d.time, cens)
rcorrp.cens(x1, x2, Surv(d.time, death))
# rcorrp.cens(x1, x2, y) ## no censoring



