### Name: reShape
### Title: Reshape Matrices and Serial Data
### Aliases: reShape
### Keywords: manip array

### ** Examples

if(.R.) {
  set.seed(1)
  Solder  <- factor(sample(c('Thin','Thick'),200,TRUE),c('Thin','Thick'))
  Opening <- factor(sample(c('S','M','L'),  200,TRUE),c('S','M','L'))
} else attach(solder[solder$skips > 10, ])
tab <- table(Opening, Solder)
tab
reShape(tab)
# attach(tab)  # do further processing

if(!.R.) {
 g <- crosstabs( ~ Solder + Opening, data = solder, subset = skips > 10)
 rowpct <- 100*attr(g,'marginals')$"N/RowTotal"   # compute row pcts
 rowpct

 r <- reShape(rowpct)
 # note names "Solder" and "Opening" came originally from formula
 # given to crosstabs
 r    
 dotplot(Solder ~ rowpct, groups=Opening, panel=panel.superpose, data=r)
}

# An example where a matrix is created from irregular vectors
follow <- data.frame(id=c('a','a','b','b','b','d'),
                     month=c(1, 2,  1,  2,  3,  2),
                     cholesterol=c(225,226, 320,319,318, 270))
follow
attach(follow)
reShape(cholesterol, id=id, colvar=month)
detach('follow')
# Could have done :
# reShape(cholesterol, triglyceride=trig, id=id, colvar=month)

# Get predictions from a regression model for 2 systematically
# varying predictors.  Convert the predictions into a matrix, with
# rows corresponding to the predictor having the most values, and
# columns corresponding to the other predictor
# d <- expand.grid(x2=0:1, x1=1:100)
# pred <- predict(fit, d)
# reShape(pred, id=d$x1, colvar=d$x2)  # makes 100 x 2 matrix

# Reshape a wide data frame containing multiple variables representing
# repeated measurements (3 repeats on 2 variables; 4 subjects)
set.seed(33)
n <- 4
w <- data.frame(age=rnorm(n, 40, 10),
                sex=sample(c('female','male'), n,TRUE),
                sbp1=rnorm(n, 120, 15),
                sbp2=rnorm(n, 120, 15),
                sbp3=rnorm(n, 120, 15),
                dbp1=rnorm(n,  80, 15),
                dbp2=rnorm(n,  80, 15),
                dbp3=rnorm(n,  80, 15), row.names=letters[1:n])
options(digits=3)
w

u <- reShape(w, base=c('sbp','dbp'), reps=3)
u
reShape(w, base=c('sbp','dbp'), reps=3, timevar='week', times=c(0,3,12))



