### Name: store
### Title: Store an Object Permanently
### Aliases: store stores storeTemp
### Keywords: data

### ** Examples

## Not run: 
##D attach(database, 1)     #this database takes precedence
##D store()                 #new objects to go under database in memory
##D                         #this doesn't work in R
##D f <- lm(y ~ x)
##D store(f)                #store f under name "f" in .Data or .GlobalEnv
##D                         #uses assign() with immediate=T
##D store(f, "final.model") #immediately store f under "final.model" in .Data
##D store()                 #store future objects in .Data.tempnnnn
##D x <- runif(1000)        #x will disappear at session end unless
##D store(x)                #this statement appears -> store in .Data
##D stores(x, y, z)         #store x,y,z in .Data under names x,y,z
##D storeTemp(x)            #put x as name 'x' in frame 0
##D                         #for R, attach .GlobalTemp and store it there
##D storeTemp(x,'X')        #same as previous but under the name X
## End(Not run)



